/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.QuartPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.blending.Blender;

public class NoiseChunk {
    private final NoiseSampler a;
    final NoiseSettings b;
    final int c;
    final int d;
    final int e;
    final int f;
    final int g;
    private final int h;
    private final int i;
    final List<d> j;
    private final NoiseSampler.a[][] k;
    private final Long2IntMap l = new Long2IntOpenHashMap();
    private final Aquifer m;
    private final a n;
    private final a o;
    private final Blender p;

    public static NoiseChunk a(IChunkAccess chunk, NoiseSampler noiseSampler, Supplier<c> supplier, GeneratorSettingBase chunkGeneratorSettings, Aquifer.a fluidLevelSampler, Blender blender) {
        ChunkCoordIntPair chunkPos = chunk.f();
        NoiseSettings noiseSettings = chunkGeneratorSettings.b();
        int i2 = Math.max(noiseSettings.h(), chunk.u_());
        int j2 = Math.min(noiseSettings.h() + noiseSettings.i(), chunk.ag());
        int k2 = MathHelper.a(i2, noiseSettings.d());
        int l2 = MathHelper.a(j2 - i2, noiseSettings.d());
        return new NoiseChunk(16 / noiseSettings.e(), l2, k2, noiseSampler, chunkPos.d(), chunkPos.e(), supplier.get(), chunkGeneratorSettings, fluidLevelSampler, blender);
    }

    public static NoiseChunk a(int minimumY, int i3, int horizontalSize, int verticalNoiseResolution, NoiseSampler noiseSampler, GeneratorSettingBase chunkGeneratorSettings, Aquifer.a fluidLevelSampler) {
        return new NoiseChunk(1, verticalNoiseResolution, horizontalSize, noiseSampler, minimumY, i3, (i2, j2, k2) -> 0.0, chunkGeneratorSettings, fluidLevelSampler, Blender.a());
    }

    private NoiseChunk(int horizontalNoiseResolution, int verticalNoiseResolution, int horizontalSize, NoiseSampler noiseSampler, int minimumY, int minimumZ, c noiseFiller, GeneratorSettingBase chunkGeneratorSettings, Aquifer.a fluidLevelSampler, Blender blender) {
        this.b = chunkGeneratorSettings.b();
        this.c = horizontalNoiseResolution;
        this.d = verticalNoiseResolution;
        this.e = horizontalSize;
        this.a = noiseSampler;
        int i2 = this.b.e();
        this.f = Math.floorDiv(minimumY, i2);
        this.g = Math.floorDiv(minimumZ, i2);
        this.j = Lists.newArrayList();
        this.h = QuartPos.a(minimumY);
        this.i = QuartPos.a(minimumZ);
        int j2 = QuartPos.a(horizontalNoiseResolution * i2);
        this.k = new NoiseSampler.a[j2 + 1][];
        this.p = blender;
        for (int k2 = 0; k2 <= j2; ++k2) {
            int l2 = this.h + k2;
            this.k[k2] = new NoiseSampler.a[j2 + 1];
            for (int m2 = 0; m2 <= j2; ++m2) {
                int n2 = this.i + m2;
                this.k[k2][m2] = noiseSampler.a(l2, n2, blender);
            }
        }
        this.m = noiseSampler.a(this, minimumY, minimumZ, horizontalSize, verticalNoiseResolution, fluidLevelSampler, chunkGeneratorSettings.h());
        this.n = noiseSampler.a(this, noiseFiller, chunkGeneratorSettings.k());
        this.o = noiseSampler.a(this, chunkGeneratorSettings.j());
    }

    public NoiseSampler.a a(int x2, int z2) {
        return this.k[x2 - this.h][z2 - this.i];
    }

    public int b(int i2, int j2) {
        return this.l.computeIfAbsent(ChunkCoordIntPair.a(QuartPos.a(i2), QuartPos.a(j2)), this::a);
    }

    private int a(long l2) {
        TerrainInfo terrainInfo2;
        int i2 = ChunkCoordIntPair.a(l2);
        int j2 = ChunkCoordIntPair.b(l2);
        int k2 = i2 - this.h;
        int m2 = j2 - this.i;
        int n2 = this.k.length;
        if (k2 >= 0 && m2 >= 0 && k2 < n2 && m2 < n2) {
            TerrainInfo terrainInfo = this.k[k2][m2].f();
        } else {
            terrainInfo2 = this.a.a(i2, j2, this.p).f();
        }
        return this.a.a(QuartPos.c(i2), QuartPos.c(j2), terrainInfo2);
    }

    protected d a(c columnSampler) {
        return new d(columnSampler);
    }

    public Blender a() {
        return this.p;
    }

    public void b() {
        this.j.forEach(interpolator -> interpolator.a());
    }

    public void a(int x2) {
        this.j.forEach(interpolator -> interpolator.a(x2));
    }

    public void c(int noiseY, int noiseZ) {
        this.j.forEach(interpolator -> interpolator.b(noiseY, noiseZ));
    }

    public void a(double deltaY) {
        this.j.forEach(interpolator -> interpolator.a(deltaY));
    }

    public void b(double deltaX) {
        this.j.forEach(interpolator -> interpolator.b(deltaX));
    }

    public void c(double deltaZ) {
        this.j.forEach(interpolator -> interpolator.c(deltaZ));
    }

    public void c() {
        this.j.forEach(d::b);
    }

    public Aquifer d() {
        return this.m;
    }

    @Nullable
    protected IBlockData a(int x2, int y2, int z2) {
        return this.n.calculate(x2, y2, z2);
    }

    @Nullable
    protected IBlockData b(int x2, int y2, int z2) {
        return this.o.calculate(x2, y2, z2);
    }

    @FunctionalInterface
    public static interface c {
        public double calculateNoise(int var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface a {
        @Nullable
        public IBlockData calculate(int var1, int var2, int var3);
    }

    public class d
    implements e {
        private double[][] b;
        private double[][] c;
        private final c d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;
        private double m;
        private double n;
        private double o;
        private double p;
        private double q;
        private double r;
        private double s;

        d(c columnSampler) {
            this.d = columnSampler;
            this.b = this.a(NoiseChunk.this.d, NoiseChunk.this.c);
            this.c = this.a(NoiseChunk.this.d, NoiseChunk.this.c);
            NoiseChunk.this.j.add(this);
        }

        private double[][] a(int sizeZ, int sizeX) {
            int i2 = sizeX + 1;
            int j2 = sizeZ + 1;
            double[][] ds = new double[i2][j2];
            for (int k2 = 0; k2 < i2; ++k2) {
                ds[k2] = new double[j2];
            }
            return ds;
        }

        void a() {
            this.a(this.b, NoiseChunk.this.f);
        }

        void a(int x2) {
            this.a(this.c, NoiseChunk.this.f + x2 + 1);
        }

        private void a(double[][] buffer, int noiseX) {
            int i2 = NoiseChunk.this.b.e();
            int j2 = NoiseChunk.this.b.d();
            for (int k2 = 0; k2 < NoiseChunk.this.c + 1; ++k2) {
                int l2 = NoiseChunk.this.g + k2;
                for (int m2 = 0; m2 < NoiseChunk.this.d + 1; ++m2) {
                    double d2;
                    int n2 = m2 + NoiseChunk.this.e;
                    int o2 = n2 * j2;
                    buffer[k2][m2] = d2 = this.d.calculateNoise(noiseX * i2, o2, l2 * i2);
                }
            }
        }

        void b(int noiseY, int noiseZ) {
            this.e = this.b[noiseZ][noiseY];
            this.f = this.b[noiseZ + 1][noiseY];
            this.g = this.c[noiseZ][noiseY];
            this.h = this.c[noiseZ + 1][noiseY];
            this.i = this.b[noiseZ][noiseY + 1];
            this.j = this.b[noiseZ + 1][noiseY + 1];
            this.k = this.c[noiseZ][noiseY + 1];
            this.l = this.c[noiseZ + 1][noiseY + 1];
        }

        void a(double deltaY) {
            this.m = MathHelper.d(deltaY, this.e, this.i);
            this.n = MathHelper.d(deltaY, this.g, this.k);
            this.o = MathHelper.d(deltaY, this.f, this.j);
            this.p = MathHelper.d(deltaY, this.h, this.l);
        }

        void b(double deltaX) {
            this.q = MathHelper.d(deltaX, this.m, this.n);
            this.r = MathHelper.d(deltaX, this.o, this.p);
        }

        void c(double deltaZ) {
            this.s = MathHelper.d(deltaZ, this.q, this.r);
        }

        @Override
        @Override
        public double sample() {
            return this.s;
        }

        private void b() {
            double[][] ds = this.b;
            this.b = this.c;
            this.c = ds;
        }
    }

    @FunctionalInterface
    public static interface e {
        public double sample();
    }

    @FunctionalInterface
    public static interface b {
        public e instantiate(NoiseChunk var1);
    }
}

