/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;

public final class GeneratorSettingBase {
    public static final Codec<GeneratorSettingBase> a = RecordCodecBuilder.create(instance -> instance.group((App)StructureSettings.a.fieldOf("structures").forGetter(GeneratorSettingBase::a), (App)NoiseSettings.a.fieldOf("noise").forGetter(GeneratorSettingBase::b), (App)IBlockData.b.fieldOf("default_block").forGetter(GeneratorSettingBase::c), (App)IBlockData.b.fieldOf("default_fluid").forGetter(GeneratorSettingBase::d), (App)SurfaceRules.o.b.fieldOf("surface_rule").forGetter(GeneratorSettingBase::e), (App)Codec.INT.fieldOf("sea_level").forGetter(GeneratorSettingBase::f), (App)Codec.BOOL.fieldOf("disable_mob_generation").forGetter(GeneratorSettingBase::g), (App)Codec.BOOL.fieldOf("aquifers_enabled").forGetter(GeneratorSettingBase::h), (App)Codec.BOOL.fieldOf("noise_caves_enabled").forGetter(GeneratorSettingBase::i), (App)Codec.BOOL.fieldOf("ore_veins_enabled").forGetter(GeneratorSettingBase::j), (App)Codec.BOOL.fieldOf("noodle_caves_enabled").forGetter(GeneratorSettingBase::k), (App)Codec.BOOL.fieldOf("legacy_random_source").forGetter(GeneratorSettingBase::l)).apply((Applicative)instance, GeneratorSettingBase::new));
    public static final Codec<Supplier<GeneratorSettingBase>> b = RegistryFileCodec.a(IRegistry.aK, a);
    private final SeededRandom.a j;
    private final StructureSettings k;
    private final NoiseSettings l;
    private final IBlockData m;
    private final IBlockData n;
    private final SurfaceRules.o o;
    private final int p;
    private final boolean q;
    private final boolean r;
    private final boolean s;
    private final boolean t;
    private final boolean u;
    public static final ResourceKey<GeneratorSettingBase> c = ResourceKey.a(IRegistry.aK, new MinecraftKey("overworld"));
    public static final ResourceKey<GeneratorSettingBase> d = ResourceKey.a(IRegistry.aK, new MinecraftKey("large_biomes"));
    public static final ResourceKey<GeneratorSettingBase> e = ResourceKey.a(IRegistry.aK, new MinecraftKey("amplified"));
    public static final ResourceKey<GeneratorSettingBase> f = ResourceKey.a(IRegistry.aK, new MinecraftKey("nether"));
    public static final ResourceKey<GeneratorSettingBase> g = ResourceKey.a(IRegistry.aK, new MinecraftKey("end"));
    public static final ResourceKey<GeneratorSettingBase> h = ResourceKey.a(IRegistry.aK, new MinecraftKey("caves"));
    public static final ResourceKey<GeneratorSettingBase> i = ResourceKey.a(IRegistry.aK, new MinecraftKey("floating_islands"));

    private GeneratorSettingBase(StructureSettings structuresConfig, NoiseSettings generationShapeConfig, IBlockData defaultBlock, IBlockData defaultFluid, SurfaceRules.o surfaceRule, int bedrockCeilingY, boolean mobGenerationDisabled, boolean aquifers, boolean noiseCaves, boolean oreVeins, boolean noodleCaves, boolean useLegacyRandom) {
        this.k = structuresConfig;
        this.l = generationShapeConfig;
        this.m = defaultBlock;
        this.n = defaultFluid;
        this.o = surfaceRule;
        this.p = bedrockCeilingY;
        this.q = mobGenerationDisabled;
        this.r = aquifers;
        this.s = noiseCaves;
        this.t = oreVeins;
        this.u = noodleCaves;
        this.j = useLegacyRandom ? SeededRandom.a.a : SeededRandom.a.b;
    }

    public StructureSettings a() {
        return this.k;
    }

    public NoiseSettings b() {
        return this.l;
    }

    public IBlockData c() {
        return this.m;
    }

    public IBlockData d() {
        return this.n;
    }

    public SurfaceRules.o e() {
        return this.o;
    }

    public int f() {
        return this.p;
    }

    @Deprecated
    protected boolean g() {
        return this.q;
    }

    public boolean h() {
        return this.r;
    }

    public boolean i() {
        return this.s;
    }

    public boolean j() {
        return this.t;
    }

    public boolean k() {
        return this.u;
    }

    public boolean l() {
        return this.j == SeededRandom.a.a;
    }

    public RandomSource a(long seed) {
        return this.m().a(seed);
    }

    public SeededRandom.a m() {
        return this.j;
    }

    public boolean a(ResourceKey<GeneratorSettingBase> registryKey) {
        return Objects.equals(this, RegistryGeneration.j.a(registryKey));
    }

    private static void a(ResourceKey<GeneratorSettingBase> registryKey, GeneratorSettingBase settings) {
        RegistryGeneration.a(RegistryGeneration.j, registryKey.a(), settings);
    }

    public static GeneratorSettingBase n() {
        return (GeneratorSettingBase)RegistryGeneration.j.iterator().next();
    }

    private static GeneratorSettingBase o() {
        return new GeneratorSettingBase(new StructureSettings(false), NoiseSettings.a(0, 128, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlider(-23.4375, 64, -46), new NoiseSlider(-0.234375, 7, 1), 2, 1, true, false, false, TerrainProvider.d()), Blocks.eq.n(), Blocks.a.n(), SurfaceRuleData.c(), 0, true, false, false, false, false, true);
    }

    private static GeneratorSettingBase p() {
        HashMap map = Maps.newHashMap(StructureSettings.b);
        map.put(StructureGenerator.i, new StructureSettingsFeature(25, 10, 34222645));
        return new GeneratorSettingBase(new StructureSettings(Optional.empty(), map), NoiseSettings.a(0, 128, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlider(0.9375, 3, 0), new NoiseSlider(2.5, 4, -1), 1, 2, false, false, false, TerrainProvider.c()), Blocks.cT.n(), Blocks.B.n(), SurfaceRuleData.b(), 32, false, false, false, false, false, true);
    }

    private static GeneratorSettingBase a(boolean amplified, boolean largeBiomes) {
        return new GeneratorSettingBase(new StructureSettings(true), NoiseSettings.a(-64, 384, new NoiseSamplingSettings(1.0, 1.0, 80.0, 160.0), new NoiseSlider(-0.078125, 2, amplified ? 0 : 8), new NoiseSlider(amplified ? 0.4 : 0.1171875, 3, 0), 1, 2, false, amplified, largeBiomes, TerrainProvider.a(amplified)), Blocks.b.n(), Blocks.A.n(), SurfaceRuleData.a(), 63, false, true, true, true, true, false);
    }

    private static GeneratorSettingBase q() {
        return new GeneratorSettingBase(new StructureSettings(false), NoiseSettings.a(-64, 192, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlider(0.9375, 3, 0), new NoiseSlider(2.5, 4, -1), 1, 2, false, false, false, TerrainProvider.a()), Blocks.b.n(), Blocks.A.n(), SurfaceRuleData.a(false, true, true), 32, false, false, false, false, false, true);
    }

    private static GeneratorSettingBase r() {
        return new GeneratorSettingBase(new StructureSettings(true), NoiseSettings.a(0, 256, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlider(-23.4375, 64, -46), new NoiseSlider(-0.234375, 7, 1), 2, 1, false, false, false, TerrainProvider.b()), Blocks.b.n(), Blocks.A.n(), SurfaceRuleData.a(false, false, false), -64, false, false, false, false, false, true);
    }

    static {
        GeneratorSettingBase.a(c, GeneratorSettingBase.a(false, false));
        GeneratorSettingBase.a(d, GeneratorSettingBase.a(false, true));
        GeneratorSettingBase.a(e, GeneratorSettingBase.a(true, false));
        GeneratorSettingBase.a(f, GeneratorSettingBase.p());
        GeneratorSettingBase.a(g, GeneratorSettingBase.o());
        GeneratorSettingBase.a(h, GeneratorSettingBase.q());
        GeneratorSettingBase.a(i, GeneratorSettingBase.r());
    }
}

