/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AxisAlignedBB;

public class EntitySectionStorage<T extends EntityAccess> {
    private final Class<T> a;
    private final Long2ObjectFunction<Visibility> b;
    private final Long2ObjectMap<EntitySection<T>> c = new Long2ObjectOpenHashMap();
    private final LongSortedSet d = new LongAVLTreeSet();

    public EntitySectionStorage(Class<T> entityClass, Long2ObjectFunction<Visibility> chunkStatusDiscriminator) {
        this.a = entityClass;
        this.b = chunkStatusDiscriminator;
    }

    public void a(AxisAlignedBB box, Consumer<EntitySection<T>> action) {
        int i2 = SectionPosition.a(box.a - 2.0);
        int j2 = SectionPosition.a(box.b - 2.0);
        int k2 = SectionPosition.a(box.c - 2.0);
        int l2 = SectionPosition.a(box.d + 2.0);
        int m2 = SectionPosition.a(box.e + 2.0);
        int n2 = SectionPosition.a(box.f + 2.0);
        for (int o2 = i2; o2 <= l2; ++o2) {
            long p2 = SectionPosition.b(o2, 0, 0);
            long q2 = SectionPosition.b(o2, -1, -1);
            LongBidirectionalIterator longIterator = this.d.subSet(p2, q2 + 1L).iterator();
            while (longIterator.hasNext()) {
                EntitySection entitySection;
                long r2 = longIterator.nextLong();
                int s2 = SectionPosition.c(r2);
                int t2 = SectionPosition.d(r2);
                if (s2 < j2 || s2 > m2 || t2 < k2 || t2 > n2 || (entitySection = (EntitySection)this.c.get(r2)) == null || entitySection.a() || !entitySection.c().b()) continue;
                action.accept(entitySection);
            }
        }
    }

    public LongStream a(long chunkPos) {
        int j2;
        int i2 = ChunkCoordIntPair.a(chunkPos);
        LongSortedSet longSortedSet = this.a(i2, j2 = ChunkCoordIntPair.b(chunkPos));
        if (longSortedSet.isEmpty()) {
            return LongStream.empty();
        }
        LongBidirectionalIterator ofLong = longSortedSet.iterator();
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize((PrimitiveIterator.OfLong)ofLong, 1301), false);
    }

    private LongSortedSet a(int chunkX, int chunkZ) {
        long l2 = SectionPosition.b(chunkX, 0, chunkZ);
        long m2 = SectionPosition.b(chunkX, -1, chunkZ);
        return this.d.subSet(l2, m2 + 1L);
    }

    public Stream<EntitySection<T>> b(long chunkPos) {
        return this.a(chunkPos).mapToObj(arg_0 -> this.c.get(arg_0)).filter(Objects::nonNull);
    }

    private static long f(long sectionPos) {
        return ChunkCoordIntPair.a(SectionPosition.b(sectionPos), SectionPosition.d(sectionPos));
    }

    public EntitySection<T> c(long sectionPos) {
        return (EntitySection)this.c.computeIfAbsent(sectionPos, this::g);
    }

    @Nullable
    public EntitySection<T> d(long sectionPos) {
        return (EntitySection)this.c.get(sectionPos);
    }

    private EntitySection<T> g(long sectionPos) {
        long l2 = EntitySectionStorage.f(sectionPos);
        Visibility visibility = (Visibility)((Object)this.b.get(l2));
        this.d.add(sectionPos);
        return new EntitySection<T>(this.a, visibility);
    }

    public LongSet a() {
        LongOpenHashSet longSet = new LongOpenHashSet();
        this.c.keySet().forEach(arg_0 -> EntitySectionStorage.a((LongSet)longSet, arg_0));
        return longSet;
    }

    public void b(AxisAlignedBB box, Consumer<T> action) {
        this.getEntities(box, action, false);
    }

    public void getEntities(AxisAlignedBB box, Consumer<T> action, boolean isContainerSearch) {
        this.a(box, section -> {
            if (isContainerSearch && section.inventoryEntityCount <= 0) {
                return;
            }
            section.a(box, action);
        });
    }

    public <U extends T> void a(EntityTypeTest<T, U> filter, AxisAlignedBB box, Consumer<U> action) {
        this.a(box, section -> {
            if (filter.a() == EntityItem.class && section.itemCount <= 0) {
                return;
            }
            section.a(filter, box, action);
        });
    }

    public void e(long sectionPos) {
        this.c.remove(sectionPos);
        this.d.remove(sectionPos);
    }

    @VisibleForDebug
    public int b() {
        return this.d.size();
    }

    private static /* synthetic */ void a(LongSet longSet, long sectionPos) {
        longSet.add(EntitySectionStorage.f(sectionPos));
    }
}

