/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;

public final class WorldDimension {
    public static final Codec<WorldDimension> a = RecordCodecBuilder.create(instance -> instance.group((App)DimensionManager.u.fieldOf("type").flatXmap(ExtraCodecs.c(), ExtraCodecs.c()).forGetter(WorldDimension::a), (App)ChunkGenerator.a.fieldOf("generator").forGetter(WorldDimension::c)).apply((Applicative)instance, instance.stable(WorldDimension::new)));
    public static final ResourceKey<WorldDimension> b = ResourceKey.a(IRegistry.S, new MinecraftKey("overworld"));
    public static final ResourceKey<WorldDimension> c = ResourceKey.a(IRegistry.S, new MinecraftKey("the_nether"));
    public static final ResourceKey<WorldDimension> d = ResourceKey.a(IRegistry.S, new MinecraftKey("the_end"));
    private static final Set<ResourceKey<WorldDimension>> e = Sets.newLinkedHashSet((Iterable)ImmutableList.of(b, c, d));
    private final Supplier<DimensionManager> f;
    private final ChunkGenerator g;

    public WorldDimension(Supplier<DimensionManager> typeSupplier, ChunkGenerator chunkGenerator) {
        this.f = typeSupplier;
        this.g = chunkGenerator;
    }

    public Supplier<DimensionManager> a() {
        return this.f;
    }

    public DimensionManager b() {
        return this.f.get();
    }

    public ChunkGenerator c() {
        return this.g;
    }

    public static RegistryMaterials<WorldDimension> a(RegistryMaterials<WorldDimension> mappedRegistry) {
        RegistryMaterials<WorldDimension> mappedRegistry2 = new RegistryMaterials<WorldDimension>(IRegistry.S, Lifecycle.experimental());
        for (ResourceKey<WorldDimension> resourceKey : e) {
            WorldDimension levelStem = mappedRegistry.a(resourceKey);
            if (levelStem == null) continue;
            mappedRegistry2.a(resourceKey, levelStem, mappedRegistry.d(levelStem));
        }
        for (Map.Entry entry : mappedRegistry.e()) {
            ResourceKey resourceKey2 = (ResourceKey)entry.getKey();
            if (e.contains(resourceKey2)) continue;
            mappedRegistry2.a(resourceKey2, (WorldDimension)entry.getValue(), mappedRegistry.d((WorldDimension)entry.getValue()));
        }
        return mappedRegistry2;
    }

    public static boolean a(long seed, RegistryMaterials<WorldDimension> options) {
        ArrayList list = Lists.newArrayList(options.e());
        if (list.size() != e.size()) {
            return false;
        }
        Map.Entry entry = (Map.Entry)list.get(0);
        Map.Entry entry2 = (Map.Entry)list.get(1);
        Map.Entry entry3 = (Map.Entry)list.get(2);
        if (entry.getKey() != b || entry2.getKey() != c || entry3.getKey() != d) {
            return false;
        }
        if (!((WorldDimension)entry.getValue()).b().a(DimensionManager.p) && ((WorldDimension)entry.getValue()).b() != DimensionManager.t) {
            return false;
        }
        if (!((WorldDimension)entry2.getValue()).b().a(DimensionManager.q)) {
            return false;
        }
        if (!((WorldDimension)entry3.getValue()).b().a(DimensionManager.r)) {
            return false;
        }
        if (!(((WorldDimension)entry2.getValue()).c() instanceof ChunkGeneratorAbstract) || !(((WorldDimension)entry3.getValue()).c() instanceof ChunkGeneratorAbstract)) {
            return false;
        }
        ChunkGeneratorAbstract noiseBasedChunkGenerator = (ChunkGeneratorAbstract)((WorldDimension)entry2.getValue()).c();
        ChunkGeneratorAbstract noiseBasedChunkGenerator2 = (ChunkGeneratorAbstract)((WorldDimension)entry3.getValue()).c();
        if (!noiseBasedChunkGenerator.a(seed, GeneratorSettingBase.f)) {
            return false;
        }
        if (!noiseBasedChunkGenerator2.a(seed, GeneratorSettingBase.g)) {
            return false;
        }
        if (!(noiseBasedChunkGenerator.e() instanceof WorldChunkManagerMultiNoise)) {
            return false;
        }
        WorldChunkManagerMultiNoise multiNoiseBiomeSource = (WorldChunkManagerMultiNoise)noiseBasedChunkGenerator.e();
        if (!multiNoiseBiomeSource.a(WorldChunkManagerMultiNoise.a.a)) {
            return false;
        }
        WorldChunkManager biomeSource = ((WorldDimension)entry.getValue()).c().e();
        if (biomeSource instanceof WorldChunkManagerMultiNoise && !((WorldChunkManagerMultiNoise)biomeSource).a(WorldChunkManagerMultiNoise.a.b)) {
            return false;
        }
        if (!(noiseBasedChunkGenerator2.e() instanceof WorldChunkManagerTheEnd)) {
            return false;
        }
        WorldChunkManagerTheEnd theEndBiomeSource = (WorldChunkManagerTheEnd)noiseBasedChunkGenerator2.e();
        return theEndBiomeSource.b(seed);
    }
}

