/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class DimensionManager {
    public static final int a = BlockPosition.c;
    public static final int b = 16;
    public static final int c = (1 << a) - 32;
    public static final int d = (c >> 1) - 1;
    public static final int e = d - c + 1;
    public static final int f = d << 4;
    public static final int g = e << 4;
    public static final MinecraftKey h = new MinecraftKey("overworld");
    public static final MinecraftKey i = new MinecraftKey("the_nether");
    public static final MinecraftKey j = new MinecraftKey("the_end");
    public static final Codec<DimensionManager> k = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("fixed_time").xmap(optional -> optional.map(OptionalLong::of).orElseGet(OptionalLong::empty), optionalLong -> optionalLong.isPresent() ? Optional.of(optionalLong.getAsLong()) : Optional.empty()).forGetter(dimensionType -> dimensionType.w), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionManager::b), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionManager::c), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionManager::d), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionManager::e), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionManager::f), (App)Codec.BOOL.fieldOf("piglin_safe").forGetter(DimensionManager::g), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionManager::h), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionManager::i), (App)Codec.BOOL.fieldOf("has_raids").forGetter(DimensionManager::j), (App)Codec.intRange((int)e, (int)d).fieldOf("min_y").forGetter(DimensionManager::k), (App)Codec.intRange((int)16, (int)c).fieldOf("height").forGetter(DimensionManager::l), (App)Codec.intRange((int)0, (int)c).fieldOf("logical_height").forGetter(DimensionManager::m), (App)MinecraftKey.a.fieldOf("infiniburn").forGetter(dimensionType -> dimensionType.K), (App)MinecraftKey.a.fieldOf("effects").orElse((Object)h).forGetter(dimensionType -> dimensionType.L), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(dimensionType -> Float.valueOf(dimensionType.M))).apply((Applicative)instance, DimensionManager::new)).comapFlatMap(DimensionManager::b, Function.identity());
    private static final int v = 8;
    public static final float[] l = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final ResourceKey<DimensionManager> m = ResourceKey.a(IRegistry.Q, new MinecraftKey("overworld"));
    public static final ResourceKey<DimensionManager> n = ResourceKey.a(IRegistry.Q, new MinecraftKey("the_nether"));
    public static final ResourceKey<DimensionManager> o = ResourceKey.a(IRegistry.Q, new MinecraftKey("the_end"));
    protected static final DimensionManager p = DimensionManager.a(OptionalLong.empty(), true, false, false, true, 1.0, false, false, true, false, true, -64, 384, 384, TagsBlock.aO.a(), h, 0.0f);
    protected static final DimensionManager q = DimensionManager.a(OptionalLong.of(18000L), false, true, true, false, 8.0, false, true, false, true, false, 0, 256, 128, TagsBlock.aP.a(), i, 0.1f);
    protected static final DimensionManager r = DimensionManager.a(OptionalLong.of(6000L), false, false, false, false, 1.0, true, false, false, false, true, 0, 256, 256, TagsBlock.aQ.a(), j, 0.0f);
    public static final ResourceKey<DimensionManager> s = ResourceKey.a(IRegistry.Q, new MinecraftKey("overworld_caves"));
    protected static final DimensionManager t = DimensionManager.a(OptionalLong.empty(), true, true, false, true, 1.0, false, false, true, false, true, -64, 384, 384, TagsBlock.aO.a(), h, 0.0f);
    public static final Codec<Supplier<DimensionManager>> u = RegistryFileCodec.a(IRegistry.Q, k);
    private final OptionalLong w;
    private final boolean x;
    private final boolean y;
    private final boolean z;
    private final boolean A;
    private final double B;
    private final boolean C;
    private final boolean D;
    private final boolean E;
    private final boolean F;
    private final boolean G;
    private final int H;
    private final int I;
    private final int J;
    private final MinecraftKey K;
    private final MinecraftKey L;
    private final float M;
    private final transient float[] N;

    private static DataResult<DimensionManager> b(DimensionManager type) {
        if (type.l() < 16) {
            return DataResult.error((String)"height has to be at least 16");
        }
        if (type.k() + type.l() > d + 1) {
            return DataResult.error((String)("min_y + height cannot be higher than: " + (d + 1)));
        }
        if (type.m() > type.l()) {
            return DataResult.error((String)"logical_height cannot be higher than height");
        }
        if (type.l() % 16 != 0) {
            return DataResult.error((String)"height has to be multiple of 16");
        }
        if (type.k() % 16 != 0) {
            return DataResult.error((String)"min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)type);
    }

    private DimensionManager(OptionalLong fixedTime, boolean hasSkylight, boolean hasCeiling, boolean ultrawarm, boolean natural, double coordinateScale, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasRaids, int minimumY, int height, int logicalHeight, MinecraftKey infiniburn, MinecraftKey effects, float ambientLight) {
        this(fixedTime, hasSkylight, hasCeiling, ultrawarm, natural, coordinateScale, false, piglinSafe, bedWorks, respawnAnchorWorks, hasRaids, minimumY, height, logicalHeight, infiniburn, effects, ambientLight);
    }

    public static DimensionManager a(OptionalLong fixedTime, boolean hasSkylight, boolean hasCeiling, boolean ultrawarm, boolean natural, double coordinateScale, boolean hasEnderDragonFight, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasRaids, int minimumY, int height, int logicalHeight, MinecraftKey infiniburn, MinecraftKey effects, float ambientLight) {
        DimensionManager dimensionType = new DimensionManager(fixedTime, hasSkylight, hasCeiling, ultrawarm, natural, coordinateScale, hasEnderDragonFight, piglinSafe, bedWorks, respawnAnchorWorks, hasRaids, minimumY, height, logicalHeight, infiniburn, effects, ambientLight);
        DimensionManager.b(dimensionType).error().ifPresent(partialResult -> {
            throw new IllegalStateException(partialResult.message());
        });
        return dimensionType;
    }

    @Deprecated
    private DimensionManager(OptionalLong fixedTime, boolean hasSkylight, boolean hasCeiling, boolean ultrawarm, boolean natural, double coordinateScale, boolean hasEnderDragonFight, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasRaids, int minimumY, int height, int logicalHeight, MinecraftKey infiniburn, MinecraftKey effects, float ambientLight) {
        this.w = fixedTime;
        this.x = hasSkylight;
        this.y = hasCeiling;
        this.z = ultrawarm;
        this.A = natural;
        this.B = coordinateScale;
        this.C = hasEnderDragonFight;
        this.D = piglinSafe;
        this.E = bedWorks;
        this.F = respawnAnchorWorks;
        this.G = hasRaids;
        this.H = minimumY;
        this.I = height;
        this.J = logicalHeight;
        this.K = infiniburn;
        this.L = effects;
        this.M = ambientLight;
        this.N = DimensionManager.a(ambientLight);
    }

    private static float[] a(float ambientLight) {
        float[] fs = new float[16];
        for (int i2 = 0; i2 <= 15; ++i2) {
            float f2 = (float)i2 / 15.0f;
            float g2 = f2 / (4.0f - 3.0f * f2);
            fs[i2] = MathHelper.i(ambientLight, g2, 1.0f);
        }
        return fs;
    }

    @Deprecated
    public static DataResult<ResourceKey<World>> a(Dynamic<?> nbt) {
        Optional optional = nbt.asNumber().result();
        if (optional.isPresent()) {
            int i2 = ((Number)optional.get()).intValue();
            if (i2 == -1) {
                return DataResult.success(World.g);
            }
            if (i2 == 0) {
                return DataResult.success(World.f);
            }
            if (i2 == 1) {
                return DataResult.success(World.h);
            }
        }
        return World.e.parse(nbt);
    }

    public static IRegistryCustom a(IRegistryCustom registryManager) {
        IRegistryWritable<DimensionManager> writableRegistry = registryManager.b(IRegistry.Q);
        writableRegistry.a(m, p, Lifecycle.stable());
        writableRegistry.a(s, t, Lifecycle.stable());
        writableRegistry.a(n, q, Lifecycle.stable());
        writableRegistry.a(o, r, Lifecycle.stable());
        return registryManager;
    }

    public static RegistryMaterials<WorldDimension> a(IRegistryCustom registryManager, long seed) {
        return DimensionManager.a(registryManager, seed, true);
    }

    public static RegistryMaterials<WorldDimension> a(IRegistryCustom registryManager, long seed, boolean bl) {
        RegistryMaterials<WorldDimension> mappedRegistry = new RegistryMaterials<WorldDimension>(IRegistry.S, Lifecycle.experimental());
        IRegistry<DimensionManager> registry = registryManager.d(IRegistry.Q);
        IRegistry<BiomeBase> registry2 = registryManager.d(IRegistry.aR);
        IRegistry<GeneratorSettingBase> registry3 = registryManager.d(IRegistry.aK);
        IRegistry<NoiseGeneratorNormal.a> registry4 = registryManager.d(IRegistry.aS);
        mappedRegistry.a(WorldDimension.c, new WorldDimension(() -> registry.d(n), new ChunkGeneratorAbstract(registry4, (WorldChunkManager)WorldChunkManagerMultiNoise.a.a.a(registry2, bl), seed, () -> registry3.d(GeneratorSettingBase.f))), Lifecycle.stable());
        mappedRegistry.a(WorldDimension.d, new WorldDimension(() -> registry.d(o), new ChunkGeneratorAbstract(registry4, (WorldChunkManager)new WorldChunkManagerTheEnd(registry2, seed), seed, () -> registry3.d(GeneratorSettingBase.g))), Lifecycle.stable());
        return mappedRegistry;
    }

    public static double a(DimensionManager fromDimension, DimensionManager toDimension) {
        double d2 = fromDimension.f();
        double e2 = toDimension.f();
        return d2 / e2;
    }

    @Deprecated
    public String a() {
        if (this.a(r)) {
            return "_end";
        }
        return "";
    }

    public static Path a(ResourceKey<World> worldRef, Path worldDirectory) {
        if (worldRef == World.f) {
            return worldDirectory;
        }
        if (worldRef == World.h) {
            return worldDirectory.resolve("DIM1");
        }
        if (worldRef == World.g) {
            return worldDirectory.resolve("DIM-1");
        }
        return worldDirectory.resolve("dimensions").resolve(worldRef.a().b()).resolve(worldRef.a().a());
    }

    public boolean b() {
        return this.x;
    }

    public boolean c() {
        return this.y;
    }

    public boolean d() {
        return this.z;
    }

    public boolean e() {
        return this.A;
    }

    public double f() {
        return this.B;
    }

    public boolean g() {
        return this.D;
    }

    public boolean h() {
        return this.E;
    }

    public boolean i() {
        return this.F;
    }

    public boolean j() {
        return this.G;
    }

    public int k() {
        return this.H;
    }

    public int l() {
        return this.I;
    }

    public int m() {
        return this.J;
    }

    public boolean n() {
        return this.C;
    }

    public boolean o() {
        return this.w.isPresent();
    }

    public float a(long time) {
        double d2 = MathHelper.g((double)this.w.orElse(time) / 24000.0 - 0.25);
        double e2 = 0.5 - Math.cos(d2 * Math.PI) / 2.0;
        return (float)(d2 * 2.0 + e2) / 3.0f;
    }

    public int b(long time) {
        return (int)(time / 24000L % 8L + 8L) % 8;
    }

    public float a(int lightLevel) {
        return this.N[lightLevel];
    }

    public Tag<Block> p() {
        Tag<Block> tag = TagsBlock.a().a(this.K);
        return tag != null ? tag : TagsBlock.aO;
    }

    public MinecraftKey q() {
        return this.L;
    }

    public boolean a(DimensionManager dimensionType) {
        if (this == dimensionType) {
            return true;
        }
        return this.x == dimensionType.x && this.y == dimensionType.y && this.z == dimensionType.z && this.A == dimensionType.A && this.B == dimensionType.B && this.C == dimensionType.C && this.D == dimensionType.D && this.E == dimensionType.E && this.F == dimensionType.F && this.G == dimensionType.G && this.H == dimensionType.H && this.I == dimensionType.I && this.J == dimensionType.J && Float.compare(dimensionType.M, this.M) == 0 && this.w.equals(dimensionType.w) && this.K.equals(dimensionType.K) && this.L.equals(dimensionType.L);
    }
}

