/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.util.WorldUtil;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spigotmc.AsyncCatcher;

public class ChunkRegionLoader {
    public static final Codec<DataPaletteBlock<IBlockData>> a = DataPaletteBlock.codec(Block.p, IBlockData.b, DataPaletteBlock.e.d, Blocks.a.n(), null);
    private static final Logger b = LogManager.getLogger();
    private static final String c = "UpgradeData";
    private static final String d = "block_ticks";
    private static final String e = "fluid_ticks";
    private static final int STARLIGHT_LIGHT_VERSION = 7;
    private static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    private static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    private static final String STARLIGHT_VERSION_TAG = "starlight.light_version";
    private static final int CURRENT_DATA_VERSION = SharedConstants.b().b().c();
    private static final boolean JUST_CORRUPT_IT = Boolean.getBoolean("Paper.ignoreWorldDataVersion");

    public static long getLastWorldSaveTime(NBTTagCompound chunkData) {
        int dataVersion = IChunkLoader.a(chunkData);
        if (dataVersion < 2842) {
            NBTTagCompound levelData = chunkData.p("Level");
            return levelData.i("LastUpdate");
        }
        return chunkData.i("LastUpdate");
    }

    public static ChunkCoordIntPair getChunkCoordinate(NBTTagCompound chunkData) {
        int dataVersion = IChunkLoader.a(chunkData);
        if (dataVersion < 2842) {
            NBTTagCompound levelData = chunkData.p("Level");
            return new ChunkCoordIntPair(levelData.h("xPos"), levelData.h("zPos"));
        }
        return new ChunkCoordIntPair(chunkData.h("xPos"), chunkData.h("zPos"));
    }

    public static ProtoChunk a(WorldServer world, VillagePlace poiStorage, ChunkCoordIntPair chunkPos, NBTTagCompound nbt) {
        InProgressChunkHolder holder = ChunkRegionLoader.loadChunk(world, poiStorage, chunkPos, nbt, true);
        holder.tasks.forEach(Runnable::run);
        return holder.protoChunk;
    }

    public static InProgressChunkHolder loadChunk(WorldServer world, VillagePlace poiStorage, ChunkCoordIntPair chunkPos, NBTTagCompound nbt, boolean distinguish) {
        NBTTagCompound nbttagcompound4;
        int i1;
        IChunkAccess object;
        BlendingData blendingdata;
        DataResult dataresult;
        ChunkCoordIntPair chunkcoordintpair1;
        ArrayDeque<Runnable> tasksToExecuteOnMain = new ArrayDeque<Runnable>();
        if (nbt.b("DataVersion", 99)) {
            int dataVersion = nbt.h("DataVersion");
            if (!JUST_CORRUPT_IT && dataVersion > CURRENT_DATA_VERSION) {
                new RuntimeException("Server attempted to load chunk saved with newer version of minecraft! " + dataVersion + " > " + CURRENT_DATA_VERSION).printStackTrace();
                System.exit(1);
            }
        }
        if (!Objects.equals(chunkPos, chunkcoordintpair1 = new ChunkCoordIntPair(nbt.h("xPos"), nbt.h("zPos")))) {
            b.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", (Object)chunkPos, (Object)chunkPos, (Object)chunkcoordintpair1);
        }
        ChunkConverter chunkconverter = nbt.b(c, 10) ? new ChunkConverter(nbt.p(c), world) : ChunkConverter.a;
        boolean flag = ChunkRegionLoader.getStatus(nbt).b(ChunkStatus.l) && nbt.c("isLightOn") != null && nbt.h(STARLIGHT_VERSION_TAG) == 7;
        NBTTagList nbttaglist = nbt.c("sections", 10);
        int i2 = world.ah();
        ChunkSection[] achunksection = new ChunkSection[i2];
        boolean flag1 = world.q_().b();
        ChunkProviderServer chunkproviderserver = world.k();
        LightEngineThreaded lightengine = chunkproviderserver.a();
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        boolean canReadSky = world.q_().b();
        if (flag) {
            tasksToExecuteOnMain.add(() -> lightengine.b(chunkPos, true));
        }
        IRegistry<BiomeBase> iregistry = world.t().d(IRegistry.aR);
        Codec<DataPaletteBlock<BiomeBase>> codec = ChunkRegionLoader.a(iregistry);
        for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
            NBTTagCompound nbttagcompound1;
            NBTTagCompound sectionData = nbttagcompound1 = nbttaglist.a(j2);
            byte b0 = nbttagcompound1.f("Y");
            int k2 = world.f(b0);
            if (k2 >= 0 && k2 < achunksection.length) {
                ChunkSection chunksection;
                DataPaletteBlock datapaletteblock1;
                DataPaletteBlock datapaletteblock;
                Logger logger;
                IBlockData[] presetBlockStates = world.chunkPacketBlockController.getPresetBlockStates(world, chunkPos, b0 << 4);
                if (nbttagcompound1.b("block_states", 10)) {
                    Codec<DataPaletteBlock<IBlockData>> blockStateCodec = presetBlockStates == null ? a : DataPaletteBlock.codec(Block.p, IBlockData.b, DataPaletteBlock.e.d, Blocks.a.n(), presetBlockStates);
                    dataresult = blockStateCodec.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound1.p("block_states")).promotePartial(s2 -> ChunkRegionLoader.a(chunkPos, b0, s2));
                    logger = b;
                    Objects.requireNonNull(logger);
                    datapaletteblock = (DataPaletteBlock)dataresult.getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
                } else {
                    datapaletteblock = new DataPaletteBlock(Block.p, Blocks.a.n(), DataPaletteBlock.e.d, presetBlockStates);
                }
                if (nbttagcompound1.b("biomes", 10)) {
                    dataresult = codec.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound1.p("biomes")).promotePartial(s2 -> ChunkRegionLoader.a(chunkPos, b0, s2));
                    logger = b;
                    Objects.requireNonNull(logger);
                    datapaletteblock1 = (DataPaletteBlock)dataresult.getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0));
                } else {
                    datapaletteblock1 = new DataPaletteBlock(iregistry, iregistry.d(Biomes.b), DataPaletteBlock.e.e, null);
                }
                achunksection[k2] = chunksection = new ChunkSection(b0, datapaletteblock, datapaletteblock1);
                tasksToExecuteOnMain.add(() -> poiStorage.a(chunkPos, chunksection));
            }
            if (!flag) continue;
            byte y2 = sectionData.f("Y");
            blockNibbles[y2 - minSection] = sectionData.b("BlockLight", 7) ? new SWMRNibbleArray((byte[])sectionData.m("BlockLight").clone(), sectionData.h(BLOCKLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.h(BLOCKLIGHT_STATE_TAG));
            if (!canReadSky) continue;
            skyNibbles[y2 - minSection] = sectionData.b("SkyLight", 7) ? new SWMRNibbleArray((byte[])sectionData.m("SkyLight").clone(), sectionData.h(SKYLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.h(SKYLIGHT_STATE_TAG));
        }
        long l2 = nbt.i("InhabitedTime");
        ChunkStatus.Type chunkstatus_type = ChunkRegionLoader.a(nbt);
        if (nbt.b("blending_data", 10)) {
            dataresult = BlendingData.f.parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p("blending_data")));
            Logger logger1 = b;
            Objects.requireNonNull(logger1);
            blendingdata = dataresult.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(null);
        } else {
            blendingdata = null;
        }
        if (chunkstatus_type == ChunkStatus.Type.b) {
            LevelChunkTicks<Block> levelchunkticks = LevelChunkTicks.a(nbt.c(d, 10), (String s2) -> IRegistry.X.b(MinecraftKey.a(s2)), chunkPos);
            LevelChunkTicks<FluidType> levelchunkticks1 = LevelChunkTicks.a(nbt.c(e, 10), (String s2) -> IRegistry.V.b(MinecraftKey.a(s2)), chunkPos);
            object = new Chunk(world.G(), chunkPos, chunkconverter, levelchunkticks, levelchunkticks1, l2, achunksection, ChunkRegionLoader.a(world, nbt), blendingdata);
            object.setBlockNibbles(blockNibbles);
            object.setSkyNibbles(skyNibbles);
        } else {
            boolean flag2;
            ProtoChunkTickList<Block> protochunkticklist = ProtoChunkTickList.a(nbt.c(d, 10), (String s2) -> IRegistry.X.b(MinecraftKey.a(s2)), chunkPos);
            ProtoChunkTickList<FluidType> protochunkticklist1 = ProtoChunkTickList.a(nbt.c(e, 10), (String s2) -> IRegistry.V.b(MinecraftKey.a(s2)), chunkPos);
            ProtoChunk protochunk = new ProtoChunk(chunkPos, chunkconverter, achunksection, protochunkticklist, protochunkticklist1, world, iregistry, blendingdata);
            protochunk.setBlockNibbles(blockNibbles);
            protochunk.setSkyNibbles(skyNibbles);
            object = protochunk;
            protochunk.b(l2);
            if (nbt.b("below_zero_retrogen", 10)) {
                dataresult = BelowZeroRetrogen.a.parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p("below_zero_retrogen")));
                Logger logger1 = b;
                Objects.requireNonNull(logger1);
                Optional optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0));
                Objects.requireNonNull(protochunk);
                optional.ifPresent(protochunk::a);
            }
            ChunkStatus chunkstatus = ChunkStatus.a(nbt.l("Status"));
            protochunk.a(chunkstatus);
            if (chunkstatus.b(ChunkStatus.k)) {
                protochunk.a(lightengine);
            }
            BelowZeroRetrogen belowzeroretrogen = protochunk.x();
            boolean bl = flag2 = chunkstatus.b(ChunkStatus.l) || belowzeroretrogen != null && belowzeroretrogen.a().b(ChunkStatus.l);
            if (!flag) {
                int offX = chunkPos.c << 4;
                int offZ = chunkPos.d << 4;
                int minChunkSection = WorldUtil.getMinSection(world);
                int maxChunkSection = WorldUtil.getMaxSection(world);
                ChunkSection[] sections = achunksection;
                for (int sectionY = minChunkSection; sectionY <= maxChunkSection; ++sectionY) {
                    ChunkSection section = sections[sectionY - minChunkSection];
                    if (section == null || section.c()) continue;
                    int offY = sectionY << 4;
                    for (int index = 0; index < 4096; ++index) {
                        if (section.i.a(index).f() <= 0) continue;
                        protochunk.j(new BlockPosition(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF));
                    }
                }
            }
        }
        NBTBase persistentBase = nbt.c("ChunkBukkitValues");
        if (persistentBase instanceof NBTTagCompound) {
            object.persistentDataContainer.putAll((NBTTagCompound)persistentBase);
        }
        object.b(flag);
        NBTTagCompound nbttagcompound2 = nbt.p("Heightmaps");
        EnumSet<HeightMap.Type> enumset = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type heightmap_type : object.j().h()) {
            String s3 = heightmap_type.a();
            if (nbttagcompound2.b(s3, 12)) {
                object.a(heightmap_type, nbttagcompound2.o(s3));
                continue;
            }
            enumset.add(heightmap_type);
        }
        HeightMap.a(object, enumset);
        NBTTagCompound nbttagcompound3 = nbt.p("structures");
        object.a(ChunkRegionLoader.a(StructurePieceSerializationContext.a(world), nbttagcompound3, world.E()));
        object.b(ChunkRegionLoader.a(chunkPos, nbttagcompound3));
        if (nbt.q("shouldSave")) {
            object.a(true);
        }
        NBTTagList nbttaglist1 = nbt.c("PostProcessing", 9);
        for (int j1 = 0; j1 < nbttaglist1.size(); ++j1) {
            NBTTagList nbttaglist2 = nbttaglist1.b(j1);
            for (i1 = 0; i1 < nbttaglist2.size(); ++i1) {
                object.a(nbttaglist2.d(i1), j1);
            }
        }
        if (chunkstatus_type == ChunkStatus.Type.b) {
            return new InProgressChunkHolder(new ProtoChunkExtension((Chunk)object, false), tasksToExecuteOnMain);
        }
        ProtoChunk protochunk1 = (ProtoChunk)object;
        NBTTagList nbttaglist2 = nbt.c("entities", 10);
        for (i1 = 0; i1 < nbttaglist2.size(); ++i1) {
            protochunk1.b(nbttaglist2.a(i1));
        }
        NBTTagList nbttaglist3 = nbt.c("block_entities", 10);
        for (int k1 = 0; k1 < nbttaglist3.size(); ++k1) {
            nbttagcompound4 = nbttaglist3.a(k1);
            object.a(nbttagcompound4);
        }
        NBTTagList nbttaglist4 = nbt.c("Lights", 9);
        for (int l1 = 0; l1 < nbttaglist4.size(); ++l1) {
            NBTTagList nbttaglist5 = nbttaglist4.b(l1);
            for (int i22 = 0; i22 < nbttaglist5.size(); ++i22) {
                protochunk1.b(nbttaglist5.d(i22), l1);
            }
        }
        nbttagcompound4 = nbt.p("CarvingMasks");
        for (String s1 : nbttagcompound4.d()) {
            WorldGenStage.Features worldgenstage_features = WorldGenStage.Features.valueOf(s1);
            protochunk1.a(worldgenstage_features, new CarvingMask(nbttagcompound4.o(s1), object.u_()));
        }
        return new InProgressChunkHolder(protochunk1, tasksToExecuteOnMain);
    }

    public static AsyncSaveData getAsyncSaveData(WorldServer world, IChunkAccess chunk) {
        AsyncCatcher.catchOp("preparation of chunk data for async save");
        ChunkCoordIntPair chunkPos = chunk.f();
        LightEngineThreaded lightenginethreaded = world.k().a();
        NibbleArray[] blockLight = new NibbleArray[lightenginethreaded.d() - lightenginethreaded.c()];
        NibbleArray[] skyLight = new NibbleArray[lightenginethreaded.d() - lightenginethreaded.c()];
        int n2 = lightenginethreaded.c();
        NBTTagCompound tickLists = new NBTTagCompound();
        ChunkRegionLoader.a(world, tickLists, chunk.q());
        NBTTagList blockEntitiesSerialized = new NBTTagList();
        for (BlockPosition blockPos : chunk.c()) {
            NBTTagCompound blockEntityNbt = chunk.i(blockPos);
            if (blockEntityNbt == null) continue;
            blockEntitiesSerialized.add(blockEntityNbt);
        }
        return new AsyncSaveData(blockLight, skyLight, tickLists.c(d), tickLists.c(e), blockEntitiesSerialized, world.V());
    }

    private static void a(ChunkCoordIntPair chunkPos, int y2, String message) {
        b.error("Recoverable errors when loading section [" + chunkPos.c + ", " + y2 + ", " + chunkPos.d + "]: " + message);
    }

    private static Codec<DataPaletteBlock<BiomeBase>> a(IRegistry<BiomeBase> biomeRegistry) {
        return DataPaletteBlock.codec(biomeRegistry, biomeRegistry.i(), DataPaletteBlock.e.e, biomeRegistry.d(Biomes.b), null);
    }

    public static NBTTagCompound a(WorldServer world, IChunkAccess chunk) {
        return ChunkRegionLoader.saveChunk(world, chunk, null);
    }

    public static NBTTagCompound saveChunk(WorldServer world, IChunkAccess chunk, @Nullable AsyncSaveData asyncsavedata) {
        Iterator<Object> iterator;
        NBTTagList nbttaglist1;
        ChunkConverter chunkconverter;
        BelowZeroRetrogen belowzeroretrogen;
        Logger logger;
        DataResult dataresult;
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        SWMRNibbleArray[] blockNibbles = chunk.getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.getSkyNibbles();
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.a("DataVersion", SharedConstants.b().getWorldVersion());
        nbttagcompound.a("xPos", chunkcoordintpair.c);
        nbttagcompound.a("yPos", chunk.ai());
        nbttagcompound.a("zPos", chunkcoordintpair.d);
        nbttagcompound.a("LastUpdate", asyncsavedata != null ? asyncsavedata.worldTime : world.V());
        nbttagcompound.a("InhabitedTime", chunk.u());
        nbttagcompound.a("Status", chunk.j().d());
        BlendingData blendingdata = chunk.t();
        if (blendingdata != null) {
            dataresult = BlendingData.f.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)blendingdata);
            logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("blending_data", (NBTBase)nbtbase));
        }
        if ((belowzeroretrogen = chunk.x()) != null) {
            dataresult = BelowZeroRetrogen.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)belowzeroretrogen);
            logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("below_zero_retrogen", (NBTBase)nbtbase));
        }
        if (!(chunkconverter = chunk.r()).a()) {
            nbttagcompound.a(c, chunkconverter.b());
        }
        ChunkSection[] achunksection = chunk.d();
        NBTTagList nbttaglist = new NBTTagList();
        LightEngineThreaded lightenginethreaded = world.k().a();
        IRegistry<BiomeBase> iregistry = world.t().d(IRegistry.aR);
        Codec<DataPaletteBlock<BiomeBase>> codec = ChunkRegionLoader.a(iregistry);
        boolean flag = chunk.v();
        for (int i2 = lightenginethreaded.c(); i2 < lightenginethreaded.d(); ++i2) {
            NBTTagCompound nbttagcompound1;
            int j2 = chunk.f(i2);
            boolean flag1 = j2 >= 0 && j2 < achunksection.length;
            SWMRNibbleArray.SaveState blockNibble = blockNibbles[i2 - minSection].getSaveState();
            SWMRNibbleArray.SaveState skyNibble = skyNibbles[i2 - minSection].getSaveState();
            if (!flag1 && blockNibble == null && skyNibble == null) continue;
            NBTTagCompound section = nbttagcompound1 = new NBTTagCompound();
            if (flag1) {
                ChunkSection chunksection = achunksection[j2];
                DataResult dataresult1 = a.encodeStart((DynamicOps)DynamicOpsNBT.a, chunksection.i());
                Logger logger1 = b;
                Objects.requireNonNull(logger1);
                nbttagcompound1.a("block_states", (NBTBase)dataresult1.getOrThrow(false, arg_0 -> ((Logger)logger1).error(arg_0)));
                dataresult1 = codec.encodeStart((DynamicOps)DynamicOpsNBT.a, chunksection.j());
                logger1 = b;
                Objects.requireNonNull(logger1);
                nbttagcompound1.a("biomes", (NBTBase)dataresult1.getOrThrow(false, arg_0 -> ((Logger)logger1).error(arg_0)));
            }
            if (blockNibble != null) {
                if (blockNibble.data != null) {
                    section.a("BlockLight", blockNibble.data);
                }
                section.a(BLOCKLIGHT_STATE_TAG, blockNibble.state);
            }
            if (skyNibble != null) {
                if (skyNibble.data != null) {
                    section.a("SkyLight", skyNibble.data);
                }
                section.a(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
            if (nbttagcompound1.f()) continue;
            nbttagcompound1.a("Y", (byte)i2);
            nbttaglist.add(nbttagcompound1);
        }
        nbttagcompound.a("sections", nbttaglist);
        if (flag) {
            nbttagcompound.a(STARLIGHT_VERSION_TAG, 7);
            nbttagcompound.a("isLightOn", false);
        }
        if (asyncsavedata != null) {
            nbttaglist1 = asyncsavedata.blockEntities;
            iterator = Collections.emptyIterator();
        } else {
            nbttaglist1 = new NBTTagList();
            iterator = chunk.c().iterator();
        }
        while (iterator.hasNext()) {
            BlockPosition blockposition = (BlockPosition)iterator.next();
            NBTTagCompound nbttagcompound2 = chunk.i(blockposition);
            if (nbttagcompound2 == null) continue;
            nbttaglist1.add(nbttagcompound2);
        }
        nbttagcompound.a("block_entities", nbttaglist1);
        if (chunk.j().g() == ChunkStatus.Type.a) {
            ProtoChunk protochunk = (ProtoChunk)chunk;
            NBTTagList nbttaglist2 = new NBTTagList();
            nbttaglist2.addAll(protochunk.D());
            nbttagcompound.a("entities", nbttaglist2);
            nbttagcompound.a("Lights", ChunkRegionLoader.a(protochunk.B()));
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            for (WorldGenStage.Features worldgenstage_features : WorldGenStage.Features.values()) {
                CarvingMask carvingmask = protochunk.a(worldgenstage_features);
                if (carvingmask == null) continue;
                nbttagcompound2.a(worldgenstage_features.toString(), carvingmask.a());
            }
            nbttagcompound.a("CarvingMasks", nbttagcompound2);
        }
        if (asyncsavedata != null) {
            nbttagcompound.a(d, asyncsavedata.blockTickList);
            nbttagcompound.a(e, asyncsavedata.fluidTickList);
        } else {
            ChunkRegionLoader.a(world, nbttagcompound, chunk.q());
        }
        nbttagcompound.a("PostProcessing", ChunkRegionLoader.a(chunk.m()));
        NBTTagCompound nbttagcompound3 = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : chunk.e()) {
            if (!chunk.j().h().contains(entry.getKey())) continue;
            nbttagcompound3.a(entry.getKey().a(), new NBTTagLongArray(entry.getValue().a()));
        }
        nbttagcompound.a("Heightmaps", nbttagcompound3);
        nbttagcompound.a("structures", ChunkRegionLoader.a(StructurePieceSerializationContext.a(world), chunkcoordintpair, chunk.g(), chunk.h()));
        if (!chunk.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("ChunkBukkitValues", chunk.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    private static void a(WorldServer world, NBTTagCompound nbt, IChunkAccess.a tickSchedulers) {
        long i2 = world.n_().e();
        nbt.a(d, tickSchedulers.a().b(i2, block -> IRegistry.X.b((Block)block).toString()));
        nbt.a(e, tickSchedulers.b().b(i2, fluidtype -> IRegistry.V.b((FluidType)fluidtype).toString()));
    }

    @javax.annotation.Nullable
    public static ChunkStatus getStatus(@javax.annotation.Nullable NBTTagCompound compound) {
        if (compound == null) {
            return null;
        }
        return ChunkStatus.getStatus(compound.l("Status"));
    }

    public static ChunkStatus.Type a(@javax.annotation.Nullable NBTTagCompound nbt) {
        return nbt != null ? ChunkStatus.a(nbt.l("Status")).g() : ChunkStatus.Type.a;
    }

    @javax.annotation.Nullable
    private static Chunk.c a(WorldServer world, NBTTagCompound nbt) {
        NBTTagList nbttaglist = ChunkRegionLoader.a(nbt, "entities");
        NBTTagList nbttaglist1 = ChunkRegionLoader.a(nbt, "block_entities");
        return nbttaglist == null && nbttaglist1 == null ? null : chunk -> {
            if (nbttaglist != null) {
                world.a(EntityTypes.a(nbttaglist, (World)world));
            }
            if (nbttaglist1 != null) {
                for (int i2 = 0; i2 < nbttaglist1.size(); ++i2) {
                    NBTTagCompound nbttagcompound1 = nbttaglist1.a(i2);
                    boolean flag = nbttagcompound1.q("keepPacked");
                    if (flag) {
                        chunk.a(nbttagcompound1);
                        continue;
                    }
                    BlockPosition blockposition = TileEntity.c(nbttagcompound1);
                    TileEntity tileentity = TileEntity.a(blockposition, chunk.a_(blockposition), nbttagcompound1);
                    if (tileentity == null) continue;
                    chunk.a(tileentity);
                }
            }
        };
    }

    @javax.annotation.Nullable
    private static NBTTagList a(NBTTagCompound nbt, String key) {
        NBTTagList nbttaglist = nbt.c(key, 10);
        return nbttaglist.isEmpty() ? null : nbttaglist;
    }

    private static NBTTagCompound a(StructurePieceSerializationContext context, ChunkCoordIntPair pos, Map<StructureGenerator<?>, StructureStart<?>> starts, Map<StructureGenerator<?>, LongSet> references) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        for (Map.Entry<StructureGenerator<?>, StructureStart<?>> entry : starts.entrySet()) {
            nbttagcompound1.a(entry.getKey().f(), entry.getValue().a(context, pos));
        }
        nbttagcompound.a("starts", nbttagcompound1);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        for (Map.Entry<StructureGenerator<?>, LongSet> entry1 : references.entrySet()) {
            nbttagcompound2.a(entry1.getKey().f(), new NBTTagLongArray(entry1.getValue()));
        }
        nbttagcompound.a("References", nbttagcompound2);
        return nbttagcompound;
    }

    private static Map<StructureGenerator<?>, StructureStart<?>> a(StructurePieceSerializationContext context, NBTTagCompound nbt, long worldSeed) {
        HashMap map = Maps.newHashMap();
        NBTTagCompound nbttagcompound1 = nbt.p("starts");
        for (String s2 : nbttagcompound1.d()) {
            String s1 = s2.toLowerCase(Locale.ROOT);
            StructureGenerator structuregenerator = (StructureGenerator)StructureGenerator.b.get((Object)s1);
            if (structuregenerator == null) {
                b.error("Unknown structure start: {}", (Object)s1);
                continue;
            }
            StructureStart<?> structurestart = StructureGenerator.a(context, nbttagcompound1.p(s2), worldSeed);
            if (structurestart == null) continue;
            map.put(structuregenerator, structurestart);
        }
        return map;
    }

    private static Map<StructureGenerator<?>, LongSet> a(ChunkCoordIntPair pos, NBTTagCompound nbt) {
        HashMap map = Maps.newHashMap();
        NBTTagCompound nbttagcompound1 = nbt.p("References");
        for (String s2 : nbttagcompound1.d()) {
            String s1 = s2.toLowerCase(Locale.ROOT);
            StructureGenerator structuregenerator = (StructureGenerator)StructureGenerator.b.get((Object)s1);
            if (structuregenerator == null) {
                b.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)s1, (Object)pos);
                continue;
            }
            map.put(structuregenerator, new LongOpenHashSet(Arrays.stream(nbttagcompound1.o(s2)).filter(i2 -> {
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(i2);
                if (chunkcoordintpair1.a(pos) > 8) {
                    b.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", (Object)s1, (Object)chunkcoordintpair1, (Object)pos);
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    public static NBTTagList a(ShortList[] lists) {
        NBTTagList nbttaglist = new NBTTagList();
        ShortList[] ashortlist1 = lists;
        int i2 = lists.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            ShortList shortlist = ashortlist1[j2];
            NBTTagList nbttaglist1 = new NBTTagList();
            if (shortlist != null) {
                for (Short oshort : shortlist) {
                    nbttaglist1.add(NBTTagShort.a(oshort));
                }
            }
            nbttaglist.add(nbttaglist1);
        }
        return nbttaglist;
    }

    public static final class InProgressChunkHolder {
        public final ProtoChunk protoChunk;
        public final ArrayDeque<Runnable> tasks;
        public NBTTagCompound poiData;

        public InProgressChunkHolder(ProtoChunk protoChunk, ArrayDeque<Runnable> tasks) {
            this.protoChunk = protoChunk;
            this.tasks = tasks;
        }
    }

    public record AsyncSaveData(NibbleArray[] blockLight, NibbleArray[] skyLight, NBTBase blockTickList, NBTBase fluidTickList, NBTTagList blockEntities, long worldTime) {
    }
}

