/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.serialization.Codec;
import io.papermc.paper.event.world.StructureLocateEvent;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IStructureAccess;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsStronghold;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.bukkit.Location;
import org.bukkit.StructureType;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.generator.CraftLimitedRegion;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator
implements BiomeManager.Provider {
    public static final Codec<ChunkGenerator> a;
    protected final WorldChunkManager b;
    protected final WorldChunkManager c;
    private final StructureSettings d;
    public final long e;
    private final List<ChunkCoordIntPair> f = Lists.newArrayList();
    private volatile boolean injected;

    public ChunkGenerator(WorldChunkManager biomeSource, StructureSettings structuresConfig) {
        this(biomeSource, biomeSource, structuresConfig, 0L);
    }

    public ChunkGenerator(WorldChunkManager populationSource, WorldChunkManager biomeSource, StructureSettings structuresConfig, long worldSeed) {
        this.b = populationSource;
        this.c = biomeSource;
        this.d = structuresConfig;
        this.e = worldSeed;
    }

    private void i() {
        StructureSettingsStronghold structuresettingsstronghold;
        if (this.f.isEmpty() && (structuresettingsstronghold = this.d.b()) != null && structuresettingsstronghold.c() != 0) {
            ArrayList list = Lists.newArrayList();
            for (BiomeBase biomebase : this.b.b()) {
                if (!ChunkGenerator.a(biomebase)) continue;
                list.add(biomebase);
            }
            int i2 = structuresettingsstronghold.a();
            int j2 = structuresettingsstronghold.c();
            int k2 = structuresettingsstronghold.b();
            Random random = new Random();
            random.setSeed(this.e);
            double d0 = random.nextDouble() * Math.PI * 2.0;
            int l2 = 0;
            int i1 = 0;
            for (int j1 = 0; j1 < j2; ++j1) {
                double d1 = (double)(4 * i2 + i2 * i1 * 6) + (random.nextDouble() - 0.5) * (double)i2 * 2.5;
                int k1 = (int)Math.round(Math.cos(d0) * d1);
                int l1 = (int)Math.round(Math.sin(d0) * d1);
                WorldChunkManager worldchunkmanager = this.b;
                int i22 = SectionPosition.a(k1, 8);
                int j22 = SectionPosition.a(l1, 8);
                Objects.requireNonNull(list);
                BlockPosition blockposition = worldchunkmanager.a(i22, 0, j22, 112, list::contains, random, this.c());
                if (blockposition != null) {
                    k1 = SectionPosition.a(blockposition.u());
                    l1 = SectionPosition.a(blockposition.w());
                }
                this.f.add(new ChunkCoordIntPair(k1, l1));
                d0 += Math.PI * 2 / (double)k2;
                if (++l2 != k2) continue;
                l2 = 0;
                k2 += 2 * k2 / (++i1 + 1);
                k2 = Math.min(k2, j2 - j1);
                d0 += random.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    private static boolean a(BiomeBase biome) {
        BiomeBase.Geography biomebase_geography = biome.r();
        return biomebase_geography != BiomeBase.Geography.l && biomebase_geography != BiomeBase.Geography.n && biomebase_geography != BiomeBase.Geography.j && biomebase_geography != BiomeBase.Geography.o && biomebase_geography != BiomeBase.Geography.q && biomebase_geography != BiomeBase.Geography.i;
    }

    protected abstract Codec<? extends ChunkGenerator> a();

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> b() {
        return IRegistry.bu.c(this.a());
    }

    public abstract ChunkGenerator a(long var1);

    public CompletableFuture<IChunkAccess> a(IRegistry<BiomeBase> biomeRegistry, Executor executor, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        return CompletableFuture.supplyAsync(SystemUtils.a("init_biomes", () -> {
            WorldChunkManager worldchunkmanager = this.c;
            Objects.requireNonNull(this.c);
            chunk.a(worldchunkmanager::getNoiseBiome, this.c());
            return chunk;
        }), SystemUtils.g());
    }

    public abstract Climate.Sampler c();

    @Override
    public BiomeBase getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        return this.e().getNoiseBiome(biomeX, biomeY, biomeZ, this.c());
    }

    public abstract void a(RegionLimitedWorldAccess var1, long var2, BiomeManager var4, StructureManager var5, IChunkAccess var6, WorldGenStage.Features var7);

    @Nullable
    public BlockPosition a(WorldServer world, StructureGenerator<?> structureFeature, BlockPosition center, int radius, boolean skipExistingChunks) {
        Location originLocation;
        CraftWorld world1 = world.getWorld();
        StructureLocateEvent event = new StructureLocateEvent((org.bukkit.World)world1, originLocation = new Location((org.bukkit.World)world1, (double)center.u(), (double)center.v(), (double)center.w()), (StructureType)StructureType.getStructureTypes().get(structureFeature.f()), radius, skipExistingChunks);
        if (!event.callEvent()) {
            return null;
        }
        if (event.getResult() != null) {
            return new BlockPosition(event.getResult().getBlockX(), event.getResult().getBlockY(), event.getResult().getBlockZ());
        }
        center = new BlockPosition(event.getOrigin().getBlockX(), event.getOrigin().getBlockY(), event.getOrigin().getBlockZ());
        radius = event.getRadius();
        skipExistingChunks = event.shouldFindUnexplored();
        structureFeature = (StructureGenerator)StructureGenerator.b.get((Object)event.getType().getName());
        if (structureFeature == StructureGenerator.l) {
            this.i();
            BlockPosition blockposition1 = null;
            double d0 = Double.MAX_VALUE;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (ChunkCoordIntPair chunkcoordintpair : this.f) {
                blockposition_mutableblockposition.d(SectionPosition.a(chunkcoordintpair.c, 8), 32, SectionPosition.a(chunkcoordintpair.d, 8));
                double d1 = blockposition_mutableblockposition.j(center);
                if (blockposition1 == null) {
                    blockposition1 = new BlockPosition(blockposition_mutableblockposition);
                    d0 = d1;
                    continue;
                }
                if (!(d1 < d0)) continue;
                blockposition1 = new BlockPosition(blockposition_mutableblockposition);
                d0 = d1;
            }
            return blockposition1;
        }
        this.updateStructureSettings(world, this.d);
        StructureSettingsFeature structuresettingsfeature = this.d.a(structureFeature);
        ImmutableMultimap<StructureFeature<?, ?>, ResourceKey<BiomeBase>> immutablemultimap = this.d.b(structureFeature);
        if (structuresettingsfeature != null && !immutablemultimap.isEmpty()) {
            IRegistry<BiomeBase> iregistry = world.t().d(IRegistry.aR);
            Set set = this.c.b().stream().flatMap(biomebase -> iregistry.c((BiomeBase)biomebase).stream()).collect(Collectors.toSet());
            Stream stream = immutablemultimap.values().stream();
            Objects.requireNonNull(set);
            return stream.noneMatch(set::contains) ? null : structureFeature.a(world, world.a(), center, radius, skipExistingChunks, world.E(), structuresettingsfeature);
        }
        return null;
    }

    public void addVanillaDecorations(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        if (!SharedConstants.a(chunkcoordintpair)) {
            SectionPosition sectionposition = SectionPosition.a(chunkcoordintpair, generatoraccessseed.ai());
            BlockPosition blockposition = sectionposition.p();
            Map<Integer, List<StructureGenerator>> map = IRegistry.aY.j().collect(Collectors.groupingBy(structuregenerator -> structuregenerator.b().ordinal()));
            List<WorldChunkManager.b> list = this.b.c();
            SeededRandom seededrandom = new SeededRandom(new XoroshiroRandomSource(RandomSupport.a()));
            long i2 = seededrandom.a(generatoraccessseed.E(), blockposition.u(), blockposition.w());
            ObjectArraySet set = new ObjectArraySet();
            if (this instanceof ChunkProviderFlat) {
                set.addAll(this.b.b());
            } else {
                ChunkCoordIntPair.a(sectionposition.r(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$3(generatoraccessseed, (Set)set, arg_0));
                set.retainAll(this.b.b());
            }
            int j2 = list.size();
            try {
                IRegistry<PlacedFeature> iregistry = generatoraccessseed.t().d(IRegistry.aN);
                IRegistry<StructureGenerator<?>> iregistry1 = generatoraccessseed.t().d(IRegistry.aX);
                int k2 = Math.max(WorldGenStage.Decoration.values().length, j2);
                for (int l2 = 0; l2 < k2; ++l2) {
                    int i1 = 0;
                    if (structuremanager.a()) {
                        List list1 = map.getOrDefault(l2, Collections.emptyList());
                        for (StructureGenerator structuregenerator2 : list1) {
                            seededrandom.b(i2, i1, l2);
                            Supplier<String> supplier = () -> {
                                Optional<String> optional = iregistry1.c(structuregenerator2).map(Object::toString);
                                Objects.requireNonNull(structuregenerator2);
                                return (String)optional.orElseGet(structuregenerator2::toString);
                            };
                            try {
                                generatoraccessseed.a(supplier);
                                structuremanager.a(sectionposition, structuregenerator2).forEach(structurestart -> structurestart.a(generatoraccessseed, structuremanager, this, seededrandom, ChunkGenerator.a(ichunkaccess), chunkcoordintpair));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport = CrashReport.a(exception, "Feature placement");
                                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Feature");
                                Objects.requireNonNull(supplier);
                                crashreportsystemdetails.a("Description", supplier::get);
                                throw new ReportedException(crashreport);
                            }
                            ++i1;
                        }
                    }
                    if (l2 >= j2) continue;
                    IntArraySet intarrayset = new IntArraySet();
                    for (BiomeBase biomebase : set) {
                        List<List<Supplier<PlacedFeature>>> list2 = biomebase.e().b();
                        if (l2 >= list2.size()) continue;
                        List<Supplier<PlacedFeature>> list3 = list2.get(l2);
                        WorldChunkManager.b worldchunkmanager_b = list.get(l2);
                        list3.stream().map(Supplier::get).forEach(placedfeature -> intarrayset.add(worldchunkmanager_b.b().applyAsInt((PlacedFeature)placedfeature)));
                    }
                    int j1 = intarrayset.size();
                    int[] aint = intarrayset.toIntArray();
                    Arrays.sort(aint);
                    WorldChunkManager.b worldchunkmanager_b1 = list.get(l2);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature2 = worldchunkmanager_b1.a().get(l1);
                        Supplier<String> supplier1 = () -> {
                            Optional<String> optional = iregistry.c(placedfeature2).map(Object::toString);
                            Objects.requireNonNull(placedfeature2);
                            return (String)optional.orElseGet(placedfeature2::toString);
                        };
                        long featurePopulationSeed = i2;
                        MinecraftKey location = iregistry.b(placedfeature2);
                        long configFeatureSeed = generatoraccessseed.getMinecraftWorld().paperConfig.featureSeeds.getLong((Object)location);
                        if (configFeatureSeed != -1L) {
                            featurePopulationSeed = seededrandom.a(configFeatureSeed, blockposition.u(), blockposition.w());
                        }
                        seededrandom.b(featurePopulationSeed, l1, l2);
                        try {
                            generatoraccessseed.a(supplier1);
                            placedfeature2.b(generatoraccessseed, this, seededrandom, blockposition);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport1 = CrashReport.a(exception1, "Feature placement");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport1.a("Feature");
                            Objects.requireNonNull(supplier1);
                            crashreportsystemdetails.a("Description", supplier1::get);
                            throw new ReportedException(crashreport1);
                        }
                    }
                }
                generatoraccessseed.a((Supplier<String>)null);
            }
            catch (Exception exception2) {
                CrashReport crashreport2 = CrashReport.a(exception2, "Biome decoration");
                crashreport2.a("Generation").a("CenterX", chunkcoordintpair.c).a("CenterZ", chunkcoordintpair.d).a("Seed", i2);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void a(GeneratorAccessSeed world, IChunkAccess chunk, StructureManager structureAccessor) {
        this.applyBiomeDecoration(world, chunk, structureAccessor, true);
    }

    public void applyBiomeDecoration(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.addVanillaDecorations(generatoraccessseed, ichunkaccess, structuremanager);
        }
        if (!(world = generatoraccessseed.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.f());
            int x2 = ichunkaccess.f().c;
            int z2 = ichunkaccess.f().d;
            for (BlockPopulator populator : world.getPopulators()) {
                SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(generatoraccessseed.E()));
                seededrandom.a(generatoraccessseed.E(), x2, z2);
                populator.populate((WorldInfo)world, (Random)seededrandom, x2, z2, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static StructureBoundingBox a(IChunkAccess chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int i2 = chunkcoordintpair.d();
        int j2 = chunkcoordintpair.e();
        LevelHeightAccessor levelheightaccessor = chunk.z();
        int k2 = levelheightaccessor.u_() + 1;
        int l2 = levelheightaccessor.ag() - 1;
        return new StructureBoundingBox(i2, k2, j2, i2 + 15, l2, j2 + 15);
    }

    public abstract void a(RegionLimitedWorldAccess var1, StructureManager var2, IChunkAccess var3);

    public abstract void a(RegionLimitedWorldAccess var1);

    public StructureSettings d() {
        return this.d;
    }

    public int a(LevelHeightAccessor world) {
        return 64;
    }

    public WorldChunkManager e() {
        return this.c;
    }

    public abstract int f();

    public WeightedRandomList<BiomeSettingsMobs.c> a(BiomeBase biome, StructureManager accessor, EnumCreatureType group, BlockPosition pos) {
        return biome.b().a(group);
    }

    public void a(IRegistryCustom registryManager, StructureManager structureAccessor, IChunkAccess chunk, DefinedStructureManager structureManager, long worldSeed) {
        StructureStart<?> structurestart;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        SectionPosition sectionposition = SectionPosition.a(chunk);
        this.updateStructureSettings(structureAccessor.getWorld(), this.d);
        StructureSettingsFeature structuresettingsfeature = this.d.a(StructureGenerator.l);
        if (!(structuresettingsfeature == null || (structurestart = structureAccessor.a(sectionposition, StructureGenerator.l, chunk)) != null && structurestart.b())) {
            StructureStart<?> structurestart1 = StructureFeatures.a.a(registryManager, this, this.b, structureManager, worldSeed, chunkcoordintpair, ChunkGenerator.a(structureAccessor, chunk, sectionposition, StructureGenerator.l), structuresettingsfeature, chunk, ChunkGenerator::a);
            structureAccessor.a(sectionposition, StructureGenerator.l, structurestart1, (IStructureAccess)chunk);
        }
        IRegistry<BiomeBase> iregistry = registryManager.d(IRegistry.aR);
        block0: for (StructureGenerator structureGenerator : IRegistry.aY) {
            Map.Entry entry;
            StructureStart<?> structurestart3;
            StructureStart<?> structurestart2;
            StructureSettingsFeature structuresettingsfeature1;
            if (structureGenerator == StructureGenerator.l || (structuresettingsfeature1 = this.d.a(structureGenerator)) == null || (structurestart2 = structureAccessor.a(sectionposition, structureGenerator, chunk)) != null && structurestart2.b()) continue;
            int j2 = ChunkGenerator.a(structureAccessor, chunk, sectionposition, structureGenerator);
            UnmodifiableIterator unmodifiableiterator = this.d.b(structureGenerator).asMap().entrySet().iterator();
            do {
                if (unmodifiableiterator.hasNext()) continue;
                structureAccessor.a(sectionposition, structureGenerator, StructureStart.b, (IStructureAccess)chunk);
                continue block0;
            } while (!(structurestart3 = ((StructureFeature)(entry = (Map.Entry)unmodifiableiterator.next()).getKey()).a(registryManager, this, this.b, structureManager, worldSeed, chunkcoordintpair, j2, structuresettingsfeature1, chunk, biomebase -> {
                Collection collection = (Collection)entry.getValue();
                Objects.requireNonNull(collection);
                return this.a(iregistry, collection::contains, (BiomeBase)biomebase);
            })).b());
            structureAccessor.a(sectionposition, structureGenerator, structurestart3, (IStructureAccess)chunk);
        }
    }

    private static int a(StructureManager structureAccessor, IChunkAccess chunk, SectionPosition sectionPos, StructureGenerator<?> structureFeature) {
        StructureStart<?> structurestart = structureAccessor.a(sectionPos, structureFeature, chunk);
        return structurestart != null ? structurestart.f() : 0;
    }

    protected boolean a(IRegistry<BiomeBase> registry, Predicate<ResourceKey<BiomeBase>> condition, BiomeBase biome) {
        return registry.c(biome).filter(condition).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStructureSettings(World world, StructureSettings settings) {
        if (this.injected) {
            return;
        }
        StructureSettings structureSettings = settings;
        synchronized (structureSettings) {
            if (this.injected) {
                return;
            }
            Map<StructureGenerator<?>, StructureSettingsFeature> original = settings.a();
            HashMap updated = new HashMap();
            SpigotWorldConfig conf = world.spigotConfig;
            for (Map.Entry<StructureGenerator<?>, StructureSettingsFeature> entry : original.entrySet()) {
                String name = IRegistry.aY.b(entry.getKey()).a();
                StructureSettingsFeature feature = entry.getValue();
                int seed = feature.c();
                switch (name) {
                    case "bastion_remnant": {
                        seed = conf.bastionSeed;
                        break;
                    }
                    case "desert_pyramid": {
                        seed = conf.desertSeed;
                        break;
                    }
                    case "endcity": {
                        seed = conf.endCitySeed;
                        break;
                    }
                    case "fortress": {
                        seed = conf.fortressSeed;
                        break;
                    }
                    case "igloo": {
                        seed = conf.iglooSeed;
                        break;
                    }
                    case "jungle_pyramid": {
                        seed = conf.jungleSeed;
                        break;
                    }
                    case "mansion": {
                        seed = conf.mansionSeed;
                        break;
                    }
                    case "monument": {
                        seed = conf.monumentSeed;
                        break;
                    }
                    case "nether_fossil": {
                        seed = conf.fossilSeed;
                        break;
                    }
                    case "ocean_ruin": {
                        seed = conf.oceanSeed;
                        break;
                    }
                    case "pillager_outpost": {
                        seed = conf.outpostSeed;
                        break;
                    }
                    case "ruined_portal": {
                        seed = conf.portalSeed;
                        break;
                    }
                    case "shipwreck": {
                        seed = conf.shipwreckSeed;
                        break;
                    }
                    case "swamp_hut": {
                        seed = conf.swampSeed;
                        break;
                    }
                    case "village": {
                        seed = conf.villageSeed;
                    }
                }
                updated.put(entry.getKey(), new StructureSettingsFeature(feature.a(), feature.b(), seed));
            }
            original.clear();
            original.putAll(updated);
            this.injected = true;
        }
    }

    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, IChunkAccess chunk) {
        boolean flag = true;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int i2 = chunkcoordintpair.c;
        int j2 = chunkcoordintpair.d;
        int k2 = chunkcoordintpair.d();
        int l2 = chunkcoordintpair.e();
        SectionPosition sectionposition = SectionPosition.a(chunk);
        for (int i1 = i2 - 8; i1 <= i2 + 8; ++i1) {
            for (int j1 = j2 - 8; j1 <= j2 + 8; ++j1) {
                long k1 = ChunkCoordIntPair.a(i1, j1);
                for (StructureStart<?> structurestart : world.a(i1, j1).g().values()) {
                    try {
                        if (!structurestart.b() || !structurestart.a().a(k2, l2, k2 + 15, l2 + 15)) continue;
                        structureAccessor.a(sectionposition, structurestart.h(), k1, (IStructureAccess)chunk);
                        PacketDebug.a(world, structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.a(exception, "Generating structure reference");
                        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Structure");
                        crashreportsystemdetails.a("Id", () -> IRegistry.aY.b(structurestart.h()).toString());
                        crashreportsystemdetails.a("Name", () -> structurestart.h().f());
                        crashreportsystemdetails.a("Class", () -> structurestart.h().getClass().getCanonicalName());
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> a(Executor var1, Blender var2, StructureManager var3, IChunkAccess var4);

    public abstract int g();

    public abstract int h();

    public abstract int a(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4);

    public abstract BlockColumn a(int var1, int var2, LevelHeightAccessor var3);

    public int b(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world) {
        return this.a(x2, z2, heightmap, world);
    }

    public int c(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world) {
        return this.a(x2, z2, heightmap, world) - 1;
    }

    public boolean a(ChunkCoordIntPair pos) {
        this.i();
        return this.f.contains(pos);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$3(GeneratorAccessSeed generatoraccessseed, Set set, ChunkCoordIntPair chunkcoordintpair1) {
        IChunkAccess ichunkaccess1 = generatoraccessseed.a(chunkcoordintpair1.c, chunkcoordintpair1.d);
        for (ChunkSection chunksection : ichunkaccess1.d()) {
            DataPaletteBlock<BiomeBase> datapaletteblock = chunksection.j();
            Objects.requireNonNull(set);
            datapaletteblock.a(set::add);
        }
    }

    static {
        IRegistry.a(IRegistry.bu, "noise", ChunkGeneratorAbstract.d);
        IRegistry.a(IRegistry.bu, "flat", ChunkProviderFlat.d);
        IRegistry.a(IRegistry.bu, "debug", ChunkProviderDebug.d);
        a = IRegistry.bu.i().dispatchStable(ChunkGenerator::a, Function.identity());
    }
}

