/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.starlight.common.light.StarLightEngine;
import co.aikar.timings.Timing;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.destroystokyo.paper.util.maplist.EntityList;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockMobSpawner;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.gameevent.EuclideanGameEventDispatcher;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;

public class Chunk
extends IChunkAccess {
    static final Logger l = LogManager.getLogger();
    private static final TickingBlockEntity m = new TickingBlockEntity(){

        @Override
        public void a() {
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public BlockPosition c() {
            return BlockPosition.b;
        }

        @Override
        public String d() {
            return "<null>";
        }
    };
    private final Map<BlockPosition, d> n;
    public boolean o;
    private boolean p;
    public final WorldServer q;
    @Nullable
    private Supplier<PlayerChunk.State> r;
    @Nullable
    private c s;
    private final Int2ObjectMap<GameEventDispatcher> t;
    private final LevelChunkTicks<Block> u;
    private final LevelChunkTicks<FluidType> v;
    public long lastSaveTime;
    public org.bukkit.Chunk bukkitChunk;
    public boolean mustNotSave;
    public boolean needsDecoration;
    public final EntityList entities = new EntityList();
    @Nullable
    public PlayerChunk playerChunk;
    static final int NEIGHBOUR_CACHE_RADIUS = 3;
    boolean loadedTicketLevel;
    private long neighbourChunksLoadedBitset;
    private final Chunk[] loadedNeighbourChunks = new Chunk[49];
    private boolean playerGeneralAreaCacheSet;
    private PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playerGeneralAreaCache;

    @Override
    public void setLastSaved(long ticks) {
        this.lastSaveTime = ticks;
    }

    public Chunk(World world, ChunkCoordIntPair pos) {
        this(world, pos, ChunkConverter.a, new LevelChunkTicks<Block>(), new LevelChunkTicks<FluidType>(), 0L, null, null, null);
    }

    public Chunk(World world, ChunkCoordIntPair pos, ChunkConverter upgradeData, LevelChunkTicks<Block> blockTickScheduler, LevelChunkTicks<FluidType> fluidTickScheduler, long inhabitedTime, @Nullable ChunkSection[] sectionArrayInitializer, @Nullable c entityLoader, @Nullable BlendingData blendingData) {
        super(pos, upgradeData, world, MinecraftServer.getServer().aV().d(IRegistry.aR), inhabitedTime, sectionArrayInitializer, blendingData);
        this.setBlockNibbles(StarLightEngine.getFilledEmptyLight(world));
        this.setSkyNibbles(StarLightEngine.getFilledEmptyLight(world));
        this.n = Maps.newHashMap();
        this.p = false;
        this.q = (WorldServer)world;
        this.t = new Int2ObjectOpenHashMap();
        for (HeightMap.Type heightmap_type : HeightMap.Type.values()) {
            if (!ChunkStatus.o.h().contains(heightmap_type)) continue;
            this.g.put(heightmap_type, new HeightMap(this, heightmap_type));
        }
        this.s = entityLoader;
        this.u = blockTickScheduler;
        this.v = fluidTickScheduler;
        this.bukkitChunk = new CraftChunk(this);
    }

    public org.bukkit.Chunk getBukkitChunk() {
        return this.bukkitChunk;
    }

    public static int getNeighbourCacheRadius() {
        return 3;
    }

    public final boolean wasLoadCallbackInvoked() {
        return this.loadedTicketLevel;
    }

    private static int getNeighbourIndex(int relativeX, int relativeZ) {
        return relativeX + relativeZ * 7 + 24;
    }

    public final Chunk getRelativeNeighbourIfLoaded(int relativeX, int relativeZ) {
        return this.loadedNeighbourChunks[Chunk.getNeighbourIndex(relativeX, relativeZ)];
    }

    public final boolean isNeighbourLoaded(int relativeX, int relativeZ) {
        return (this.neighbourChunksLoadedBitset & 1L << Chunk.getNeighbourIndex(relativeX, relativeZ)) != 0L;
    }

    public final void setNeighbourLoaded(int relativeX, int relativeZ, Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk must be non-null, neighbour: (" + relativeX + "," + relativeZ + "), chunk: " + this.c);
        }
        long before = this.neighbourChunksLoadedBitset;
        int index = Chunk.getNeighbourIndex(relativeX, relativeZ);
        this.loadedNeighbourChunks[index] = chunk;
        this.neighbourChunksLoadedBitset |= 1L << index;
        this.onNeighbourChange(before, this.neighbourChunksLoadedBitset);
    }

    public final void setNeighbourUnloaded(int relativeX, int relativeZ) {
        long before = this.neighbourChunksLoadedBitset;
        int index = Chunk.getNeighbourIndex(relativeX, relativeZ);
        this.loadedNeighbourChunks[index] = null;
        this.neighbourChunksLoadedBitset &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        this.onNeighbourChange(before, this.neighbourChunksLoadedBitset);
    }

    public final void resetNeighbours() {
        long before = this.neighbourChunksLoadedBitset;
        this.neighbourChunksLoadedBitset = 0L;
        Arrays.fill(this.loadedNeighbourChunks, null);
        this.onNeighbourChange(before, 0L);
    }

    protected void onNeighbourChange(long bitsetBefore, long bitsetAfter) {
    }

    public final boolean isAnyNeighborsLoaded() {
        return this.neighbourChunksLoadedBitset != 0L;
    }

    public final boolean areNeighboursLoaded(int radius) {
        return Chunk.areNeighboursLoaded(this.neighbourChunksLoadedBitset, radius);
    }

    public static boolean areNeighboursLoaded(long bitset, int radius) {
        switch (radius) {
            case 0: {
                return (bitset & 1L << Chunk.getNeighbourIndex(0, 0)) != 0L;
            }
            case 1: {
                long mask = 0L;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        mask |= 1L << Chunk.getNeighbourIndex(dx, dz);
                    }
                }
                return (bitset & mask) == mask;
            }
            case 2: {
                long mask = 0L;
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        mask |= 1L << Chunk.getNeighbourIndex(dx, dz);
                    }
                }
                return (bitset & mask) == mask;
            }
            case 3: {
                long mask = 0L;
                for (int dx = -3; dx <= 3; ++dx) {
                    for (int dz = -3; dz <= 3; ++dz) {
                        mask |= 1L << Chunk.getNeighbourIndex(dx, dz);
                    }
                }
                return (bitset & mask) == mask;
            }
        }
        throw new IllegalArgumentException("Radius not recognized: " + radius);
    }

    public PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> getPlayerGeneralAreaCache() {
        if (!this.playerGeneralAreaCacheSet) {
            this.updateGeneralAreaCache();
        }
        return this.playerGeneralAreaCache;
    }

    public void updateGeneralAreaCache() {
        this.updateGeneralAreaCache(this.q.k().a.playerGeneralAreaMap.getObjectsInRange(this.coordinateKey));
    }

    public void updateGeneralAreaCache(PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> value) {
        this.playerGeneralAreaCacheSet = true;
        this.playerGeneralAreaCache = value;
    }

    public EntityPlayer findNearestPlayer(double sourceX, double sourceY, double sourceZ, double maxRange, Predicate<Entity> predicate) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> nearby;
        if (!this.playerGeneralAreaCacheSet) {
            this.updateGeneralAreaCache();
        }
        if ((nearby = this.playerGeneralAreaCache) == null) {
            return null;
        }
        EntityPlayer[] backingSet = nearby.getBackingSet();
        double closestDistance = maxRange < 0.0 ? Double.MAX_VALUE : maxRange * maxRange;
        EntityPlayer closest = null;
        for (EntityPlayer _player : backingSet) {
            EntityPlayer player;
            double distance;
            if (!(_player instanceof EntityPlayer) || !((distance = (player = _player).h(sourceX, sourceY, sourceZ)) < closestDistance) || !predicate.test(player)) continue;
            closest = player;
            closestDistance = distance;
        }
        return closest;
    }

    public void getNearestPlayers(double sourceX, double sourceY, double sourceZ, Predicate<Entity> predicate, double range, List<EntityPlayer> ret) {
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> nearby;
        if (!this.playerGeneralAreaCacheSet) {
            this.updateGeneralAreaCache();
        }
        if ((nearby = this.playerGeneralAreaCache) == null) {
            return;
        }
        double rangeSquared = range * range;
        for (EntityPlayer _player : nearby.getBackingSet()) {
            double distanceSquared;
            if (!(_player instanceof EntityPlayer)) continue;
            EntityPlayer player = _player;
            if (range >= 0.0 && (distanceSquared = player.h(sourceX, sourceY, sourceZ)) > rangeSquared || predicate != null && !predicate.test(player)) continue;
            ret.add(player);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Chunk(WorldServer world, ProtoChunk protoChunk, @Nullable c entityLoader) {
        this(world, protoChunk.f(), protoChunk.r(), protoChunk.F(), protoChunk.G(), protoChunk.u(), protoChunk.d(), entityLoader, protoChunk.t());
        void var5_7;
        this.setBlockNibbles(protoChunk.getBlockNibbles());
        this.setSkyNibbles(protoChunk.getSkyNibbles());
        this.setSkyEmptinessMap(protoChunk.getSkyEmptinessMap());
        this.setBlockEmptinessMap(protoChunk.getBlockEmptinessMap());
        for (TileEntity tileEntity : protoChunk.C().values()) {
            this.a(tileEntity);
        }
        this.h.putAll(protoChunk.E());
        boolean bl = false;
        while (var5_7 < protoChunk.m().length) {
            this.a[var5_7] = protoChunk.m()[var5_7];
            ++var5_7;
        }
        this.a(protoChunk.g());
        this.b(protoChunk.h());
        for (Map.Entry entry : protoChunk.e()) {
            if (!ChunkStatus.o.h().contains(entry.getKey())) continue;
            this.a((HeightMap.Type)entry.getKey(), ((HeightMap)entry.getValue()).a());
        }
        this.b(protoChunk.v());
        this.a(true);
        this.needsDecoration = true;
        this.persistentDataContainer = protoChunk.persistentDataContainer;
    }

    @Override
    public TickContainerAccess<Block> o() {
        return this.u;
    }

    @Override
    public TickContainerAccess<FluidType> p() {
        return this.v;
    }

    @Override
    public IChunkAccess.a q() {
        return new IChunkAccess.a(this.u, this.v);
    }

    @Override
    public long u() {
        return this.q.paperConfig.fixedInhabitedTime < 0 ? super.u() : (long)this.q.paperConfig.fixedInhabitedTime;
    }

    @Override
    public GameEventDispatcher a(int ySectionCoord) {
        return (GameEventDispatcher)this.t.computeIfAbsent(ySectionCoord, j2 -> new EuclideanGameEventDispatcher(this.q));
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.getBlockStateFinal(pos.u(), pos.v(), pos.w());
    }

    @Override
    public IBlockData getBlockState(int x2, int y2, int z2) {
        return this.getBlockStateFinal(x2, y2, z2);
    }

    public final IBlockData getBlockStateFinal(int x2, int y2, int z2) {
        int i2 = this.e(y2);
        if (i2 < 0 || i2 >= this.k.length || this.k[i2].f == 0 || this.k[i2].c()) {
            return Blocks.a.n();
        }
        return this.k[i2].i.a((y2 & 0xF) << 8 | (z2 & 0xF) << 4 | x2 & 0xF);
    }

    public IBlockData getBlockState_unused(int i2, int j2, int k2) {
        if (this.q.ad()) {
            IBlockData iblockdata = null;
            if (j2 == 60) {
                iblockdata = Blocks.gB.n();
            }
            if (j2 == 70) {
                iblockdata = ChunkProviderDebug.a(i2, k2);
            }
            return iblockdata == null ? Blocks.a.n() : iblockdata;
        }
        try {
            ChunkSection chunksection;
            int l2 = this.e(j2);
            if (l2 >= 0 && l2 < this.k.length && !(chunksection = this.k[l2]).c()) {
                return chunksection.a(i2 & 0xF, j2 & 0xF, k2 & 0xF);
            }
            return Blocks.a.n();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting block state");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        return this.b_(blockposition);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        return this.a_(blockposition);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        return this.a(pos.u(), pos.v(), pos.w());
    }

    public Fluid a(int x2, int y2, int z2) {
        ChunkSection chunksection;
        int index = this.e(y2);
        if (index >= 0 && index < this.k.length && !(chunksection = this.k[index]).c()) {
            return chunksection.i.a((y2 & 0xF) << 8 | (z2 & 0xF) << 4 | x2 & 0xF).n();
        }
        return FluidTypes.a.h();
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition pos, IBlockData state, boolean moved) {
        return this.setBlockState(pos, state, moved, true);
    }

    @Nullable
    public IBlockData setBlockState(BlockPosition blockposition, IBlockData iblockdata, boolean flag, boolean doPlace) {
        int l2;
        int k2;
        int i2 = blockposition.v();
        ChunkSection chunksection = this.b(this.e(i2));
        boolean flag1 = chunksection.c();
        if (flag1 && iblockdata.g()) {
            return null;
        }
        int j2 = blockposition.u() & 0xF;
        IBlockData iblockdata1 = chunksection.a(j2, k2 = i2 & 0xF, l2 = blockposition.w() & 0xF, iblockdata);
        if (iblockdata1 == iblockdata) {
            return null;
        }
        Block block = iblockdata.b();
        this.g.get(HeightMap.Type.e).a(j2, i2, l2, iblockdata);
        this.g.get(HeightMap.Type.f).a(j2, i2, l2, iblockdata);
        this.g.get(HeightMap.Type.d).a(j2, i2, l2, iblockdata);
        this.g.get(HeightMap.Type.b).a(j2, i2, l2, iblockdata);
        boolean flag2 = chunksection.c();
        if (flag1 != flag2) {
            this.q.k().a().a(blockposition, flag2);
        }
        boolean flag3 = iblockdata1.m();
        if (!this.q.y) {
            iblockdata1.b(this.q, blockposition, iblockdata, flag);
        } else if (!iblockdata1.a(block) && flag3) {
            this.d(blockposition);
        }
        if (!chunksection.a(j2, k2, l2).a(block)) {
            return null;
        }
        if (!this.q.y && doPlace && (!this.q.captureBlockStates || block instanceof BlockTileEntity)) {
            iblockdata.a((World)this.q, blockposition, iblockdata1, flag);
        }
        if (iblockdata.m()) {
            TileEntity tileentity = this.a(blockposition, EnumTileEntityState.c);
            if (tileentity == null) {
                tileentity = ((ITileEntity)((Object)block)).a(blockposition, iblockdata);
                if (tileentity != null) {
                    this.b(tileentity);
                }
            } else {
                tileentity.b(iblockdata);
                this.e(tileentity);
            }
        }
        this.b = true;
        return iblockdata1;
    }

    @Override
    @Deprecated
    public void a(Entity entity) {
    }

    @Nullable
    private TileEntity k(BlockPosition pos) {
        IBlockData iblockdata = this.a_(pos);
        return !iblockdata.m() ? null : ((ITileEntity)((Object)iblockdata.b())).a(pos, iblockdata);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.a(pos, EnumTileEntityState.c);
    }

    @Deprecated
    @Nullable
    public final TileEntity getTileEntityImmediately(BlockPosition pos) {
        return this.a(pos, EnumTileEntityState.a);
    }

    @Nullable
    public TileEntity a(BlockPosition pos, EnumTileEntityState creationType) {
        TileEntity tileentity1;
        NBTTagCompound nbttagcompound;
        TileEntity tileentity = this.q.capturedTileEntities.get(pos);
        if (tileentity == null) {
            tileentity = this.i.get(pos);
        }
        if (tileentity == null && (nbttagcompound = this.h.remove(pos)) != null && (tileentity1 = this.a(pos, nbttagcompound)) != null) {
            return tileentity1;
        }
        if (tileentity == null) {
            if (creationType == EnumTileEntityState.a && (tileentity = this.k(pos)) != null) {
                this.b(tileentity);
            }
        } else if (tileentity.r()) {
            this.i.remove(pos);
            return null;
        }
        return tileentity;
    }

    public void b(TileEntity blockEntity) {
        this.a(blockEntity);
        if (this.J()) {
            this.d(blockEntity);
            this.e(blockEntity);
        }
    }

    private boolean J() {
        return this.o || this.q.k_();
    }

    boolean l(BlockPosition pos) {
        if (!this.q.p_().a(pos)) {
            return false;
        }
        WorldServer world = this.q;
        if (!(world instanceof WorldServer)) {
            return true;
        }
        WorldServer worldserver = world;
        return this.B().a(PlayerChunk.State.c) && worldserver.c(ChunkCoordIntPair.a(pos));
    }

    @Override
    public void a(TileEntity blockEntity) {
        BlockPosition blockposition = blockEntity.p();
        if (this.a_(blockposition).m()) {
            blockEntity.a(this.q);
            blockEntity.s();
            TileEntity tileentity1 = this.i.put(blockposition.h(), blockEntity);
            if (tileentity1 != null && tileentity1 != blockEntity) {
                tileentity1.aa_();
            }
        } else if (blockEntity instanceof TileEntityMobSpawner && !(this.a_(blockposition).b() instanceof BlockMobSpawner)) {
            this.d(blockEntity.p());
        } else {
            ServerInternalException e2 = new ServerInternalException("Attempted to place a tile entity (" + blockEntity + ") at " + blockEntity.p().u() + "," + blockEntity.p().v() + "," + blockEntity.p().w() + " (" + this.a_(blockposition) + ") where there was no entity tile!\nChunk coordinates: " + this.c.c * 16 + "," + this.c.d * 16);
            e2.printStackTrace();
            ServerInternalException.reportInternalException((Throwable)e2);
            if (this.q.paperConfig.removeCorruptTEs) {
                this.d(blockEntity.p());
                this.a(true);
                Bukkit.getLogger().info("Removing corrupt tile entity");
            }
        }
    }

    @Override
    @Nullable
    public NBTTagCompound i(BlockPosition pos) {
        TileEntity tileentity = this.c_(pos);
        if (tileentity != null && !tileentity.r()) {
            NBTTagCompound nbttagcompound = tileentity.m();
            nbttagcompound.a("keepPacked", false);
            return nbttagcompound;
        }
        NBTTagCompound nbttagcompound = this.h.get(pos);
        if (nbttagcompound != null) {
            nbttagcompound = nbttagcompound.g();
            nbttagcompound.a("keepPacked", true);
        }
        return nbttagcompound;
    }

    @Override
    public void d(BlockPosition pos) {
        if (this.J()) {
            TileEntity tileentity = this.i.remove(pos);
            if (!this.h.isEmpty()) {
                this.h.remove(pos);
            }
            if (tileentity != null) {
                this.c(tileentity);
                tileentity.aa_();
            }
        }
        this.m(pos);
    }

    private <T extends TileEntity> void c(T blockEntity) {
        GameEventListener gameeventlistener;
        Block block;
        if (!this.q.y && (block = blockEntity.q().b()) instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).a(this.q, blockEntity)) != null) {
            int i2 = SectionPosition.a(blockEntity.p().v());
            GameEventDispatcher gameeventdispatcher = this.a(i2);
            gameeventdispatcher.b(gameeventlistener);
            if (gameeventdispatcher.a()) {
                this.t.remove(i2);
            }
        }
    }

    private void m(BlockPosition pos) {
        d chunk_d = this.n.remove(pos);
        if (chunk_d != null) {
            chunk_d.a(m);
        }
    }

    public void C() {
        if (this.s != null) {
            this.s.run(this);
            this.s = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        if (this.loadedTicketLevel) {
            l.error("Double calling chunk load!", new Throwable());
        }
        int chunkX = this.c.c;
        int chunkZ = this.c.d;
        ChunkProviderServer chunkProvider = this.q.k();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                Chunk neighbour = chunkProvider.getChunkAtIfLoadedMainThreadNoCache(chunkX + dx, chunkZ + dz);
                if (neighbour == null) continue;
                neighbour.setNeighbourLoaded(-dx, -dz, this);
                this.setNeighbourLoaded(dx, dz, neighbour);
            }
        }
        this.setNeighbourLoaded(0, 0, this);
        this.loadedTicketLevel = true;
        CraftServer server = this.q.getCraftServer();
        this.q.k().addLoadedChunk(this);
        if (server != null) {
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent(this.bukkitChunk, this.needsDecoration));
            if (this.needsDecoration) {
                try (Timing ignored = this.q.timings.chunkLoadPopulate.startTiming();){
                    this.needsDecoration = false;
                    Random random = new Random();
                    random.setSeed(this.q.E());
                    long xRand = random.nextLong() / 2L * 2L + 1L;
                    long zRand = random.nextLong() / 2L * 2L + 1L;
                    random.setSeed((long)this.c.c * xRand + (long)this.c.d * zRand ^ this.q.E());
                    CraftWorld world = this.q.getWorld();
                    if (world != null) {
                        this.q.populating = true;
                        try {
                            for (BlockPopulator populator : world.getPopulators()) {
                                populator.populate((org.bukkit.World)world, random, this.bukkitChunk);
                            }
                        }
                        finally {
                            this.q.populating = false;
                        }
                    }
                    server.getPluginManager().callEvent((Event)new ChunkPopulateEvent(this.bukkitChunk));
                }
            }
        }
    }

    public void unloadCallback() {
        if (!this.loadedTicketLevel) {
            l.error("Double calling chunk unload!", new Throwable());
        }
        CraftServer server = this.q.getCraftServer();
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent(this.bukkitChunk, this.i());
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
        this.q.k().removeLoadedChunk(this);
        int chunkX = this.c.c;
        int chunkZ = this.c.d;
        ChunkProviderServer chunkProvider = this.q.k();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                Chunk neighbour = chunkProvider.getChunkAtIfLoadedMainThreadNoCache(chunkX + dx, chunkZ + dz);
                if (neighbour == null) continue;
                neighbour.setNeighbourUnloaded(-dx, -dz);
            }
        }
        this.loadedTicketLevel = false;
        this.resetNeighbours();
    }

    @Override
    public boolean i() {
        return super.i() && !this.mustNotSave;
    }

    public boolean A() {
        return false;
    }

    public void a(PacketDataSerializer buf, NBTTagCompound nbt, Consumer<ClientboundLevelChunkPacketData.b> consumer) {
        this.G();
        for (ChunkSection chunksection : this.k) {
            chunksection.a(buf);
        }
        for (HeightMap.Type heightmap_type : HeightMap.Type.values()) {
            String s2 = heightmap_type.a();
            if (!nbt.b(s2, 12)) continue;
            this.a(heightmap_type, nbt.o(s2));
        }
        consumer.accept((blockposition, tileentitytypes, nbttagcompound1) -> {
            TileEntity tileentity = this.a(blockposition, EnumTileEntityState.a);
            if (tileentity != null && nbttagcompound1 != null && tileentity.u() == tileentitytypes) {
                tileentity.a(nbttagcompound1);
            }
        });
    }

    public void c(boolean loaded) {
        this.o = loaded;
    }

    public World D() {
        return this.q;
    }

    public Map<BlockPosition, TileEntity> E() {
        return this.i;
    }

    @Override
    public Stream<BlockPosition> n() {
        return StreamSupport.stream(BlockPosition.b(this.c.d(), this.u_(), this.c.e(), this.c.f(), this.ag() - 1, this.c.g()).spliterator(), false).filter(blockposition -> this.a_((BlockPosition)blockposition).f() != 0);
    }

    public void F() {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (this.a[i2] == null) continue;
            for (Short oshort : this.a[i2]) {
                BlockPosition blockposition = ProtoChunk.a(oshort, this.g(i2), chunkcoordintpair);
                IBlockData iblockdata = this.a_(blockposition);
                Fluid fluid = iblockdata.n();
                if (!fluid.c()) {
                    fluid.a(this.q, blockposition);
                }
                if (iblockdata.b() instanceof BlockFluids) continue;
                IBlockData iblockdata1 = Block.b(iblockdata, this.q, blockposition);
                this.q.a(blockposition, iblockdata1, 20);
            }
            this.a[i2].clear();
        }
        for (BlockPosition blockposition1 : ImmutableList.copyOf(this.h.keySet())) {
            this.c_(blockposition1);
        }
        this.h.clear();
        this.e.a(this);
    }

    @Nullable
    private TileEntity a(BlockPosition pos, NBTTagCompound nbt) {
        TileEntity tileentity;
        IBlockData iblockdata = this.a_(pos);
        if ("DUMMY".equals(nbt.l("id"))) {
            if (iblockdata.m()) {
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(pos, iblockdata);
            } else {
                tileentity = null;
                l.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)pos, (Object)iblockdata);
            }
        } else {
            tileentity = TileEntity.a(pos, iblockdata, nbt);
        }
        if (tileentity != null) {
            tileentity.a(this.q);
            this.b(tileentity);
        } else {
            l.warn("Tried to load a block entity for block {} but failed at location {}", (Object)iblockdata, (Object)pos);
        }
        return tileentity;
    }

    public void c(long time) {
        this.u.a(time);
        this.v.a(time);
    }

    public void a(WorldServer world) {
        world.l().a(this.c, this.u);
        world.m().a(this.c, this.v);
    }

    public void b(WorldServer world) {
        world.l().a(this.c);
        world.m().a(this.c);
    }

    @Override
    public ChunkStatus j() {
        return ChunkStatus.o;
    }

    public PlayerChunk.State B() {
        return this.r == null ? PlayerChunk.State.b : this.r.get();
    }

    public void b(Supplier<PlayerChunk.State> levelTypeProvider) {
        this.r = levelTypeProvider;
    }

    public void G() {
        this.i.values().forEach(TileEntity::aa_);
        this.i.clear();
        this.n.values().forEach(chunk_d -> chunk_d.a(m));
        this.n.clear();
    }

    public void H() {
        this.i.values().forEach(tileentity -> {
            this.d(tileentity);
            this.e(tileentity);
        });
    }

    private <T extends TileEntity> void d(T blockEntity) {
        GameEventListener gameeventlistener;
        Block block;
        if (!this.q.y && (block = blockEntity.q().b()) instanceof ITileEntity && (gameeventlistener = ((ITileEntity)((Object)block)).a(this.q, blockEntity)) != null) {
            GameEventDispatcher gameeventdispatcher = this.a(SectionPosition.a(blockEntity.p().v()));
            gameeventdispatcher.a(gameeventlistener);
        }
    }

    private <T extends TileEntity> void e(T blockEntity) {
        IBlockData iblockdata = blockEntity.q();
        BlockEntityTicker<?> blockentityticker = iblockdata.a((World)this.q, blockEntity.u());
        if (blockentityticker == null) {
            this.m(blockEntity.p());
        } else {
            this.n.compute(blockEntity.p(), (blockposition, chunk_d) -> {
                TickingBlockEntity tickingblockentity = this.a(blockEntity, blockentityticker);
                if (chunk_d != null) {
                    chunk_d.a(tickingblockentity);
                    return chunk_d;
                }
                if (this.J()) {
                    d chunk_d1 = new d(tickingblockentity);
                    this.q.a(chunk_d1);
                    return chunk_d1;
                }
                return null;
            });
        }
    }

    private <T extends TileEntity> TickingBlockEntity a(T blockEntity, BlockEntityTicker<T> blockEntityTicker) {
        return new a(blockEntity, blockEntityTicker);
    }

    public boolean I() {
        return this.p;
    }

    public void d(boolean shouldRenderOnUpdate) {
        this.p = shouldRenderOnUpdate;
    }

    @FunctionalInterface
    public static interface c {
        public void run(Chunk var1);
    }

    public static enum EnumTileEntityState {
        a,
        b,
        c;

    }

    private class d
    implements TickingBlockEntity {
        private TickingBlockEntity b;

        d(TickingBlockEntity tickingblockentity) {
            this.b = tickingblockentity;
        }

        void a(TickingBlockEntity wrapped) {
            this.b = wrapped;
        }

        @Override
        public void a() {
            this.b.a();
        }

        @Override
        public boolean b() {
            return this.b.b();
        }

        @Override
        public BlockPosition c() {
            return this.b.c();
        }

        @Override
        public String d() {
            return this.b.d();
        }

        public String toString() {
            return this.b.toString() + " <wrapped>";
        }
    }

    private class a<T extends TileEntity>
    implements TickingBlockEntity {
        private final T b;
        private final BlockEntityTicker<T> c;
        private boolean d;

        a(TileEntity tileentity, BlockEntityTicker blockentityticker) {
            this.b = tileentity;
            this.c = blockentityticker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void a() {
            BlockPosition blockposition;
            if (!((TileEntity)this.b).r() && ((TileEntity)this.b).l() && Chunk.this.l(blockposition = ((TileEntity)this.b).p())) {
                try {
                    GameProfilerFiller gameprofilerfiller = Chunk.this.q.ab();
                    gameprofilerfiller.a(this::d);
                    ((TileEntity)this.b).tickTimer.startTiming();
                    IBlockData iblockdata = Chunk.this.a_(blockposition);
                    if (((TileEntity)this.b).u().a(iblockdata)) {
                        this.c.tick(Chunk.this.q, ((TileEntity)this.b).p(), iblockdata, this.b);
                        this.d = false;
                    } else if (!this.d) {
                        this.d = true;
                        l.warn("Block entity {} @ {} state {} invalid for ticking:", new org.apache.logging.log4j.util.Supplier[]{this::d, this::c, () -> iblockdata});
                    }
                    gameprofilerfiller.c();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw throwable;
                    }
                    String msg = String.format("BlockEntity threw exception at %s:%s,%s,%s", Chunk.this.D().getWorld().getName(), this.c().u(), this.c().v(), this.c().w());
                    MinecraftServer.r.error(msg, throwable);
                    Chunk.this.q.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, throwable)));
                    Chunk.this.d(this.c());
                }
                finally {
                    ((TileEntity)this.b).tickTimer.stopTiming();
                }
            }
        }

        @Override
        public boolean b() {
            return ((TileEntity)this.b).r();
        }

        @Override
        public BlockPosition c() {
            return ((TileEntity)this.b).p();
        }

        @Override
        public String d() {
            return TileEntityTypes.a(((TileEntity)this.b).u()).toString();
        }

        public String toString() {
            String s2 = this.d();
            return "Level ticker for " + s2 + "@" + this.c();
        }
    }
}

