/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockStateList<O, S extends IBlockDataHolder<O, S>> {
    static final Pattern a = Pattern.compile("^[a-z0-9_]+$");
    private final O b;
    private final ImmutableSortedMap<String, IBlockState<?>> c;
    private final ImmutableList<S> d;

    protected BlockStateList(Function<O, S> defaultStateGetter, O owner, b<O, S> factory, Map<String, IBlockState<?>> propertiesMap) {
        this.b = owner;
        this.c = ImmutableSortedMap.copyOf(propertiesMap);
        Supplier<IBlockDataHolder> supplier = () -> (IBlockDataHolder)defaultStateGetter.apply(owner);
        MapCodec<IBlockDataHolder> mapCodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(supplier));
        for (Map.Entry entry : this.c.entrySet()) {
            mapCodec = BlockStateList.a(mapCodec, supplier, (String)entry.getKey(), (IBlockState)entry.getValue());
        }
        MapCodec<IBlockDataHolder> mapCodec2 = mapCodec;
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList list3 = Lists.newArrayList();
        Stream<List<List<Object>>> stream = Stream.of(Collections.emptyList());
        for (IBlockState property : this.c.values()) {
            stream = stream.flatMap(list -> property.a().stream().map(comparable -> {
                ArrayList list2 = Lists.newArrayList((Iterable)list);
                list2.add(Pair.of((Object)property, (Object)comparable));
                return list2;
            }));
        }
        stream.forEach(list2 -> {
            ImmutableMap immutableMap = (ImmutableMap)list2.stream().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
            IBlockDataHolder stateHolder = (IBlockDataHolder)factory.create(owner, immutableMap, mapCodec2);
            map.put(immutableMap, stateHolder);
            list3.add(stateHolder);
        });
        for (IBlockDataHolder stateHolder : list3) {
            stateHolder.a(map);
        }
        this.d = ImmutableList.copyOf((Collection)list3);
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> MapCodec<S> a(MapCodec<S> mapCodec, Supplier<S> defaultStateGetter, String key, IBlockState<T> property) {
        return Codec.mapPair(mapCodec, (MapCodec)property.e().fieldOf(key).orElseGet(string -> {}, () -> property.a((IBlockDataHolder)defaultStateGetter.get()))).xmap(pair -> (IBlockDataHolder)((IBlockDataHolder)pair.getFirst()).a(property, ((IBlockState.a)pair.getSecond()).b()), stateHolder -> Pair.of((Object)stateHolder, property.a((IBlockDataHolder<?, ?>)stateHolder)));
    }

    public ImmutableList<S> a() {
        return this.d;
    }

    public S b() {
        return (S)((IBlockDataHolder)this.d.get(0));
    }

    public O c() {
        return this.b;
    }

    public Collection<IBlockState<?>> d() {
        return this.c.values();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.b).add("properties", this.c.values().stream().map(IBlockState::f).collect(Collectors.toList())).toString();
    }

    @Nullable
    public IBlockState<?> a(String name) {
        return (IBlockState)this.c.get((Object)name);
    }

    public static interface b<O, S> {
        public S create(O var1, ImmutableMap<IBlockState<?>, Comparable<?>> var2, MapCodec<S> var3);
    }

    public static class a<O, S extends IBlockDataHolder<O, S>> {
        private final O a;
        private final Map<String, IBlockState<?>> b = Maps.newHashMap();

        public a(O owner) {
            this.a = owner;
        }

        public a<O, S> a(IBlockState<?> ... properties) {
            for (IBlockState<?> property : properties) {
                this.a((IBlockState<T>)property);
                this.b.put(property.f(), property);
            }
            return this;
        }

        private <T extends Comparable<T>> void a(IBlockState<T> property) {
            String string = property.f();
            if (!a.matcher(string).matches()) {
                throw new IllegalArgumentException(this.a + " has invalidly named property: " + string);
            }
            Collection<T> collection = property.a();
            if (collection.size() <= 1) {
                throw new IllegalArgumentException(this.a + " attempted use property " + string + " with <= 1 possible values");
            }
            for (Comparable comparable : collection) {
                String string2 = property.a(comparable);
                if (a.matcher(string2).matches()) continue;
                throw new IllegalArgumentException(this.a + " has property: " + string + " with invalidly named value: " + string2);
            }
            if (this.b.containsKey(string)) {
                throw new IllegalArgumentException(this.a + " has duplicate property: " + string);
            }
        }

        public BlockStateList<O, S> a(Function<O, S> defaultStateGetter, b<O, S> factory) {
            return new BlockStateList<O, S>(defaultStateGetter, this.a, factory, this.b);
        }
    }
}

