/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.destroystokyo.paper.PaperConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.piston.PistonExtendsChecker;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class BlockPiston
extends BlockDirectional {
    public static final BlockStateBoolean b = BlockProperties.g;
    public static final int c = 0;
    public static final int d = 1;
    public static final int e = 2;
    public static final float f = 4.0f;
    protected static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape h = Block.a(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape j = Block.a(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape k = Block.a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape l = Block.a(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean m;

    public BlockPiston(boolean sticky, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.E.b().a(BlockDirectional.a, EnumDirection.c)).a(b, false));
        this.m = sticky;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(b).booleanValue()) {
            switch (state.c(BlockDirectional.a)) {
                case a: {
                    return l;
                }
                default: {
                    return k;
                }
                case c: {
                    return j;
                }
                case d: {
                    return i;
                }
                case e: {
                    return h;
                }
                case f: 
            }
            return g;
        }
        return VoxelShapes.b();
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        if (!world.y) {
            this.a(world, pos, state);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block block, BlockPosition fromPos, boolean notify) {
        if (!world.y) {
            this.a(world, pos, state);
        }
    }

    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!oldState.a(state.b()) && !world.y && world.c_(pos) == null) {
            this.a(world, pos, state);
        }
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)((IBlockData)this.n().a(BlockDirectional.a, ctx.d().f())).a(b, false);
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockDirectional.a);
        boolean flag = this.a(world, pos, enumdirection);
        if (flag && !state.c(b).booleanValue()) {
            if (new PistonExtendsChecker(world, pos, enumdirection, true).a()) {
                world.a(pos, (Block)this, 0, enumdirection.b());
            }
        } else if (!flag && state.c(b).booleanValue()) {
            TileEntityPiston tileentitypiston;
            TileEntity tileentity;
            BlockPosition blockposition1 = pos.a(enumdirection, 2);
            IBlockData iblockdata1 = world.a_(blockposition1);
            int b0 = 1;
            if (iblockdata1.a(Blocks.bu) && iblockdata1.c(BlockDirectional.a) == enumdirection && (tileentity = world.c_(blockposition1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).c() && (tileentitypiston.a(0.0f) < 0.5f || world.V() == tileentitypiston.v() || ((WorldServer)world).c())) {
                b0 = 2;
            }
            world.a(pos, (Block)this, b0, enumdirection.b());
        }
    }

    private boolean a(World world, BlockPosition pos, EnumDirection pistonFace) {
        for (EnumDirection enumdirection1 : EnumDirection.values()) {
            if (enumdirection1 == pistonFace || !world.a(pos.a(enumdirection1), enumdirection1)) continue;
            return true;
        }
        if (world.a(pos, EnumDirection.a)) {
            return true;
        }
        BlockPosition blockposition1 = pos.b();
        for (EnumDirection enumdirection2 : EnumDirection.values()) {
            if (enumdirection2 == EnumDirection.a || !world.a(blockposition1.a(enumdirection2), enumdirection2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        EnumDirection enumdirection = state.c(BlockDirectional.a);
        EnumDirection directionQueuedAs = EnumDirection.a(data & 7);
        if (!PaperConfig.allowBlockPermanentBreakingExploits && enumdirection != directionQueuedAs) {
            return false;
        }
        if (!world.y) {
            boolean flag = this.a(world, pos, enumdirection);
            if (flag && (type == 1 || type == 2)) {
                world.a(pos, (IBlockData)state.a(b, true), 2);
                return false;
            }
            if (!flag && type == 0) {
                return false;
            }
        }
        if (type == 0) {
            if (!this.a(world, pos, enumdirection, true)) {
                return false;
            }
            world.a(pos, (IBlockData)state.a(b, true), 67);
            world.a((EntityHuman)null, pos, SoundEffects.ov, SoundCategory.e, 0.5f, world.w.nextFloat() * 0.25f + 0.6f);
            world.a(GameEvent.G, pos);
        } else if (type == 1 || type == 2) {
            TileEntity tileentity = world.c_(pos.a(enumdirection));
            if (tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).j();
            }
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.bu.n().a(BlockPistonMoving.a, enumdirection)).a(BlockPistonMoving.b, this.m ? BlockPropertyPistonType.b : BlockPropertyPistonType.a);
            if (!this.m && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(enumdirection)).callEvent()) {
                return false;
            }
            world.a(pos, iblockdata1, 20);
            world.a(BlockPistonMoving.a(pos, iblockdata1, (IBlockData)this.n().a(BlockDirectional.a, EnumDirection.a(data & 7)), enumdirection, false, true));
            world.a(pos, iblockdata1.b());
            iblockdata1.a((GeneratorAccess)world, pos, 2);
            if (this.m) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                BlockPosition blockposition1 = pos.b(enumdirection.i() * 2, enumdirection.j() * 2, enumdirection.k() * 2);
                IBlockData iblockdata2 = world.a_(blockposition1);
                boolean flag1 = false;
                if (iblockdata2.a(Blocks.bu) && (tileentity1 = world.c_(blockposition1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).d() == enumdirection && tileentitypiston.c()) {
                    tileentitypiston.j();
                    flag1 = true;
                }
                if (!flag1) {
                    if (type == 1 && !iblockdata2.g() && BlockPiston.a(iblockdata2, world, blockposition1, enumdirection.f(), false, enumdirection) && (iblockdata2.k() == EnumPistonReaction.a || iblockdata2.a(Blocks.bc) || iblockdata2.a(Blocks.aV))) {
                        this.a(world, pos, enumdirection, false);
                    } else {
                        if (type == 1 && iblockdata2.g() && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(enumdirection)).callEvent()) {
                            return false;
                        }
                        world.a(pos.a(enumdirection), false);
                    }
                }
            } else {
                BlockPosition headPos = pos.a(enumdirection);
                if (PaperConfig.allowBlockPermanentBreakingExploits || world.a_(headPos) == Blocks.bd.n().a(BlockDirectional.a, enumdirection)) {
                    world.a(headPos, false);
                } else {
                    ((WorldServer)world).k().a(headPos);
                }
            }
            world.a((EntityHuman)null, pos, SoundEffects.ou, SoundCategory.e, 0.5f, world.w.nextFloat() * 0.15f + 0.6f);
            world.a(GameEvent.F, pos);
        }
        return true;
    }

    public static boolean a(IBlockData state, World world, BlockPosition pos, EnumDirection direction, boolean canBreak, EnumDirection pistonDir) {
        if (pos.v() >= world.u_() && pos.v() <= world.ag() - 1 && world.p_().a(pos)) {
            if (state.g()) {
                return true;
            }
            if (!(state.a(Blocks.bQ) || state.a(Blocks.nw) || state.a(Blocks.nx))) {
                if (direction == EnumDirection.a && pos.v() == world.u_()) {
                    return false;
                }
                if (direction == EnumDirection.b && pos.v() == world.ag() - 1) {
                    return false;
                }
                if (!state.a(Blocks.bc) && !state.a(Blocks.aV)) {
                    if (state.h(world, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.k()) {
                        case c: {
                            return false;
                        }
                        case b: {
                            return canBreak;
                        }
                        case e: {
                            return direction == pistonDir;
                        }
                    }
                } else if (state.c(b).booleanValue()) {
                    return false;
                }
                return !state.m();
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean a(World world, BlockPosition pos, EnumDirection dir, boolean retract) {
        void var25_35;
        void var25_33;
        BlockPosition blockposition5;
        IBlockData iblockdata1;
        BlockPosition blockposition3;
        int k2;
        PistonExtendsChecker pistonextendschecker;
        BlockPosition blockposition1 = pos.a(dir);
        if (!retract && world.a_(blockposition1).a(Blocks.bd)) {
            world.a(blockposition1, Blocks.a.n(), 20);
        }
        if (!(pistonextendschecker = new PistonExtendsChecker(world, pos, dir, retract)).a()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPosition> list = pistonextendschecker.c();
        ArrayList list1 = Lists.newArrayList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            BlockPosition blockposition2 = list.get(i2);
            IBlockData iblockdata = world.a_(blockposition2);
            list1.add(iblockdata);
            map.put(blockposition2, iblockdata);
        }
        List<BlockPosition> list2 = pistonextendschecker.d();
        IBlockData[] aiblockdata = new IBlockData[list.size() + list2.size()];
        EnumDirection enumdirection1 = retract ? dir : dir.f();
        int j2 = 0;
        final org.bukkit.block.Block bblock = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        final List<BlockPosition> moved = pistonextendschecker.c();
        final List<BlockPosition> broken = pistonextendschecker.d();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(){

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPosition pos = index < moved.size() ? (BlockPosition)moved.get(index) : (BlockPosition)broken.get(index - moved.size());
                return bblock.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            }
        };
        Object event = retract ? new BlockPistonExtendEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1)) : new BlockPistonRetractEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            for (BlockPosition b2 : broken) {
                world.a(b2, Blocks.a.n(), world.a_(b2), 3);
            }
            for (BlockPosition b2 : moved) {
                world.a(b2, Blocks.a.n(), world.a_(b2), 3);
                b2 = b2.a(enumdirection1);
                world.a(b2, Blocks.a.n(), world.a_(b2), 3);
            }
            return false;
        }
        for (k2 = list2.size() - 1; k2 >= 0; --k2) {
            blockposition3 = list2.get(k2);
            iblockdata1 = world.a_(blockposition3);
            TileEntity tileentity = iblockdata1.m() ? world.c_(blockposition3) : null;
            BlockPiston.dropResources(iblockdata1, world, blockposition3, tileentity, pos);
            world.a(blockposition3, Blocks.a.n(), 18);
            if (!iblockdata1.a(TagsBlock.ax)) {
                world.a(blockposition3, iblockdata1);
            }
            aiblockdata[j2++] = iblockdata1;
        }
        for (k2 = list.size() - 1; k2 >= 0; --k2) {
            boolean allowDesync = PaperConfig.allowPistonDuplication;
            BlockPosition oldPos = blockposition3 = list.get(k2);
            iblockdata1 = allowDesync ? world.a_(oldPos) : null;
            blockposition3 = blockposition3.a(enumdirection1);
            map.remove(blockposition3);
            IBlockData iblockdata2 = (IBlockData)Blocks.bu.n().a(BlockDirectional.a, dir);
            world.a(blockposition3, iblockdata2, 68);
            if (!allowDesync) {
                iblockdata1 = world.a_(oldPos);
                map.replace(oldPos, iblockdata1);
            }
            world.a(BlockPistonMoving.a(blockposition3, iblockdata2, allowDesync ? (IBlockData)list1.get(k2) : iblockdata1, dir, retract, false));
            if (!allowDesync) {
                world.a(oldPos, Blocks.a.n(), 1046);
            }
            aiblockdata[j2++] = iblockdata1;
        }
        if (retract) {
            BlockPropertyPistonType blockpropertypistontype = this.m ? BlockPropertyPistonType.b : BlockPropertyPistonType.a;
            IBlockData iblockdata3 = (IBlockData)((IBlockData)Blocks.bd.n().a(BlockDirectional.a, dir)).a(BlockPistonExtension.b, blockpropertypistontype);
            iblockdata1 = (IBlockData)((IBlockData)Blocks.bu.n().a(BlockPistonMoving.a, dir)).a(BlockPistonMoving.b, this.m ? BlockPropertyPistonType.b : BlockPropertyPistonType.a);
            map.remove(blockposition1);
            world.a(blockposition1, iblockdata1, 68);
            world.a(BlockPistonMoving.a(blockposition1, iblockdata1, iblockdata3, dir, true, true));
        }
        IBlockData iblockdata4 = Blocks.a.n();
        for (BlockPosition blockposition4 : map.keySet()) {
            world.a(blockposition4, iblockdata4, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            blockposition5 = (BlockPosition)entry.getKey();
            IBlockData iblockdata5 = (IBlockData)entry.getValue();
            iblockdata5.b(world, blockposition5, 2);
            iblockdata4.a((GeneratorAccess)world, blockposition5, 2);
            iblockdata4.b(world, blockposition5, 2);
        }
        j2 = 0;
        int n2 = list2.size() - 1;
        while (var25_33 >= 0) {
            iblockdata1 = aiblockdata[j2++];
            blockposition5 = list2.get((int)var25_33);
            iblockdata1.b(world, blockposition5, 2);
            world.b(blockposition5, iblockdata1.b());
            --var25_33;
        }
        int n3 = list.size() - 1;
        while (var25_35 >= 0) {
            world.b(list.get((int)var25_35), aiblockdata[j2++].b());
            --var25_35;
        }
        if (retract) {
            world.b(blockposition1, Blocks.bd);
        }
        return true;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(BlockDirectional.a, rotation.a(state.c(BlockDirectional.a)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(BlockDirectional.a)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockDirectional.a, b);
    }

    @Override
    public boolean g_(IBlockData state) {
        return state.c(b);
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }
}

