/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import com.destroystokyo.paper.loottable.PaperTileEntityLootableInventory;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;

public abstract class TileEntityLootable
extends TileEntityContainer {
    public static final String d = "LootTable";
    public static final String e = "LootTableSeed";
    @Nullable
    public MinecraftKey g;
    public long h;
    public final PaperLootableInventoryData lootableData = new PaperLootableInventoryData(new PaperTileEntityLootableInventory(this));

    protected TileEntityLootable(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        super(type, pos, state);
    }

    public static void a(IBlockAccess world, Random random, BlockPosition pos, MinecraftKey id) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityLootable) {
            ((TileEntityLootable)blockEntity).a(id, random.nextLong());
        }
    }

    protected boolean d(NBTTagCompound nbt) {
        this.lootableData.loadNbt(nbt);
        if (nbt.b(d, 8)) {
            this.g = new MinecraftKey(nbt.l(d));
            try {
                CraftNamespacedKey.fromMinecraft(this.g);
            }
            catch (IllegalArgumentException ex) {
                this.g = null;
            }
            this.h = nbt.i(e);
            return false;
        }
        return false;
    }

    protected boolean e(NBTTagCompound nbt) {
        this.lootableData.saveNbt(nbt);
        if (this.g == null) {
            return false;
        }
        nbt.a(d, this.g.toString());
        if (this.h != 0L) {
            nbt.a(e, this.h);
        }
        return false;
    }

    public void e(@Nullable EntityHuman player) {
        if (this.lootableData.shouldReplenish(player) && this.n.n() != null) {
            LootTable lootTable = this.n.n().aG().a(this.g);
            if (player instanceof EntityPlayer) {
                CriterionTriggers.N.a((EntityPlayer)player, this.g);
            }
            this.lootableData.processRefill(player);
            LootTableInfo.Builder builder = new LootTableInfo.Builder((WorldServer)this.n).a(LootContextParameters.f, Vec3D.a(this.o)).a(this.h);
            if (player != null) {
                builder.a(player.fL()).a(LootContextParameters.a, player);
            }
            lootTable.a((IInventory)this, builder.a(LootContextParameterSets.b));
        }
    }

    public void a(MinecraftKey id, long seed) {
        this.g = id;
        this.h = seed;
    }

    @Override
    public boolean c() {
        this.e((EntityHuman)null);
        for (ItemStack itemStack : this.f()) {
            if (itemStack.b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack a(int slot) {
        if (slot == 0) {
            this.e((EntityHuman)null);
        }
        return this.f().get(slot);
    }

    @Override
    public ItemStack a(int slot, int amount) {
        this.e((EntityHuman)null);
        ItemStack itemStack = ContainerUtil.a(this.f(), slot, amount);
        if (!itemStack.b()) {
            this.e();
        }
        return itemStack;
    }

    @Override
    public ItemStack b(int slot) {
        this.e((EntityHuman)null);
        return ContainerUtil.a(this.f(), slot);
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.e((EntityHuman)null);
        this.f().set(slot, stack);
        if (stack.I() > this.M_()) {
            stack.e(this.M_());
        }
        this.e();
    }

    @Override
    public boolean a(EntityHuman player) {
        if (this.n.c_(this.o) != this) {
            return false;
        }
        return !(player.h((double)this.o.u() + 0.5, (double)this.o.v() + 0.5, (double)this.o.w() + 0.5) > 64.0);
    }

    @Override
    public void a() {
        this.f().clear();
    }

    protected abstract NonNullList<ItemStack> f();

    protected abstract void a(NonNullList<ItemStack> var1);

    @Override
    public boolean d(EntityHuman player) {
        return super.d(player) && (this.g == null || !player.B_());
    }

    @Override
    @Nullable
    public Container createMenu(int syncId, PlayerInventory inv, EntityHuman player) {
        if (this.d(player)) {
            this.e(inv.l);
            return this.a(syncId, inv);
        }
        return null;
    }
}

