/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TileEntityHopper
extends TileEntityLootable
implements IHopper {
    public static final int c = 8;
    public static final int f = 5;
    private NonNullList<net.minecraft.world.item.ItemStack> i;
    private int j = -1;
    private long k;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    private static boolean skipPullModeEventFire = false;
    private static boolean skipPushModeEventFire = false;
    public static boolean skipHopperEvents = false;
    private static final BiPredicate<net.minecraft.world.item.ItemStack, Integer> STACK_SIZE_TEST = (itemstack, i2) -> itemstack.I() >= itemstack.d();
    private static final BiPredicate<net.minecraft.world.item.ItemStack, Integer> IS_EMPTY_TEST = (itemstack, i2) -> itemstack.b();

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.i;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int M_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityHopper(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.q, pos, state);
        this.i = NonNullList.a(5, net.minecraft.world.item.ItemStack.b);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.i = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.b);
        if (!this.d(nbt)) {
            ContainerUtil.b(nbt, this.i);
        }
        this.j = nbt.h("TransferCooldown");
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (!this.e(nbt)) {
            ContainerUtil.a(nbt, this.i);
        }
        nbt.a("TransferCooldown", this.j);
    }

    @Override
    public int b() {
        return this.i.size();
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int slot, int amount) {
        this.e((EntityHuman)null);
        return ContainerUtil.a(this.f(), slot, amount);
    }

    @Override
    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        this.e((EntityHuman)null);
        this.f().set(slot, stack);
        if (stack.I() > this.M_()) {
            stack.e(this.M_());
        }
    }

    @Override
    protected IChatBaseComponent g() {
        return new ChatMessage("container.hopper");
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityHopper blockEntity) {
        --blockEntity.j;
        blockEntity.k = world.V();
        if (!blockEntity.j()) {
            blockEntity.c(0);
            boolean result = TileEntityHopper.a(world, pos, state, blockEntity, () -> TileEntityHopper.a(world, blockEntity));
            if (!result && blockEntity.n.spigotConfig.hopperCheck > 1) {
                blockEntity.c(blockEntity.n.spigotConfig.hopperCheck);
            }
        }
    }

    private static boolean a(World world, BlockPosition pos, IBlockData state, TileEntityHopper blockEntity, BooleanSupplier booleansupplier) {
        if (world.y) {
            return false;
        }
        if (!blockEntity.j() && state.c(BlockHopper.b).booleanValue()) {
            boolean flag = false;
            if (!blockEntity.c()) {
                flag = TileEntityHopper.ejectItems(world, pos, state, blockEntity, blockEntity);
            }
            if (!blockEntity.i()) {
                flag |= booleansupplier.getAsBoolean();
            }
            if (flag) {
                blockEntity.c(world.spigotConfig.hopperTransfer);
                TileEntityHopper.a(world, pos, state);
                return true;
            }
        }
        return false;
    }

    private boolean i() {
        net.minecraft.world.item.ItemStack itemstack;
        Iterator iterator = this.i.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(itemstack = (net.minecraft.world.item.ItemStack)iterator.next()).b() && itemstack.I() == itemstack.d());
        return false;
    }

    private static boolean hopperPush(World level, BlockPosition pos, IInventory destination, EnumDirection enumdirection, TileEntityHopper hopper) {
        skipPushModeEventFire = skipHopperEvents;
        boolean foundItem = false;
        for (int i2 = 0; i2 < hopper.b(); ++i2) {
            net.minecraft.world.item.ItemStack origItemStack;
            net.minecraft.world.item.ItemStack item = hopper.a(i2);
            if (item.b()) continue;
            foundItem = true;
            net.minecraft.world.item.ItemStack itemstack = origItemStack = item;
            int origCount = origItemStack.I();
            int moved = Math.min(level.spigotConfig.hopperAmount, origCount);
            origItemStack.e(moved);
            if (!skipPushModeEventFire && (itemstack = TileEntityHopper.callPushMoveEvent(destination, itemstack, hopper)) == null) {
                origItemStack.e(origCount);
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack2 = TileEntityHopper.a((IInventory)hopper, destination, itemstack, enumdirection);
            int remaining = itemstack2.I();
            if (remaining != moved) {
                origItemStack = origItemStack.cloneItemStack(true);
                origItemStack.e(origCount);
                if (!origItemStack.b()) {
                    origItemStack.e(origCount - moved + remaining);
                }
                hopper.a(i2, origItemStack);
                destination.e();
                return true;
            }
            origItemStack.e(origCount);
        }
        if (foundItem && level.paperConfig.cooldownHopperWhenFull) {
            hopper.c(level.spigotConfig.hopperTransfer);
        }
        return false;
    }

    private static boolean hopperPull(World level, IHopper ihopper, IInventory iinventory, net.minecraft.world.item.ItemStack origItemStack, int i2) {
        net.minecraft.world.item.ItemStack itemstack = origItemStack;
        int origCount = origItemStack.I();
        int moved = Math.min(level.spigotConfig.hopperAmount, origCount);
        itemstack.e(moved);
        if (!skipPullModeEventFire && (itemstack = TileEntityHopper.callPullMoveEvent(ihopper, iinventory, itemstack)) == null) {
            origItemStack.e(origCount);
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack2 = TileEntityHopper.a(iinventory, ihopper, itemstack, null);
        int remaining = itemstack2.I();
        if (remaining != moved) {
            origItemStack = origItemStack.cloneItemStack(true);
            origItemStack.e(origCount);
            if (!origItemStack.b()) {
                origItemStack.e(origCount - moved + remaining);
            }
            TileEntity.IGNORE_TILE_UPDATES = true;
            iinventory.a(i2, origItemStack);
            TileEntity.IGNORE_TILE_UPDATES = false;
            iinventory.e();
            return true;
        }
        origItemStack.e(origCount);
        if (level.paperConfig.cooldownHopperWhenFull) {
            TileEntityHopper.cooldownHopper(ihopper);
        }
        return false;
    }

    private static net.minecraft.world.item.ItemStack callPushMoveEvent(IInventory iinventory, net.minecraft.world.item.ItemStack itemstack, TileEntityHopper hopper) {
        Inventory destinationInventory = TileEntityHopper.getInventory(iinventory);
        InventoryMoveItemEvent event = new InventoryMoveItemEvent(hopper.getOwner(false).getInventory(), (ItemStack)CraftItemStack.asCraftMirror(itemstack), destinationInventory, true);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPushModeEventFire = true;
        }
        if (!result) {
            TileEntityHopper.cooldownHopper(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    private static net.minecraft.world.item.ItemStack callPullMoveEvent(IHopper hopper, IInventory iinventory, net.minecraft.world.item.ItemStack itemstack) {
        Inventory sourceInventory = TileEntityHopper.getInventory(iinventory);
        Inventory destination = TileEntityHopper.getInventory(hopper);
        InventoryMoveItemEvent event = new InventoryMoveItemEvent(sourceInventory, (ItemStack)CraftItemStack.asCraftMirror(itemstack), destination, false);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPullModeEventFire = true;
        }
        if (!result) {
            TileEntityHopper.cooldownHopper(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    private static Inventory getInventory(IInventory iinventory) {
        CraftInventoryDoubleChest sourceInventory = iinventory instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory) : (iinventory instanceof TileEntity ? ((TileEntity)((Object)iinventory)).getOwner(false).getInventory() : iinventory.getOwner().getInventory());
        return sourceInventory;
    }

    private static void cooldownHopper(IHopper hopper) {
        if (hopper instanceof TileEntityHopper) {
            TileEntityHopper blockEntity = (TileEntityHopper)hopper;
            blockEntity.c(blockEntity.k().spigotConfig.hopperTransfer);
        } else if (hopper instanceof EntityMinecartHopper) {
            EntityMinecartHopper blockEntity = (EntityMinecartHopper)hopper;
            blockEntity.n(blockEntity.W().spigotConfig.hopperTransfer / 2);
        }
    }

    private static boolean ejectItems(World world, BlockPosition blockposition, IBlockData iblockdata, IInventory iinventory, TileEntityHopper hopper) {
        IInventory iinventory1 = TileEntityHopper.b(world, blockposition, iblockdata);
        if (iinventory1 == null) {
            return false;
        }
        EnumDirection enumdirection = iblockdata.c(BlockHopper.a).f();
        if (TileEntityHopper.b(iinventory1, enumdirection)) {
            return false;
        }
        return TileEntityHopper.hopperPush(world, blockposition, iinventory1, enumdirection, hopper);
    }

    private static IntStream a(IInventory inventory, EnumDirection side) {
        return inventory instanceof IWorldInventory ? IntStream.of(((IWorldInventory)inventory).a(side)) : IntStream.range(0, inventory.b());
    }

    private static boolean b(IInventory inventory, EnumDirection direction) {
        return TileEntityHopper.allMatch(inventory, direction, STACK_SIZE_TEST);
    }

    private static boolean c(IInventory inv, EnumDirection facing) {
        return TileEntityHopper.allMatch(inv, facing, IS_EMPTY_TEST);
    }

    private static boolean allMatch(IInventory iinventory, EnumDirection enumdirection, BiPredicate<net.minecraft.world.item.ItemStack, Integer> test) {
        if (iinventory instanceof IWorldInventory) {
            for (int i2 : ((IWorldInventory)iinventory).a(enumdirection)) {
                if (test.test(iinventory.a(i2), i2)) continue;
                return false;
            }
        } else {
            int size = iinventory.b();
            for (int i3 = 0; i3 < size; ++i3) {
                if (test.test(iinventory.a(i3), i3)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean anyMatch(IInventory iinventory, EnumDirection enumdirection, BiPredicate<net.minecraft.world.item.ItemStack, Integer> test) {
        if (iinventory instanceof IWorldInventory) {
            for (int i2 : ((IWorldInventory)iinventory).a(enumdirection)) {
                if (!test.test(iinventory.a(i2), i2)) continue;
                return true;
            }
        } else {
            int size = iinventory.b();
            for (int i3 = 0; i3 < size; ++i3) {
                if (!test.test(iinventory.a(i3), i3)) continue;
                return true;
            }
        }
        return true;
    }

    public static boolean a(World world, IHopper hopper) {
        EntityItem entityitem;
        IInventory iinventory = TileEntityHopper.c(world, hopper);
        if (iinventory != null) {
            EnumDirection enumdirection = EnumDirection.a;
            skipPullModeEventFire = skipHopperEvents;
            return !TileEntityHopper.c(iinventory, enumdirection) && TileEntityHopper.anyMatch(iinventory, enumdirection, (item, i2) -> {
                if (!item.b() && TileEntityHopper.b(iinventory, item, i2, enumdirection)) {
                    return TileEntityHopper.hopperPull(world, hopper, iinventory, item, i2);
                }
                return false;
            });
        }
        Iterator<EntityItem> iterator = TileEntityHopper.b(world, hopper).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!TileEntityHopper.a((IInventory)hopper, entityitem = iterator.next()));
        return true;
    }

    private static boolean a(IHopper ihopper, IInventory iinventory, int i2, EnumDirection enumdirection, World world) {
        net.minecraft.world.item.ItemStack itemstack = iinventory.a(i2);
        if (!itemstack.b() && TileEntityHopper.b(iinventory, itemstack, i2, enumdirection)) {
            return TileEntityHopper.hopperPull(world, ihopper, iinventory, itemstack, i2);
        }
        return false;
    }

    public static boolean a(IInventory inventory, EntityItem itemEntity) {
        boolean flag = false;
        InventoryPickupItemEvent event = new InventoryPickupItemEvent(TileEntityHopper.getInventory(inventory), (Item)itemEntity.getBukkitEntity());
        itemEntity.t.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = itemEntity.h().m();
        net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.a((IInventory)null, inventory, itemstack, (EnumDirection)null);
        if (itemstack1.b()) {
            flag = true;
            itemEntity.ah();
        } else {
            itemEntity.a(itemstack1);
        }
        return flag;
    }

    public static net.minecraft.world.item.ItemStack a(@Nullable IInventory from, IInventory to, net.minecraft.world.item.ItemStack stack, @Nullable EnumDirection side) {
        if (to instanceof IWorldInventory && side != null) {
            IWorldInventory iworldinventory = (IWorldInventory)to;
            int[] aint = iworldinventory.a(side);
            for (int i2 = 0; i2 < aint.length && !stack.b(); ++i2) {
                stack = TileEntityHopper.a(from, to, stack, aint[i2], side);
            }
        } else {
            int j2 = to.b();
            for (int k2 = 0; k2 < j2 && !stack.b(); ++k2) {
                stack = TileEntityHopper.a(from, to, stack, k2, side);
            }
        }
        return stack;
    }

    private static boolean a(IInventory inventory, net.minecraft.world.item.ItemStack stack, int slot, @Nullable EnumDirection side) {
        return !inventory.b(slot, stack) ? false : !(inventory instanceof IWorldInventory) || ((IWorldInventory)inventory).a(slot, stack, side);
    }

    private static boolean b(IInventory inv, net.minecraft.world.item.ItemStack stack, int slot, EnumDirection facing) {
        return !(inv instanceof IWorldInventory) || ((IWorldInventory)inv).b(slot, stack, facing);
    }

    private static net.minecraft.world.item.ItemStack a(@Nullable IInventory from, IInventory to, net.minecraft.world.item.ItemStack stack, int slot, @Nullable EnumDirection side) {
        net.minecraft.world.item.ItemStack itemstack1 = to.a(slot);
        if (TileEntityHopper.a(to, stack, slot, side)) {
            boolean flag = false;
            boolean flag1 = to.c();
            if (itemstack1.b()) {
                net.minecraft.world.item.ItemStack leftover = net.minecraft.world.item.ItemStack.b;
                if (!stack.b() && stack.I() > to.M_()) {
                    leftover = stack;
                    stack = stack.a(to.M_());
                }
                TileEntity.IGNORE_TILE_UPDATES = true;
                to.a(slot, stack);
                TileEntity.IGNORE_TILE_UPDATES = false;
                stack = leftover;
                flag = true;
            } else if (TileEntityHopper.a(itemstack1, stack)) {
                int j2 = Math.min(stack.d(), to.M_()) - itemstack1.I();
                int k2 = Math.min(stack.I(), j2);
                stack.g(k2);
                itemstack1.f(k2);
                boolean bl = flag = k2 > 0;
            }
            if (flag) {
                TileEntityHopper tileentityhopper;
                if (flag1 && to instanceof TileEntityHopper && !(tileentityhopper = (TileEntityHopper)to).v()) {
                    int b0 = 0;
                    if (from instanceof TileEntityHopper) {
                        TileEntityHopper tileentityhopper1 = (TileEntityHopper)from;
                        if (tileentityhopper.k >= tileentityhopper1.k) {
                            b0 = 1;
                        }
                    }
                    tileentityhopper.c(tileentityhopper.n.spigotConfig.hopperTransfer - b0);
                }
                to.e();
            }
        }
        return stack;
    }

    @Nullable
    private static IInventory b(World world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockHopper.a);
        return TileEntityHopper.a(world, pos.a(enumdirection));
    }

    @Nullable
    private static IInventory c(World world, IHopper hopper) {
        return TileEntityHopper.a(world, hopper.y(), hopper.z() + 1.0, hopper.A());
    }

    public static List<EntityItem> b(World world, IHopper hopper) {
        double d0 = hopper.y();
        double d1 = hopper.z();
        double d2 = hopper.A();
        AxisAlignedBB bb = new AxisAlignedBB(d0 - 0.5, d1, d2 - 0.5, d0 + 0.5, d1 + 1.5, d2 + 0.5);
        return world.a(EntityItem.class, bb, Entity::bl);
    }

    @Nullable
    public static IInventory a(World world, BlockPosition pos) {
        return TileEntityHopper.getContainerAt(world, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, true);
    }

    public static IInventory a(World world, double x2, double y2, double z2) {
        return TileEntityHopper.getContainerAt(world, x2, y2, z2, false);
    }

    @Nullable
    private static IInventory getContainerAt(World world, double x2, double y2, double z2, boolean optimizeEntities) {
        List<Entity> list;
        TileEntity tileentity;
        IInventory object = null;
        BlockPosition blockposition = new BlockPosition(x2, y2, z2);
        if (!world.C(blockposition)) {
            return null;
        }
        IBlockData iblockdata = world.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof IInventoryHolder) {
            object = ((IInventoryHolder)((Object)block)).a(iblockdata, world, blockposition);
        } else if (iblockdata.m() && (tileentity = world.c_(blockposition)) instanceof IInventory && (object = (IInventory)((Object)tileentity)) instanceof TileEntityChest && block instanceof BlockChest) {
            object = BlockChest.a((BlockChest)block, iblockdata, world, blockposition, true);
        }
        if (!(object != null || optimizeEntities && world.paperConfig.hoppersIgnoreOccludingBlocks && CraftMagicNumbers.getMaterial(block).isOccluding() || (list = world.a((Entity)null, new AxisAlignedBB(x2 - 0.5, y2 - 0.5, z2 - 0.5, x2 + 0.5, y2 + 0.5, z2 + 0.5), IEntitySelector.d)).isEmpty())) {
            object = (IInventory)((Object)list.get(world.w.nextInt(list.size())));
        }
        return object;
    }

    private static boolean a(net.minecraft.world.item.ItemStack first, net.minecraft.world.item.ItemStack second) {
        return !first.a(second.c()) ? false : (first.h() != second.h() ? false : (first.I() > first.d() ? false : net.minecraft.world.item.ItemStack.a(first, second)));
    }

    @Override
    public double y() {
        return (double)this.o.u() + 0.5;
    }

    @Override
    public double z() {
        return (double)this.o.v() + 0.5;
    }

    @Override
    public double A() {
        return (double)this.o.w() + 0.5;
    }

    private void c(int cooldown) {
        this.j = cooldown;
    }

    private boolean j() {
        return this.j > 0;
    }

    private boolean v() {
        return this.j > 8;
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> f() {
        return this.i;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> list) {
        this.i = list;
    }

    public static void a(World world, BlockPosition pos, IBlockData state, Entity entity, TileEntityHopper blockEntity) {
        if (entity instanceof EntityItem && VoxelShapes.c(VoxelShapes.a(entity.cw().d(-pos.u(), -pos.v(), -pos.w())), blockEntity.L_(), OperatorBoolean.i)) {
            TileEntityHopper.a(world, pos, state, blockEntity, () -> TileEntityHopper.a((IInventory)blockEntity, (EntityItem)entity));
        }
    }

    @Override
    protected Container a(int syncId, PlayerInventory playerInventory) {
        return new ContainerHopper(syncId, playerInventory, this);
    }
}

