/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCauldron;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockStates;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final int c = 1;
    public static final int d = 3;
    public static final BlockStateInteger e = BlockProperties.aF;
    private static final int h = 6;
    private static final double i = 3.0;
    public static final Predicate<BiomeBase.Precipitation> f = biomebase_precipitation -> biomebase_precipitation == BiomeBase.Precipitation.b;
    public static final Predicate<BiomeBase.Precipitation> g = biomebase_precipitation -> biomebase_precipitation == BiomeBase.Precipitation.c;
    private final Predicate<BiomeBase.Precipitation> j;

    public LayeredCauldronBlock(BlockBase.Info settings, Predicate<BiomeBase.Precipitation> precipitationPredicate, Map<Item, CauldronInteraction> behaviorMap) {
        super(settings, behaviorMap);
        this.j = precipitationPredicate;
        this.k((IBlockData)this.E.b().a(e, 1));
    }

    @Override
    public boolean c(IBlockData state) {
        return state.c(e) == 3;
    }

    @Override
    protected boolean a(FluidType fluid) {
        return fluid == FluidTypes.c && this.j == f;
    }

    @Override
    protected double a(IBlockData state) {
        return (6.0 + (double)state.c(e).intValue() * 3.0) / 16.0;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.y && entity.bE() && this.a(state, pos, entity)) {
            if (entity.a(world, pos) && !LayeredCauldronBlock.lowerFillLevel(state, world, pos, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH)) {
                return;
            }
            entity.au();
        }
    }

    protected void d(IBlockData state, World world, BlockPosition pos) {
        LayeredCauldronBlock.e(state, world, pos);
    }

    public static void e(IBlockData state, World world, BlockPosition pos) {
        LayeredCauldronBlock.lowerFillLevel(state, world, pos, null, CauldronLevelChangeEvent.ChangeReason.UNKNOWN);
    }

    public static boolean lowerFillLevel(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        int i2 = iblockdata.c(e) - 1;
        return LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, i2 == 0 ? Blocks.ek.n() : (IBlockData)iblockdata.a(e, i2), entity, reason);
    }

    public static boolean changeLevel(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData newBlock, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        CraftBlockState newState = CraftBlockStates.getBlockState(world, blockposition);
        newState.setData(newBlock);
        CauldronLevelChangeEvent event = new CauldronLevelChangeEvent(world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (Entity)(entity == null ? null : entity.getBukkitEntity()), reason, (BlockState)newState);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        newState.update(true);
        return true;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, BiomeBase.Precipitation precipitation) {
        if (BlockCauldron.a(world, precipitation) && state.c(e) != 3 && this.j.test(precipitation)) {
            LayeredCauldronBlock.changeLevel(state, world, pos, (IBlockData)state.a(e), null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
        }
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        return state.c(e);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{e});
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, FluidType fluid) {
        if (!this.c(state)) {
            if (!LayeredCauldronBlock.changeLevel(state, world, pos, (IBlockData)state.a(e, state.c(e) + 1), null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL)) {
                return;
            }
            world.c(1047, pos, 0);
        }
    }
}

