/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockStairs
extends Block
implements IBlockWaterlogged {
    public static final BlockStateDirection a = BlockFacingHorizontal.aE;
    public static final BlockStateEnum<BlockPropertyHalf> b = BlockProperties.ac;
    public static final BlockStateEnum<BlockPropertyStairsShape> c = BlockProperties.be;
    public static final BlockStateBoolean d = BlockProperties.C;
    protected static final VoxelShape e = BlockStepAbstract.d;
    protected static final VoxelShape f = BlockStepAbstract.c;
    protected static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape h = Block.a(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape i = Block.a(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape j = Block.a(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape k = Block.a(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape l = Block.a(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape m = Block.a(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape n = Block.a(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] F = BlockStairs.a(e, g, k, h, l);
    protected static final VoxelShape[] G = BlockStairs.a(f, i, m, j, n);
    private static final int[] H = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block I;
    private final IBlockData J;

    private static VoxelShape[] a(VoxelShape base, VoxelShape northWest, VoxelShape northEast, VoxelShape southWest, VoxelShape southEast) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(i2 -> BlockStairs.a(i2, base, northWest, northEast, southWest, southEast)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape a(int i2, VoxelShape base, VoxelShape northWest, VoxelShape northEast, VoxelShape southWest, VoxelShape southEast) {
        VoxelShape voxelShape = base;
        if ((i2 & 1) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, northWest);
        }
        if ((i2 & 2) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, northEast);
        }
        if ((i2 & 4) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, southWest);
        }
        if ((i2 & 8) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, southEast);
        }
        return voxelShape;
    }

    protected BlockStairs(IBlockData baseBlockState, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b().a(a, EnumDirection.c)).a(b, BlockPropertyHalf.b)).a(c, BlockPropertyStairsShape.a)).a(d, false));
        this.I = baseBlockState.b();
        this.J = baseBlockState;
    }

    @Override
    @Override
    public boolean g_(IBlockData state) {
        return true;
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return (state.c(b) == BlockPropertyHalf.a ? F : G)[H[this.n(state)]];
    }

    private int n(IBlockData state) {
        return state.c(c).ordinal() * 4 + state.c(a).d();
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Random random) {
        this.I.a(state, world, pos, random);
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, EntityHuman player) {
        this.J.a(world, pos, player);
    }

    @Override
    @Override
    public void a(GeneratorAccess world, BlockPosition pos, IBlockData state) {
        this.I.a(world, pos, state);
    }

    @Override
    @Override
    public float f() {
        return this.I.f();
    }

    @Override
    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (state.a(state.b())) {
            return;
        }
        this.J.a(world, pos, Blocks.a, pos, false);
        this.I.b(this.J, world, pos, oldState, false);
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (state.a(newState.b())) {
            return;
        }
        this.J.b(world, pos, newState, moved);
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, IBlockData state, Entity entity) {
        this.I.a(world, pos, state, entity);
    }

    @Override
    @Override
    public boolean e_(IBlockData state) {
        return this.I.e_(state);
    }

    @Override
    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        this.I.b(state, world, pos, random);
    }

    @Override
    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        this.I.a(state, world, pos, random);
    }

    @Override
    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        return this.J.a(world, player, hand, hit);
    }

    @Override
    @Override
    public void a(World world, BlockPosition pos, Explosion explosion) {
        this.I.a(world, pos, explosion);
    }

    @Override
    @Override
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection direction = ctx.k();
        BlockPosition blockPos = ctx.a();
        Fluid fluidState = ctx.q().b_(blockPos);
        IBlockData blockState = (IBlockData)((IBlockData)((IBlockData)this.n().a(a, ctx.g())).a(b, direction == EnumDirection.a || direction != EnumDirection.b && ctx.l().c - (double)blockPos.v() > 0.5 ? BlockPropertyHalf.a : BlockPropertyHalf.b)).a(d, fluidState.a() == FluidTypes.c);
        return (IBlockData)blockState.a(c, BlockStairs.h(blockState, ctx.q(), blockPos));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(d).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        if (direction.n().d()) {
            return (IBlockData)state.a(c, BlockStairs.h(state, world, pos));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    private static BlockPropertyStairsShape h(IBlockData state, IBlockAccess world, BlockPosition pos) {
        EnumDirection direction3;
        EnumDirection direction2;
        EnumDirection direction = state.c(a);
        IBlockData blockState = world.a_(pos.a(direction));
        if (BlockStairs.h(blockState) && state.c(b) == blockState.c(b) && (direction2 = blockState.c(a)).n() != state.c(a).n() && BlockStairs.c(state, world, pos, direction2.f())) {
            if (direction2 == direction.h()) {
                return BlockPropertyStairsShape.d;
            }
            return BlockPropertyStairsShape.e;
        }
        IBlockData blockState2 = world.a_(pos.a(direction.f()));
        if (BlockStairs.h(blockState2) && state.c(b) == blockState2.c(b) && (direction3 = blockState2.c(a)).n() != state.c(a).n() && BlockStairs.c(state, world, pos, direction3)) {
            if (direction3 == direction.h()) {
                return BlockPropertyStairsShape.b;
            }
            return BlockPropertyStairsShape.c;
        }
        return BlockPropertyStairsShape.a;
    }

    private static boolean c(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection dir) {
        IBlockData blockState = world.a_(pos.a(dir));
        return !BlockStairs.h(blockState) || blockState.c(a) != state.c(a) || blockState.c(b) != state.c(b);
    }

    public static boolean h(IBlockData state) {
        return state.b() instanceof BlockStairs;
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(a, rotation.a(state.c(a)));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        EnumDirection direction = state.c(a);
        BlockPropertyStairsShape stairsShape = state.c(c);
        switch (mirror) {
            case b: {
                if (direction.n() != EnumDirection.EnumAxis.c) break;
                switch (stairsShape) {
                    case b: {
                        return (IBlockData)state.a(EnumBlockRotation.c).a(c, BlockPropertyStairsShape.c);
                    }
                    case c: {
                        return (IBlockData)state.a(EnumBlockRotation.c).a(c, BlockPropertyStairsShape.b);
                    }
                    case d: {
                        return (IBlockData)state.a(EnumBlockRotation.c).a(c, BlockPropertyStairsShape.e);
                    }
                    case e: {
                        return (IBlockData)state.a(EnumBlockRotation.c).a(c, BlockPropertyStairsShape.d);
                    }
                }
                return state.a(EnumBlockRotation.c);
            }
            case c: {
                if (direction.n() != EnumDirection.EnumAxis.a) break;
                switch (stairsShape) {
                    case b: {
                        return (IBlockData)state.a(EnumBlockRotation.c).a(c, BlockPropertyStairsShape.b);
                    }
                    case c: {
                        return (IBlockData)state.a(EnumBlockRotation.c).a(c, BlockPropertyStairsShape.c);
                    }
                    case d: {
                        return (IBlockData)state.a(EnumBlockRotation.c).a(c, BlockPropertyStairsShape.e);
                    }
                    case e: {
                        return (IBlockData)state.a(EnumBlockRotation.c).a(c, BlockPropertyStairsShape.d);
                    }
                    case a: {
                        return state.a(EnumBlockRotation.c);
                    }
                }
                break;
            }
        }
        return super.a(state, mirror);
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b, c, d);
    }

    @Override
    @Override
    public Fluid c_(IBlockData state) {
        if (state.c(d).booleanValue()) {
            return FluidTypes.c.a(false);
        }
        return super.c_(state);
    }

    @Override
    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }
}

