/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockSoulFire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class BlockFireAbstract
extends Block {
    private static final int c = 8;
    private final float d;
    protected static final float a = 1.0f;
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public BlockFireAbstract(BlockBase.Info settings, float damage) {
        super(settings);
        this.d = damage;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return BlockFireAbstract.a(ctx.q(), ctx.a());
    }

    public static IBlockData a(IBlockAccess world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.c();
        IBlockData iblockdata = world.a_(blockposition1);
        return BlockSoulFire.h(iblockdata) ? Blocks.bU.n() : ((BlockFire)Blocks.bT).b(world, pos);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Random random) {
        block12: {
            block11: {
                double d2;
                double d1;
                double d0;
                int i2;
                BlockPosition blockposition1;
                IBlockData iblockdata1;
                if (random.nextInt(24) == 0) {
                    world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.ge, SoundCategory.e, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.f(iblockdata1 = world.a_(blockposition1 = pos.c())) || iblockdata1.d(world, blockposition1, EnumDirection.b)) break block11;
                if (this.f(world.a_(pos.f()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)pos.u() + random.nextDouble() * (double)0.1f;
                        d1 = (double)pos.v() + random.nextDouble();
                        d2 = (double)pos.w() + random.nextDouble();
                        world.a(Particles.N, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.f(world.a_(pos.g()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)(pos.u() + 1) - random.nextDouble() * (double)0.1f;
                        d1 = (double)pos.v() + random.nextDouble();
                        d2 = (double)pos.w() + random.nextDouble();
                        world.a(Particles.N, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.f(world.a_(pos.d()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)pos.u() + random.nextDouble();
                        d1 = (double)pos.v() + random.nextDouble();
                        d2 = (double)pos.w() + random.nextDouble() * (double)0.1f;
                        world.a(Particles.N, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.f(world.a_(pos.e()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d0 = (double)pos.u() + random.nextDouble();
                        d1 = (double)pos.v() + random.nextDouble();
                        d2 = (double)(pos.w() + 1) - random.nextDouble() * (double)0.1f;
                        world.a(Particles.N, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.f(world.a_(pos.b()))) break block12;
                for (i2 = 0; i2 < 2; ++i2) {
                    d0 = (double)pos.u() + random.nextDouble();
                    d1 = (double)(pos.v() + 1) - random.nextDouble() * (double)0.1f;
                    d2 = (double)pos.w() + random.nextDouble();
                    world.a(Particles.N, d0, d1, d2, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i3 = 0; i3 < 3; ++i3) {
                double d0 = (double)pos.u() + random.nextDouble();
                double d1 = (double)pos.v() + random.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.w() + random.nextDouble();
                world.a(Particles.N, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean f(IBlockData var1);

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!entity.aP()) {
            entity.g(entity.at() + 1);
            if (entity.at() == 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), (Entity)entity.getBukkitEntity(), 8);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.setSecondsOnFire(event.getDuration(), false);
                }
            }
            entity.a(DamageSource.a, this.d);
        }
        super.a(state, world, pos, entity);
    }

    @Override
    public void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        this.onPlace(state, world, pos, oldState, notify, null);
    }

    @Override
    public void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext itemActionContext) {
        if (!iblockdata1.a(iblockdata.b())) {
            Optional<BlockPortalShape> optional;
            if (BlockFireAbstract.a(world) && (optional = BlockPortalShape.a(world, blockposition, EnumDirection.EnumAxis.a)).isPresent()) {
                optional.get().createPortalBlocks(itemActionContext);
                return;
            }
            if (!iblockdata.a((IWorldReader)world, blockposition)) {
                this.fireExtinguished(world, blockposition);
            }
        }
    }

    private static boolean a(World world) {
        return world.getTypeKey() == WorldDimension.b || world.getTypeKey() == WorldDimension.c;
    }

    @Override
    protected void a(World world, EntityHuman player, BlockPosition pos, IBlockData state) {
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!world.k_()) {
            world.a((EntityHuman)null, 1009, pos, 0);
        }
        super.a(world, pos, state, player);
    }

    public static boolean a(World world, BlockPosition pos, EnumDirection direction) {
        IBlockData iblockdata = world.a_(pos);
        return !iblockdata.g() ? false : BlockFireAbstract.a(world, pos).a((IWorldReader)world, pos) || BlockFireAbstract.b(world, pos, direction);
    }

    private static boolean b(World world, BlockPosition pos, EnumDirection direction) {
        if (!BlockFireAbstract.a(world)) {
            return false;
        }
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.i();
        boolean flag = false;
        for (EnumDirection enumdirection1 : EnumDirection.values()) {
            if (!world.a_(blockposition_mutableblockposition.g(pos).c(enumdirection1)).a(Blocks.bQ)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = direction.n().d() ? direction.h().n() : EnumDirection.EnumDirectionLimit.a.b(world.w);
        return BlockPortalShape.a(world, pos, enumdirection_enumaxis).isPresent();
    }

    protected void fireExtinguished(GeneratorAccess world, BlockPosition position) {
        if (!CraftEventFactory.callBlockFadeEvent(world, position, Blocks.a.n()).isCancelled()) {
            world.a(position, false);
        }
    }
}

