/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;

public class BlockFire
extends BlockFireAbstract {
    public static final int c = 15;
    public static final BlockStateInteger d = BlockProperties.ar;
    public static final BlockStateBoolean e = BlockSprawling.a;
    public static final BlockStateBoolean f = BlockSprawling.b;
    public static final BlockStateBoolean g = BlockSprawling.c;
    public static final BlockStateBoolean h = BlockSprawling.d;
    public static final BlockStateBoolean i = BlockSprawling.e;
    private static final Map<EnumDirection, BlockStateBoolean> j = BlockSprawling.g.entrySet().stream().filter(entry -> entry.getKey() != EnumDirection.a).collect(SystemUtils.b());
    private static final VoxelShape k = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape l = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape m = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape n = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape F = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<IBlockData, VoxelShape> G;
    private static final int H = 60;
    private static final int I = 30;
    private static final int J = 15;
    private static final int K = 5;
    private static final int L = 100;
    private static final int M = 60;
    private static final int N = 20;
    private static final int O = 5;
    public final Object2IntMap<Block> P = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> Q = new Object2IntOpenHashMap();

    public BlockFire(BlockBase.Info settings) {
        super(settings, 1.0f);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b().a(d, 0)).a(e, false)).a(f, false)).a(g, false)).a(h, false)).a(i, false));
        this.G = ImmutableMap.copyOf(this.E.a().stream().filter(iblockdata -> iblockdata.c(d) == 0).collect(Collectors.toMap(Function.identity(), BlockFire::h)));
    }

    private static VoxelShape h(IBlockData state) {
        VoxelShape voxelshape = VoxelShapes.a();
        if (state.c(i).booleanValue()) {
            voxelshape = k;
        }
        if (state.c(e).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, n);
        }
        if (state.c(g).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, F);
        }
        if (state.c(f).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, m);
        }
        if (state.c(h).booleanValue()) {
            voxelshape = VoxelShapes.a(voxelshape, l);
        }
        return voxelshape.b() ? BlockFireAbstract.b : voxelshape;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (!(world instanceof WorldServer)) {
            return this.a(state, world, pos) ? this.a(world, pos, (int)state.c(d)) : Blocks.a.n();
        }
        if (!this.a(state, world, pos)) {
            if (!(world instanceof World)) {
                return Blocks.a.n();
            }
            CraftBlockState blockState = CraftBlockStates.getBlockState(world, pos);
            blockState.setData(Blocks.a.n());
            BlockFadeEvent event = new BlockFadeEvent((org.bukkit.block.Block)blockState.getBlock(), (BlockState)blockState);
            ((World)world).getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return this.a(world, pos, (int)state.c(d));
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.G.get(state.a(d, 0));
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return this.b(ctx.q(), ctx.a());
    }

    protected IBlockData b(IBlockAccess world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.c();
        IBlockData iblockdata = world.a_(blockposition1);
        if (!this.f(iblockdata) && !iblockdata.d(world, blockposition1, EnumDirection.b)) {
            IBlockData iblockdata1 = this.n();
            for (EnumDirection enumdirection : EnumDirection.values()) {
                BlockStateBoolean blockstateboolean = j.get(enumdirection);
                if (blockstateboolean == null) continue;
                iblockdata1 = (IBlockData)iblockdata1.a(blockstateboolean, this.f(world.a_(pos.a(enumdirection))));
            }
            return iblockdata1;
        }
        return this.n();
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.c();
        return world.a_(blockposition1).d(world, blockposition1, EnumDirection.b) || this.d(world, pos);
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        world.a(pos, (Block)this, BlockFire.a(world.w));
        if (world.X().b(GameRules.b)) {
            if (!state.a((IWorldReader)world, pos)) {
                this.fireExtinguished(world, pos);
            }
            IBlockData iblockdata1 = world.a_(pos.c());
            boolean flag = iblockdata1.a(world.q_().p());
            int i2 = state.c(d);
            if (!flag && world.Z() && this.a(world, pos) && random.nextFloat() < 0.2f + (float)i2 * 0.03f) {
                this.fireExtinguished(world, pos);
            } else {
                boolean flag1;
                int j2 = Math.min(15, i2 + random.nextInt(3) / 2);
                if (i2 != j2) {
                    state = (IBlockData)state.a(d, j2);
                    world.a(pos, state, 4);
                }
                if (!flag) {
                    if (!this.d(world, pos)) {
                        BlockPosition blockposition1 = pos.c();
                        if (!world.a_(blockposition1).d(world, blockposition1, EnumDirection.b) || i2 > 3) {
                            this.fireExtinguished(world, pos);
                        }
                        return;
                    }
                    if (i2 == 15 && random.nextInt(4) == 0 && !this.f(world.a_(pos.c()))) {
                        this.fireExtinguished(world, pos);
                        return;
                    }
                }
                int k2 = (flag1 = world.t(pos)) ? -50 : 0;
                this.trySpread(world, pos.g(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.f(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.c(), 250 + k2, random, i2, pos);
                this.trySpread(world, pos.b(), 250 + k2, random, i2, pos);
                this.trySpread(world, pos.d(), 300 + k2, random, i2, pos);
                this.trySpread(world, pos.e(), 300 + k2, random, i2, pos);
                BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
                for (int l2 = -1; l2 <= 1; ++l2) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l2 == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockposition_mutableblockposition.a(pos, l2, j1, i1);
                            int l1 = this.a((IWorldReader)world, (BlockPosition)blockposition_mutableblockposition);
                            if (l1 <= 0) continue;
                            int i22 = (l1 + 40 + world.af().a() * 7) / (i2 + 30);
                            if (flag1) {
                                i22 /= 2;
                            }
                            if (i22 <= 0 || random.nextInt(k1) > i22 || world.Z() && this.a(world, (BlockPosition)blockposition_mutableblockposition)) continue;
                            int j22 = Math.min(15, i2 + random.nextInt(5) / 4);
                            if (world.a_(blockposition_mutableblockposition).b() == Blocks.bT || CraftEventFactory.callBlockIgniteEvent((World)world, (BlockPosition)blockposition_mutableblockposition, pos).isCancelled()) continue;
                            CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition_mutableblockposition, this.a((GeneratorAccess)world, (BlockPosition)blockposition_mutableblockposition, j22), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean a(World world, BlockPosition pos) {
        return world.s(pos) || world.s(pos.f()) || world.s(pos.g()) || world.s(pos.d()) || world.s(pos.e());
    }

    private int n(IBlockData state) {
        return state.b(BlockProperties.C) && state.c(BlockProperties.C) != false ? 0 : this.Q.getInt((Object)state.b());
    }

    private int o(IBlockData state) {
        return state.b(BlockProperties.C) && state.c(BlockProperties.C) != false ? 0 : this.P.getInt((Object)state.b());
    }

    private void trySpread(World world, BlockPosition blockposition, int i2, Random random, int j2, BlockPosition sourceposition) {
        int k2 = this.n(world.a_(blockposition));
        if (random.nextInt(i2) < k2) {
            IBlockData iblockdata = world.a_(blockposition);
            org.bukkit.block.Block theBlock = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            org.bukkit.block.Block sourceBlock = world.getWorld().getBlockAt(sourceposition.u(), sourceposition.v(), sourceposition.w());
            BlockBurnEvent event = new BlockBurnEvent(theBlock, sourceBlock);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (random.nextInt(j2 + 10) < 5 && !world.s(blockposition)) {
                int l2 = Math.min(j2 + random.nextInt(5) / 4, 15);
                world.a(blockposition, this.a((GeneratorAccess)world, blockposition, l2), 3);
            } else if (iblockdata.b() != Blocks.bN) {
                world.a(blockposition, false);
            }
            Block block = iblockdata.b();
            if (block instanceof BlockTNT) {
                BlockTNT blocktnt = (BlockTNT)block;
                org.bukkit.block.Block tntBlock = MCUtil.toBukkitBlock(world, blockposition);
                if (!new TNTPrimeEvent(tntBlock, TNTPrimeEvent.PrimeReason.FIRE, null).callEvent()) {
                    return;
                }
                world.a(blockposition, false);
                BlockTNT.a(world, blockposition);
            }
        }
    }

    private IBlockData a(GeneratorAccess world, BlockPosition pos, int age) {
        IBlockData iblockdata = BlockFire.a(world, pos);
        return iblockdata.a(Blocks.bT) ? (IBlockData)iblockdata.a(d, age) : iblockdata;
    }

    private boolean d(IBlockAccess world, BlockPosition pos) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.f(world.a_(pos.a(enumdirection)))) continue;
            return true;
        }
        return false;
    }

    private int a(IWorldReader world, BlockPosition pos) {
        if (!world.w(pos)) {
            return 0;
        }
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            IBlockData iblockdata = world.a_(pos.a(enumdirection));
            i2 = Math.max(this.o(iblockdata), i2);
        }
        return i2;
    }

    @Override
    protected boolean f(IBlockData state) {
        return this.o(state) > 0;
    }

    @Override
    public void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, ItemActionContext itemActionContext) {
        super.onPlace(iblockdata, world, blockposition, iblockdata1, flag, itemActionContext);
        world.a(blockposition, (Block)this, BlockFire.a(world.w));
    }

    private static int a(Random random) {
        return 30 + random.nextInt(10);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(d, e, f, g, h, i);
    }

    private void a(Block block, int burnChance, int spreadChance) {
        this.P.put((Object)block, burnChance);
        this.Q.put((Object)block, spreadChance);
    }

    public static void c() {
        BlockFire blockfire = (BlockFire)Blocks.bT;
        blockfire.a(Blocks.n, 5, 20);
        blockfire.a(Blocks.o, 5, 20);
        blockfire.a(Blocks.p, 5, 20);
        blockfire.a(Blocks.q, 5, 20);
        blockfire.a(Blocks.r, 5, 20);
        blockfire.a(Blocks.s, 5, 20);
        blockfire.a(Blocks.hY, 5, 20);
        blockfire.a(Blocks.hZ, 5, 20);
        blockfire.a(Blocks.ia, 5, 20);
        blockfire.a(Blocks.ib, 5, 20);
        blockfire.a(Blocks.ic, 5, 20);
        blockfire.a(Blocks.id, 5, 20);
        blockfire.a(Blocks.dZ, 5, 20);
        blockfire.a(Blocks.iv, 5, 20);
        blockfire.a(Blocks.iw, 5, 20);
        blockfire.a(Blocks.ix, 5, 20);
        blockfire.a(Blocks.iz, 5, 20);
        blockfire.a(Blocks.iy, 5, 20);
        blockfire.a(Blocks.cR, 5, 20);
        blockfire.a(Blocks.iA, 5, 20);
        blockfire.a(Blocks.iB, 5, 20);
        blockfire.a(Blocks.iC, 5, 20);
        blockfire.a(Blocks.iE, 5, 20);
        blockfire.a(Blocks.iD, 5, 20);
        blockfire.a(Blocks.bW, 5, 20);
        blockfire.a(Blocks.eC, 5, 20);
        blockfire.a(Blocks.eB, 5, 20);
        blockfire.a(Blocks.eD, 5, 20);
        blockfire.a(Blocks.gy, 5, 20);
        blockfire.a(Blocks.gz, 5, 20);
        blockfire.a(Blocks.M, 5, 5);
        blockfire.a(Blocks.N, 5, 5);
        blockfire.a(Blocks.O, 5, 5);
        blockfire.a(Blocks.P, 5, 5);
        blockfire.a(Blocks.Q, 5, 5);
        blockfire.a(Blocks.R, 5, 5);
        blockfire.a(Blocks.X, 5, 5);
        blockfire.a(Blocks.S, 5, 5);
        blockfire.a(Blocks.T, 5, 5);
        blockfire.a(Blocks.U, 5, 5);
        blockfire.a(Blocks.V, 5, 5);
        blockfire.a(Blocks.W, 5, 5);
        blockfire.a(Blocks.ae, 5, 5);
        blockfire.a(Blocks.af, 5, 5);
        blockfire.a(Blocks.ag, 5, 5);
        blockfire.a(Blocks.ah, 5, 5);
        blockfire.a(Blocks.ai, 5, 5);
        blockfire.a(Blocks.aj, 5, 5);
        blockfire.a(Blocks.Y, 5, 5);
        blockfire.a(Blocks.Z, 5, 5);
        blockfire.a(Blocks.aa, 5, 5);
        blockfire.a(Blocks.ab, 5, 5);
        blockfire.a(Blocks.ac, 5, 5);
        blockfire.a(Blocks.ad, 5, 5);
        blockfire.a(Blocks.ak, 30, 60);
        blockfire.a(Blocks.al, 30, 60);
        blockfire.a(Blocks.am, 30, 60);
        blockfire.a(Blocks.an, 30, 60);
        blockfire.a(Blocks.ao, 30, 60);
        blockfire.a(Blocks.ap, 30, 60);
        blockfire.a(Blocks.bO, 30, 20);
        blockfire.a(Blocks.bN, 15, 100);
        blockfire.a(Blocks.aX, 60, 100);
        blockfire.a(Blocks.aY, 60, 100);
        blockfire.a(Blocks.aZ, 60, 100);
        blockfire.a(Blocks.hi, 60, 100);
        blockfire.a(Blocks.hj, 60, 100);
        blockfire.a(Blocks.hk, 60, 100);
        blockfire.a(Blocks.hl, 60, 100);
        blockfire.a(Blocks.hm, 60, 100);
        blockfire.a(Blocks.hn, 60, 100);
        blockfire.a(Blocks.bv, 60, 100);
        blockfire.a(Blocks.bw, 60, 100);
        blockfire.a(Blocks.bx, 60, 100);
        blockfire.a(Blocks.by, 60, 100);
        blockfire.a(Blocks.bz, 60, 100);
        blockfire.a(Blocks.bA, 60, 100);
        blockfire.a(Blocks.bB, 60, 100);
        blockfire.a(Blocks.bC, 60, 100);
        blockfire.a(Blocks.bD, 60, 100);
        blockfire.a(Blocks.bE, 60, 100);
        blockfire.a(Blocks.bF, 60, 100);
        blockfire.a(Blocks.bH, 60, 100);
        blockfire.a(Blocks.bG, 60, 100);
        blockfire.a(Blocks.be, 30, 60);
        blockfire.a(Blocks.bf, 30, 60);
        blockfire.a(Blocks.bg, 30, 60);
        blockfire.a(Blocks.bh, 30, 60);
        blockfire.a(Blocks.bi, 30, 60);
        blockfire.a(Blocks.bj, 30, 60);
        blockfire.a(Blocks.bk, 30, 60);
        blockfire.a(Blocks.bl, 30, 60);
        blockfire.a(Blocks.bm, 30, 60);
        blockfire.a(Blocks.bn, 30, 60);
        blockfire.a(Blocks.bo, 30, 60);
        blockfire.a(Blocks.bp, 30, 60);
        blockfire.a(Blocks.bq, 30, 60);
        blockfire.a(Blocks.br, 30, 60);
        blockfire.a(Blocks.bs, 30, 60);
        blockfire.a(Blocks.bt, 30, 60);
        blockfire.a(Blocks.dX, 15, 100);
        blockfire.a(Blocks.hg, 5, 5);
        blockfire.a(Blocks.gO, 60, 20);
        blockfire.a(Blocks.np, 15, 20);
        blockfire.a(Blocks.gP, 60, 20);
        blockfire.a(Blocks.gQ, 60, 20);
        blockfire.a(Blocks.gR, 60, 20);
        blockfire.a(Blocks.gS, 60, 20);
        blockfire.a(Blocks.gT, 60, 20);
        blockfire.a(Blocks.gU, 60, 20);
        blockfire.a(Blocks.gV, 60, 20);
        blockfire.a(Blocks.gW, 60, 20);
        blockfire.a(Blocks.gX, 60, 20);
        blockfire.a(Blocks.gY, 60, 20);
        blockfire.a(Blocks.gZ, 60, 20);
        blockfire.a(Blocks.ha, 60, 20);
        blockfire.a(Blocks.hb, 60, 20);
        blockfire.a(Blocks.hc, 60, 20);
        blockfire.a(Blocks.hd, 60, 20);
        blockfire.a(Blocks.he, 60, 20);
        blockfire.a(Blocks.ks, 30, 60);
        blockfire.a(Blocks.lm, 60, 60);
        blockfire.a(Blocks.me, 60, 60);
        blockfire.a(Blocks.mm, 30, 20);
        blockfire.a(Blocks.no, 5, 20);
        blockfire.a(Blocks.mu, 60, 100);
        blockfire.a(Blocks.nr, 5, 20);
        blockfire.a(Blocks.nq, 30, 20);
        blockfire.a(Blocks.aq, 30, 60);
        blockfire.a(Blocks.ar, 30, 60);
        blockfire.a(Blocks.pB, 15, 60);
        blockfire.a(Blocks.pC, 15, 60);
        blockfire.a(Blocks.pD, 60, 100);
        blockfire.a(Blocks.pE, 30, 60);
        blockfire.a(Blocks.pF, 30, 60);
        blockfire.a(Blocks.pI, 60, 100);
        blockfire.a(Blocks.pJ, 60, 100);
        blockfire.a(Blocks.pK, 60, 100);
        blockfire.a(Blocks.pL, 30, 60);
        blockfire.a(Blocks.dY, 15, 100);
    }
}

