/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;

public abstract class BlockButtonAbstract
extends BlockAttachable {
    public static final BlockStateBoolean a = BlockProperties.w;
    private static final int L = 1;
    private static final int M = 2;
    protected static final int b = 2;
    protected static final int c = 3;
    protected static final VoxelShape d = Block.a(6.0, 14.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape e = Block.a(5.0, 14.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape f = Block.a(6.0, 0.0, 5.0, 10.0, 2.0, 11.0);
    protected static final VoxelShape g = Block.a(5.0, 0.0, 6.0, 11.0, 2.0, 10.0);
    protected static final VoxelShape h = Block.a(5.0, 6.0, 14.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape i = Block.a(5.0, 6.0, 0.0, 11.0, 10.0, 2.0);
    protected static final VoxelShape j = Block.a(14.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape k = Block.a(0.0, 6.0, 5.0, 2.0, 10.0, 11.0);
    protected static final VoxelShape l = Block.a(6.0, 15.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape m = Block.a(5.0, 15.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape n = Block.a(6.0, 0.0, 5.0, 10.0, 1.0, 11.0);
    protected static final VoxelShape F = Block.a(5.0, 0.0, 6.0, 11.0, 1.0, 10.0);
    protected static final VoxelShape G = Block.a(5.0, 6.0, 15.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape H = Block.a(5.0, 6.0, 0.0, 11.0, 10.0, 1.0);
    protected static final VoxelShape I = Block.a(15.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape J = Block.a(0.0, 6.0, 5.0, 1.0, 10.0, 11.0);
    private final boolean N;

    protected BlockButtonAbstract(boolean wooden, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(BlockFacingHorizontal.aE, EnumDirection.c)).a(a, false)).a(BlockAttachable.K, BlockPropertyAttachPosition.b));
        this.N = wooden;
    }

    private int c() {
        return this.N ? 30 : 20;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection enumdirection = state.c(BlockFacingHorizontal.aE);
        boolean flag = state.c(a);
        switch (state.c(BlockAttachable.K)) {
            case a: {
                if (enumdirection.n() == EnumDirection.EnumAxis.a) {
                    return flag ? n : f;
                }
                return flag ? F : g;
            }
            case b: {
                switch (enumdirection) {
                    case f: {
                        return flag ? J : k;
                    }
                    case e: {
                        return flag ? I : j;
                    }
                    case d: {
                        return flag ? H : i;
                    }
                }
                return flag ? G : h;
            }
        }
        return enumdirection.n() == EnumDirection.EnumAxis.a ? (flag ? l : d) : (flag ? m : e);
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (state.c(a).booleanValue()) {
            return EnumInteractionResult.b;
        }
        boolean powered = state.c(a);
        org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return EnumInteractionResult.a;
        }
        this.d(state, world, pos);
        this.a(player, (GeneratorAccess)world, pos, true);
        world.a((net.minecraft.world.entity.Entity)player, GameEvent.h, pos);
        return EnumInteractionResult.a(world.y);
    }

    public void d(IBlockData state, World world, BlockPosition pos) {
        world.a(pos, (IBlockData)state.a(a, true), 3);
        this.f(state, world, pos);
        world.a(pos, (Block)this, this.c());
    }

    protected void a(@Nullable EntityHuman player, GeneratorAccess world, BlockPosition pos, boolean powered) {
        world.a(powered ? player : null, pos, this.a(powered), SoundCategory.e, 0.3f, powered ? 0.6f : 0.5f);
    }

    protected abstract SoundEffect a(boolean var1);

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!moved && !state.a(newState.b())) {
            if (state.c(a).booleanValue()) {
                this.f(state, world, pos);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    public int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(a) != false ? 15 : 0;
    }

    @Override
    public int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(a) != false && BlockButtonAbstract.h(state) == direction ? 15 : 0;
    }

    @Override
    public boolean f_(IBlockData state) {
        return true;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        if (state.c(a).booleanValue()) {
            if (this.N) {
                this.e(state, world, pos);
            } else {
                org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, 15, 0);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                if (eventRedstone.getNewCurrent() > 0) {
                    return;
                }
                world.a(pos, (IBlockData)state.a(a, false), 3);
                this.f(state, world, pos);
                this.a((EntityHuman)null, (GeneratorAccess)world, pos, false);
                world.a(GameEvent.j, pos);
            }
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.y && this.N && !state.c(a).booleanValue()) {
            this.e(state, world, pos);
        }
    }

    private void e(IBlockData state, World world, BlockPosition pos) {
        List<EntityArrow> list = world.a(EntityArrow.class, state.j(world, pos).a().a(pos));
        boolean flag = !list.isEmpty();
        boolean flag1 = state.c(a);
        if (flag1 != flag && flag) {
            org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            boolean allowed = false;
            for (EntityArrow object : list) {
                if (object == null) continue;
                EntityInteractEvent event = new EntityInteractEvent((Entity)((net.minecraft.world.entity.Entity)object).getBukkitEntity(), block);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        if (flag != flag1) {
            boolean powered = flag1;
            org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (flag && eventRedstone.getNewCurrent() <= 0 || !flag && eventRedstone.getNewCurrent() > 0) {
                return;
            }
            world.a(pos, (IBlockData)state.a(a, flag), 3);
            this.f(state, world, pos);
            this.a((EntityHuman)null, (GeneratorAccess)world, pos, flag);
            world.a((net.minecraft.world.entity.Entity)list.stream().findFirst().orElse(null), flag ? GameEvent.h : GameEvent.j, pos);
        }
        if (flag) {
            world.a(new BlockPosition(pos), (Block)this, this.c());
        }
    }

    private void f(IBlockData state, World world, BlockPosition pos) {
        world.b(pos, this);
        world.b(pos.a(BlockButtonAbstract.h(state).f()), this);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aE, a, BlockAttachable.K);
    }
}

