/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.PlayerBedFailEnterEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.entity.Player;

public class BlockBed
extends BlockFacingHorizontal
implements ITileEntity {
    public static final BlockStateEnum<BlockPropertyBedPart> a = BlockProperties.aX;
    public static final BlockStateBoolean b = BlockProperties.t;
    protected static final int c = 9;
    protected static final VoxelShape d = Block.a(0.0, 3.0, 0.0, 16.0, 9.0, 16.0);
    private static final int m = 3;
    protected static final VoxelShape e = Block.a(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    protected static final VoxelShape f = Block.a(0.0, 0.0, 13.0, 3.0, 3.0, 16.0);
    protected static final VoxelShape g = Block.a(13.0, 0.0, 0.0, 16.0, 3.0, 3.0);
    protected static final VoxelShape h = Block.a(13.0, 0.0, 13.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape i = VoxelShapes.a(d, e, g);
    protected static final VoxelShape j = VoxelShapes.a(d, f, h);
    protected static final VoxelShape k = VoxelShapes.a(d, e, f);
    protected static final VoxelShape l = VoxelShapes.a(d, g, h);
    private final EnumColor n;

    public BlockBed(EnumColor color, BlockBase.Info settings) {
        super(settings);
        this.n = color;
        this.k((IBlockData)((IBlockData)this.E.b().a(a, BlockPropertyBedPart.b)).a(b, false));
    }

    @Nullable
    public static EnumDirection a(IBlockAccess world, BlockPosition pos) {
        IBlockData iblockdata = world.a_(pos);
        return iblockdata.b() instanceof BlockBed ? iblockdata.c(BlockFacingHorizontal.aE) : null;
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (world.y) {
            return EnumInteractionResult.b;
        }
        if (state.c(a) != BlockPropertyBedPart.a && !(state = world.a_(pos = pos.a(state.c(BlockFacingHorizontal.aE)))).a(this)) {
            return EnumInteractionResult.b;
        }
        if (state.c(b).booleanValue()) {
            if (!this.a(world, pos)) {
                player.a((IChatBaseComponent)new ChatMessage("block.minecraft.bed.occupied"), true);
            }
            return EnumInteractionResult.a;
        }
        IBlockData finaliblockdata = state;
        BlockPosition finalblockposition = pos;
        player.a(pos).ifLeft(entityhuman_enumbedresult -> {
            if (entityhuman_enumbedresult != null) {
                Component message;
                PlayerBedFailEnterEvent event = new PlayerBedFailEnterEvent((Player)player.getBukkitEntity(), PlayerBedFailEnterEvent.FailReason.VALUES[entityhuman_enumbedresult.ordinal()], (org.bukkit.block.Block)CraftBlock.at(world, finalblockposition), !world.q_().h(), PaperAdventure.asAdventure(entityhuman_enumbedresult.a()));
                if (!event.callEvent()) {
                    return;
                }
                if (event.getWillExplode()) {
                    this.explodeBed(finaliblockdata, world, finalblockposition);
                } else if (entityhuman_enumbedresult != null && (message = event.getMessage()) != null) {
                    player.a(PaperAdventure.asVanilla(message), true);
                }
            }
        });
        return EnumInteractionResult.a;
    }

    private EnumInteractionResult explodeBed(IBlockData iblockdata, World world, BlockPosition blockposition) {
        world.a(blockposition, false);
        BlockPosition blockposition1 = blockposition.a(iblockdata.c(BlockFacingHorizontal.aE).f());
        if (world.a_(blockposition1).b() == this) {
            world.a(blockposition1, false);
        }
        world.a(null, DamageSource.a(), null, (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, 5.0f, true, Explosion.Effect.c);
        return EnumInteractionResult.a;
    }

    public static boolean a(World world) {
        return true;
    }

    private boolean a(World world, BlockPosition pos) {
        List<EntityVillager> list = world.a(EntityVillager.class, new AxisAlignedBB(pos), EntityLiving::fb);
        if (list.isEmpty()) {
            return false;
        }
        list.get(0).fc();
        return true;
    }

    @Override
    public void a(World world, IBlockData state, BlockPosition pos, Entity entity, float fallDistance) {
        super.a(world, state, pos, entity, fallDistance * 0.5f);
    }

    @Override
    public void a(IBlockAccess world, Entity entity) {
        if (entity.bK()) {
            super.a(world, entity);
        } else {
            this.a(entity);
        }
    }

    private void a(Entity entity) {
        Vec3D vec3d = entity.da();
        if (vec3d.c < 0.0) {
            double d0 = entity instanceof EntityLiving ? 1.0 : 0.8;
            entity.n(vec3d.b, -vec3d.c * (double)0.66f * d0, vec3d.d);
        }
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return direction == BlockBed.a(state.c(a), state.c(BlockFacingHorizontal.aE)) ? (neighborState.a(this) && neighborState.c(a) != state.c(a) ? (IBlockData)state.a(b, neighborState.c(b)) : Blocks.a.n()) : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    private static EnumDirection a(BlockPropertyBedPart part, EnumDirection direction) {
        return part == BlockPropertyBedPart.b ? direction : direction.f();
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        BlockPosition blockposition1;
        IBlockData iblockdata1;
        BlockPropertyBedPart blockpropertybedpart;
        if (!world.y && player.f() && (blockpropertybedpart = state.c(a)) == BlockPropertyBedPart.b && (iblockdata1 = world.a_(blockposition1 = pos.a(BlockBed.a(blockpropertybedpart, state.c(BlockFacingHorizontal.aE))))).a(this) && iblockdata1.c(a) == BlockPropertyBedPart.a) {
            world.a(blockposition1, Blocks.a.n(), 35);
            world.a(player, 2001, blockposition1, Block.i(iblockdata1));
        }
        super.a(world, pos, state, player);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection enumdirection = ctx.g();
        BlockPosition blockposition = ctx.a();
        BlockPosition blockposition1 = blockposition.a(enumdirection);
        World world = ctx.q();
        return world.a_(blockposition1).a(ctx) && world.p_().a(blockposition1) ? (IBlockData)this.n().a(BlockFacingHorizontal.aE, enumdirection) : null;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection enumdirection = BlockBed.g(state).f();
        switch (enumdirection) {
            case c: {
                return i;
            }
            case d: {
                return j;
            }
            case e: {
                return k;
            }
        }
        return l;
    }

    public static EnumDirection g(IBlockData state) {
        EnumDirection enumdirection = state.c(BlockFacingHorizontal.aE);
        return state.c(a) == BlockPropertyBedPart.a ? enumdirection.f() : enumdirection;
    }

    public static DoubleBlockFinder.BlockType h(IBlockData state) {
        BlockPropertyBedPart blockpropertybedpart = state.c(a);
        return blockpropertybedpart == BlockPropertyBedPart.a ? DoubleBlockFinder.BlockType.b : DoubleBlockFinder.BlockType.c;
    }

    private static boolean b(IBlockAccess world, BlockPosition pos) {
        return world.a_(pos.c()).b() instanceof BlockBed;
    }

    public static Optional<Vec3D> a(EntityTypes<?> type, ICollisionAccess world, BlockPosition pos, float spawnAngle) {
        EnumDirection enumdirection2;
        EnumDirection enumdirection = world.a_(pos).c(BlockFacingHorizontal.aE);
        EnumDirection enumdirection1 = enumdirection.g();
        EnumDirection enumDirection = enumdirection2 = enumdirection1.a(spawnAngle) ? enumdirection1.f() : enumdirection1;
        if (BlockBed.b(world, pos)) {
            return BlockBed.a(type, world, pos, enumdirection, enumdirection2);
        }
        int[][] aint = BlockBed.a(enumdirection, enumdirection2);
        Optional<Vec3D> optional = BlockBed.a(type, world, pos, aint, true);
        return optional.isPresent() ? optional : BlockBed.a(type, world, pos, aint, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> type, ICollisionAccess world, BlockPosition pos, EnumDirection bedDirection, EnumDirection respawnDirection) {
        int[][] aint = BlockBed.b(bedDirection, respawnDirection);
        Optional<Vec3D> optional = BlockBed.a(type, world, pos, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPosition blockposition1 = pos.c();
        Optional<Vec3D> optional1 = BlockBed.a(type, world, blockposition1, aint, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] aint1 = BlockBed.a(bedDirection);
        Optional<Vec3D> optional2 = BlockBed.a(type, world, pos, aint1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vec3D> optional3 = BlockBed.a(type, world, pos, aint, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3D> optional4 = BlockBed.a(type, world, blockposition1, aint, false);
        return optional4.isPresent() ? optional4 : BlockBed.a(type, world, pos, aint1, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> type, ICollisionAccess world, BlockPosition pos, int[][] possibleOffsets, boolean ignoreInvalidPos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int[][] aint1 = possibleOffsets;
        int i2 = possibleOffsets.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int[] aint2 = aint1[j2];
            blockposition_mutableblockposition.d(pos.u() + aint2[0], pos.v(), pos.w() + aint2[1]);
            Vec3D vec3d = DismountUtil.a(type, world, blockposition_mutableblockposition, ignoreInvalidPos);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    @Override
    public EnumPistonReaction d(IBlockData state) {
        return EnumPistonReaction.b;
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.b;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aE, a, b);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityBed(pos, state, this.n);
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack itemStack) {
        super.a(world, pos, state, placer, itemStack);
        if (!world.y) {
            BlockPosition blockposition1 = pos.a(state.c(BlockFacingHorizontal.aE));
            world.a(blockposition1, (IBlockData)state.a(a, BlockPropertyBedPart.a), 3);
            world.a(pos, Blocks.a);
            state.a((GeneratorAccess)world, pos, 3);
        }
    }

    public EnumColor c() {
        return this.n;
    }

    @Override
    public long a(IBlockData state, BlockPosition pos) {
        BlockPosition blockposition1 = pos.a(state.c(BlockFacingHorizontal.aE), state.c(a) == BlockPropertyBedPart.a ? 0 : 1);
        return MathHelper.c(blockposition1.u(), pos.v(), blockposition1.w());
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    private static int[][] a(EnumDirection bedDirection, EnumDirection respawnDirection) {
        return (int[][])ArrayUtils.addAll((Object[])BlockBed.b(bedDirection, respawnDirection), (Object[])BlockBed.a(bedDirection));
    }

    private static int[][] b(EnumDirection bedDirection, EnumDirection respawnDirection) {
        return new int[][]{{respawnDirection.i(), respawnDirection.k()}, {respawnDirection.i() - bedDirection.i(), respawnDirection.k() - bedDirection.k()}, {respawnDirection.i() - bedDirection.i() * 2, respawnDirection.k() - bedDirection.k() * 2}, {-bedDirection.i() * 2, -bedDirection.k() * 2}, {-respawnDirection.i() - bedDirection.i() * 2, -respawnDirection.k() - bedDirection.k() * 2}, {-respawnDirection.i() - bedDirection.i(), -respawnDirection.k() - bedDirection.k()}, {-respawnDirection.i(), -respawnDirection.k()}, {-respawnDirection.i() + bedDirection.i(), -respawnDirection.k() + bedDirection.k()}, {bedDirection.i(), bedDirection.k()}, {respawnDirection.i() + bedDirection.i(), respawnDirection.k() + bedDirection.k()}};
    }

    private static int[][] a(EnumDirection bedDirection) {
        return new int[][]{{0, 0}, {-bedDirection.i(), -bedDirection.k()}};
    }
}

