/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;

public class WorldChunkManagerTheEnd
extends WorldChunkManager {
    public static final Codec<WorldChunkManagerTheEnd> b = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.a(IRegistry.aR).forGetter(theEndBiomeSource -> theEndBiomeSource.g), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.h)).apply((Applicative)instance, instance.stable(WorldChunkManagerTheEnd::new)));
    private static final float d = -0.9f;
    public static final int c = 64;
    private static final long e = 4096L;
    private final NoiseGenerator3Handler f;
    private final IRegistry<BiomeBase> g;
    private final long h;
    private final BiomeBase i;
    private final BiomeBase j;
    private final BiomeBase k;
    private final BiomeBase l;
    private final BiomeBase m;
    private static final ThreadLocal<Map<NoiseGenerator3Handler, NoiseCache>> noiseCache = ThreadLocal.withInitial(WeakHashMap::new);

    public WorldChunkManagerTheEnd(IRegistry<BiomeBase> biomeRegistry, long seed) {
        this(biomeRegistry, seed, biomeRegistry.d(Biomes.ae), biomeRegistry.d(Biomes.af), biomeRegistry.d(Biomes.ag), biomeRegistry.d(Biomes.ah), biomeRegistry.d(Biomes.ai));
    }

    private WorldChunkManagerTheEnd(IRegistry<BiomeBase> biomeRegistry, long seed, BiomeBase centerBiome, BiomeBase highlandsBiome, BiomeBase midlandsBiome, BiomeBase smallIslandsBiome, BiomeBase barrensBiome) {
        super((List<BiomeBase>)ImmutableList.of((Object)centerBiome, (Object)highlandsBiome, (Object)midlandsBiome, (Object)smallIslandsBiome, (Object)barrensBiome));
        this.g = biomeRegistry;
        this.h = seed;
        this.i = centerBiome;
        this.j = highlandsBiome;
        this.k = midlandsBiome;
        this.l = smallIslandsBiome;
        this.m = barrensBiome;
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(seed));
        worldgenRandom.b(17292);
        this.f = new NoiseGenerator3Handler(worldgenRandom);
    }

    @Override
    protected Codec<? extends WorldChunkManager> a() {
        return b;
    }

    @Override
    public WorldChunkManager a(long seed) {
        return new WorldChunkManagerTheEnd(this.g, seed, this.i, this.j, this.k, this.l, this.m);
    }

    @Override
    public BiomeBase getNoiseBiome(int x2, int y2, int z2, Climate.Sampler noise) {
        int i2 = x2 >> 2;
        int j2 = z2 >> 2;
        if ((long)i2 * (long)i2 + (long)j2 * (long)j2 <= 4096L) {
            return this.i;
        }
        float f2 = WorldChunkManagerTheEnd.a(this.f, i2 * 2 + 1, j2 * 2 + 1);
        if (f2 > 40.0f) {
            return this.j;
        }
        if (f2 >= 0.0f) {
            return this.k;
        }
        return f2 < -20.0f ? this.l : this.m;
    }

    public boolean b(long seed) {
        return this.h == seed;
    }

    public static float a(NoiseGenerator3Handler simplexNoise, int i2, int j2) {
        int k2 = i2 / 2;
        int l2 = j2 / 2;
        int m2 = i2 % 2;
        int n2 = j2 % 2;
        float f2 = 100.0f - MathHelper.c((long)i2 * (long)i2 + (long)j2 * (long)j2) * 8.0f;
        f2 = MathHelper.a(f2, -100.0f, 80.0f);
        NoiseCache cache = noiseCache.get().computeIfAbsent(simplexNoise, noiseKey -> new NoiseCache());
        for (int o2 = -12; o2 <= 12; ++o2) {
            for (int p2 = -12; p2 <= 12; ++p2) {
                long q2 = k2 + o2;
                long r2 = l2 + p2;
                long key = ChunkCoordIntPair.a((int)q2, (int)r2);
                int index = (int)HashCommon.mix((long)key) & 0x1FFF;
                float g2 = Float.MIN_VALUE;
                if (cache.keys[index] == key) {
                    g2 = cache.values[index];
                } else {
                    if (q2 * q2 + r2 * r2 > 4096L && simplexNoise.a(q2, r2) < (double)-0.9f) {
                        g2 = (MathHelper.e(q2) * 3439.0f + MathHelper.e(r2) * 147.0f) % 13.0f + 9.0f;
                    }
                    cache.keys[index] = key;
                    cache.values[index] = g2;
                }
                if (g2 == Float.MIN_VALUE) continue;
                float h2 = m2 - o2 * 2;
                float s2 = n2 - p2 * 2;
                float t2 = 100.0f - MathHelper.c(h2 * h2 + s2 * s2) * g2;
                t2 = MathHelper.a(t2, -100.0f, 80.0f);
                f2 = Math.max(f2, t2);
            }
        }
        return f2;
    }

    private static final class NoiseCache {
        public long[] keys = new long[8192];
        public float[] values = new float[8192];

        public NoiseCache() {
            Arrays.fill(this.keys, Long.MIN_VALUE);
        }
    }
}

