/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;

public class WorldChunkManagerHell
extends WorldChunkManager
implements BiomeManager.Provider {
    public static final Codec<WorldChunkManagerHell> b = BiomeBase.d.fieldOf("biome").xmap(WorldChunkManagerHell::new, fixedBiomeSource -> fixedBiomeSource.c).stable().codec();
    private final Supplier<BiomeBase> c;

    public WorldChunkManagerHell(BiomeBase biome) {
        this(() -> biome);
    }

    public WorldChunkManagerHell(Supplier<BiomeBase> biome) {
        super((List<BiomeBase>)ImmutableList.of((Object)biome.get()));
        this.c = biome;
    }

    @Override
    @Override
    protected Codec<? extends WorldChunkManager> a() {
        return b;
    }

    @Override
    @Override
    public WorldChunkManager a(long seed) {
        return this;
    }

    @Override
    @Override
    public BiomeBase getNoiseBiome(int x2, int y2, int z2, Climate.Sampler noise) {
        return this.c.get();
    }

    @Override
    @Override
    public BiomeBase getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        return this.c.get();
    }

    @Override
    @Nullable
    @Override
    public BlockPosition a(int x2, int y2, int z2, int radius, int blockCheckInterval, Predicate<BiomeBase> predicate, Random random, boolean bl, Climate.Sampler noiseSampler) {
        if (predicate.test(this.c.get())) {
            if (bl) {
                return new BlockPosition(x2, y2, z2);
            }
            return new BlockPosition(x2 - radius + random.nextInt(radius * 2 + 1), y2, z2 - radius + random.nextInt(radius * 2 + 1));
        }
        return null;
    }

    @Override
    @Override
    public Set<BiomeBase> a(int x2, int y2, int z2, int radius, Climate.Sampler sampler) {
        return Sets.newHashSet((Object[])new BiomeBase[]{this.c.get()});
    }
}

