/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IStructureAccess;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureManager {
    private final GeneratorAccess a;
    private final GeneratorSettings b;
    private final StructureCheck c;

    public StructureManager(GeneratorAccess world, GeneratorSettings options, StructureCheck locator) {
        this.a = world;
        this.b = options;
        this.c = locator;
    }

    public StructureManager a(RegionLimitedWorldAccess region) {
        if (region.G() != this.a) {
            WorldServer worldserver = region.G();
            throw new IllegalStateException("Using invalid feature manager (source level: " + worldserver + ", region: " + region);
        }
        return new StructureManager(region, this.b, this.c);
    }

    public List<? extends StructureStart<?>> a(SectionPosition sectionPos, StructureGenerator<?> feature) {
        LongSet longset = this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).b(feature);
        ImmutableList.Builder builder = ImmutableList.builder();
        LongIterator longiterator = longset.iterator();
        while (longiterator.hasNext()) {
            long i2 = longiterator.next();
            SectionPosition sectionposition1 = SectionPosition.a(new ChunkCoordIntPair(i2), this.a.ai());
            StructureStart<?> structurestart = this.a(sectionposition1, feature, this.a.a(sectionposition1.a(), sectionposition1.c(), ChunkStatus.d));
            if (structurestart == null || !structurestart.b()) continue;
            builder.add(structurestart);
        }
        return builder.build();
    }

    @Nullable
    public StructureStart<?> a(SectionPosition pos, StructureGenerator<?> feature, IStructureAccess holder) {
        return holder.a(feature);
    }

    public void a(SectionPosition pos, StructureGenerator<?> feature, StructureStart<?> structureStart, IStructureAccess holder) {
        holder.a(feature, structureStart);
    }

    public void a(SectionPosition pos, StructureGenerator<?> feature, long reference, IStructureAccess holder) {
        holder.a(feature, reference);
    }

    public boolean a() {
        return this.b.b();
    }

    public StructureStart<?> a(BlockPosition pos, StructureGenerator<?> structure) {
        StructureStart<?> structurestart;
        Iterator<StructureStart<?>> iterator = this.a(SectionPosition.a(pos), structure).iterator();
        do {
            if (iterator.hasNext()) continue;
            return StructureStart.b;
        } while (!(structurestart = iterator.next()).a().b(pos));
        return structurestart;
    }

    public StructureStart<?> b(BlockPosition pos, StructureGenerator<?> structure) {
        for (StructureStart<?> structurestart : this.a(SectionPosition.a(pos), structure)) {
            for (StructurePiece structurepiece : structurestart.i()) {
                if (!structurepiece.f().b(pos)) continue;
                return structurestart;
            }
        }
        return StructureStart.b;
    }

    public boolean a(BlockPosition pos) {
        SectionPosition sectionposition = SectionPosition.a(pos);
        return this.a.a(sectionposition.a(), sectionposition.c(), ChunkStatus.e).w();
    }

    public StructureCheckResult a(ChunkCoordIntPair chunkPos, StructureGenerator<?> structure, boolean skipExistingChunk) {
        return this.c.a(chunkPos, structure, skipExistingChunk);
    }

    public void a(StructureStart<?> structureStart) {
        structureStart.e();
        this.c.a(structureStart.c(), structureStart.h());
    }

    public World getWorld() {
        return this.a.getMinecraftWorld();
    }
}

