/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class RayTrace {
    private final Vec3D a;
    private final Vec3D b;
    private final BlockCollisionOption c;
    private final FluidCollisionOption d;
    private final VoxelShapeCollision e;

    public RayTrace(Vec3D start, Vec3D end, BlockCollisionOption shapeType, FluidCollisionOption fluidHandling, Entity entity) {
        this.a = start;
        this.b = end;
        this.c = shapeType;
        this.d = fluidHandling;
        this.e = entity == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entity);
    }

    public Vec3D a() {
        return this.b;
    }

    public Vec3D b() {
        return this.a;
    }

    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return this.c.get(state, world, pos, this.e);
    }

    public VoxelShape a(Fluid state, IBlockAccess world, BlockPosition pos) {
        return this.d.a(state) ? state.d(world, pos) : VoxelShapes.a();
    }

    public static enum BlockCollisionOption implements c
    {
        a(BlockBase.BlockData::b),
        b(BlockBase.BlockData::a),
        c(BlockBase.BlockData::c);

        private final c d;

        private BlockCollisionOption(c raytrace_c) {
            this.d = raytrace_c;
        }

        @Override
        public VoxelShape get(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.d.get(state, world, pos, context);
        }
    }

    public static enum FluidCollisionOption {
        a(fluid -> false),
        b(Fluid::b),
        c(fluid -> !fluid.c());

        private final Predicate<Fluid> d;

        private FluidCollisionOption(Predicate<Fluid> predicate) {
            this.d = predicate;
        }

        public boolean a(Fluid state) {
            return this.d.test(state);
        }
    }

    public static interface c {
        public VoxelShape get(IBlockData var1, IBlockAccess var2, BlockPosition var3, VoxelShapeCollision var4);
    }
}

