/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;

public interface IWorldReader
extends IBlockLightAccess,
ICollisionAccess,
BiomeManager.Provider {
    @Nullable
    public IChunkAccess getChunkIfLoadedImmediately(int var1, int var2);

    @Nullable
    public IChunkAccess a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean b(int var1, int var2);

    public int a(HeightMap.Type var1, int var2, int var3);

    public int o_();

    public BiomeManager s_();

    default public BiomeBase v(BlockPosition pos) {
        return this.s_().a(pos);
    }

    default public Stream<IBlockData> c(AxisAlignedBB box) {
        int n2;
        int i2 = MathHelper.b(box.a);
        int j2 = MathHelper.b(box.d);
        int k2 = MathHelper.b(box.b);
        int l2 = MathHelper.b(box.e);
        int m2 = MathHelper.b(box.c);
        return this.a(i2, k2, m2, j2, l2, n2 = MathHelper.b(box.f)) ? this.a(box) : Stream.empty();
    }

    @Override
    default public int a(BlockPosition pos, ColorResolver colorResolver) {
        return colorResolver.getColor(this.v(pos), pos.u(), pos.w());
    }

    @Override
    default public BiomeBase getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        IChunkAccess chunkAccess = this.a(QuartPos.e(biomeX), QuartPos.e(biomeZ), ChunkStatus.f, false);
        return chunkAccess != null ? chunkAccess.getNoiseBiome(biomeX, biomeY, biomeZ) : this.a(biomeX, biomeY, biomeZ);
    }

    public BiomeBase a(int var1, int var2, int var3);

    public boolean k_();

    @Deprecated
    public int m_();

    public DimensionManager q_();

    @Override
    default public int u_() {
        return this.q_().k();
    }

    @Override
    default public int v_() {
        return this.q_().l();
    }

    default public BlockPosition a(HeightMap.Type heightmap, BlockPosition pos) {
        return new BlockPosition(pos.u(), this.a(heightmap, pos.u(), pos.w()), pos.w());
    }

    default public boolean w(BlockPosition pos) {
        return this.a_(pos).g();
    }

    default public boolean x(BlockPosition pos) {
        if (pos.v() >= this.m_()) {
            return this.f(pos);
        }
        BlockPosition blockPos = new BlockPosition(pos.u(), this.m_(), pos.w());
        if (!this.f(blockPos)) {
            return false;
        }
        BlockPosition var4 = blockPos.c();
        while (var4.v() > pos.v()) {
            IBlockData blockState = this.a_(var4);
            if (blockState.b(this, var4) > 0 && !blockState.c().a()) {
                return false;
            }
            var4 = var4.c();
        }
        return true;
    }

    @Deprecated
    default public float y(BlockPosition pos) {
        return this.q_().a(this.B(pos));
    }

    default public int c(BlockPosition pos, EnumDirection direction) {
        return this.a_(pos).c((IBlockAccess)this, pos, direction);
    }

    default public IChunkAccess z(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    default public IChunkAccess a(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.o, true);
    }

    default public IChunkAccess a(int chunkX, int chunkZ, ChunkStatus status) {
        return this.a(chunkX, chunkZ, status, true);
    }

    @Override
    @Nullable
    default public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.c, false);
    }

    default public boolean A(BlockPosition pos) {
        return this.b_(pos).a(TagsFluid.b);
    }

    default public boolean d(AxisAlignedBB box) {
        int i2 = MathHelper.b(box.a);
        int j2 = MathHelper.e(box.d);
        int k2 = MathHelper.b(box.b);
        int l2 = MathHelper.e(box.e);
        int m2 = MathHelper.b(box.c);
        int n2 = MathHelper.e(box.f);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int o2 = i2; o2 < j2; ++o2) {
            for (int p2 = k2; p2 < l2; ++p2) {
                for (int q2 = m2; q2 < n2; ++q2) {
                    IBlockData blockState = this.a_(mutableBlockPos.d(o2, p2, q2));
                    if (blockState.n().c()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int B(BlockPosition pos) {
        return this.c(pos, this.o_());
    }

    default public int c(BlockPosition pos, int ambientDarkness) {
        return pos.u() >= -30000000 && pos.w() >= -30000000 && pos.u() < 30000000 && pos.w() < 30000000 ? this.b(pos, ambientDarkness) : 15;
    }

    @Deprecated
    default public boolean f(int x2, int z2) {
        return this.b(SectionPosition.a(x2), SectionPosition.a(z2));
    }

    @Deprecated
    default public boolean C(BlockPosition pos) {
        return this.f(pos.u(), pos.w());
    }

    @Deprecated
    default public boolean a(BlockPosition min, BlockPosition max) {
        return this.a(min.u(), min.v(), min.w(), max.u(), max.v(), max.w());
    }

    @Deprecated
    default public boolean a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return maxY >= this.u_() && minY < this.ag() ? this.b(minX, minZ, maxX, maxZ) : false;
    }

    @Deprecated
    default public boolean b(int minX, int minZ, int maxX, int maxZ) {
        int i2 = SectionPosition.a(minX);
        int j2 = SectionPosition.a(maxX);
        int k2 = SectionPosition.a(minZ);
        int l2 = SectionPosition.a(maxZ);
        for (int m2 = i2; m2 <= j2; ++m2) {
            for (int n2 = k2; n2 <= l2; ++n2) {
                if (this.b(m2, n2)) continue;
                return false;
            }
        }
        return true;
    }
}

