/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.entity.HumanEntity;

public interface IEntityAccess {
    public List<Entity> getHardCollidingEntities(Entity var1, AxisAlignedBB var2, Predicate<? super Entity> var3);

    public void getEntities(Entity var1, AxisAlignedBB var2, Predicate<? super Entity> var3, List<Entity> var4);

    public void getHardCollidingEntities(Entity var1, AxisAlignedBB var2, Predicate<? super Entity> var3, List<Entity> var4);

    public <T> void getEntitiesByClass(Class<? extends T> var1, Entity var2, AxisAlignedBB var3, List<? super T> var4, Predicate<? super T> var5);

    public List<Entity> a(@Nullable Entity var1, AxisAlignedBB var2, Predicate<? super Entity> var3);

    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> var1, AxisAlignedBB var2, Predicate<? super T> var3);

    default public <T extends Entity> List<T> a(Class<T> entityClass, AxisAlignedBB box, Predicate<? super T> predicate) {
        return this.a((EntityTypeTest<Entity, T>)EntityTypeTest.a(entityClass), box, predicate);
    }

    public List<? extends EntityHuman> z();

    default public List<Entity> a_(@Nullable Entity except, AxisAlignedBB box) {
        return this.a(except, box, IEntitySelector.f);
    }

    default public boolean a(@Nullable Entity entity, VoxelShape shape) {
        if (shape.b()) {
            return true;
        }
        for (Entity entity2 : this.a_(entity, shape.a())) {
            if (entity2.do() || !entity2.r || entity != null && entity2.v(entity) || !shape.intersects(entity2.cw())) continue;
            return false;
        }
        return true;
    }

    default public <T extends Entity> List<T> a(Class<T> entityClass, AxisAlignedBB box) {
        return this.a(entityClass, box, IEntitySelector.f);
    }

    default public List<VoxelShape> b(@Nullable Entity entity, AxisAlignedBB box) {
        if (box.a() < 1.0E-7) {
            return List.of();
        }
        Predicate<Entity> predicate = entity == null ? IEntitySelector.g : IEntitySelector.f.and(entity::h);
        List<Entity> list = this.a(entity, box.g(-1.0E-7), predicate);
        if (list.isEmpty()) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (Entity entity2 : list) {
            builder.add((Object)VoxelShapes.a(entity2.cw()));
        }
        return builder.build();
    }

    default public EntityHuman findNearbyPlayer(Entity entity, double d0, @Nullable Predicate<Entity> predicate) {
        return this.a(entity.dc(), entity.de(), entity.di(), d0, predicate);
    }

    @Nullable
    default public EntityHuman a(double x2, double y2, double z2, double maxDistance, @Nullable Predicate<Entity> targetPredicate) {
        double d2 = -1.0;
        EntityHuman player = null;
        for (EntityHuman entityHuman : this.z()) {
            if (targetPredicate != null && !targetPredicate.test(entityHuman)) continue;
            double e2 = entityHuman.h(x2, y2, z2);
            if (!(maxDistance < 0.0) && !(e2 < maxDistance * maxDistance) || d2 != -1.0 && !(e2 < d2)) continue;
            d2 = e2;
            player = entityHuman;
        }
        return player;
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x2, double y2, double z2, double radius, boolean notSpectator) {
        return this.findNearbyBukkitPlayers(x2, y2, z2, radius, notSpectator ? IEntitySelector.f : IEntitySelector.e);
    }

    default public List<HumanEntity> findNearbyBukkitPlayers(double x2, double y2, double z2, double radius, @Nullable Predicate<Entity> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityHuman entityHuman : this.z()) {
            if (predicate != null && !predicate.test(entityHuman)) continue;
            double distanceSquared = entityHuman.h(x2, y2, z2);
            if (!(radius < 0.0) && !(distanceSquared < radius * radius)) continue;
            builder.add((Object)entityHuman.getBukkitEntity());
        }
        return builder.build();
    }

    @Nullable
    default public EntityHuman a(Entity entity, double maxDistance) {
        return this.a(entity.dc(), entity.de(), entity.di(), maxDistance, false);
    }

    @Nullable
    default public EntityHuman a(double x2, double y2, double z2, double maxDistance, boolean ignoreCreative) {
        Predicate<Entity> predicate = ignoreCreative ? IEntitySelector.e : IEntitySelector.f;
        return this.a(x2, y2, z2, maxDistance, predicate);
    }

    default public boolean isAffectsSpawningPlayerNearby(double d0, double d1, double d2, double d3) {
        Iterator<? extends EntityHuman> iterator = this.z().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return false;
            }
            EntityHuman entityhuman = iterator.next();
            if (!IEntitySelector.affectsSpawning.test(entityhuman)) continue;
            double d4 = entityhuman.h(d0, d1, d2);
            if (!(d3 >= 0.0) || !(d4 >= d3 * d3)) break;
        }
        return true;
    }

    default public boolean a(double x2, double y2, double z2, double range) {
        for (EntityHuman entityHuman : this.z()) {
            if (!IEntitySelector.f.test(entityHuman) || !IEntitySelector.b.test(entityHuman)) continue;
            double d2 = entityHuman.h(x2, y2, z2);
            if (!(range < 0.0) && !(d2 < range * range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public EntityHuman a(PathfinderTargetCondition targetPredicate, EntityLiving entity) {
        return this.a(this.z(), targetPredicate, entity, entity.dc(), entity.de(), entity.di());
    }

    @Nullable
    default public EntityHuman a(PathfinderTargetCondition targetPredicate, EntityLiving entity, double x2, double y2, double z2) {
        return this.a(this.z(), targetPredicate, entity, x2, y2, z2);
    }

    @Nullable
    default public EntityHuman a(PathfinderTargetCondition targetPredicate, double x2, double y2, double z2) {
        return this.a(this.z(), targetPredicate, null, x2, y2, z2);
    }

    @Nullable
    default public <T extends EntityLiving> T a(Class<? extends T> entityClass, PathfinderTargetCondition targetPredicate, @Nullable EntityLiving entity, double x2, double y2, double z2, AxisAlignedBB box) {
        return (T)this.a(this.a(entityClass, box, (? super T livingEntity) -> true), targetPredicate, entity, x2, y2, z2);
    }

    @Nullable
    default public <T extends EntityLiving> T a(List<? extends T> entityList, PathfinderTargetCondition targetPredicate, @Nullable EntityLiving entity, double x2, double y2, double z2) {
        double d2 = -1.0;
        EntityLiving livingEntity = null;
        for (EntityLiving livingEntity2 : entityList) {
            if (!targetPredicate.a(entity, livingEntity2)) continue;
            double e2 = livingEntity2.h(x2, y2, z2);
            if (d2 != -1.0 && !(e2 < d2)) continue;
            d2 = e2;
            livingEntity = livingEntity2;
        }
        return (T)livingEntity;
    }

    default public List<EntityHuman> a(PathfinderTargetCondition targetPredicate, EntityLiving entity, AxisAlignedBB box) {
        ArrayList list = Lists.newArrayList();
        for (EntityHuman entityHuman : this.z()) {
            if (!box.e(entityHuman.dc(), entityHuman.de(), entityHuman.di()) || !targetPredicate.a(entity, entityHuman)) continue;
            list.add(entityHuman);
        }
        return list;
    }

    default public <T extends EntityLiving> List<T> a(Class<T> entityClass, PathfinderTargetCondition targetPredicate, EntityLiving targetingEntity, AxisAlignedBB box) {
        List<EntityLiving> list = this.a(entityClass, box, (? super T livingEntityx) -> true);
        ArrayList list2 = Lists.newArrayList();
        for (EntityLiving livingEntity : list) {
            if (!targetPredicate.a(targetingEntity, livingEntity)) continue;
            list2.add(livingEntity);
        }
        return list2;
    }

    @Nullable
    default public EntityHuman b(UUID uuid) {
        for (int i2 = 0; i2 < this.z().size(); ++i2) {
            EntityHuman player = this.z().get(i2);
            if (!uuid.equals(player.cm())) continue;
            return player;
        }
        return null;
    }
}

