/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicLike;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.GameRule;

public class GameRules {
    public static final int a = 3;
    static final Logger K = LogManager.getLogger();
    private static final Map<GameRuleKey<?>, GameRuleDefinition<?>> L = Maps.newTreeMap(Comparator.comparing(gamerules_gamerulekey -> gamerules_gamerulekey.a));
    public static final GameRuleKey<GameRuleBoolean> b = GameRules.a("doFireTick", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> c = GameRules.a("mobGriefing", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> d = GameRules.a("keepInventory", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> e = GameRules.a("doMobSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> f = GameRules.a("doMobLoot", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> g = GameRules.a("doTileDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> h = GameRules.a("doEntityDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> i = GameRules.a("commandBlockOutput", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> j = GameRules.a("naturalRegeneration", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> k = GameRules.a("doDaylightCycle", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> l = GameRules.a("logAdminCommands", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> m = GameRules.a("showDeathMessages", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> n = GameRules.a("randomTickSpeed", GameRuleCategory.e, GameRuleInt.a(3));
    public static final GameRuleKey<GameRuleBoolean> o = GameRules.a("sendCommandFeedback", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> p = GameRules.a("reducedDebugInfo", GameRuleCategory.g, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        int i2 = gamerules_gameruleboolean.a() ? 22 : 23;
        for (EntityPlayer entityplayer : minecraftserver.ac().t()) {
            entityplayer.b.a(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> q = GameRules.a("spectatorsGenerateChunks", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> r = GameRules.a("spawnRadius", GameRuleCategory.a, GameRuleInt.a(10));
    public static final GameRuleKey<GameRuleBoolean> s = GameRules.a("disableElytraMovementCheck", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> t = GameRules.a("maxEntityCramming", GameRuleCategory.b, GameRuleInt.a(24));
    public static final GameRuleKey<GameRuleBoolean> u = GameRules.a("doWeatherCycle", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> v = GameRules.a("doLimitedCrafting", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> w = GameRules.a("maxCommandChainLength", GameRuleCategory.g, GameRuleInt.a(65536));
    public static final GameRuleKey<GameRuleBoolean> x = GameRules.a("announceAdvancements", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> y = GameRules.a("disableRaids", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> z = GameRules.a("doInsomnia", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> A = GameRules.a("doImmediateRespawn", GameRuleCategory.a, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (EntityPlayer entityplayer : minecraftserver.ac().t()) {
            entityplayer.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.l, gamerules_gameruleboolean.a() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> B = GameRules.a("drowningDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> C = GameRules.a("fallDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> D = GameRules.a("fireDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> E = GameRules.a("freezeDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> F = GameRules.a("doPatrolSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> G = GameRules.a("doTraderSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> H = GameRules.a("forgiveDeadPlayers", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> I = GameRules.a("universalAnger", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> J = GameRules.a("playersSleepingPercentage", GameRuleCategory.a, GameRuleInt.a(100));
    private final Map<GameRuleKey<?>, GameRuleValue<?>> M;

    private static <T extends GameRuleValue<T>> GameRuleKey<T> a(String name, GameRuleCategory category, GameRuleDefinition<T> type) {
        GameRuleKey gamerules_gamerulekey = new GameRuleKey(name, category);
        GameRuleDefinition<T> gamerules_gameruledefinition1 = L.put(gamerules_gamerulekey, type);
        if (gamerules_gameruledefinition1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + name);
        }
        return gamerules_gamerulekey;
    }

    public GameRules(DynamicLike<?> dynamiclike) {
        this();
        this.a(dynamiclike);
    }

    public GameRules() {
        this.M = (Map)L.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleDefinition)entry.getValue()).a()));
    }

    private GameRules(Map<GameRuleKey<?>, GameRuleValue<?>> rules) {
        this.M = rules;
    }

    public <T extends GameRuleValue<T>> T a(GameRuleKey<T> key) {
        return (T)this.M.get(key);
    }

    public NBTTagCompound a() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.M.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> nbttagcompound.a(gamerules_gamerulekey.a, gamerules_gamerulevalue.b()));
        return nbttagcompound;
    }

    private void a(DynamicLike<?> dynamiclike) {
        this.M.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> {
            Optional optional = dynamiclike.get(gamerules_gamerulekey.a).asString().result();
            Objects.requireNonNull(gamerules_gamerulevalue);
            optional.ifPresent(gamerules_gamerulevalue::a);
        });
    }

    public GameRules b() {
        return new GameRules((Map)this.M.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleValue)entry.getValue()).f())));
    }

    public static void a(GameRuleVisitor visitor) {
        L.forEach((gamerules_gamerulekey, gamerules_gameruledefinition) -> GameRules.a(visitor, gamerules_gamerulekey, gamerules_gameruledefinition));
    }

    private static <T extends GameRuleValue<T>> void a(GameRuleVisitor consumer, GameRuleKey<?> key, GameRuleDefinition<?> type) {
        consumer.a(key, type);
        type.a(consumer, key);
    }

    public void a(GameRules rules, @Nullable MinecraftServer server) {
        rules.M.keySet().forEach(gamerules_gamerulekey -> this.a((GameRuleKey)gamerules_gamerulekey, rules, server));
    }

    private <T extends GameRuleValue<T>> void a(GameRuleKey<T> key, GameRules rules, @Nullable MinecraftServer server) {
        T t0 = rules.a(key);
        ((GameRuleValue)this.a(key)).a(t0, server);
    }

    public boolean b(GameRuleKey<GameRuleBoolean> rule) {
        return this.a(rule).a();
    }

    public int c(GameRuleKey<GameRuleInt> rule) {
        return this.a(rule).a();
    }

    public static final class GameRuleKey<T extends GameRuleValue<T>> {
        final String a;
        private final GameRuleCategory b;

        public GameRuleKey(String name, GameRuleCategory category) {
            this.a = name;
            this.b = category;
        }

        public String toString() {
            return this.a;
        }

        public boolean equals(Object object) {
            return this == object ? true : object instanceof GameRuleKey && ((GameRuleKey)object).a.equals(this.a);
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public String a() {
            return this.a;
        }

        public String b() {
            return "gamerule." + this.a;
        }

        public GameRuleCategory c() {
            return this.b;
        }
    }

    public static enum GameRuleCategory {
        a("gamerule.category.player"),
        b("gamerule.category.mobs"),
        c("gamerule.category.spawning"),
        d("gamerule.category.drops"),
        e("gamerule.category.updates"),
        f("gamerule.category.chat"),
        g("gamerule.category.misc");

        private final String h;

        private GameRuleCategory(String s2) {
            this.h = s2;
        }

        public String a() {
            return this.h;
        }
    }

    public static class GameRuleDefinition<T extends GameRuleValue<T>> {
        private final Supplier<ArgumentType<?>> a;
        private final Function<GameRuleDefinition<T>, T> b;
        final BiConsumer<MinecraftServer, T> c;
        private final h<T> d;

        GameRuleDefinition(Supplier<ArgumentType<?>> argumentType, Function<GameRuleDefinition<T>, T> ruleFactory, BiConsumer<MinecraftServer, T> changeCallback, h<T> ruleAcceptor) {
            this.a = argumentType;
            this.b = ruleFactory;
            this.c = changeCallback;
            this.d = ruleAcceptor;
        }

        public RequiredArgumentBuilder<CommandListenerWrapper, ?> a(String name) {
            return CommandDispatcher.a(name, this.a.get());
        }

        public T a() {
            return (T)((GameRuleValue)this.b.apply(this));
        }

        public void a(GameRuleVisitor consumer, GameRuleKey<T> key) {
            this.d.call(consumer, key, this);
        }
    }

    public static abstract class GameRuleValue<T extends GameRuleValue<T>> {
        protected final GameRuleDefinition<T> a;

        public GameRuleValue(GameRuleDefinition<T> type) {
            this.a = type;
        }

        protected abstract void updateFromArgument(CommandContext<CommandListenerWrapper> var1, String var2, GameRuleKey<T> var3);

        public void setFromArgument(CommandContext<CommandListenerWrapper> context, String name, GameRuleKey<T> gameRuleKey) {
            this.updateFromArgument(context, name, gameRuleKey);
            this.a(((CommandListenerWrapper)context.getSource()).j());
        }

        public void a(@Nullable MinecraftServer server) {
            if (server != null) {
                this.a.c.accept(server, (MinecraftServer)this.g());
            }
        }

        public abstract void a(String var1);

        public abstract String b();

        public String toString() {
            return this.b();
        }

        public abstract int c();

        protected abstract T g();

        protected abstract T f();

        public abstract void a(T var1, @Nullable MinecraftServer var2);
    }

    public static interface GameRuleVisitor {
        default public <T extends GameRuleValue<T>> void a(GameRuleKey<T> key, GameRuleDefinition<T> type) {
        }

        default public void b(GameRuleKey<GameRuleBoolean> key, GameRuleDefinition<GameRuleBoolean> type) {
        }

        default public void c(GameRuleKey<GameRuleInt> key, GameRuleDefinition<GameRuleInt> type) {
        }
    }

    public static class GameRuleBoolean
    extends GameRuleValue<GameRuleBoolean> {
        private boolean b;

        static GameRuleDefinition<GameRuleBoolean> a(boolean initialValue, BiConsumer<MinecraftServer, GameRuleBoolean> changeCallback) {
            return new GameRuleDefinition<GameRuleBoolean>(BoolArgumentType::bool, gamerules_gameruledefinition -> new GameRuleBoolean((GameRuleDefinition<GameRuleBoolean>)gamerules_gameruledefinition, initialValue), changeCallback, GameRuleVisitor::b);
        }

        static GameRuleDefinition<GameRuleBoolean> a(boolean initialValue) {
            return GameRuleBoolean.a(initialValue, (minecraftserver, gamerules_gameruleboolean) -> {});
        }

        public GameRuleBoolean(GameRuleDefinition<GameRuleBoolean> type, boolean initialValue) {
            super(type);
            this.b = initialValue;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> context, String name, GameRuleKey<GameRuleBoolean> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandListenerWrapper)context.getSource()).getBukkitWorld(), ((CommandListenerWrapper)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(BoolArgumentType.getBool(context, (String)name)));
            if (!event.callEvent()) {
                return;
            }
            this.b = Boolean.parseBoolean(event.getValue());
        }

        public boolean a() {
            return this.b;
        }

        @Override
        public void a(boolean value, @Nullable MinecraftServer server) {
            this.b = value;
            this.a(server);
        }

        @Override
        public String b() {
            return Boolean.toString(this.b);
        }

        @Override
        public void a(String value) {
            this.b = Boolean.parseBoolean(value);
        }

        @Override
        public int c() {
            return this.b ? 1 : 0;
        }

        protected GameRuleBoolean d() {
            return this;
        }

        protected GameRuleBoolean e() {
            return new GameRuleBoolean(this.a, this.b);
        }

        @Override
        public void a(GameRuleBoolean rule, @Nullable MinecraftServer server) {
            this.b = rule.b;
            this.a(server);
        }
    }

    public static class GameRuleInt
    extends GameRuleValue<GameRuleInt> {
        private int b;

        private static GameRuleDefinition<GameRuleInt> a(int initialValue, BiConsumer<MinecraftServer, GameRuleInt> changeCallback) {
            return new GameRuleDefinition<GameRuleInt>(IntegerArgumentType::integer, gamerules_gameruledefinition -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)gamerules_gameruledefinition, initialValue), changeCallback, GameRuleVisitor::c);
        }

        static GameRuleDefinition<GameRuleInt> a(int initialValue) {
            return GameRuleInt.a(initialValue, (minecraftserver, gamerules_gameruleint) -> {});
        }

        public GameRuleInt(GameRuleDefinition<GameRuleInt> rule, int initialValue) {
            super(rule);
            this.b = initialValue;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandListenerWrapper> context, String name, GameRuleKey<GameRuleInt> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandListenerWrapper)context.getSource()).getBukkitWorld(), ((CommandListenerWrapper)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(IntegerArgumentType.getInteger(context, (String)name)));
            if (!event.callEvent()) {
                return;
            }
            this.b = Integer.parseInt(event.getValue());
        }

        public int a() {
            return this.b;
        }

        @Override
        public void a(int value, @Nullable MinecraftServer server) {
            this.b = value;
            this.a(server);
        }

        @Override
        public String b() {
            return Integer.toString(this.b);
        }

        @Override
        public void a(String value) {
            this.b = GameRuleInt.c(value);
        }

        public boolean b(String input) {
            try {
                this.b = Integer.parseInt(input);
                return true;
            }
            catch (NumberFormatException numberformatexception) {
                return false;
            }
        }

        private static int c(String input) {
            if (!input.isEmpty()) {
                try {
                    return Integer.parseInt(input);
                }
                catch (NumberFormatException numberformatexception) {
                    K.warn("Failed to parse integer {}", (Object)input);
                }
            }
            return 0;
        }

        @Override
        public int c() {
            return this.b;
        }

        protected GameRuleInt d() {
            return this;
        }

        protected GameRuleInt e() {
            return new GameRuleInt(this.a, this.b);
        }

        @Override
        public void a(GameRuleInt rule, @Nullable MinecraftServer server) {
            this.b = rule.b;
            this.a(server);
        }
    }

    private static interface h<T extends GameRuleValue<T>> {
        public void call(GameRuleVisitor var1, GameRuleKey<T> var2, GameRuleDefinition<T> var3);
    }
}

