/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.PaperConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class Explosion {
    private static final ExplosionDamageCalculator a = new ExplosionDamageCalculator();
    private static final int b = 16;
    private final boolean c;
    private final Effect d;
    private final Random e = new Random();
    private final World f;
    private final double g;
    private final double h;
    private final double i;
    @Nullable
    public final net.minecraft.world.entity.Entity j;
    private final float k;
    private final DamageSource l;
    private final ExplosionDamageCalculator m;
    private final List<BlockPosition> n = Lists.newArrayList();
    private final Map<EntityHuman, Vec3D> o = Maps.newHashMap();
    public boolean wasCanceled = false;

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power) {
        this(world, entity, x2, y2, z2, power, false, Effect.c);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, List<BlockPosition> affectedBlocks) {
        this(world, entity, x2, y2, z2, power, false, Effect.c, affectedBlocks);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType, List<BlockPosition> affectedBlocks) {
        this(world, entity, x2, y2, z2, power, createFire, destructionType);
        this.n.addAll(affectedBlocks);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType) {
        this(world, entity, null, null, x2, y2, z2, power, createFire, destructionType);
    }

    public Explosion(World world, @Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, Effect destructionType) {
        this.f = world;
        this.j = entity;
        this.k = (float)Math.max((double)power, 0.0);
        this.g = x2;
        this.h = y2;
        this.i = z2;
        this.c = createFire;
        this.d = destructionType;
        this.l = damageSource == null ? DamageSource.a(this) : damageSource;
        this.m = behavior == null ? this.a(entity) : behavior;
    }

    private ExplosionDamageCalculator a(@Nullable net.minecraft.world.entity.Entity entity) {
        return entity == null ? a : new ExplosionDamageCalculatorEntity(entity);
    }

    public static float a(Vec3D source, net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB axisalignedbb = entity.cw();
        double d0 = 1.0 / ((axisalignedbb.d - axisalignedbb.a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.e - axisalignedbb.b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.f - axisalignedbb.c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i2 = 0;
            int j2 = 0;
            float f2 = 0.0f;
            while (f2 <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f22 = 0.0f;
                    while (f22 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = MathHelper.d((double)f2, axisalignedbb.a, axisalignedbb.d);
                        Vec3D vec3d1 = new Vec3D(d5 + d3, d6 = MathHelper.d((double)f1, axisalignedbb.b, axisalignedbb.e), (d7 = MathHelper.d((double)f22, axisalignedbb.c, axisalignedbb.f)) + d4);
                        if (entity.t.a(new RayTrace(vec3d1, source, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity)).c() == MovingObjectPosition.EnumMovingObjectType.a) {
                            ++i2;
                        }
                        ++j2;
                        f22 = (float)((double)f22 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f2 = (float)((double)f2 + d0);
            }
            return (float)i2 / (float)j2;
        }
        return 0.0f;
    }

    public void a() {
        int j2;
        int i2;
        if (this.k < 0.1f) {
            return;
        }
        this.f.a(this.j, GameEvent.v, new BlockPosition(this.g, this.h, this.i));
        HashSet set = Sets.newHashSet();
        boolean flag = true;
        for (int k2 = 0; k2 < 16; ++k2) {
            for (i2 = 0; i2 < 16; ++i2) {
                block2: for (j2 = 0; j2 < 16; ++j2) {
                    if (k2 != 0 && k2 != 15 && i2 != 0 && i2 != 15 && j2 != 0 && j2 != 15) continue;
                    double d0 = (float)k2 / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)i2 / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)j2 / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.g;
                    double d5 = this.h;
                    double d6 = this.i;
                    float f1 = 0.3f;
                    for (float f2 = this.k * (0.7f + this.f.w.nextFloat() * 0.6f); f2 > 0.0f; f2 -= 0.22500001f) {
                        BlockPosition blockposition = new BlockPosition(d4, d5, d6);
                        IBlockData iblockdata = this.f.a_(blockposition);
                        if (!iblockdata.isDestroyable()) continue;
                        Fluid fluid = iblockdata.n();
                        if (!this.f.j(blockposition)) continue block2;
                        Optional<Float> optional = this.m.a(this, (IBlockAccess)this.f, blockposition, iblockdata, fluid);
                        if (optional.isPresent()) {
                            f2 -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f2 > 0.0f && this.m.a(this, (IBlockAccess)this.f, blockposition, iblockdata, f2)) {
                            TileEntity extension;
                            set.add(blockposition);
                            if (!PaperConfig.allowHeadlessPistons && iblockdata.b() == Blocks.bu && (extension = this.f.c_(blockposition)) instanceof TileEntityPiston && ((TileEntityPiston)extension).f()) {
                                EnumDirection direction = iblockdata.c(BlockDirectional.a);
                                set.add(blockposition.a(direction.f()));
                            }
                        }
                        d4 += d0 * (double)0.3f;
                        d5 += d1 * (double)0.3f;
                        d6 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.n.addAll(set);
        float f2 = this.k * 2.0f;
        i2 = MathHelper.b(this.g - (double)f2 - 1.0);
        j2 = MathHelper.b(this.g + (double)f2 + 1.0);
        int l2 = MathHelper.b(this.h - (double)f2 - 1.0);
        int i1 = MathHelper.b(this.h + (double)f2 + 1.0);
        int j1 = MathHelper.b(this.i - (double)f2 - 1.0);
        int k1 = MathHelper.b(this.i + (double)f2 + 1.0);
        List<net.minecraft.world.entity.Entity> list = this.f.a(this.j, new AxisAlignedBB(i2, l2, j1, j2, i1, k1), (Predicate<? super net.minecraft.world.entity.Entity>)((com.google.common.base.Predicate)entity -> entity.bl() && !entity.B_()));
        Vec3D vec3d = new Vec3D(this.g, this.h, this.i);
        for (int l1 = 0; l1 < list.size(); ++l1) {
            EntityHuman entityhuman;
            double d10;
            double d9;
            double d8;
            double d11;
            double d7;
            net.minecraft.world.entity.Entity entity2 = list.get(l1);
            if (entity2.cC() || !((d7 = Math.sqrt(entity2.f(vec3d)) / (double)f2) <= 1.0) || (d11 = Math.sqrt((d8 = entity2.dc() - this.g) * d8 + (d9 = (entity2 instanceof EntityTNTPrimed ? entity2.de() : entity2.dg()) - this.h) * d9 + (d10 = entity2.di() - this.i) * d10)) == 0.0) continue;
            d8 /= d11;
            d9 /= d11;
            d10 /= d11;
            double d12 = this.getBlockDensity(vec3d, entity2);
            double d13 = (1.0 - d7) * d12;
            CraftEventFactory.entityDamage = this.j;
            entity2.forceExplosionKnockback = false;
            boolean wasDamaged = entity2.a(this.b(), (float)((int)((d13 * d13 + d13) / 2.0 * 7.0 * (double)f2 + 1.0)));
            CraftEventFactory.entityDamage = null;
            if (!wasDamaged && !(entity2 instanceof EntityTNTPrimed) && !(entity2 instanceof EntityFallingBlock) && !entity2.forceExplosionKnockback) continue;
            double d14 = d13;
            if (entity2 instanceof EntityLiving) {
                d14 = entity2 instanceof EntityHuman && this.f.paperConfig.disableExplosionKnockback ? 0.0 : EnchantmentProtection.a((EntityLiving)entity2, d13);
            }
            entity2.g(entity2.da().b(d8 * d14, d9 * d14, d10 * d14));
            if (!(entity2 instanceof EntityHuman) || (entityhuman = (EntityHuman)entity2).B_() || entityhuman.f() && entityhuman.fr().b || this.f.paperConfig.disableExplosionKnockback) continue;
            this.o.put(entityhuman, new Vec3D(d8 * d13, d9 * d13, d10 * d13));
        }
    }

    public void a(boolean particles) {
        boolean flag1;
        if (this.f.y) {
            this.f.a(this.g, this.h, this.i, SoundEffects.gM, SoundCategory.e, 4.0f, (1.0f + (this.f.w.nextFloat() - this.f.w.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag1 = this.d != Effect.a;
        if (particles) {
            if (this.k >= 2.0f && flag1) {
                this.f.a(Particles.w, this.g, this.h, this.i, 1.0, 0.0, 0.0);
            } else {
                this.f.a(Particles.x, this.g, this.h, this.i, 1.0, 0.0, 0.0);
            }
        }
        if (flag1) {
            float yield;
            List bukkitBlocks;
            boolean cancelled;
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.n, this.f.w);
            Iterator<BlockPosition> iterator = this.n.iterator();
            CraftWorld bworld = this.f.getWorld();
            CraftEntity explode = this.j == null ? null : this.j.getBukkitEntity();
            Location location = new Location((org.bukkit.World)bworld, this.g, this.h, this.i);
            ArrayList blockList = Lists.newArrayList();
            for (int i1 = this.n.size() - 1; i1 >= 0; --i1) {
                BlockPosition cpos = this.n.get(i1);
                org.bukkit.block.Block bblock = bworld.getBlockAt(cpos.u(), cpos.v(), cpos.w());
                if (bblock.getType().isAir()) continue;
                blockList.add(bblock);
            }
            if (explode != null) {
                event = new EntityExplodeEvent((Entity)explode, location, (List)blockList, this.d == Effect.c ? 1.0f / this.k : 1.0f);
                this.f.getCraftServer().getPluginManager().callEvent((Event)event);
                cancelled = event.isCancelled();
                bukkitBlocks = event.blockList();
                yield = event.getYield();
            } else {
                event = new BlockExplodeEvent(location.getBlock(), (List)blockList, this.d == Effect.c ? 1.0f / this.k : 1.0f);
                this.f.getCraftServer().getPluginManager().callEvent((Event)event);
                cancelled = event.isCancelled();
                bukkitBlocks = event.blockList();
                yield = event.getYield();
            }
            this.n.clear();
            for (org.bukkit.block.Block bblock : bukkitBlocks) {
                BlockPosition coords = new BlockPosition(bblock.getX(), bblock.getY(), bblock.getZ());
                this.n.add(coords);
            }
            if (cancelled) {
                this.wasCanceled = true;
                return;
            }
            for (BlockPosition blockposition : this.n) {
                IBlockData iblockdata = this.f.a_(blockposition);
                Block block = iblockdata.b();
                if (iblockdata.g() || !iblockdata.isDestroyable()) continue;
                BlockPosition blockposition1 = blockposition.h();
                this.f.ab().a("explosion_blocks");
                if (block.a(this) && this.f instanceof WorldServer) {
                    TileEntity tileentity = iblockdata.m() ? this.f.c_(blockposition) : null;
                    LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.f).a(this.f.w).a(LootContextParameters.f, Vec3D.a(blockposition)).a(LootContextParameters.i, ItemStack.b).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, this.j);
                    if (this.d == Effect.c || yield < 1.0f) {
                        loottableinfo_builder.a(LootContextParameters.j, Float.valueOf(1.0f / yield));
                    }
                    iblockdata.a(loottableinfo_builder).forEach(itemstack -> Explosion.a((ObjectArrayList<Pair<ItemStack, BlockPosition>>)objectarraylist, itemstack, blockposition1));
                }
                this.f.a(blockposition, Blocks.a.n(), 3);
                block.a(this.f, blockposition, this);
                this.f.ab().c();
            }
            for (Pair pair : objectarraylist) {
                Block.a(this.f, (BlockPosition)pair.getSecond(), (ItemStack)pair.getFirst());
            }
        }
        if (this.c) {
            for (BlockPosition blockposition2 : this.n) {
                if (this.e.nextInt(3) != 0 || !this.f.a_(blockposition2).g() || !this.f.a_(blockposition2.c()).i(this.f, blockposition2.c()) || CraftEventFactory.callBlockIgniteEvent(this.f, blockposition2.u(), blockposition2.v(), blockposition2.w(), this).isCancelled()) continue;
                this.f.b(blockposition2, BlockFireAbstract.a(this.f, blockposition2));
            }
        }
    }

    private static void a(ObjectArrayList<Pair<ItemStack, BlockPosition>> stacks, ItemStack stack, BlockPosition pos) {
        if (stack.b()) {
            return;
        }
        int i2 = stacks.size();
        for (int j2 = 0; j2 < i2; ++j2) {
            Pair pair = (Pair)stacks.get(j2);
            ItemStack itemstack1 = (ItemStack)pair.getFirst();
            if (!EntityItem.a(itemstack1, stack)) continue;
            ItemStack itemstack2 = EntityItem.a(itemstack1, stack, 16);
            stacks.set(j2, (Object)Pair.of((Object)itemstack2, (Object)((BlockPosition)pair.getSecond())));
            if (!stack.b()) continue;
            return;
        }
        stacks.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public DamageSource b() {
        return this.l;
    }

    public Map<EntityHuman, Vec3D> c() {
        return this.o;
    }

    @Nullable
    public EntityLiving d() {
        net.minecraft.world.entity.Entity entity;
        if (this.j == null) {
            return null;
        }
        if (this.j instanceof EntityTNTPrimed) {
            return ((EntityTNTPrimed)this.j).h();
        }
        if (this.j instanceof EntityLiving) {
            return (EntityLiving)this.j;
        }
        if (this.j instanceof IProjectile && (entity = ((IProjectile)this.j).x()) instanceof EntityLiving) {
            return (EntityLiving)entity;
        }
        return null;
    }

    public void e() {
        this.n.clear();
    }

    public List<BlockPosition> f() {
        return this.n;
    }

    private float getBlockDensity(Vec3D vec3d, net.minecraft.world.entity.Entity entity) {
        if (!this.f.paperConfig.optimizeExplosions) {
            return Explosion.a(vec3d, entity);
        }
        CacheKey key = new CacheKey(this, entity.cw());
        Float blockDensity = this.f.explosionDensityCache.get(key);
        if (blockDensity == null) {
            blockDensity = Float.valueOf(Explosion.a(vec3d, entity));
            this.f.explosionDensityCache.put(key, blockDensity);
        }
        return blockDensity.floatValue();
    }

    public static enum Effect {
        a,
        b,
        c;

    }

    static class CacheKey {
        private final World world;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final double minX;
        private final double minY;
        private final double minZ;
        private final double maxX;
        private final double maxY;
        private final double maxZ;

        public CacheKey(Explosion explosion, AxisAlignedBB aabb) {
            this.world = explosion.f;
            this.posX = explosion.g;
            this.posY = explosion.h;
            this.posZ = explosion.i;
            this.minX = aabb.a;
            this.minY = aabb.b;
            this.minZ = aabb.c;
            this.maxX = aabb.d;
            this.maxY = aabb.e;
            this.maxZ = aabb.f;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o2;
            if (Double.compare(cacheKey.posX, this.posX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posY, this.posY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posZ, this.posZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minX, this.minX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minY, this.minY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minZ, this.minZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxX, this.maxX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxY, this.maxY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxZ, this.maxZ) != 0) {
                return false;
            }
            return this.world.equals(cacheKey.world);
        }

        public int hashCode() {
            int result = this.world.hashCode();
            long temp = Double.doubleToLongBits(this.posX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

