/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.map.MapView;

public class ItemWorldMap
extends ItemWorldMapBase {
    public static final int a = 128;
    public static final int b = 128;
    private static final int c = -12173266;
    private static final String d = "map";

    public ItemWorldMap(Item.Info settings) {
        super(settings);
    }

    public static ItemStack a(World world, int x2, int z2, byte scale, boolean showIcons, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack(Items.pp);
        ItemWorldMap.a(itemstack, world, x2, z2, scale, showIcons, unlimitedTracking, world.aa());
        return itemstack;
    }

    @Nullable
    public static WorldMap a(@Nullable Integer id, World world) {
        return id == null ? null : world.a(ItemWorldMap.a(id));
    }

    @Nullable
    public static WorldMap a(ItemStack map, World world) {
        Integer integer = ItemWorldMap.d(map);
        return ItemWorldMap.a(integer, world);
    }

    @Nullable
    public static Integer d(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.s();
        return nbttagcompound != null && nbttagcompound.b(d, 99) ? Integer.valueOf(nbttagcompound.h(d)) : null;
    }

    public static int a(World world, int x2, int z2, int scale, boolean showIcons, boolean unlimitedTracking, ResourceKey<World> dimension) {
        WorldMap worldmap = WorldMap.a(x2, z2, (byte)scale, showIcons, unlimitedTracking, dimension);
        int l2 = world.v();
        world.a(ItemWorldMap.a(l2), worldmap);
        MapInitializeEvent event = new MapInitializeEvent((MapView)worldmap.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return l2;
    }

    private static void a(ItemStack stack, int id) {
        stack.t().a(d, id);
    }

    private static void a(ItemStack stack, World world, int x2, int z2, int scale, boolean showIcons, boolean unlimitedTracking, ResourceKey<World> dimension) {
        int l2 = ItemWorldMap.a(world, x2, z2, scale, showIcons, unlimitedTracking, dimension);
        ItemWorldMap.a(stack, l2);
    }

    public static String a(int mapId) {
        return "map_" + mapId;
    }

    public void a(World world, Entity entity, WorldMap state) {
        if (world.aa() == state.e && entity instanceof EntityHuman) {
            int i2 = 1 << state.f;
            int j2 = state.c;
            int k2 = state.d;
            int l2 = MathHelper.b(entity.dc() - (double)j2) / i2 + 64;
            int i1 = MathHelper.b(entity.di() - (double)k2) / i2 + 64;
            int j1 = 128 / i2;
            if (world.q_().c()) {
                j1 /= 2;
            }
            WorldMap.WorldMapHumanTracker worldmap_worldmaphumantracker = state.a((EntityHuman)entity);
            ++worldmap_worldmaphumantracker.b;
            boolean flag = false;
            for (int k1 = l2 - j1 + 1; k1 < l2 + j1; ++k1) {
                if ((k1 & 0xF) != (worldmap_worldmaphumantracker.b & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int l1 = i1 - j1 - 1; l1 < i1 + j1; ++l1) {
                    double d2;
                    if (k1 < 0 || l1 < -1 || k1 >= 128 || l1 >= 128) continue;
                    int i22 = k1 - l2;
                    int j22 = l1 - i1;
                    boolean flag1 = i22 * i22 + j22 * j22 > (j1 - 2) * (j1 - 2);
                    int k22 = (j2 / i2 + k1 - 64) * i2;
                    int l22 = (k2 / i2 + l1 - 64) * i2;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    Chunk chunk = world.getChunkIfLoaded(new BlockPosition(k22, 0, l22));
                    if (chunk == null || chunk.A()) continue;
                    ChunkCoordIntPair chunkcoordintpair = chunk.f();
                    int i3 = k22 & 0xF;
                    int j3 = l22 & 0xF;
                    int k3 = 0;
                    double d1 = 0.0;
                    if (world.q_().c()) {
                        int l3 = k22 + l22 * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.j.n().d(world, BlockPosition.b), 10);
                        } else {
                            multiset.add((Object)Blocks.b.n().d(world, BlockPosition.b), 100);
                        }
                        d1 = 100.0;
                    } else {
                        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
                        BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
                        for (int i4 = 0; i4 < i2; ++i4) {
                            for (int j4 = 0; j4 < i2; ++j4) {
                                IBlockData iblockdata;
                                int k4 = chunk.a(HeightMap.Type.b, i4 + i3, j4 + j3) + 1;
                                if (k4 > world.u_() + 1) {
                                    do {
                                        blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                    } while ((iblockdata = chunk.a_(blockposition_mutableblockposition)).d(world, blockposition_mutableblockposition) == MaterialMapColor.a && k4 > world.u_());
                                    if (k4 > world.u_() && !iblockdata.n().c()) {
                                        IBlockData iblockdata1;
                                        int l4 = k4 - 1;
                                        blockposition_mutableblockposition1.g(blockposition_mutableblockposition);
                                        do {
                                            blockposition_mutableblockposition1.q(l4--);
                                            iblockdata1 = chunk.a_(blockposition_mutableblockposition1);
                                            ++k3;
                                        } while (l4 > world.u_() && !iblockdata1.n().c());
                                        iblockdata = this.a(world, iblockdata, blockposition_mutableblockposition);
                                    }
                                } else {
                                    iblockdata = Blocks.z.n();
                                }
                                state.a(world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                                d1 += (double)k4 / (double)(i2 * i2);
                                multiset.add((Object)iblockdata.d(world, blockposition_mutableblockposition));
                            }
                        }
                    }
                    MaterialMapColor materialmapcolor = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialMapColor.a);
                    MaterialMapColor.a materialmapcolor_a = materialmapcolor == MaterialMapColor.m ? ((d2 = (double)(k3 /= i2 * i2) * 0.1 + (double)(k1 + l1 & 1) * 0.2) < 0.5 ? MaterialMapColor.a.c : (d2 > 0.9 ? MaterialMapColor.a.a : MaterialMapColor.a.b)) : ((d2 = (d1 - d0) * 4.0 / (double)(i2 + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4) > 0.6 ? MaterialMapColor.a.c : (d2 < -0.6 ? MaterialMapColor.a.a : MaterialMapColor.a.b));
                    d0 = d1;
                    if (l1 < 0 || i22 * i22 + j22 * j22 >= j1 * j1 || flag1 && (k1 + l1 & 1) == 0) continue;
                    flag |= state.a(k1, l1, materialmapcolor.b(materialmapcolor_a));
                }
            }
        }
    }

    private IBlockData a(World world, IBlockData state, BlockPosition pos) {
        Fluid fluid = state.n();
        return !fluid.c() && !state.d(world, pos, EnumDirection.b) ? fluid.g() : state;
    }

    private static boolean a(boolean[] biomes, int scale, int x2, int z2) {
        return biomes[x2 * scale + z2 * scale * 128 * scale];
    }

    public static void a(WorldServer world, ItemStack map) {
        WorldMap worldmap = ItemWorldMap.a(map, (World)world);
        if (worldmap != null && world.aa() == worldmap.e) {
            int i1;
            int l2;
            int i2 = 1 << worldmap.f;
            int j2 = worldmap.c;
            int k2 = worldmap.d;
            boolean[] aboolean = new boolean[128 * i2 * 128 * i2];
            for (l2 = 0; l2 < 128 * i2; ++l2) {
                for (i1 = 0; i1 < 128 * i2; ++i1) {
                    BiomeBase.Geography biomebase_geography = world.a((j2 / i2 - 64) * i2 + i1, 0, (k2 / i2 - 64) * i2 + l2).r();
                    aboolean[l2 * 128 * i2 + i1] = biomebase_geography == BiomeBase.Geography.l || biomebase_geography == BiomeBase.Geography.n || biomebase_geography == BiomeBase.Geography.o;
                }
            }
            for (l2 = 0; l2 < 128; ++l2) {
                for (i1 = 0; i1 < 128; ++i1) {
                    if (l2 <= 0 || i1 <= 0 || l2 >= 127 || i1 >= 127) continue;
                    int j1 = 8;
                    if (!ItemWorldMap.a(aboolean, i2, l2 - 1, i1 - 1)) {
                        --j1;
                    }
                    if (!ItemWorldMap.a(aboolean, i2, l2 - 1, i1 + 1)) {
                        --j1;
                    }
                    if (!ItemWorldMap.a(aboolean, i2, l2 - 1, i1)) {
                        --j1;
                    }
                    if (!ItemWorldMap.a(aboolean, i2, l2 + 1, i1 - 1)) {
                        --j1;
                    }
                    if (!ItemWorldMap.a(aboolean, i2, l2 + 1, i1 + 1)) {
                        --j1;
                    }
                    if (!ItemWorldMap.a(aboolean, i2, l2 + 1, i1)) {
                        --j1;
                    }
                    if (!ItemWorldMap.a(aboolean, i2, l2, i1 - 1)) {
                        --j1;
                    }
                    if (!ItemWorldMap.a(aboolean, i2, l2, i1 + 1)) {
                        --j1;
                    }
                    MaterialMapColor.a materialmapcolor_a = MaterialMapColor.a.d;
                    MaterialMapColor materialmapcolor = MaterialMapColor.a;
                    if (ItemWorldMap.a(aboolean, i2, l2, i1)) {
                        materialmapcolor = MaterialMapColor.p;
                        if (j1 > 7 && i1 % 2 == 0) {
                            switch ((l2 + (int)(MathHelper.a((float)i1 + 0.0f) * 7.0f)) / 8 % 5) {
                                case 0: 
                                case 4: {
                                    materialmapcolor_a = MaterialMapColor.a.a;
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    materialmapcolor_a = MaterialMapColor.a.b;
                                    break;
                                }
                                case 2: {
                                    materialmapcolor_a = MaterialMapColor.a.c;
                                }
                            }
                        } else if (j1 > 7) {
                            materialmapcolor = MaterialMapColor.a;
                        } else if (j1 > 5) {
                            materialmapcolor_a = MaterialMapColor.a.b;
                        } else if (j1 > 3) {
                            materialmapcolor_a = MaterialMapColor.a.a;
                        } else if (j1 > 1) {
                            materialmapcolor_a = MaterialMapColor.a.a;
                        }
                    } else if (j1 > 0) {
                        materialmapcolor = MaterialMapColor.A;
                        materialmapcolor_a = j1 > 3 ? MaterialMapColor.a.b : MaterialMapColor.a.d;
                    }
                    if (materialmapcolor == MaterialMapColor.a) continue;
                    worldmap.b(l2, i1, materialmapcolor.b(materialmapcolor_a));
                }
            }
        }
    }

    @Override
    public void a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        WorldMap worldmap;
        if (!world.y && (worldmap = ItemWorldMap.a(stack, world)) != null) {
            if (entity instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity;
                worldmap.a(entityhuman, stack);
            }
            if (!worldmap.h && (selected || entity instanceof EntityHuman && ((EntityHuman)entity).es() == stack)) {
                this.a(world, entity, worldmap);
            }
        }
    }

    @Override
    @Nullable
    public Packet<?> a(ItemStack stack, World world, EntityHuman player) {
        Integer integer = ItemWorldMap.d(stack);
        WorldMap worldmap = ItemWorldMap.a(integer, world);
        return worldmap != null ? worldmap.a((int)integer, player) : null;
    }

    @Override
    public void b(ItemStack stack, World world, EntityHuman player) {
        NBTTagCompound nbttagcompound = stack.s();
        if (nbttagcompound != null && nbttagcompound.b("map_scale_direction", 99)) {
            ItemWorldMap.a(stack, world, nbttagcompound.h("map_scale_direction"));
            nbttagcompound.r("map_scale_direction");
        } else if (nbttagcompound != null && nbttagcompound.b("map_to_lock", 1) && nbttagcompound.q("map_to_lock")) {
            ItemWorldMap.a(world, stack);
            nbttagcompound.r("map_to_lock");
        }
    }

    private static void a(ItemStack map, World world, int amount) {
        WorldMap worldmap = ItemWorldMap.a(map, world);
        if (worldmap != null) {
            int j2 = world.v();
            world.a(ItemWorldMap.a(j2), worldmap.a(amount));
            ItemWorldMap.a(map, j2);
        }
    }

    public static void a(World world, ItemStack stack) {
        WorldMap worldmap = ItemWorldMap.a(stack, world);
        if (worldmap != null) {
            int i2 = world.v();
            String s2 = ItemWorldMap.a(i2);
            WorldMap worldmap1 = worldmap.a();
            world.a(s2, worldmap1);
            ItemWorldMap.a(stack, i2);
        }
    }

    @Override
    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
        WorldMap worldmap;
        Integer integer = ItemWorldMap.d(stack);
        WorldMap worldMap = worldmap = world == null ? null : ItemWorldMap.a(integer, world);
        if (worldmap != null && worldmap.h) {
            tooltip.add(new ChatMessage("filled_map.locked", integer).a(EnumChatFormat.h));
        }
        if (context.a()) {
            if (worldmap != null) {
                tooltip.add(new ChatMessage("filled_map.id", integer).a(EnumChatFormat.h));
                tooltip.add(new ChatMessage("filled_map.scale", 1 << worldmap.f).a(EnumChatFormat.h));
                tooltip.add(new ChatMessage("filled_map.level", worldmap.f, 4).a(EnumChatFormat.h));
            } else {
                tooltip.add(new ChatMessage("filled_map.unknown").a(EnumChatFormat.h));
            }
        }
    }

    public static int k(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.b("display");
        if (nbttagcompound != null && nbttagcompound.b("MapColor", 99)) {
            int i2 = nbttagcompound.h("MapColor");
            return 0xFF000000 | i2 & 0xFFFFFF;
        }
        return -12173266;
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        IBlockData iblockdata = context.q().a_(context.a());
        if (iblockdata.a(TagsBlock.B)) {
            WorldMap worldmap;
            if (!context.q().y && (worldmap = ItemWorldMap.a(context.n(), context.q())) != null && !worldmap.a(context.q(), context.a())) {
                return EnumInteractionResult.e;
            }
            return EnumInteractionResult.a(context.q().y);
        }
        return super.a(context);
    }
}

