/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Item
implements IMaterial {
    private static final Logger a = LogManager.getLogger();
    public static final Map<Block, Item> k = Maps.newHashMap();
    protected static final UUID l = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID m = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    public static final int n = 64;
    public static final int o = 32;
    public static final int p = 13;
    @Nullable
    protected final CreativeModeTab q;
    public final EnumItemRarity b;
    private final int c;
    private final int d;
    private final boolean e;
    @Nullable
    private final Item f;
    @Nullable
    private String g;
    @Nullable
    private final FoodInfo h;

    public static int a(Item item) {
        return item == null ? 0 : IRegistry.aa.a(item);
    }

    public static Item b(int id) {
        return IRegistry.aa.a(id);
    }

    @Deprecated
    public static Item a(Block block) {
        return k.getOrDefault(block, Items.a);
    }

    public Item(Info settings) {
        String string;
        this.q = settings.d;
        this.b = settings.e;
        this.f = settings.c;
        this.d = settings.b;
        this.c = settings.a;
        this.h = settings.f;
        this.e = settings.g;
        if (SharedConstants.aJ && !(string = this.getClass().getSimpleName()).endsWith("Item")) {
            a.error("Item classes should end with Item and {} doesn't.", (Object)string);
        }
    }

    public void a(World world, EntityLiving user, ItemStack stack, int remainingUseTicks) {
    }

    public void a(EntityItem entity) {
    }

    public void b(NBTTagCompound nbt) {
    }

    public boolean a(IBlockData state, World world, BlockPosition pos, EntityHuman miner) {
        return true;
    }

    @Override
    @Override
    public Item k() {
        return this;
    }

    public EnumInteractionResult a(ItemActionContext context) {
        return EnumInteractionResult.d;
    }

    public float a(ItemStack stack, IBlockData state) {
        return 1.0f;
    }

    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        if (this.u()) {
            ItemStack itemStack = user.b(hand);
            if (user.s(this.v().d())) {
                user.c(hand);
                return InteractionResultWrapper.b(itemStack);
            }
            return InteractionResultWrapper.d(itemStack);
        }
        return InteractionResultWrapper.c(user.b(hand));
    }

    public ItemStack a(ItemStack stack, World world, EntityLiving user) {
        if (this.u()) {
            return user.a(world, stack);
        }
        return stack;
    }

    public final int l() {
        return this.c;
    }

    public final int m() {
        return this.d;
    }

    public boolean n() {
        return this.d > 0;
    }

    public boolean e(ItemStack stack) {
        return stack.g();
    }

    public int f(ItemStack stack) {
        return Math.round(13.0f - (float)stack.h() * 13.0f / (float)this.d);
    }

    public int g(ItemStack stack) {
        float f2 = Math.max(0.0f, ((float)this.d - (float)stack.h()) / (float)this.d);
        return MathHelper.h(f2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player) {
        return false;
    }

    public boolean a(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return false;
    }

    public boolean a(ItemStack stack, EntityLiving target, EntityLiving attacker) {
        return false;
    }

    public boolean a(ItemStack stack, World world, IBlockData state, BlockPosition pos, EntityLiving miner) {
        return false;
    }

    public boolean a_(IBlockData state) {
        return false;
    }

    public EnumInteractionResult a(ItemStack stack, EntityHuman user, EntityLiving entity, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public IChatBaseComponent o() {
        return new ChatMessage(this.a());
    }

    @Override
    public String toString() {
        return IRegistry.aa.b(this).a();
    }

    protected String p() {
        if (this.g == null) {
            this.g = SystemUtils.a("item", IRegistry.aa.b(this));
        }
        return this.g;
    }

    public String a() {
        return this.p();
    }

    public String j(ItemStack stack) {
        return this.a();
    }

    public boolean q() {
        return true;
    }

    @Nullable
    public final Item r() {
        return this.f;
    }

    public boolean s() {
        return this.f != null;
    }

    public void a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
    }

    public void b(ItemStack stack, World world, EntityHuman player) {
    }

    public boolean N_() {
        return false;
    }

    public EnumAnimation c(ItemStack stack) {
        return stack.c().u() ? EnumAnimation.b : EnumAnimation.a;
    }

    public int b(ItemStack stack) {
        if (stack.c().u()) {
            return this.v().e() ? 16 : 32;
        }
        return 0;
    }

    public void a(ItemStack stack, World world, EntityLiving user, int remainingUseTicks) {
    }

    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
    }

    public Optional<TooltipComponent> h(ItemStack stack) {
        return Optional.empty();
    }

    public IChatBaseComponent m(ItemStack stack) {
        return new ChatMessage(this.j(stack));
    }

    public boolean i(ItemStack stack) {
        return stack.B();
    }

    public EnumItemRarity n(ItemStack stack) {
        if (!stack.B()) {
            return this.b;
        }
        switch (this.b) {
            case a: 
            case b: {
                return EnumItemRarity.c;
            }
            case c: {
                return EnumItemRarity.d;
            }
        }
        return this.b;
    }

    public boolean c_(ItemStack stack) {
        return this.l() == 1 && this.n();
    }

    protected static MovingObjectPositionBlock a(World world, EntityHuman player, RayTrace.FluidCollisionOption fluidHandling) {
        float f2 = player.dn();
        float g2 = player.dm();
        Vec3D vec3 = player.bg();
        float h2 = MathHelper.b(-g2 * ((float)Math.PI / 180) - (float)Math.PI);
        float i2 = MathHelper.a(-g2 * ((float)Math.PI / 180) - (float)Math.PI);
        float j2 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float k2 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        float l2 = i2 * j2;
        float m2 = k2;
        float n2 = h2 * j2;
        double d2 = 5.0;
        Vec3D vec32 = vec3.b((double)l2 * 5.0, (double)m2 * 5.0, (double)n2 * 5.0);
        return world.a(new RayTrace(vec3, vec32, RayTrace.BlockCollisionOption.b, fluidHandling, player));
    }

    public int c() {
        return 0;
    }

    public void a(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.a(group)) {
            stacks.add(new ItemStack(this));
        }
    }

    protected boolean a(CreativeModeTab group) {
        CreativeModeTab creativeModeTab = this.t();
        return creativeModeTab != null && (group == CreativeModeTab.g || group == creativeModeTab);
    }

    @Nullable
    public final CreativeModeTab t() {
        return this.q;
    }

    public boolean a(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot slot) {
        return ImmutableMultimap.of();
    }

    public boolean l(ItemStack stack) {
        return false;
    }

    public ItemStack O_() {
        return new ItemStack(this);
    }

    public boolean u() {
        return this.h != null;
    }

    @Nullable
    public FoodInfo v() {
        return this.h;
    }

    public SoundEffect P_() {
        return SoundEffects.gK;
    }

    public SoundEffect h() {
        return SoundEffects.gL;
    }

    public boolean w() {
        return this.e;
    }

    public boolean a(DamageSource source) {
        return !this.e || !source.s();
    }

    @Nullable
    public SoundEffect g() {
        return null;
    }

    public boolean Q_() {
        return true;
    }

    public static class Info {
        int a = 64;
        int b;
        @Nullable
        Item c;
        @Nullable
        CreativeModeTab d;
        EnumItemRarity e = EnumItemRarity.a;
        @Nullable
        FoodInfo f;
        boolean g;

        public Info a(FoodInfo foodComponent) {
            this.f = foodComponent;
            return this;
        }

        public Info a(int maxCount) {
            if (this.b > 0) {
                throw new RuntimeException("Unable to have damage AND stack.");
            }
            this.a = maxCount;
            return this;
        }

        public Info b(int maxDamage) {
            return this.b == 0 ? this.c(maxDamage) : this;
        }

        public Info c(int maxDamage) {
            this.b = maxDamage;
            this.a = 1;
            return this;
        }

        public Info a(Item recipeRemainder) {
            this.c = recipeRemainder;
            return this;
        }

        public Info a(CreativeModeTab group) {
            this.d = group;
            return this;
        }

        public Info a(EnumItemRarity rarity) {
            this.e = rarity;
            return this;
        }

        public Info a() {
            this.g = true;
            return this;
        }
    }
}

