/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class EntityMinecartAbstract
extends Entity {
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.c);
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> ap = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> aq = DataWatcher.a(EntityMinecartAbstract.class, DataWatcherRegistry.i);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> ar = ImmutableMap.of((Object)((Object)EntityPose.a), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.f), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.d), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float b = 0.95f;
    private boolean as;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> at = SystemUtils.a(Maps.newEnumMap(BlockPropertyTrackPosition.class), enummap -> {
        BaseBlockPosition baseblockposition = EnumDirection.e.p();
        BaseBlockPosition baseblockposition1 = EnumDirection.f.p();
        BaseBlockPosition baseblockposition2 = EnumDirection.c.p();
        BaseBlockPosition baseblockposition3 = EnumDirection.d.p();
        BaseBlockPosition baseblockposition4 = baseblockposition.n();
        BaseBlockPosition baseblockposition5 = baseblockposition1.n();
        BaseBlockPosition baseblockposition6 = baseblockposition2.n();
        BaseBlockPosition baseblockposition7 = baseblockposition3.n();
        enummap.put(BlockPropertyTrackPosition.a, Pair.of((Object)baseblockposition2, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.b, Pair.of((Object)baseblockposition, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.c, Pair.of((Object)baseblockposition4, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.d, Pair.of((Object)baseblockposition, (Object)baseblockposition5));
        enummap.put(BlockPropertyTrackPosition.e, Pair.of((Object)baseblockposition2, (Object)baseblockposition7));
        enummap.put(BlockPropertyTrackPosition.f, Pair.of((Object)baseblockposition6, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.g, Pair.of((Object)baseblockposition3, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.h, Pair.of((Object)baseblockposition3, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.i, Pair.of((Object)baseblockposition2, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.j, Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    });
    private int au;
    private double av;
    private double aw;
    private double ax;
    private double ay;
    private double az;
    private double aA;
    private double aB;
    private double aC;
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95f;
    private double flyingY = 0.95f;
    private double flyingZ = 0.95f;
    public double maxSpeed = 0.4;

    protected EntityMinecartAbstract(EntityTypes<?> type, World world) {
        super(type, world);
        this.r = true;
    }

    protected EntityMinecartAbstract(EntityTypes<?> type, World world, double x2, double y2, double z2) {
        this(type, world);
        this.e(x2, y2, z2);
        this.u = x2;
        this.v = y2;
        this.w = z2;
    }

    public static EntityMinecartAbstract a(World world, double x2, double y2, double z2, EnumMinecartType type) {
        return type == EnumMinecartType.b ? new EntityMinecartChest(world, x2, y2, z2) : (type == EnumMinecartType.c ? new EntityMinecartFurnace(world, x2, y2, z2) : (type == EnumMinecartType.d ? new EntityMinecartTNT(world, x2, y2, z2) : (type == EnumMinecartType.e ? new EntityMinecartMobSpawner(world, x2, y2, z2) : (type == EnumMinecartType.f ? new EntityMinecartHopper(world, x2, y2, z2) : (type == EnumMinecartType.g ? new EntityMinecartCommandBlock(world, x2, y2, z2) : new EntityMinecartRideable(world, x2, y2, z2))))));
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a_() {
        this.Z.a(c, 0);
        this.Z.a(d, 1);
        this.Z.a(e, Float.valueOf(0.0f));
        this.Z.a(f, Block.i(Blocks.a.n()));
        this.Z.a(ap, 6);
        this.Z.a(aq, false);
    }

    @Override
    public boolean h(Entity other) {
        return EntityBoat.a(this, other);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return EntityLiving.i(super.a(portalAxis, portalRect));
    }

    @Override
    public double bq() {
        return 0.0;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cu();
        if (enumdirection.n() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.cW();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> immutablelist = passenger.eY();
        for (EntityPose entitypose : immutablelist) {
            EntitySize entitysize = passenger.a(entitypose);
            float f2 = Math.min(entitysize.a, 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)ar.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i2 = (Integer)unmodifiableiterator1.next();
                int[][] aint1 = aint;
                int j2 = aint.length;
                for (int k2 = 0; k2 < j2; ++k2) {
                    Vec3D vec3d;
                    AxisAlignedBB axisalignedbb;
                    int[] aint2 = aint1[k2];
                    blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v() + i2, blockposition.w() + aint2[1]);
                    double d0 = this.t.a(DismountUtil.a((IBlockAccess)this.t, (BlockPosition)blockposition_mutableblockposition), () -> DismountUtil.a((IBlockAccess)this.t, blockposition_mutableblockposition.c()));
                    if (!DismountUtil.a(d0) || !DismountUtil.a(this.t, passenger, (axisalignedbb = new AxisAlignedBB(-f2, 0.0, -f2, f2, entitysize.b, f2)).c(vec3d = Vec3D.a(blockposition_mutableblockposition, d0)))) continue;
                    passenger.b(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.cw().e;
        blockposition_mutableblockposition.c((double)blockposition.u(), d1, (double)blockposition.w());
        for (EntityPose entitypose1 : immutablelist) {
            double d2 = passenger.a((EntityPose)entitypose1).b;
            int l2 = MathHelper.e(d1 - (double)blockposition_mutableblockposition.v() + d2);
            double d3 = DismountUtil.a(blockposition_mutableblockposition, l2, blockposition1 -> this.t.a_((BlockPosition)blockposition1).k(this.t, (BlockPosition)blockposition1));
            if (!(d1 + d2 <= d3)) continue;
            passenger.b(entitypose1);
            break;
        }
        return super.b(passenger);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!this.t.y && !this.do()) {
            boolean flag;
            if (this.b(source)) {
                return false;
            }
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            CraftEntity passenger = source.l() == null ? null : source.l().getBukkitEntity();
            VehicleDamageEvent event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)passenger, (double)amount);
            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            amount = (float)event.getDamage();
            this.d(-this.o());
            this.c(10);
            this.bf();
            this.a(this.l() + amount * 10.0f);
            this.a(GameEvent.r, source.l());
            boolean bl = flag = source.l() instanceof EntityHuman && ((EntityHuman)source.l()).fr().d;
            if (flag || this.l() > 40.0f) {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)passenger);
                this.t.getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.a(40.0f);
                    return true;
                }
                this.bs();
                if (flag && !this.Y()) {
                    this.ah();
                } else {
                    this.a(source);
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected float aC() {
        IBlockData iblockdata = this.t.a_(this.cW());
        return iblockdata.a(TagsBlock.H) ? 1.0f : super.aC();
    }

    public void a(DamageSource damageSource) {
        this.a(Entity.RemovalReason.a);
        if (this.t.X().b(GameRules.h)) {
            ItemStack itemstack = new ItemStack(Items.lM);
            if (this.Y()) {
                itemstack.a(this.Z());
            }
            this.b(itemstack);
        }
    }

    @Override
    public void bA() {
        this.d(-this.o());
        this.c(10);
        this.a(this.l() + this.l() * 10.0f);
    }

    @Override
    public boolean bh() {
        return !this.do();
    }

    private static Pair<BaseBlockPosition, BaseBlockPosition> a(BlockPropertyTrackPosition shape) {
        return at.get(shape);
    }

    @Override
    public EnumDirection cu() {
        return this.as ? this.ct().f().g() : this.ct().g();
    }

    @Override
    public void k() {
        double prevX = this.dc();
        double prevY = this.de();
        double prevZ = this.di();
        float prevYaw = this.dm();
        float prevPitch = this.dn();
        if (this.n() > 0) {
            this.c(this.n() - 1);
        }
        if (this.l() > 0.0f) {
            this.a(this.l() - 1.0f);
        }
        this.ao();
        if (this.t.y) {
            if (this.au > 0) {
                double d0 = this.dc() + (this.av - this.dc()) / (double)this.au;
                double d1 = this.de() + (this.aw - this.de()) / (double)this.au;
                double d2 = this.di() + (this.ax - this.di()) / (double)this.au;
                double d3 = MathHelper.f(this.ay - (double)this.dm());
                this.o(this.dm() + (float)d3 / (float)this.au);
                this.p(this.dn() + (float)(this.az - (double)this.dn()) / (float)this.au);
                --this.au;
                this.e(d0, d1, d2);
                this.a(this.dm(), this.dn());
            } else {
                this.am();
                this.a(this.dm(), this.dn());
            }
        } else {
            double d6;
            BlockPosition blockposition;
            IBlockData iblockdata;
            int k2;
            int j2;
            int i2;
            if (!this.aM()) {
                double d0 = this.aQ() ? -0.005 : -0.04;
                this.g(this.da().b(0.0, d0, 0.0));
            }
            if (this.t.a_(new BlockPosition(i2 = MathHelper.b(this.dc()), (j2 = MathHelper.b(this.de())) - 1, k2 = MathHelper.b(this.di()))).a(TagsBlock.H)) {
                --j2;
            }
            if (BlockMinecartTrackAbstract.g(iblockdata = this.t.a_(blockposition = new BlockPosition(i2, j2, k2)))) {
                this.c(blockposition, iblockdata);
                if (iblockdata.a(Blocks.fQ)) {
                    this.a(i2, j2, k2, iblockdata.c(BlockPoweredRail.e));
                }
            } else {
                this.i();
            }
            this.aI();
            this.p(0.0f);
            double d4 = this.u - this.dc();
            double d5 = this.w - this.di();
            if (d4 * d4 + d5 * d5 > 0.001) {
                this.o((float)(MathHelper.d(d5, d4) * 180.0 / Math.PI));
                if (this.as) {
                    this.o(this.dm() + 180.0f);
                }
            }
            if ((d6 = (double)MathHelper.g(this.dm() - this.x)) < -170.0 || d6 >= 170.0) {
                this.o(this.dm() + 180.0f);
                this.as = !this.as;
            }
            this.a(this.dm(), this.dn());
            CraftWorld bworld = this.t.getWorld();
            Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
            Location to = new Location((org.bukkit.World)bworld, this.dc(), this.de(), this.di(), this.dm(), this.dn());
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            this.t.getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
            if (!from.equals((Object)to)) {
                this.t.getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
            }
            if (this.q() == EnumMinecartType.a && this.da().i() > 0.01) {
                List<Entity> list = this.t.a((Entity)this, this.cw().c(0.2f, 0.0, 0.2f), IEntitySelector.a(this));
                if (!list.isEmpty()) {
                    for (int l2 = 0; l2 < list.size(); ++l2) {
                        VehicleEntityCollisionEvent collisionEvent;
                        Entity entity = list.get(l2);
                        if (!(entity instanceof EntityHuman || entity instanceof EntityIronGolem || entity instanceof EntityMinecartAbstract || this.bG() || entity.bF())) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.t.getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                            entity.k(this);
                            continue;
                        }
                        if (!this.v(entity)) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.t.getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                        }
                        entity.g(this);
                    }
                }
            } else {
                for (Entity entity1 : this.t.a_(this, this.cw().c(0.2f, 0.0, 0.2f))) {
                    if (this.u(entity1) || !entity1.bi() || !(entity1 instanceof EntityMinecartAbstract)) continue;
                    VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity1.getBukkitEntity());
                    this.t.getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                    if (collisionEvent.isCancelled()) continue;
                    entity1.g(this);
                }
            }
            this.aW();
            if (this.bc()) {
                this.as();
                this.L *= 0.5f;
            }
            this.Y = false;
        }
    }

    protected double h() {
        return this.aQ() ? this.maxSpeed / 2.0 : this.maxSpeed;
    }

    public void a(int x2, int y2, int z2, boolean powered) {
    }

    protected void i() {
        double d0 = this.h();
        Vec3D vec3d = this.da();
        this.n(MathHelper.a(vec3d.b, -d0, d0), vec3d.c, MathHelper.a(vec3d.d, -d0, d0));
        if (this.z) {
            this.g(new Vec3D(this.da().b * this.derailedX, this.da().c * this.derailedY, this.da().d * this.derailedZ));
        }
        this.a(EnumMoveType.a, this.da());
        if (!this.z) {
            this.g(new Vec3D(this.da().b * this.flyingX, this.da().c * this.flyingY, this.da().d * this.flyingZ));
        }
    }

    protected void c(BlockPosition pos, IBlockData state) {
        double d18;
        Vec3D vec3d4;
        double d17;
        double d16;
        double d15;
        this.m();
        double d0 = this.dc();
        double d1 = this.de();
        double d2 = this.di();
        Vec3D vec3d = this.p(d0, d1, d2);
        d1 = pos.v();
        boolean flag = false;
        boolean flag1 = false;
        if (state.a(Blocks.aT)) {
            flag = state.c(BlockPoweredRail.e);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.aQ()) {
            d3 *= 0.2;
        }
        Vec3D vec3d1 = this.da();
        BlockPropertyTrackPosition blockpropertytrackposition = state.c(((BlockMinecartTrackAbstract)state.b()).d());
        switch (blockpropertytrackposition) {
            case c: {
                this.g(vec3d1.b(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case d: {
                this.g(vec3d1.b(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case e: {
                this.g(vec3d1.b(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case f: {
                this.g(vec3d1.b(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec3d1 = this.da();
        Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
        BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
        BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
        double d4 = baseblockposition1.u() - baseblockposition.u();
        double d5 = baseblockposition1.w() - baseblockposition.w();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec3d1.b * d4 + vec3d1.d * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec3d1.h());
        vec3d1 = new Vec3D(d8 * d4 / d6, vec3d1.c, d8 * d5 / d6);
        this.g(vec3d1);
        Entity entity = this.cG();
        if (entity instanceof EntityHuman) {
            Vec3D vec3d2 = entity.da();
            double d9 = vec3d2.i();
            double d10 = this.da().i();
            if (d9 > 1.0E-4 && d10 < 0.01) {
                this.g(this.da().b(vec3d2.b * 0.1, 0.0, vec3d2.d * 0.1));
                flag1 = false;
            }
        }
        if (flag1) {
            double d11 = this.da().h();
            if (d11 < 0.03) {
                this.g(Vec3D.a);
            } else {
                this.g(this.da().d(0.5, 0.0, 0.5));
            }
        }
        double d11 = (double)pos.u() + 0.5 + (double)baseblockposition.u() * 0.5;
        double d12 = (double)pos.w() + 0.5 + (double)baseblockposition.w() * 0.5;
        double d13 = (double)pos.u() + 0.5 + (double)baseblockposition1.u() * 0.5;
        double d14 = (double)pos.w() + 0.5 + (double)baseblockposition1.w() * 0.5;
        d4 = d13 - d11;
        d5 = d14 - d12;
        if (d4 == 0.0) {
            d15 = d2 - (double)pos.w();
        } else if (d5 == 0.0) {
            d15 = d0 - (double)pos.u();
        } else {
            d16 = d0 - d11;
            d17 = d2 - d12;
            d15 = (d16 * d4 + d17 * d5) * 2.0;
        }
        d0 = d11 + d4 * d15;
        d2 = d12 + d5 * d15;
        this.e(d0, d1, d2);
        d16 = this.bG() ? 0.75 : 1.0;
        d17 = this.h();
        vec3d1 = this.da();
        this.a(EnumMoveType.a, new Vec3D(MathHelper.a(d16 * vec3d1.b, -d17, d17), 0.0, MathHelper.a(d16 * vec3d1.d, -d17, d17)));
        if (baseblockposition.v() != 0 && MathHelper.b(this.dc()) - pos.u() == baseblockposition.u() && MathHelper.b(this.di()) - pos.w() == baseblockposition.w()) {
            this.e(this.dc(), this.de() + (double)baseblockposition.v(), this.di());
        } else if (baseblockposition1.v() != 0 && MathHelper.b(this.dc()) - pos.u() == baseblockposition1.u() && MathHelper.b(this.di()) - pos.w() == baseblockposition1.w()) {
            this.e(this.dc(), this.de() + (double)baseblockposition1.v(), this.di());
        }
        this.j();
        Vec3D vec3d3 = this.p(this.dc(), this.de(), this.di());
        if (vec3d3 != null && vec3d != null) {
            double d19 = (vec3d.c - vec3d3.c) * 0.05;
            vec3d4 = this.da();
            d18 = vec3d4.h();
            if (d18 > 0.0) {
                this.g(vec3d4.d((d18 + d19) / d18, 1.0, (d18 + d19) / d18));
            }
            this.e(this.dc(), vec3d3.c, this.di());
        }
        int i2 = MathHelper.b(this.dc());
        int j2 = MathHelper.b(this.di());
        if (i2 != pos.u() || j2 != pos.w()) {
            vec3d4 = this.da();
            d18 = vec3d4.h();
            this.n(d18 * (double)(i2 - pos.u()), vec3d4.c, d18 * (double)(j2 - pos.w()));
        }
        if (flag) {
            vec3d4 = this.da();
            d18 = vec3d4.h();
            if (d18 > 0.01) {
                double d20 = 0.06;
                this.g(vec3d4.b(vec3d4.b / d18 * 0.06, 0.0, vec3d4.d / d18 * 0.06));
            } else {
                Vec3D vec3d5 = this.da();
                double d21 = vec3d5.b;
                double d22 = vec3d5.d;
                if (blockpropertytrackposition == BlockPropertyTrackPosition.b) {
                    if (this.a(pos.f())) {
                        d21 = 0.02;
                    } else if (this.a(pos.g())) {
                        d21 = -0.02;
                    }
                } else {
                    if (blockpropertytrackposition != BlockPropertyTrackPosition.a) {
                        return;
                    }
                    if (this.a(pos.d())) {
                        d22 = 0.02;
                    } else if (this.a(pos.e())) {
                        d22 = -0.02;
                    }
                }
                this.n(d21, vec3d5.c, d22);
            }
        }
    }

    private boolean a(BlockPosition pos) {
        return this.t.a_(pos).g(this.t, pos);
    }

    protected void j() {
        double d0 = this.bG() || !this.slowWhenEmpty ? 0.997 : 0.96;
        Vec3D vec3d = this.da();
        vec3d = vec3d.d(d0, 0.0, d0);
        if (this.aQ()) {
            vec3d = vec3d.a((double)0.95f);
        }
        this.g(vec3d);
    }

    @Nullable
    public Vec3D a(double x2, double y2, double z2, double offset) {
        IBlockData iblockdata;
        int k2;
        int j2;
        int i2 = MathHelper.b(x2);
        if (this.t.a_(new BlockPosition(i2, (j2 = MathHelper.b(y2)) - 1, k2 = MathHelper.b(z2))).a(TagsBlock.H)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.g(iblockdata = this.t.a_(new BlockPosition(i2, j2, k2)))) {
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).d());
            y2 = j2;
            if (blockpropertytrackposition.b()) {
                y2 = j2 + 1;
            }
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d4 = baseblockposition1.u() - baseblockposition.u();
            double d5 = baseblockposition1.w() - baseblockposition.w();
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (baseblockposition.v() != 0 && MathHelper.b(x2 += (d4 /= d6) * offset) - i2 == baseblockposition.u() && MathHelper.b(z2 += (d5 /= d6) * offset) - k2 == baseblockposition.w()) {
                y2 += (double)baseblockposition.v();
            } else if (baseblockposition1.v() != 0 && MathHelper.b(x2) - i2 == baseblockposition1.u() && MathHelper.b(z2) - k2 == baseblockposition1.w()) {
                y2 += (double)baseblockposition1.v();
            }
            return this.p(x2, y2, z2);
        }
        return null;
    }

    @Nullable
    public Vec3D p(double x2, double y2, double z2) {
        IBlockData iblockdata;
        int k2;
        int j2;
        int i2 = MathHelper.b(x2);
        if (this.t.a_(new BlockPosition(i2, (j2 = MathHelper.b(y2)) - 1, k2 = MathHelper.b(z2))).a(TagsBlock.H)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.g(iblockdata = this.t.a_(new BlockPosition(i2, j2, k2)))) {
            double d12;
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.c(((BlockMinecartTrackAbstract)iblockdata.b()).d());
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.a(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d3 = (double)i2 + 0.5 + (double)baseblockposition.u() * 0.5;
            double d4 = (double)j2 + 0.0625 + (double)baseblockposition.v() * 0.5;
            double d5 = (double)k2 + 0.5 + (double)baseblockposition.w() * 0.5;
            double d6 = (double)i2 + 0.5 + (double)baseblockposition1.u() * 0.5;
            double d7 = (double)j2 + 0.0625 + (double)baseblockposition1.v() * 0.5;
            double d8 = (double)k2 + 0.5 + (double)baseblockposition1.w() * 0.5;
            double d9 = d6 - d3;
            double d10 = (d7 - d4) * 2.0;
            double d11 = d8 - d5;
            if (d9 == 0.0) {
                d12 = z2 - (double)k2;
            } else if (d11 == 0.0) {
                d12 = x2 - (double)i2;
            } else {
                double d13 = x2 - d3;
                double d14 = z2 - d5;
                d12 = (d13 * d9 + d14 * d11) * 2.0;
            }
            x2 = d3 + d9 * d12;
            y2 = d4 + d10 * d12;
            z2 = d5 + d11 * d12;
            if (d10 < 0.0) {
                y2 += 1.0;
            } else if (d10 > 0.0) {
                y2 += 0.5;
            }
            return new Vec3D(x2, y2, z2);
        }
        return null;
    }

    @Override
    public AxisAlignedBB cx() {
        AxisAlignedBB axisalignedbb = this.cw();
        return this.w() ? axisalignedbb.g((double)Math.abs(this.t()) / 16.0) : axisalignedbb;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.q("CustomDisplayTile")) {
            this.b(GameProfileSerializer.c(nbt.p("DisplayState")));
            this.m(nbt.h("DisplayOffset"));
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.w()) {
            nbt.a("CustomDisplayTile", true);
            nbt.a("DisplayState", GameProfileSerializer.a(this.r()));
            nbt.a("DisplayOffset", this.t());
        }
    }

    @Override
    public void g(Entity entity) {
        if (!(this.t.y || entity.Q || this.Q)) {
            if (!this.t.paperConfig.allowVehicleCollisions && this.t.paperConfig.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
                return;
            }
            if (!this.u(entity)) {
                double d1;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.t.getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) {
                    return;
                }
                double d0 = entity.dc() - this.dc();
                double d2 = d0 * d0 + (d1 = entity.di() - this.di()) * d1;
                if (d2 >= (double)1.0E-4f) {
                    d2 = Math.sqrt(d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= (double)0.1f;
                    d1 *= (double)0.1f;
                    d0 *= 0.5;
                    d1 *= 0.5;
                    if (entity instanceof EntityMinecartAbstract) {
                        Vec3D vec3d1;
                        double d5;
                        double d4 = entity.dc() - this.dc();
                        Vec3D vec3d = new Vec3D(d4, 0.0, d5 = entity.di() - this.di()).d();
                        double d6 = Math.abs(vec3d.b(vec3d1 = new Vec3D(MathHelper.b(this.dm() * ((float)Math.PI / 180)), 0.0, MathHelper.a(this.dm() * ((float)Math.PI / 180))).d()));
                        if (d6 < (double)0.8f) {
                            return;
                        }
                        Vec3D vec3d2 = this.da();
                        Vec3D vec3d3 = entity.da();
                        if (((EntityMinecartAbstract)entity).q() == EnumMinecartType.c && this.q() != EnumMinecartType.c) {
                            this.g(vec3d2.d(0.2, 1.0, 0.2));
                            this.i(vec3d3.b - d0, 0.0, vec3d3.d - d1);
                            entity.g(vec3d3.d(0.95, 1.0, 0.95));
                        } else if (((EntityMinecartAbstract)entity).q() != EnumMinecartType.c && this.q() == EnumMinecartType.c) {
                            entity.g(vec3d3.d(0.2, 1.0, 0.2));
                            entity.i(vec3d2.b + d0, 0.0, vec3d2.d + d1);
                            this.g(vec3d2.d(0.95, 1.0, 0.95));
                        } else {
                            double d7 = (vec3d3.b + vec3d2.b) / 2.0;
                            double d8 = (vec3d3.d + vec3d2.d) / 2.0;
                            this.g(vec3d2.d(0.2, 1.0, 0.2));
                            this.i(d7 - d0, 0.0, d8 - d1);
                            entity.g(vec3d3.d(0.2, 1.0, 0.2));
                            entity.i(d7 + d0, 0.0, d8 + d1);
                        }
                    } else {
                        this.i(-d0, 0.0, -d1);
                        entity.i(d0 / 4.0, 0.0, d1 / 4.0);
                    }
                }
            }
        }
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.av = x2;
        this.aw = y2;
        this.ax = z2;
        this.ay = yaw;
        this.az = pitch;
        this.au = interpolationSteps + 2;
        this.n(this.aA, this.aB, this.aC);
    }

    @Override
    public void k(double x2, double y2, double z2) {
        this.aA = x2;
        this.aB = y2;
        this.aC = z2;
        this.n(this.aA, this.aB, this.aC);
    }

    public void a(float damageWobbleStrength) {
        this.Z.b(e, Float.valueOf(damageWobbleStrength));
    }

    public float l() {
        return this.Z.a(e).floatValue();
    }

    public void c(int wobbleTicks) {
        this.Z.b(c, wobbleTicks);
    }

    public int n() {
        return this.Z.a(c);
    }

    public void d(int wobbleSide) {
        this.Z.b(d, wobbleSide);
    }

    public int o() {
        return this.Z.a(d);
    }

    public abstract EnumMinecartType q();

    public IBlockData r() {
        return !this.w() ? this.s() : Block.a(this.ai().a(f));
    }

    public IBlockData s() {
        return Blocks.a.n();
    }

    public int t() {
        return !this.w() ? this.u() : this.ai().a(ap).intValue();
    }

    public int u() {
        return 6;
    }

    public void b(IBlockData state) {
        this.ai().b(f, Block.i(state));
        this.a(true);
    }

    public void m(int offset) {
        this.ai().b(ap, offset);
        this.a(true);
    }

    public boolean w() {
        return this.ai().a(aq);
    }

    public void a(boolean present) {
        this.ai().b(aq, present);
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    @Override
    public ItemStack dk() {
        return new ItemStack(switch (this.q()) {
            case EnumMinecartType.c -> Items.lO;
            case EnumMinecartType.b -> Items.lN;
            case EnumMinecartType.d -> Items.lP;
            case EnumMinecartType.f -> Items.lQ;
            case EnumMinecartType.g -> Items.rR;
            default -> Items.lM;
        });
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public static enum EnumMinecartType {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }
}

