/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;

public class EntityFishingHook
extends IProjectile {
    private final Random b = new Random();
    private boolean c;
    private int d;
    private static final int e = 10;
    public static final DataWatcherObject<Integer> f = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> ap = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.i);
    private int aq;
    private int ar;
    private int as;
    private int at;
    private float au;
    private boolean av = true;
    @Nullable
    public Entity aw;
    public HookState ax = HookState.a;
    private final int ay;
    private final int az;
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public boolean applyLure = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World world, int lureLevel, int luckOfTheSeaLevel) {
        super((EntityTypes<? extends IProjectile>)type, world);
        this.af = true;
        this.ay = Math.max(0, lureLevel);
        this.az = Math.max(0, luckOfTheSeaLevel);
        this.minWaitTime = world.paperConfig.fishingMinTicks;
        this.maxWaitTime = world.paperConfig.fishingMaxTicks;
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World world) {
        this(type, world, 0, 0);
    }

    public EntityFishingHook(EntityHuman thrower, World world, int lureLevel, int luckOfTheSeaLevel) {
        this(EntityTypes.bj, world, lureLevel, luckOfTheSeaLevel);
        this.b((Entity)thrower);
        float f2 = thrower.dn();
        float f1 = thrower.dm();
        float f22 = MathHelper.b(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.a(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float f5 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        double d0 = thrower.dc() - (double)f3 * 0.3;
        double d1 = thrower.dg();
        double d2 = thrower.di() - (double)f22 * 0.3;
        this.b(d0, d1, d2, f1, f2);
        Vec3D vec3d = new Vec3D(-f3, MathHelper.a(-(f5 / f4), -5.0f, 5.0f), -f22);
        double d3 = vec3d.f();
        vec3d = vec3d.d(0.6 / d3 + 0.5 + this.R.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.R.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.R.nextGaussian() * 0.0045);
        this.g(vec3d);
        this.o((float)(MathHelper.d(vec3d.b, vec3d.d) * 57.2957763671875));
        this.p((float)(MathHelper.d(vec3d.c, vec3d.h()) * 57.2957763671875));
        this.x = this.dm();
        this.y = this.dn();
    }

    @Override
    protected void a_() {
        this.ai().a(f, 0);
        this.ai().a(ap, false);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (f.equals(data)) {
            int i2 = this.ai().a(f);
            Entity entity = this.aw = i2 > 0 ? this.t.a(i2 - 1) : null;
        }
        if (ap.equals(data)) {
            this.c = this.ai().a(ap);
            if (this.c) {
                this.n(this.da().b, -0.4f * MathHelper.a(this.b, 0.6f, 1.0f), this.da().d);
            }
        }
        super.a(data);
    }

    @Override
    public boolean a(double distance) {
        double d1 = 64.0;
        return distance < 4096.0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
    }

    @Override
    public void k() {
        this.b.setSeed(this.cm().getLeastSignificantBits() ^ this.t.V());
        super.k();
        EntityHuman entityhuman = this.i();
        if (entityhuman == null) {
            this.ah();
        } else if (this.t.y || !this.a(entityhuman)) {
            boolean flag;
            if (this.z) {
                ++this.aq;
                if (this.aq >= 1200) {
                    this.ah();
                    return;
                }
            } else {
                this.aq = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockposition = this.cW();
            Fluid fluid = this.t.b_(blockposition);
            if (fluid.a(TagsFluid.b)) {
                f2 = fluid.a((IBlockAccess)this.t, blockposition);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.ax == HookState.a) {
                if (this.aw != null) {
                    this.g(Vec3D.a);
                    this.ax = HookState.b;
                    return;
                }
                if (flag) {
                    this.g(this.da().d(0.3, 0.2, 0.3));
                    this.ax = HookState.c;
                    return;
                }
                this.l();
            } else {
                if (this.ax == HookState.b) {
                    if (this.aw != null) {
                        if (!this.aw.do() && this.aw.t.aa() == this.t.aa()) {
                            this.e(this.aw.dc(), this.aw.e(0.8), this.aw.di());
                        } else {
                            this.x(null);
                            this.ax = HookState.a;
                        }
                    }
                    return;
                }
                if (this.ax == HookState.c) {
                    Vec3D vec3d = this.da();
                    double d0 = this.de() + vec3d.c - (double)blockposition.v() - (double)f2;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.n(vec3d.b * 0.9, vec3d.c - d0 * (double)this.R.nextFloat() * 0.2, vec3d.d * 0.9);
                    if (this.ar <= 0 && this.at <= 0) {
                        this.av = true;
                    } else {
                        boolean bl2 = this.av = this.av && this.d < 10 && this.b(blockposition);
                    }
                    if (flag) {
                        this.d = Math.max(0, this.d - 1);
                        if (this.c) {
                            this.g(this.da().b(0.0, -0.1 * (double)this.b.nextFloat() * (double)this.b.nextFloat(), 0.0));
                        }
                        if (!this.t.y) {
                            this.a(blockposition);
                        }
                    } else {
                        this.d = Math.min(10, this.d + 1);
                    }
                }
            }
            if (!fluid.a(TagsFluid.b)) {
                this.g(this.da().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.da());
            this.z();
            if (this.ax == HookState.a && (this.z || this.A)) {
                this.g(Vec3D.a);
            }
            double d1 = 0.92;
            this.g(this.da().a(0.92));
            this.am();
            if (this.ah) {
                this.ah();
            }
        }
    }

    private boolean a(EntityHuman player) {
        ItemStack itemstack = player.er();
        ItemStack itemstack1 = player.es();
        boolean flag = itemstack.a(Items.or);
        boolean flag1 = itemstack1.a(Items.or);
        if (!player.do() && player.bl() && (flag || flag1) && this.f(player) <= 1024.0) {
            return false;
        }
        this.ah();
        return true;
    }

    private void l() {
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::a);
        this.preOnHit(movingobjectposition);
    }

    @Override
    protected boolean a(Entity entity) {
        return super.a(entity) || entity.bl() && entity instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        if (!this.t.y) {
            this.x(entityHitResult.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        this.g(this.da().d().a(blockHitResult.a(this)));
    }

    public void x(@Nullable Entity entity) {
        this.aw = entity;
        this.ai().b(f, entity == null ? 0 : entity.ae() + 1);
    }

    private void a(BlockPosition pos) {
        WorldServer worldserver = (WorldServer)this.t;
        int i2 = 1;
        BlockPosition blockposition1 = pos.b();
        if (this.R.nextFloat() < 0.25f && this.t.s(blockposition1)) {
            ++i2;
        }
        if (this.R.nextFloat() < 0.5f && !this.t.f(blockposition1)) {
            --i2;
        }
        if (this.ar > 0) {
            --this.ar;
            if (this.ar <= 0) {
                this.as = 0;
                this.at = 0;
                this.ai().b(ap, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.i().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.t.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.at > 0) {
            this.at -= i2;
            if (this.at > 0) {
                double d2;
                double d1;
                this.au = (float)((double)this.au + this.R.nextGaussian() * 4.0);
                float f2 = this.au * ((float)Math.PI / 180);
                float f1 = MathHelper.a(f2);
                float f22 = MathHelper.b(f2);
                double d0 = this.dc() + (double)(f1 * (float)this.at * 0.1f);
                IBlockData iblockdata = worldserver.a_(new BlockPosition(d0, (d1 = (double)((float)MathHelper.b(this.de()) + 1.0f)) - 1.0, d2 = this.di() + (double)(f22 * (float)this.at * 0.1f)));
                if (iblockdata.a(Blocks.A)) {
                    if (this.R.nextFloat() < 0.15f) {
                        worldserver.a(Particles.e, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, f22, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f22 * 0.04f;
                    worldserver.a(Particles.A, d0, d1, d2, 0, (double)f4, 0.01, -f3, 1.0);
                    worldserver.a(Particles.A, d0, d1, d2, 0, (double)(-f4), 0.01, f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.i().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.t.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.a(SoundEffects.gi, 0.25f, 1.0f + (this.R.nextFloat() - this.R.nextFloat()) * 0.4f);
                double d3 = this.de() + 0.5;
                worldserver.a(Particles.e, this.dc(), d3, this.di(), (int)(1.0f + this.cT() * 20.0f), (double)this.cT(), 0.0, this.cT(), 0.2f);
                worldserver.a(Particles.A, this.dc(), d3, this.di(), (int)(1.0f + this.cT() * 20.0f), (double)this.cT(), 0.0, this.cT(), 0.2f);
                this.ar = MathHelper.a(this.R, 20, 40);
                this.ai().b(ap, true);
            }
        } else if (this.as > 0) {
            this.as -= i2;
            float f3 = 0.15f;
            if (this.as < 20) {
                f3 = (float)((double)f3 + (double)(20 - this.as) * 0.05);
            } else if (this.as < 40) {
                f3 = (float)((double)f3 + (double)(40 - this.as) * 0.02);
            } else if (this.as < 60) {
                f3 = (float)((double)f3 + (double)(60 - this.as) * 0.01);
            }
            if (this.R.nextFloat() < f3) {
                double d2;
                double d1;
                float f1 = MathHelper.a(this.R, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f2 = MathHelper.a(this.R, 25.0f, 60.0f);
                double d0 = this.dc() + (double)(MathHelper.a(f1) * f2 * 0.1f);
                IBlockData iblockdata = worldserver.a_(new BlockPosition(d0, (d1 = (double)((float)MathHelper.b(this.de()) + 1.0f)) - 1.0, d2 = this.di() + (double)(MathHelper.b(f1) * f2 * 0.1f)));
                if (iblockdata.a(Blocks.A)) {
                    worldserver.a(Particles.ab, d0, d1, d2, 2 + this.R.nextInt(2), (double)0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.as <= 0) {
                this.au = MathHelper.a(this.R, 0.0f, 360.0f);
                this.at = MathHelper.a(this.R, 20, 80);
            }
        } else {
            this.as = MathHelper.a(this.R, this.minWaitTime, this.maxWaitTime);
            this.as -= this.applyLure ? this.az * 20 * 5 : 0;
        }
    }

    private boolean b(BlockPosition pos) {
        WaterPosition entityfishinghook_waterposition = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition entityfishinghook_waterposition1 = this.a(pos.b(-2, i2, -2), pos.b(2, i2, 2));
            switch (entityfishinghook_waterposition1) {
                case c: {
                    return false;
                }
                case a: {
                    if (entityfishinghook_waterposition != WaterPosition.c) break;
                    return false;
                }
                case b: {
                    if (entityfishinghook_waterposition != WaterPosition.a) break;
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private WaterPosition a(BlockPosition start, BlockPosition end) {
        return BlockPosition.b(start, end).map(this::c).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition pos) {
        IBlockData iblockdata = this.t.a_(pos);
        if (!iblockdata.g() && !iblockdata.a(Blocks.ed)) {
            Fluid fluid = iblockdata.n();
            return fluid.a(TagsFluid.b) && fluid.b() && iblockdata.k(this.t, pos).b() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean h() {
        return this.av;
    }

    @Override
    public void b(NBTTagCompound nbt) {
    }

    @Override
    public void a(NBTTagCompound nbt) {
    }

    public int a(ItemStack usedItem) {
        EntityHuman entityhuman = this.i();
        if (!this.t.y && entityhuman != null && !this.a(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.aw != null) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.aw.getBukkitEntity(), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.t.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                this.c(this.aw);
                CriterionTriggers.D.a((EntityPlayer)entityhuman, usedItem, this, Collections.emptyList());
                this.t.a((Entity)this, (byte)31);
                i2 = this.aw instanceof EntityItem ? 3 : 5;
            } else if (this.ar > 0) {
                LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.t).a(LootContextParameters.f, this.cV()).a(LootContextParameters.i, usedItem).a(LootContextParameters.a, this).a(this.R).a((float)this.ay + entityhuman.fL());
                LootTable loottable = this.t.n().aG().a(LootTables.ag);
                List<ItemStack> list = loottable.a(loottableinfo_builder.a(LootContextParameterSets.e));
                CriterionTriggers.D.a((EntityPlayer)entityhuman, usedItem, this, list);
                for (ItemStack itemstack1 : list) {
                    Entity entityitem = null;
                    if (!itemstack1.b()) {
                        entityitem = new EntityItem(this.t, this.dc(), this.de(), this.di(), itemstack1);
                    }
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)(entityitem != null ? entityitem.getBukkitEntity() : null), (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.R.nextInt(6) + 1);
                    this.t.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.dc() - this.dc();
                    double d1 = entityhuman.de() - this.de();
                    double d2 = entityhuman.di() - this.di();
                    double d3 = 0.1;
                    if (entityitem != null) {
                        entityitem.n(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                        this.t.b(entityitem);
                    }
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.t.b(new EntityExperienceOrb(entityhuman.t, entityhuman.dc(), entityhuman.de() + 0.5, entityhuman.di() + 0.5, playerFishEvent2.getExpToDrop(), ExperienceOrb.SpawnReason.FISHING, this.i(), this));
                    }
                    if (!itemstack1.a(TagsItem.ag)) continue;
                    entityhuman.a(StatisticList.R, 1);
                }
                i2 = 1;
            }
            if (this.z) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.IN_GROUND);
                this.t.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.REEL_IN);
                this.t.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.ah();
            return i2;
        }
        return 0;
    }

    @Override
    public void a(byte status) {
        if (status == 31 && this.t.y && this.aw instanceof EntityHuman && ((EntityHuman)this.aw).fo()) {
            this.c(this.aw);
        }
        super.a(status);
    }

    public void c(Entity entity) {
        Entity entity1 = this.x();
        if (entity1 != null) {
            Vec3D vec3d = new Vec3D(entity1.dc() - this.dc(), entity1.de() - this.de(), entity1.di() - this.di()).a(0.1);
            entity.g(entity.da().e(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.a((EntityFishingHook)null);
        super.a(reason);
    }

    @Override
    public void aj() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void b(@Nullable Entity entity) {
        super.b(entity);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook fishingBobber) {
        EntityHuman entityhuman = this.i();
        if (entityhuman != null) {
            entityhuman.co = fishingBobber;
        }
    }

    @Nullable
    public EntityHuman i() {
        Entity entity = this.x();
        return entity instanceof EntityHuman ? (EntityHuman)entity : null;
    }

    @Nullable
    public Entity j() {
        return this.aw;
    }

    @Override
    public boolean ci() {
        return false;
    }

    @Override
    public Packet<?> S() {
        Entity entity = this.x();
        return new PacketPlayOutSpawnEntity(this, entity == null ? this.ae() : entity.ae());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (this.i() == null) {
            int i2 = packet.m();
            Entity.g.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.t.a(i2), (Object)i2);
            this.ag();
        }
    }

    public static enum HookState {
        a,
        b,
        c;

    }

    private static enum WaterPosition {
        a,
        b,
        c;

    }
}

