/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<OptionalInt> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.i);
    private int e;
    public int f;
    @Nullable
    public EntityLiving ap;
    public UUID spawningEntity;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    public EntityFireworks(World world, double x2, double y2, double z2, ItemStack stack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.D, world);
        this.e = 0;
        this.e(x2, y2, z2);
        int i2 = 1;
        if (!stack.b() && stack.r()) {
            this.Z.b(b, stack.m());
            i2 += stack.a("Fireworks").f("Flight");
        }
        this.n(this.R.nextGaussian() * 0.001, 0.05, this.R.nextGaussian() * 0.001);
        this.f = 10 * i2 + this.R.nextInt(6) + this.R.nextInt(7);
    }

    public EntityFireworks(World world, @Nullable Entity entity, double x2, double y2, double z2, ItemStack stack) {
        this(world, x2, y2, z2, stack);
        this.b(entity);
    }

    public EntityFireworks(World world, ItemStack stack, EntityLiving shooter) {
        this(world, shooter, shooter.dc(), shooter.de(), shooter.di(), stack);
        this.Z.b(c, OptionalInt.of(shooter.ae()));
        this.ap = shooter;
    }

    public EntityFireworks(World world, ItemStack stack, double x2, double y2, double z2, boolean shotAtAngle) {
        this(world, x2, y2, z2, stack);
        this.Z.b(d, shotAtAngle);
    }

    public EntityFireworks(World world, ItemStack stack, Entity entity, double x2, double y2, double z2, boolean shotAtAngle) {
        this(world, stack, x2, y2, z2, shotAtAngle);
        this.b(entity);
    }

    @Override
    public void inactiveTick() {
        ++this.e;
        if (!this.t.y && this.e > this.f && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.j();
        }
        super.inactiveTick();
    }

    @Override
    protected void a_() {
        this.Z.a(b, ItemStack.b);
        this.Z.a(c, OptionalInt.empty());
        this.Z.a(d, false);
    }

    @Override
    public boolean a(double distance) {
        return distance < 4096.0 && !this.o();
    }

    @Override
    public boolean j(double cameraX, double cameraY, double cameraZ) {
        return super.j(cameraX, cameraY, cameraZ) && !this.o();
    }

    @Override
    public void k() {
        super.k();
        if (this.o()) {
            if (this.ap == null) {
                this.Z.a(c).ifPresent(i2 -> {
                    Entity entity = this.t.a(i2);
                    if (entity instanceof EntityLiving) {
                        this.ap = (EntityLiving)entity;
                    }
                });
            }
            if (this.ap != null) {
                if (this.ap.eU()) {
                    Vec3D vec3d = this.ap.bv();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3D vec3d1 = this.ap.da();
                    this.ap.g(vec3d1.b(vec3d.b * 0.1 + (vec3d.b * 1.5 - vec3d1.b) * 0.5, vec3d.c * 0.1 + (vec3d.c * 1.5 - vec3d1.c) * 0.5, vec3d.d * 0.1 + (vec3d.d * 1.5 - vec3d1.d) * 0.5));
                }
                this.e(this.ap.dc(), this.ap.de(), this.ap.di());
                this.g(this.ap.da());
            }
        } else {
            if (!this.i()) {
                double d2 = this.A ? 1.0 : 1.15;
                this.g(this.da().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            Vec3D vec3d = this.da();
            this.a(EnumMoveType.a, vec3d);
            this.g(vec3d);
        }
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::a);
        if (!this.Q) {
            this.preOnHit(movingobjectposition);
            this.ag = true;
        }
        this.z();
        if (this.e == 0 && !this.aL()) {
            this.t.a((EntityHuman)null, this.dc(), this.de(), this.di(), SoundEffects.ga, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.e;
        if (this.t.y && this.e % 2 < 2) {
            this.t.a(Particles.z, this.dc(), this.de() - 0.3, this.di(), this.R.nextGaussian() * 0.05, -this.da().c * 0.5, this.R.nextGaussian() * 0.05);
        }
        if (!this.t.y && this.e > this.f && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.j();
        }
    }

    private void j() {
        this.t.a((Entity)this, (byte)17);
        this.a(GameEvent.v, this.x());
        this.n();
        this.ah();
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        if (!this.t.y && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.j();
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        BlockPosition blockposition = new BlockPosition(blockHitResult.a());
        this.t.a_(blockposition).a(this.t, blockposition, (Entity)this);
        if (!this.t.k_() && this.l() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.j();
        }
        super.a(blockHitResult);
    }

    private boolean l() {
        ItemStack itemstack = this.Z.a(b);
        NBTTagCompound nbttagcompound = itemstack.b() ? null : itemstack.b("Fireworks");
        NBTTagList nbttaglist = nbttagcompound != null ? nbttagcompound.c("Explosions", 10) : null;
        return nbttaglist != null && !nbttaglist.isEmpty();
    }

    private void n() {
        NBTTagList nbttaglist;
        float f2 = 0.0f;
        ItemStack itemstack = this.Z.a(b);
        NBTTagCompound nbttagcompound = itemstack.b() ? null : itemstack.b("Fireworks");
        NBTTagList nBTTagList = nbttaglist = nbttagcompound != null ? nbttagcompound.c("Explosions", 10) : null;
        if (nbttaglist != null && !nbttaglist.isEmpty()) {
            f2 = 5.0f + (float)(nbttaglist.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.ap != null) {
                CraftEventFactory.entityDamage = this;
                this.ap.a(DamageSource.a(this, this.x()), 5.0f + (float)(nbttaglist.size() * 2));
                CraftEventFactory.entityDamage = null;
            }
            double d0 = 5.0;
            Vec3D vec3d = this.cV();
            List<EntityLiving> list = this.t.a(EntityLiving.class, this.cw().g(5.0));
            for (EntityLiving entityliving : list) {
                if (entityliving == this.ap || !(this.f(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec3d1 = new Vec3D(entityliving.dc(), entityliving.e(0.5 * (double)i2), entityliving.di());
                    MovingObjectPositionBlock movingobjectpositionblock = this.t.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (movingobjectpositionblock.c() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.e(entityliving)) / 5.0);
                CraftEventFactory.entityDamage = this;
                entityliving.a(DamageSource.a(this, this.x()), f1);
                CraftEventFactory.entityDamage = null;
            }
        }
    }

    private boolean o() {
        return this.Z.a(c).isPresent();
    }

    @Override
    public boolean i() {
        return this.Z.a(d);
    }

    @Override
    public void a(byte status) {
        if (status == 17 && this.t.y) {
            if (!this.l()) {
                for (int i2 = 0; i2 < this.R.nextInt(3) + 2; ++i2) {
                    this.t.a(Particles.R, this.dc(), this.de(), this.di(), this.R.nextGaussian() * 0.05, 0.005, this.R.nextGaussian() * 0.05);
                }
            } else {
                ItemStack itemstack = this.Z.a(b);
                NBTTagCompound nbttagcompound = itemstack.b() ? null : itemstack.b("Fireworks");
                Vec3D vec3d = this.da();
                this.t.a(this.dc(), this.de(), this.di(), vec3d.b, vec3d.c, vec3d.d, nbttagcompound);
            }
        }
        super.a(status);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Life", this.e);
        nbt.a("LifeTime", this.f);
        ItemStack itemstack = this.Z.a(b);
        if (!itemstack.b()) {
            nbt.a("FireworksItem", itemstack.b(new NBTTagCompound()));
        }
        nbt.a("ShotAtAngle", this.Z.a(d));
        if (this.spawningEntity != null) {
            nbt.a("SpawningEntity", this.spawningEntity);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.e = nbt.h("Life");
        this.f = nbt.h("LifeTime");
        ItemStack itemstack = ItemStack.a(nbt.p("FireworksItem"));
        if (!itemstack.b()) {
            this.Z.b(b, itemstack);
        }
        if (nbt.e("ShotAtAngle")) {
            this.Z.b(d, nbt.q("ShotAtAngle"));
        }
        if (nbt.b("SpawningEntity")) {
            this.spawningEntity = nbt.a("SpawningEntity");
        }
    }

    @Override
    public ItemStack h() {
        ItemStack itemstack = this.Z.a(b);
        return itemstack.b() ? new ItemStack(Items.rz) : itemstack;
    }

    @Override
    public boolean cf() {
        return false;
    }
}

