/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public abstract class EntityHuman
extends EntityLiving {
    public static final String bF = "OfflinePlayer:";
    public static final int bG = 16;
    public static final int bH = 20;
    public static final int bI = 100;
    public static final int bJ = 10;
    public static final int bK = 200;
    public static final float bL = 1.5f;
    public static final float bM = 0.6f;
    public static final float bN = 0.6f;
    public static final float bO = 1.62f;
    public static final EntitySize bP = EntitySize.b(0.6f, 1.8f);
    private static final Map<EntityPose, EntitySize> b = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bP).put((Object)EntityPose.c, (Object)EntityLiving.aE).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f)).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f)).build();
    private static final int c = 25;
    private static final DataWatcherObject<Float> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.c);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bQ = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bR = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bS = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.p);
    protected static final DataWatcherObject<NBTTagCompound> bT = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.p);
    private long f;
    private final PlayerInventory cp = new PlayerInventory(this);
    protected InventoryEnderChest bU = new InventoryEnderChest(this);
    public final ContainerPlayer bV;
    public Container bW;
    protected FoodMetaData bX = new FoodMetaData(this);
    protected int bY;
    public float bZ;
    public float ca;
    public int cb;
    public double cc;
    public double cd;
    public double ce;
    public double cf;
    public double cg;
    public double ch;
    public int cq;
    protected boolean ci;
    private final PlayerAbilities cr = new PlayerAbilities();
    public int cj;
    public int ck;
    public float cl;
    protected int cm;
    protected final float cn = 0.02f;
    private int cs;
    public GameProfile ct;
    private boolean cu;
    private net.minecraft.world.item.ItemStack cv = net.minecraft.world.item.ItemStack.b;
    private final ItemCooldown cw = this.j();
    @Nullable
    public EntityFishingHook co;
    public boolean affectsSpawning = true;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition pos, float yaw, GameProfile profile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bi, world);
        this.a_(EntityHuman.a(profile));
        this.ct = profile;
        this.bV = new ContainerPlayer(this.cp, !world.y, this);
        this.bW = this.bV;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yaw, 0.0f);
        this.bl = 180.0f;
    }

    public boolean a(World world, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.e()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.fB()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.er();
        return itemstack.b() || !itemstack.b(world.r(), new ShapeDetectorBlock(world, pos, false));
    }

    public static AttributeProvider.Builder fe() {
        return EntityLiving.dv().a(GenericAttributes.f, 1.0).a(GenericAttributes.d, 0.1f).a(GenericAttributes.h).a(GenericAttributes.k);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(d, Float.valueOf(0.0f));
        this.Z.a(e, 0);
        this.Z.a(bQ, (byte)0);
        this.Z.a(bR, (byte)1);
        this.Z.a(bS, new NBTTagCompound());
        this.Z.a(bT, new NBTTagCompound());
    }

    @Override
    public void k() {
        this.Q = this.B_();
        if (this.B_()) {
            this.z = false;
        }
        if (this.cb > 0) {
            --this.cb;
        }
        if (this.fb()) {
            ++this.cq;
            if (this.cq == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.cq = Integer.MIN_VALUE;
            }
            if (this.cq > 100) {
                this.cq = 100;
            }
            if (!this.t.y && this.t.P()) {
                this.a(false, true);
            }
        } else if (this.cq > 0) {
            ++this.cq;
            if (this.cq >= 110) {
                this.cq = 0;
            }
        }
        this.fi();
        super.k();
        if (!this.t.y && this.bW != null && !this.bW.a(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bW = this.bV;
        }
        this.r();
        if (!this.t.y) {
            this.bX.a(this);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bl()) {
                this.a(StatisticList.m);
            }
            if (this.bL()) {
                this.a(StatisticList.o);
            }
            if (!this.fb()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dc(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.di(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dc() || d1 != this.di()) {
            this.e(d0, this.de(), d1);
        }
        ++this.aR;
        net.minecraft.world.item.ItemStack itemstack = this.er();
        if (!net.minecraft.world.item.ItemStack.b(this.cv, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.d(this.cv, itemstack)) {
                this.fJ();
            }
            this.cv = itemstack.m();
        }
        this.n();
        this.cw.a();
        this.fj();
    }

    public boolean ff() {
        return this.bI();
    }

    protected boolean fg() {
        return this.bI();
    }

    protected boolean fh() {
        return this.bI();
    }

    protected boolean fi() {
        this.ci = ((Entity)this).a(TagsFluid.b);
        return this.ci;
    }

    private void n() {
        net.minecraft.world.item.ItemStack itemstack = this.b(EnumItemSlot.f);
        if (itemstack.a(Items.mc) && !((Entity)this).a(TagsFluid.b)) {
            this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldown j() {
        return new ItemCooldown();
    }

    private void r() {
        this.cc = this.cf;
        this.cd = this.cg;
        this.ce = this.ch;
        double d0 = this.dc() - this.cf;
        double d1 = this.de() - this.cg;
        double d2 = this.di() - this.ch;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.cc = this.cf = this.dc();
        }
        if (d2 > 10.0) {
            this.ce = this.ch = this.di();
        }
        if (d1 > 10.0) {
            this.cd = this.cg = this.de();
        }
        if (d0 < -10.0) {
            this.cc = this.cf = this.dc();
        }
        if (d2 < -10.0) {
            this.ce = this.ch = this.di();
        }
        if (d1 < -10.0) {
            this.cd = this.cg = this.de();
        }
        this.cf += d0 * 0.25;
        this.ch += d2 * 0.25;
        this.cg += d1 * 0.25;
    }

    protected void fj() {
        if (this.c(EntityPose.d)) {
            EntityPose entitypose = this.eU() ? EntityPose.b : (this.fb() ? EntityPose.c : (this.bP() ? EntityPose.d : (this.eG() ? EntityPose.e : (this.bI() && !this.cr.b ? EntityPose.f : EntityPose.a))));
            EntityPose entitypose1 = !(this.B_() || this.bF() || this.c(entitypose)) ? (this.c(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    @Override
    public int ar() {
        return this.cr.a ? 1 : 80;
    }

    @Override
    protected SoundEffect aF() {
        return SoundEffects.oP;
    }

    @Override
    protected SoundEffect aG() {
        return SoundEffects.oN;
    }

    @Override
    protected SoundEffect aH() {
        return SoundEffects.oO;
    }

    @Override
    public int bz() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.t.a(this, this.dc(), this.de(), this.di(), sound, this.cO(), volume, pitch);
    }

    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.h;
    }

    @Override
    public int cP() {
        return 20;
    }

    @Override
    public void a(byte status) {
        if (status == 9) {
            this.v();
        } else if (status == 23) {
            this.cu = false;
        } else if (status == 22) {
            this.cu = true;
        } else if (status == 43) {
            this.a(Particles.f);
        } else {
            super.a(status);
        }
    }

    private void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.R.nextGaussian() * 0.02;
            double d1 = this.R.nextGaussian() * 0.02;
            double d2 = this.R.nextGaussian() * 0.02;
            this.t.a(parameters, this.d(1.0), this.df() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.q();
        this.bW = this.bV;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.bW = this.bV;
    }

    public void q() {
        this.bW = this.bV;
    }

    @Override
    public void bo() {
        if (!this.t.y && this.fg() && this.bF()) {
            this.p();
            this.f(false);
        } else {
            double d0 = this.dc();
            double d1 = this.de();
            double d2 = this.di();
            super.bo();
            this.bZ = this.ca;
            this.ca = 0.0f;
            this.r(this.dc() - d0, this.de() - d1, this.di() - d2);
        }
    }

    @Override
    protected void eE() {
        super.eE();
        this.eo();
        this.ba = this.dm();
    }

    @Override
    public void w_() {
        if (this.bY > 0) {
            --this.bY;
        }
        if (this.t.af() == EnumDifficulty.a && this.t.X().b(GameRules.j)) {
            if (this.dZ() < this.el() && this.S % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.bX.c() && this.S % 10 == 0) {
                this.bX.a(this.bX.a() + 1);
            }
        }
        this.cp.j();
        this.bZ = this.ca;
        super.w_();
        this.bc = 0.02f;
        if (this.bO()) {
            this.bc = (float)((double)this.bc + 0.005999999865889549);
        }
        this.r((float)this.b(GenericAttributes.d));
        float f2 = this.z && !this.ea() && !this.bP() ? Math.min(0.1f, (float)this.da().h()) : 0.0f;
        this.ca += (f2 - this.ca) * 0.4f;
        if (this.dZ() > 0.0f && !this.B_()) {
            AxisAlignedBB axisalignedbb = this.bF() && !this.cN().do() ? this.cw().b(this.cN().cw()).c(1.0, 0.0, 1.0) : this.cw().c(1.0, 0.5, 1.0);
            List<Entity> list = this.t.a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Entity entity = list.get(i2);
                if (entity.ad() == EntityTypes.A) {
                    list1.add(entity);
                    continue;
                }
                if (entity.do()) continue;
                this.c(entity);
            }
            if (!list1.isEmpty()) {
                this.c((Entity)SystemUtils.a(list1, this.R));
            }
        }
        this.c(this.fG());
        this.c(this.fH());
        if ((!this.t.y && (this.L > 0.5f || this.aQ()) || this.cr.b || this.fb() || this.am) && !this.t.paperConfig.parrotsHangOnBetter) {
            this.fD();
        }
    }

    private void c(@Nullable NBTTagCompound entityNbt) {
        if (!(entityNbt == null || entityNbt.e("Silent") && entityNbt.q("Silent") || this.t.w.nextInt(200) != 0)) {
            String s2 = entityNbt.l("id");
            EntityTypes.a(s2).filter(entitytypes -> entitytypes == EntityTypes.al).ifPresent(entitytypes -> {
                if (!EntityParrot.a(this.t, this)) {
                    this.t.a((EntityHuman)null, this.dc(), this.de(), this.di(), EntityParrot.a(this.t, this.t.w), this.cO(), 1.0f, EntityParrot.a(this.t.w));
                }
            });
        }
    }

    private void c(Entity entity) {
        entity.b(this);
    }

    public int fk() {
        return this.Z.a(e);
    }

    public void s(int score) {
        this.Z.b(e, score);
    }

    public void t(int score) {
        int j2 = this.fk();
        this.Z.b(e, j2 + score);
    }

    @Override
    public void a(DamageSource source) {
        super.a(source);
        this.am();
        if (!this.B_()) {
            this.dropAllDeathLoot(source);
        }
        if (source != null) {
            this.n(-MathHelper.b((this.aN + this.dm()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.aN + this.dm()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.n(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.au();
        this.a_(false);
    }

    @Override
    protected void ec() {
        super.ec();
        if (!this.t.X().b(GameRules.d)) {
            this.fl();
            this.cp.k();
        }
    }

    protected void fl() {
        for (int i2 = 0; i2 < this.cp.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.cp.a(i2);
            if (itemstack.b() || !EnchantmentManager.e(itemstack)) continue;
            this.cp.b(i2);
        }
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return source == DamageSource.c ? SoundEffects.oJ : (source == DamageSource.h ? SoundEffects.oH : (source == DamageSource.u ? SoundEffects.oK : (source == DamageSource.v ? SoundEffects.oI : SoundEffects.oG)));
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.oF;
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        return this.a(stack, false, retainOwnership);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, false);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership, boolean alwaysSucceed) {
        WorldMap worldmap;
        if (stack.b()) {
            return null;
        }
        if (this.t.y) {
            this.a(EnumHand.a);
        }
        double d0 = this.dg() - (double)0.3f;
        net.minecraft.world.item.ItemStack tmp = stack.m();
        stack.e(0);
        stack = tmp;
        EntityItem entityitem = new EntityItem(this.t, this.dc(), d0, this.di(), stack);
        entityitem.a(40);
        if (retainOwnership) {
            entityitem.c(this.cm());
        }
        if (throwRandomly) {
            float f2 = this.R.nextFloat() * 0.5f;
            float f1 = this.R.nextFloat() * ((float)Math.PI * 2);
            entityitem.n(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dn() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dn() * ((float)Math.PI / 180));
            float f32 = MathHelper.a(this.dm() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dm() * ((float)Math.PI / 180));
            float f5 = this.R.nextFloat() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.R.nextFloat();
            entityitem.n((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.R.nextFloat() - this.R.nextFloat()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        Player player = (Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.t.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && !alwaysSucceed) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (retainOwnership && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (retainOwnership && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        if (stack.c() == Items.pp && (worldmap = ItemWorldMap.a(stack, this.t)) != null) {
            worldmap.a(this, stack);
        }
        return entityitem;
    }

    public float c(IBlockData block) {
        float f2 = this.cp.a(block);
        if (f2 > 1.0f) {
            int i2 = EnchantmentManager.f(this);
            net.minecraft.world.item.ItemStack itemstack = this.er();
            if (i2 > 0 && !itemstack.b()) {
                f2 += (float)(i2 * i2 + 1);
            }
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.a(MobEffects.d)) {
            f2 *= (switch (this.b(MobEffects.d).c()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (((Entity)this).a(TagsFluid.b) && !EnchantmentManager.h(this)) {
            f2 /= 5.0f;
        }
        if (!this.z) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData state) {
        return !state.r() || this.cp.f().b(state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a_(EntityHuman.a(this.ct));
        NBTTagList nbttaglist = nbt.c("Inventory", 10);
        this.cp.b(nbttaglist);
        this.cp.k = nbt.h("SelectedItemSlot");
        this.cq = nbt.g("SleepTimer");
        this.cl = nbt.j("XpP");
        this.cj = nbt.h("XpLevel");
        this.ck = nbt.h("XpTotal");
        this.cm = nbt.h("XpSeed");
        if (this.cm == 0) {
            this.cm = this.R.nextInt();
        }
        this.s(nbt.h("Score"));
        this.bX.a(nbt);
        this.cr.b(nbt);
        this.a(GenericAttributes.d).a(this.cr.b());
        if (nbt.b("EnderItems", 9)) {
            this.bU.a(nbt.c("EnderItems", 10));
        }
        if (nbt.b("ShoulderEntityLeft", 10)) {
            this.i(nbt.p("ShoulderEntityLeft"));
        }
        if (nbt.b("ShoulderEntityRight", 10)) {
            this.j(nbt.p("ShoulderEntityRight"));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("DataVersion", SharedConstants.b().getWorldVersion());
        nbt.a("Inventory", this.cp.a(new NBTTagList()));
        nbt.a("SelectedItemSlot", this.cp.k);
        nbt.a("SleepTimer", (short)this.cq);
        nbt.a("XpP", this.cl);
        nbt.a("XpLevel", this.cj);
        nbt.a("XpTotal", this.ck);
        nbt.a("XpSeed", this.cm);
        nbt.a("Score", this.fk());
        this.bX.b(nbt);
        this.cr.a(nbt);
        nbt.a("EnderItems", this.bU.g());
        if (!this.fG().f()) {
            nbt.a("ShoulderEntityLeft", this.fG());
        }
        if (!this.fH().f()) {
            nbt.a("ShoulderEntityRight", this.fH());
        }
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) ? true : (damageSource == DamageSource.h ? !this.t.X().b(GameRules.B) : (damageSource.z() ? !this.t.X().b(GameRules.C) : (damageSource.s() ? !this.t.X().b(GameRules.D) : (damageSource == DamageSource.v ? !this.t.X().b(GameRules.E) : false))));
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean damaged;
        if (this.b(source)) {
            return false;
        }
        if (this.cr.a && !source.i()) {
            this.forceExplosionKnockback = true;
            return false;
        }
        this.bg = 0;
        if (this.ea()) {
            return false;
        }
        if (source.w()) {
            if (this.t.af() == EnumDifficulty.a) {
                return false;
            }
            if (this.t.af() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.t.af() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(source, amount)) {
            this.fD();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving attacker) {
        super.d(attacker);
        if (attacker.er().c() instanceof ItemAxe) {
            this.r(true);
        }
    }

    @Override
    public boolean dS() {
        return !this.fr().a && super.dS();
    }

    public boolean a(EntityHuman player) {
        Team team;
        if (player instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)player;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = player.t.getCraftServer().getOfflinePlayer(player.co());
            team = player.t.getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.t.getCraftServer().getOfflinePlayer(this.co()));
    }

    @Override
    protected void b(DamageSource source, float amount) {
        this.cp.a(source, amount, PlayerInventory.f);
    }

    @Override
    protected void c(DamageSource source, float amount) {
        this.cp.a(source, amount, PlayerInventory.g);
    }

    @Override
    protected void q(float amount) {
        if (this.bA.a(Items.sv)) {
            if (!this.t.y) {
                this.b(StatisticList.c.b(this.bA.c()));
            }
            if (amount >= 3.0f) {
                int i2 = 1 + MathHelper.d(amount);
                EnumHand enumhand = this.eM();
                this.bA.a(i2, this, (T entityhuman) -> entityhuman.d(enumhand));
                if (this.bA.b()) {
                    if (enumhand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.b);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.b);
                    }
                    this.bA = net.minecraft.world.item.ItemStack.b;
                    this.a(SoundEffects.qA, 0.8f, 0.8f + this.t.w.nextFloat() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean damageEntity0(DamageSource damagesource, float f2) {
        return super.damageEntity0(damagesource, f2);
    }

    @Override
    protected boolean dz() {
        return !this.cr.b && super.dz();
    }

    public void a(TileEntitySign sign) {
    }

    public void a(CommandBlockListenerAbstract commandBlockExecutor) {
    }

    public void a(TileEntityCommand commandBlock) {
    }

    public void a(TileEntityStructure structureBlock) {
    }

    public void a(TileEntityJigsaw jigsaw) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory factory) {
        return OptionalInt.empty();
    }

    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
    }

    public void a(net.minecraft.world.item.ItemStack book, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand hand) {
        if (this.B_()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.d;
        }
        net.minecraft.world.item.ItemStack itemstack = this.b(hand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.m();
        EnumInteractionResult enuminteractionresult = entity.a(this, hand);
        if (enuminteractionresult.a()) {
            if (this.cr.d && itemstack == this.b(hand) && itemstack.I() < itemstack1.I()) {
                itemstack.e(itemstack1.I());
            }
            return enuminteractionresult;
        }
        if (!itemstack.b() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.cr.d) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, hand)).a()) {
                if (itemstack.b() && !this.cr.d) {
                    this.a(hand, net.minecraft.world.item.ItemStack.b);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.d;
    }

    @Override
    public double bp() {
        return -0.35;
    }

    @Override
    public void bt() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        this.s = 0;
    }

    @Override
    protected boolean ew() {
        return super.ew() || this.fb() || this.do() || !this.valid;
    }

    @Override
    public boolean dF() {
        return !this.cr.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        if (!this.cr.b && (type == EnumMoveType.a || type == EnumMoveType.b) && this.fh() && this.t()) {
            double d0 = movement.b;
            double d1 = movement.d;
            double d2 = 0.05;
            while (d0 != 0.0 && this.t.a((Entity)this, this.cw().d(d0, -this.P, 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.t.a((Entity)this, this.cw().d(0.0, -this.P, d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.t.a((Entity)this, this.cw().d(d0, -this.P, d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            movement = new Vec3D(d0, movement.c, d1);
        }
        return movement;
    }

    private boolean t() {
        return this.z || this.L < this.P && !this.t.a((Entity)this, this.cw().d(0.0, this.L - this.P, 0.0));
    }

    public void d(Entity target) {
        if (target.cf() && !target.r(this)) {
            float f2 = (float)this.b(GenericAttributes.f);
            float f1 = target instanceof EntityLiving ? EnchantmentManager.a(this.er(), ((EntityLiving)target).eq()) : EnchantmentManager.a(this.er(), EnumMonsterType.a);
            float f22 = this.v(0.5f);
            f1 *= f22;
            if ((f2 *= 0.2f + f22 * f22 * 0.8f) > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack;
                boolean flag = f22 > 0.9f;
                boolean flag1 = false;
                int b0 = 0;
                int i2 = b0 + EnchantmentManager.b(this);
                if (this.bO() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dc(), this.de(), this.di(), SoundEffects.ox, this.cO(), 1.0f, 1.0f);
                    ++i2;
                    flag1 = true;
                }
                boolean flag2 = flag && this.L > 0.0f && !this.z && !this.b_() && !this.aQ() && !this.a(MobEffects.o) && !this.bF() && target instanceof EntityLiving;
                flag2 = flag2 && !this.t.paperConfig.disablePlayerCrits;
                boolean bl = flag2 = flag2 && !this.bO();
                if (flag2) {
                    f2 *= 1.5f;
                }
                f2 += f1;
                boolean flag3 = false;
                double d0 = this.I - this.H;
                if (flag && !flag2 && !flag1 && this.z && d0 < (double)this.eC() && (itemstack = this.b(EnumHand.a)).c() instanceof ItemSword) {
                    flag3 = true;
                }
                float f3 = 0.0f;
                boolean flag4 = false;
                int j2 = EnchantmentManager.c(this);
                if (target instanceof EntityLiving) {
                    f3 = ((EntityLiving)target).dZ();
                    if (j2 > 0 && !target.bE()) {
                        EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), 1);
                        Bukkit.getPluginManager().callEvent((Event)combustEvent);
                        if (!combustEvent.isCancelled()) {
                            flag4 = true;
                            target.setSecondsOnFire(combustEvent.getDuration(), false);
                        }
                    }
                }
                Vec3D vec3d = target.da();
                boolean flag5 = target.a(DamageSource.a(this).critical(flag2), f2);
                if (flag5) {
                    if (i2 > 0) {
                        if (target instanceof EntityLiving) {
                            ((EntityLiving)target).knockback((float)i2 * 0.5f, MathHelper.a(this.dm() * ((float)Math.PI / 180)), -MathHelper.b(this.dm() * ((float)Math.PI / 180)), this);
                        } else {
                            target.i(-MathHelper.a(this.dm() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, 0.1, MathHelper.b(this.dm() * ((float)Math.PI / 180)) * (float)i2 * 0.5f);
                        }
                        this.g(this.da().d(0.6, 1.0, 0.6));
                        if (!this.t.paperConfig.disableSprintInterruptionOnAttack) {
                            this.g(false);
                        }
                    }
                    if (flag3) {
                        float f4 = 1.0f + EnchantmentManager.a(this) * f2;
                        List<EntityLiving> list = this.t.a(EntityLiving.class, target.cw().c(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving : list) {
                            if (entityliving == this || entityliving == target || this.p(entityliving) || entityliving instanceof EntityArmorStand && ((EntityArmorStand)entityliving).t() || !(this.f((Entity)entityliving) < 9.0) || !entityliving.a(DamageSource.a(this).sweep().critical(flag2), f4)) continue;
                            entityliving.knockback(0.4f, MathHelper.a(this.dm() * ((float)Math.PI / 180)), -MathHelper.b(this.dm() * ((float)Math.PI / 180)), this);
                        }
                        EntityHuman.sendSoundEffect(this, this.dc(), this.de(), this.di(), SoundEffects.oA, this.cO(), 1.0f, 1.0f);
                        this.fm();
                    }
                    if (target instanceof EntityPlayer && target.D) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).b.a(new PacketPlayOutEntityVelocity(target));
                            target.D = false;
                            target.g(vec3d);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dc(), this.de(), this.di(), SoundEffects.ow, this.cO(), 1.0f, 1.0f);
                        this.a(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dc(), this.de(), this.di(), SoundEffects.oz, this.cO(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dc(), this.de(), this.di(), SoundEffects.oB, this.cO(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.b(target);
                    }
                    this.x(target);
                    if (target instanceof EntityLiving) {
                        EnchantmentManager.a((EntityLiving)target, (Entity)this);
                    }
                    EnchantmentManager.b(this, target);
                    net.minecraft.world.item.ItemStack itemstack1 = this.er();
                    Entity object = target;
                    if (target instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)target).b;
                    }
                    if (!this.t.y && !itemstack1.b() && object instanceof EntityLiving) {
                        itemstack1.a((EntityLiving)object, this);
                        if (itemstack1.b()) {
                            this.a(EnumHand.a, net.minecraft.world.item.ItemStack.b);
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f5 = f3 - ((EntityLiving)target).dZ();
                        this.a(StatisticList.G, Math.round(f5 * 10.0f));
                        if (j2 > 0) {
                            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), j2 * 4);
                            Bukkit.getPluginManager().callEvent((Event)combustEvent);
                            if (!combustEvent.isCancelled()) {
                                target.setSecondsOnFire(combustEvent.getDuration(), false);
                            }
                        }
                        if (this.t instanceof WorldServer && f5 > 2.0f) {
                            int k2 = (int)((double)f5 * 0.5);
                            ((WorldServer)this.t).a(Particles.h, target.dc(), target.e(0.5), target.di(), k2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.t.spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dc(), this.de(), this.di(), SoundEffects.oy, this.cO(), 1.0f, 1.0f);
                    if (flag4) {
                        target.au();
                    }
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    @Override
    protected void g(EntityLiving target) {
        this.d((Entity)target);
    }

    public void r(boolean sprinting) {
        float f2 = 0.25f + (float)EnchantmentManager.f(this) * 0.05f;
        if (sprinting) {
            f2 += 0.75f;
        }
        if (this.R.nextFloat() < f2) {
            this.fK().a(Items.sv, 100);
            this.eR();
            this.t.a((Entity)this, (byte)30);
        }
    }

    public void a(Entity target) {
    }

    public void b(Entity target) {
    }

    public void fm() {
        double d0 = -MathHelper.a(this.dm() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dm() * ((float)Math.PI / 180));
        if (this.t instanceof WorldServer) {
            ((WorldServer)this.t).a(Particles.Y, this.dc() + d0, this.e(0.5), this.di() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void fn() {
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.bV.b(this);
        if (this.bW != null) {
            this.bW.b(this);
        }
    }

    public boolean fo() {
        return false;
    }

    public GameProfile fp() {
        return this.ct;
    }

    public PlayerInventory fq() {
        return this.cp;
    }

    public PlayerAbilities fr() {
        return this.cr;
    }

    public void a(net.minecraft.world.item.ItemStack cursorStack, net.minecraft.world.item.ItemStack slotStack, ClickAction clickType) {
    }

    public Either<EnumBedResult, Unit> a(BlockPosition pos) {
        return this.startSleepInBed(pos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cq = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        super.fc();
        if (this.t instanceof WorldServer && updateSleepingPlayers) {
            ((WorldServer)this.t).e();
        }
        this.cq = skipSleepTimer ? 0 : 100;
    }

    @Override
    public void fc() {
        this.a(true, true);
    }

    public static Optional<Vec3D> a(WorldServer world, BlockPosition pos, float angle, boolean forced, boolean alive) {
        IBlockData iblockdata = world.a_(pos);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && iblockdata.c(BlockRespawnAnchor.c) > 0 && BlockRespawnAnchor.a(world)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bi, world, pos);
            if (!alive && optional.isPresent()) {
                world.a(pos, (IBlockData)iblockdata.a(BlockRespawnAnchor.c, iblockdata.c(BlockRespawnAnchor.c) - 1), 3);
            }
            return optional;
        }
        if (block instanceof BlockBed && BlockBed.a(world)) {
            return BlockBed.a(EntityTypes.bi, (ICollisionAccess)world, pos, angle);
        }
        if (!forced) {
            return Optional.empty();
        }
        boolean flag2 = block.X_();
        boolean flag3 = world.a_(pos.b()).b().X_();
        return flag2 && flag3 ? Optional.of(new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.1, (double)pos.w() + 0.5)) : Optional.empty();
    }

    public boolean fs() {
        return this.fb() && this.cq >= 100;
    }

    public int ft() {
        return this.cq;
    }

    public void a(IChatBaseComponent message, boolean actionBar) {
    }

    public void a(MinecraftKey stat) {
        this.b(StatisticList.i.b(stat));
    }

    public void a(MinecraftKey stat, int amount) {
        this.a(StatisticList.i.b(stat), amount);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int amount) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<IRecipe<?>> recipes) {
        return 0;
    }

    public void a(MinecraftKey[] ids) {
    }

    public int b(Collection<IRecipe<?>> recipes) {
        return 0;
    }

    @Override
    public void ez() {
        super.ez();
        this.a(StatisticList.E);
        if (this.bO()) {
            this.causeFoodExhaustion(this.t.spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.t.spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void h(Vec3D movementInput) {
        double d3;
        double d0 = this.dc();
        double d1 = this.de();
        double d2 = this.di();
        if (this.bP() && !this.bF()) {
            double d4;
            d3 = this.bv().c;
            double d5 = d4 = d3 < -0.2 ? 0.085 : 0.06;
            if (d3 <= 0.0 || this.bo || !this.t.a_(new BlockPosition(this.dc(), this.de() + 1.0 - 0.1, this.di())).n().c()) {
                Vec3D vec3d1 = this.da();
                this.g(vec3d1.b(0.0, (d3 - vec3d1.c) * d4, 0.0));
            }
        }
        if (this.cr.b && !this.bF()) {
            d3 = this.da().c;
            float f2 = this.bc;
            this.bc = this.cr.a() * (float)(this.bO() ? 2 : 1);
            super.h(movementInput);
            Vec3D vec3d2 = this.da();
            this.n(vec3d2.b, d3 * 0.6, vec3d2.d);
            this.bc = f2;
            this.m();
            if (this.h(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.b(7, false);
            }
        } else {
            super.h(movementInput);
        }
        this.q(this.dc() - d0, this.de() - d1, this.di() - d2);
    }

    @Override
    public void aV() {
        if (this.cr.b) {
            this.h(false);
        } else {
            super.aV();
        }
    }

    protected boolean f(BlockPosition pos) {
        return !this.t.a_(pos).o(this.t, pos);
    }

    @Override
    public float eC() {
        return (float)this.b(GenericAttributes.d);
    }

    public void q(double dx, double dy, double dz) {
        if (!this.bF()) {
            if (this.bP()) {
                int i2 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.t.spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.b)) {
                int i3 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (i3 > 0) {
                    this.a(StatisticList.w, i3);
                    this.causeFoodExhaustion(this.t.spigotConfig.swimMultiplier * (float)i3 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.aQ()) {
                int i4 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i4 > 0) {
                    this.a(StatisticList.s, i4);
                    this.causeFoodExhaustion(this.t.spigotConfig.swimMultiplier * (float)i4 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.b_()) {
                if (dy > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(dy * 100.0));
                }
            } else if (this.z) {
                int i5 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i5 > 0) {
                    if (this.bO()) {
                        this.a(StatisticList.r, i5);
                        this.causeFoodExhaustion(this.t.spigotConfig.sprintMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.bN()) {
                        this.a(StatisticList.q, i5);
                        this.causeFoodExhaustion(this.t.spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, i5);
                        this.causeFoodExhaustion(this.t.spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.eU()) {
                int i6 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.a(StatisticList.B, i6);
            } else {
                int i7 = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (i7 > 25) {
                    this.a(StatisticList.v, i7);
                }
            }
        }
    }

    private void r(double dx, double dy, double dz) {
        int i2;
        if (this.bF() && (i2 = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f)) > 0) {
            Entity entity = this.cN();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof EntityBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.cr.c) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)fallDistance * 100.0));
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    public boolean fu() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.z && !this.eU() && !this.aQ() && !this.a(MobEffects.y) && (itemstack = this.b(EnumItemSlot.e)).a(Items.lT) && ItemElytra.d(itemstack)) {
            this.fv();
            return true;
        }
        return false;
    }

    public void fv() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void fw() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void aY() {
        if (!this.B_()) {
            super.aY();
        }
    }

    @Override
    public EntityLiving.a ef() {
        return new EntityLiving.a(SoundEffects.oM, SoundEffects.oC);
    }

    @Override
    public void a(WorldServer world, EntityLiving other) {
        this.b(StatisticList.g.b(other.ad()));
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!this.cr.b) {
            super.a(state, multiplier);
        }
    }

    public void d(int experience) {
        this.t(experience);
        this.cl += (float)experience / (float)this.fy();
        this.ck = MathHelper.a(this.ck + experience, 0, Integer.MAX_VALUE);
        while (this.cl < 0.0f) {
            float f2 = this.cl * (float)this.fy();
            if (this.cj > 0) {
                this.c(-1);
                this.cl = 1.0f + f2 / (float)this.fy();
                continue;
            }
            this.c(-1);
            this.cl = 0.0f;
        }
        while (this.cl >= 1.0f) {
            this.cl = (this.cl - 1.0f) * (float)this.fy();
            this.c(1);
            this.cl /= (float)this.fy();
        }
    }

    public int fx() {
        return this.cm;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int experienceLevels) {
        this.cj -= experienceLevels;
        if (this.cj < 0) {
            this.cj = 0;
            this.cl = 0.0f;
            this.ck = 0;
        }
        this.cm = this.R.nextInt();
    }

    public void c(int levels) {
        this.cj += levels;
        if (this.cj < 0) {
            this.cj = 0;
            this.cl = 0.0f;
            this.ck = 0;
        }
        if (levels > 0 && this.cj % 5 == 0 && (float)this.cs < (float)this.S - 100.0f) {
            float f2 = this.cj > 30 ? 1.0f : (float)this.cj / 30.0f;
            this.t.a((EntityHuman)null, this.dc(), this.de(), this.di(), SoundEffects.oL, this.cO(), f2 * 0.75f, 1.0f);
            this.cs = this.S;
        }
    }

    public int fy() {
        return this.cj >= 30 ? 112 + (this.cj - 30) * 9 : (this.cj >= 15 ? 37 + (this.cj - 15) * 5 : 7 + this.cj * 2);
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.t.a(fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            ((EntityPlayer)fromEntity).b.a(new PacketPlayOutNamedSoundEffect(soundEffect, soundCategory, x2, y2, z2, volume, pitch));
        }
    }

    public void u(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cr.a || this.t.y || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.bX.a(event.getExhaustion());
        }
    }

    public FoodMetaData fz() {
        return this.bX;
    }

    public boolean s(boolean ignoreHunger) {
        return this.cr.a || ignoreHunger || this.bX.c();
    }

    public boolean fA() {
        return this.dZ() > 0.0f && this.dZ() < this.el();
    }

    public boolean fB() {
        return this.cr.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.cr.e) {
            return true;
        }
        BlockPosition blockposition1 = pos.a(facing.f());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.t, blockposition1, false);
        return stack.a(this.t.r(), shapedetectorblock);
    }

    @Override
    protected int d(EntityHuman player) {
        if (!this.t.X().b(GameRules.d) && !this.B_()) {
            int i2 = this.cj * 7;
            return i2 > 100 ? 100 : i2;
        }
        return 0;
    }

    @Override
    protected boolean dJ() {
        return true;
    }

    @Override
    public boolean cs() {
        return true;
    }

    @Override
    protected Entity.MovementEmission aN() {
        return !this.cr.b && (!this.z || !this.bL()) ? Entity.MovementEmission.d : Entity.MovementEmission.a;
    }

    public void w() {
    }

    @Override
    public IChatBaseComponent X() {
        return new ChatComponentText(this.ct.getName());
    }

    public InventoryEnderChest fC() {
        return this.bU;
    }

    @Override
    public net.minecraft.world.item.ItemStack b(EnumItemSlot slot) {
        return slot == EnumItemSlot.a ? this.cp.f() : (slot == EnumItemSlot.b ? this.cp.j.get(0) : (slot.a() == EnumItemSlot.Function.b ? this.cp.i.get(slot.b()) : net.minecraft.world.item.ItemStack.b));
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.f(itemstack);
        if (enumitemslot == EnumItemSlot.a) {
            this.equipEventAndSound(itemstack, silent);
            this.cp.h.set(this.cp.k, itemstack);
        } else if (enumitemslot == EnumItemSlot.b) {
            this.equipEventAndSound(itemstack, silent);
            this.cp.j.set(0, itemstack);
        } else if (enumitemslot.a() == EnumItemSlot.Function.b) {
            this.equipEventAndSound(itemstack, silent);
            this.cp.i.set(enumitemslot.b(), itemstack);
        }
    }

    public boolean j(net.minecraft.world.item.ItemStack stack) {
        this.c(stack);
        return this.cp.e(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bB() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.er(), this.es()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bC() {
        return this.cp.i;
    }

    public boolean h(NBTTagCompound entityNbt) {
        if (!this.bF() && this.z && !this.aQ() && !this.am) {
            if (this.fG().f()) {
                this.i(entityNbt);
                this.f = this.t.V();
                return true;
            }
            if (this.fH().f()) {
                this.j(entityNbt);
                this.f = this.t.V();
                return true;
            }
            return false;
        }
        return false;
    }

    public void fD() {
        if (this.f + 20L < this.t.V()) {
            if (this.spawnEntityFromShoulder(this.fG())) {
                this.i(new NBTTagCompound());
            }
            if (this.spawnEntityFromShoulder(this.fH())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.spawnEntityFromShoulder0(this.fG());
        if (entity != null) {
            this.i(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.spawnEntityFromShoulder0(this.fH());
        if (entity != null) {
            this.j(new NBTTagCompound());
        }
        return entity;
    }

    private boolean spawnEntityFromShoulder(NBTTagCompound nbttagcompound) {
        return this.spawnEntityFromShoulder0(nbttagcompound) != null;
    }

    private Entity spawnEntityFromShoulder0(@Nullable NBTTagCompound nbttagcompound) {
        if (!this.t.y && nbttagcompound != null && !nbttagcompound.f()) {
            return EntityTypes.a(nbttagcompound, this.t).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.ak);
                }
                entity.e(this.dc(), this.de() + (double)0.7f, this.di());
                boolean addedToWorld = ((WorldServer)this.t).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
                return addedToWorld ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean B_();

    @Override
    public boolean bP() {
        return !this.cr.b && !this.B_() && super.bP();
    }

    public abstract boolean f();

    @Override
    public boolean cp() {
        return !this.cr.b;
    }

    public Scoreboard fE() {
        return this.t.K();
    }

    @Override
    public IChatBaseComponent C_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.bW(), this.X());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent component) {
        String s2 = this.fp().getName();
        return component.a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + s2 + " ")).a(this.cv()).a(s2));
    }

    @Override
    public String co() {
        return this.fp().getName();
    }

    @Override
    public float b(EntityPose pose, EntitySize dimensions) {
        switch (pose) {
            case d: 
            case b: 
            case e: {
                return 0.4f;
            }
            case f: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    @Override
    public void t(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.ai().b(d, Float.valueOf(amount));
    }

    @Override
    public float eI() {
        return this.ai().a(d).floatValue();
    }

    public static UUID a(GameProfile profile) {
        UUID uuid = profile.getId();
        if (uuid == null) {
            uuid = EntityHuman.c(profile.getName());
        }
        return uuid;
    }

    public static UUID c(String nickname) {
        return UUID.nameUUIDFromBytes((bF + nickname).getBytes(StandardCharsets.UTF_8));
    }

    public boolean a(PlayerModelPart modelPart) {
        return (this.ai().a(bQ) & modelPart.a()) == modelPart.a();
    }

    @Override
    public SlotAccess k(int mappedIndex) {
        if (mappedIndex >= 0 && mappedIndex < this.cp.h.size()) {
            return SlotAccess.a(this.cp, mappedIndex);
        }
        int j2 = mappedIndex - 200;
        return j2 >= 0 && j2 < this.bU.b() ? SlotAccess.a(this.bU, j2) : super.k(mappedIndex);
    }

    public boolean fF() {
        return this.cu;
    }

    public void t(boolean reducedDebugInfo) {
        this.cu = reducedDebugInfo;
    }

    @Override
    public void g(int ticks) {
        super.g(this.cr.a ? Math.min(ticks, 1) : ticks);
    }

    @Override
    public EnumMainHand eK() {
        return this.Z.a(bR) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void a(EnumMainHand arm) {
        this.Z.b(bR, (byte)(arm != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound fG() {
        return this.Z.a(bS);
    }

    public void i(NBTTagCompound entityNbt) {
        this.Z.b(bS, entityNbt);
    }

    public NBTTagCompound fH() {
        return this.Z.a(bT);
    }

    public void j(NBTTagCompound entityNbt) {
        this.Z.b(bT, entityNbt);
    }

    public float fI() {
        return (float)(1.0 / this.b(GenericAttributes.h) * 20.0);
    }

    public float v(float baseTime) {
        return MathHelper.a(((float)this.aR + baseTime) / this.fI(), 0.0f, 1.0f);
    }

    public void fJ() {
        this.aR = 0;
    }

    public ItemCooldown fK() {
        return this.cw;
    }

    @Override
    protected float aC() {
        return !this.cr.b && !this.eU() ? super.aC() : 1.0f;
    }

    public float fL() {
        return (float)this.b(GenericAttributes.k);
    }

    public boolean fM() {
        return this.cr.d && this.B() >= 2;
    }

    @Override
    public boolean g(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.i(stack);
        return this.b(enumitemslot).b();
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return b.getOrDefault((Object)pose, bP);
    }

    @Override
    public ImmutableList<EntityPose> eY() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack) {
        return !(this instanceof EntityPlayer) || new PlayerReadyArrowEvent((Player)((EntityPlayer)this).getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
    }

    @Override
    public net.minecraft.world.item.ItemStack h(net.minecraft.world.item.ItemStack stack) {
        if (!(stack.c() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.b;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)stack.c()).e();
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.b()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)stack.c()).b();
        for (int i2 = 0; i2 < this.cp.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.cp.a(i2);
            if (!predicate.test(itemstack2) || !this.tryReadyArrow(stack, itemstack2)) continue;
            return itemstack2;
        }
        return this.cr.d ? new net.minecraft.world.item.ItemStack(Items.mh) : net.minecraft.world.item.ItemStack.b;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(World world, net.minecraft.world.item.ItemStack stack) {
        this.fz().a(stack.c(), stack);
        this.b(StatisticList.c.b(stack.c()));
        world.a((EntityHuman)null, this.dc(), this.de(), this.di(), SoundEffects.oE, SoundCategory.h, 0.5f, world.w.nextFloat() * 0.1f + 0.9f);
        if (this instanceof EntityPlayer) {
            CriterionTriggers.z.a((EntityPlayer)this, stack);
        }
        return super.a(world, stack);
    }

    @Override
    protected boolean b(IBlockData landingState) {
        return this.cr.b || super.b(landingState);
    }

    @Override
    public Vec3D n(float delta) {
        float f3;
        double d0 = 0.22 * (this.eK() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.i(delta * 0.5f, this.dn(), this.y) * ((float)Math.PI / 180);
        float f2 = MathHelper.i(delta, this.aZ, this.aY) * ((float)Math.PI / 180);
        if (!this.eU() && !this.eG()) {
            if (this.bQ()) {
                return this.k(delta).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f2));
            }
            double d2 = this.cw().c() - 1.0;
            double d1 = this.bN() ? -0.2 : 0.07;
            return this.k(delta).e(new Vec3D(d0, d2, d1).b(-f2));
        }
        Vec3D vec3d = this.e(delta);
        Vec3D vec3d1 = this.da();
        double d1 = vec3d1.i();
        double d3 = vec3d.i();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.b * vec3d.b + vec3d1.d * vec3d.d) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.b * vec3d.d - vec3d1.d * vec3d.b;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.k(delta).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f2));
    }

    @Override
    public boolean ds() {
        return true;
    }

    public boolean fN() {
        return this.eL() && this.eN().a(Items.ot);
    }

    @Override
    public boolean dr() {
        return false;
    }

    public static enum EnumBedResult {
        a,
        b(new ChatMessage("block.minecraft.bed.no_sleep")),
        c(new ChatMessage("block.minecraft.bed.too_far_away")),
        d(new ChatMessage("block.minecraft.bed.obstructed")),
        e,
        f(new ChatMessage("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

