/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> e = entity -> entity.bl() && !(entity instanceof EntityRavager);
    private static final double bW = 0.3;
    private static final double bX = 0.35;
    private static final int bY = 8356754;
    private static final double bZ = 0.5725490196078431;
    private static final double ca = 0.5137254901960784;
    private static final double cb = 0.4980392156862745;
    private static final int cc = 10;
    public static final int b = 40;
    private int cd;
    private int ce;
    private int cf;

    public EntityRavager(EntityTypes<? extends EntityRavager> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
        this.P = 1.0f;
        this.bM = 20;
    }

    @Override
    protected void u() {
        super.u();
        this.bR.a(0, new PathfinderGoalFloat(this));
        this.bR.a(4, new a());
        this.bR.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.bR.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bR.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bS.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bS.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bS.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, entityliving -> !entityliving.y_()));
        this.bS.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void M() {
        boolean flag = !(this.cE() instanceof EntityInsentient) || this.cE().ad().a((Tag<EntityTypes<?>>)TagsEntity.c);
        boolean flag1 = !(this.cN() instanceof EntityBoat);
        this.bR.a(PathfinderGoal.Type.a, flag);
        this.bR.a(PathfinderGoal.Type.c, flag && flag1);
        this.bR.a(PathfinderGoal.Type.b, flag);
        this.bR.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder n() {
        return EntityMonster.fD().a(GenericAttributes.a, 100.0).a(GenericAttributes.d, 0.3).a(GenericAttributes.c, 0.75).a(GenericAttributes.f, 12.0).a(GenericAttributes.g, 1.5).a(GenericAttributes.b, 32.0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AttackTick", this.cd);
        nbt.a("StunTick", this.ce);
        nbt.a("RoarTick", this.cf);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.cd = nbt.h("AttackTick");
        this.ce = nbt.h("StunTick");
        this.cf = nbt.h("RoarTick");
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.pz;
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new b(this, world);
    }

    @Override
    public int U() {
        return 45;
    }

    @Override
    public double bq() {
        return 2.1;
    }

    @Override
    public boolean ff() {
        return !this.fr() && this.cE() instanceof EntityLiving;
    }

    @Override
    @Nullable
    public Entity cE() {
        return this.cG();
    }

    @Override
    public void w_() {
        super.w_();
        if (this.bl()) {
            if (this.ew()) {
                this.a(GenericAttributes.d).a(0.0);
            } else {
                double d0 = this.G() != null ? 0.35 : 0.3;
                double d1 = this.a(GenericAttributes.d).b();
                this.a(GenericAttributes.d).a(MathHelper.d(0.1, d1, d0));
            }
            if (this.A && this.t.X().b(GameRules.c)) {
                boolean flag = false;
                AxisAlignedBB axisalignedbb = this.cw().g(0.2);
                for (BlockPosition blockposition : BlockPosition.b(MathHelper.b(axisalignedbb.a), MathHelper.b(axisalignedbb.b), MathHelper.b(axisalignedbb.c), MathHelper.b(axisalignedbb.d), MathHelper.b(axisalignedbb.e), MathHelper.b(axisalignedbb.f))) {
                    IBlockData iblockdata = this.t.a_(blockposition);
                    Block block = iblockdata.b();
                    if (!(block instanceof BlockLeaves) || CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.n()).isCancelled()) continue;
                    flag = this.t.a(blockposition, true, (Entity)this) || flag;
                }
                if (!flag && this.z) {
                    this.ez();
                }
            }
            if (this.cf > 0) {
                --this.cf;
                if (this.cf == 10) {
                    this.fK();
                }
            }
            if (this.cd > 0) {
                --this.cd;
            }
            if (this.ce > 0) {
                --this.ce;
                this.fJ();
                if (this.ce == 0) {
                    this.a(SoundEffects.pE, 1.0f, 1.0f);
                    this.cf = 20;
                }
            }
        }
    }

    private void fJ() {
        if (this.R.nextInt(6) == 0) {
            double d0 = this.dc() - (double)this.cT() * Math.sin(this.aY * ((float)Math.PI / 180)) + (this.R.nextDouble() * 0.6 - 0.3);
            double d1 = this.de() + (double)this.cU() - 0.3;
            double d2 = this.di() + (double)this.cT() * Math.cos(this.aY * ((float)Math.PI / 180)) + (this.R.nextDouble() * 0.6 - 0.3);
            this.t.a(Particles.v, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    @Override
    protected boolean ew() {
        return super.ew() || this.cd > 0 || this.ce > 0 || this.cf > 0;
    }

    @Override
    public boolean B(Entity entity) {
        return this.ce <= 0 && this.cf <= 0 ? super.B(entity) : false;
    }

    @Override
    protected void e(EntityLiving target) {
        if (this.cf == 0) {
            if (this.R.nextDouble() < 0.5) {
                this.ce = 40;
                this.a(SoundEffects.pD, 1.0f, 1.0f);
                this.t.a((Entity)this, (byte)39);
                target.g((Entity)this);
            } else {
                this.a((Entity)target);
            }
            target.D = true;
        }
    }

    private void fK() {
        if (this.bl()) {
            List<Entity> list = this.t.a(EntityLiving.class, this.cw().g(4.0), e);
            for (EntityLiving entityLiving : list) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.a(DamageSource.c(this), 6.0f);
                }
                this.a((Entity)entityLiving);
            }
            Vec3D vec3d = this.cw().f();
            for (int i2 = 0; i2 < 40; ++i2) {
                double d0 = this.R.nextGaussian() * 0.2;
                double d1 = this.R.nextGaussian() * 0.2;
                double d2 = this.R.nextGaussian() * 0.2;
                this.t.a(Particles.R, vec3d.b, vec3d.c, vec3d.d, d0, d1, d2);
            }
            this.t.a((Entity)this, GameEvent.K, this.cY());
        }
    }

    private void a(Entity entity) {
        double d0 = entity.dc() - this.dc();
        double d1 = entity.di() - this.di();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.i(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    @Override
    public void a(byte status) {
        if (status == 4) {
            this.cd = 10;
            this.a(SoundEffects.py, 1.0f, 1.0f);
        } else if (status == 39) {
            this.ce = 40;
        }
        super.a(status);
    }

    public int q() {
        return this.cd;
    }

    public int fy() {
        return this.ce;
    }

    public int fI() {
        return this.cf;
    }

    @Override
    public boolean z(Entity target) {
        this.cd = 10;
        this.t.a((Entity)this, (byte)4);
        this.a(SoundEffects.py, 1.0f, 1.0f);
        return super.z(target);
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        return SoundEffects.px;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.pB;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.pA;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.pC, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader world) {
        return !world.d(this.cw());
    }

    @Override
    public void a(int wave, boolean unused) {
    }

    @Override
    public boolean fz() {
        return false;
    }

    private class a
    extends PathfinderGoalMeleeAttack {
        public a() {
            super(EntityRavager.this, 1.0, true);
        }

        @Override
        protected double a(EntityLiving entity) {
            float f2 = EntityRavager.this.cT() - 0.1f;
            return f2 * 2.0f * f2 * 2.0f + entity.cT();
        }
    }

    private static class b
    extends Navigation {
        public b(EntityInsentient mob, World world) {
            super(mob, world);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new c();
            return new Pathfinder(this.o, range);
        }
    }

    private static class c
    extends PathfinderNormal {
        c() {
        }

        @Override
        protected PathType a(IBlockAccess world, boolean canOpenDoors, boolean canEnterOpenDoors, BlockPosition pos, PathType type) {
            return type == PathType.w ? PathType.b : super.a(world, canOpenDoors, canEnterOpenDoors, pos, type);
        }
    }
}

