/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityEvoker
extends EntityIllagerWizard {
    @Nullable
    private EntitySheep e;

    public EntityEvoker(EntityTypes<? extends EntityEvoker> type, World world) {
        super((EntityTypes<? extends EntityIllagerWizard>)type, world);
        this.bM = 10;
    }

    @Override
    @Override
    protected void u() {
        super.u();
        this.bR.a(0, new PathfinderGoalFloat(this));
        this.bR.a(1, new b());
        this.bR.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 0.6, 1.0));
        this.bR.a(4, new c());
        this.bR.a(5, new a());
        this.bR.a(6, new d());
        this.bR.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bR.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bR.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bS.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bS.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bS.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bS.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false));
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fD().a(GenericAttributes.d, 0.5).a(GenericAttributes.b, 12.0).a(GenericAttributes.a, 24.0);
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
    }

    @Override
    @Override
    public SoundEffect t() {
        return SoundEffects.fK;
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
    }

    @Override
    @Override
    protected void R() {
        super.R();
    }

    @Override
    @Override
    public boolean p(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.p(other)) {
            return true;
        }
        if (other instanceof EntityVex) {
            return this.p(((EntityVex)other).q());
        }
        if (other instanceof EntityLiving && ((EntityLiving)other).eq() == EnumMonsterType.d) {
            return this.bW() == null && other.bW() == null;
        }
        return false;
    }

    @Override
    @Override
    protected SoundEffect r() {
        return SoundEffects.fI;
    }

    @Override
    @Override
    public SoundEffect x_() {
        return SoundEffects.fL;
    }

    @Override
    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.fN;
    }

    public void a(@Nullable EntitySheep sheep) {
        this.e = sheep;
    }

    @Nullable
    public EntitySheep fR() {
        return this.e;
    }

    @Override
    @Override
    protected SoundEffect fy() {
        return SoundEffects.fJ;
    }

    @Override
    @Override
    public void a(int wave, boolean unused) {
    }

    class b
    extends EntityIllagerWizard.b {
        b() {
            super(EntityEvoker.this);
        }

        @Override
        @Override
        public void e() {
            if (EntityEvoker.this.G() != null) {
                EntityEvoker.this.z().a(EntityEvoker.this.G(), (float)EntityEvoker.this.U(), (float)EntityEvoker.this.T());
            } else if (EntityEvoker.this.fR() != null) {
                EntityEvoker.this.z().a(EntityEvoker.this.fR(), (float)EntityEvoker.this.U(), (float)EntityEvoker.this.T());
            }
        }
    }

    class c
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        c() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).d().e();
        }

        @Override
        @Override
        public boolean a() {
            if (!super.a()) {
                return false;
            }
            int i2 = EntityEvoker.this.t.a(EntityVex.class, this.e, EntityEvoker.this, EntityEvoker.this.cw().g(16.0)).size();
            return EntityEvoker.this.R.nextInt(8) + 1 > i2;
        }

        @Override
        @Override
        protected int g() {
            return 100;
        }

        @Override
        @Override
        protected int i() {
            return 340;
        }

        @Override
        @Override
        protected void k() {
            WorldServer serverLevel = (WorldServer)EntityEvoker.this.t;
            for (int i2 = 0; i2 < 3; ++i2) {
                BlockPosition blockPos = EntityEvoker.this.cW().b(-2 + EntityEvoker.this.R.nextInt(5), 1, -2 + EntityEvoker.this.R.nextInt(5));
                EntityVex vex = EntityTypes.aU.a(EntityEvoker.this.t);
                vex.a(blockPos, 0.0f, 0.0f);
                vex.a(serverLevel, EntityEvoker.this.t.d_(blockPos), EnumMobSpawn.f, null, null);
                vex.a(EntityEvoker.this);
                vex.g(blockPos);
                vex.a(20 * (30 + EntityEvoker.this.R.nextInt(90)));
                serverLevel.a_(vex);
            }
        }

        @Override
        @Override
        protected SoundEffect l() {
            return SoundEffects.fP;
        }

        @Override
        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.b;
        }
    }

    class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        a() {
            super(EntityEvoker.this);
        }

        @Override
        @Override
        protected int g() {
            return 40;
        }

        @Override
        @Override
        protected int i() {
            return 100;
        }

        @Override
        @Override
        protected void k() {
            EntityLiving livingEntity = EntityEvoker.this.G();
            double d2 = Math.min(livingEntity.de(), EntityEvoker.this.de());
            double e2 = Math.max(livingEntity.de(), EntityEvoker.this.de()) + 1.0;
            float f2 = (float)MathHelper.d(livingEntity.di() - EntityEvoker.this.di(), livingEntity.dc() - EntityEvoker.this.dc());
            if (EntityEvoker.this.f((Entity)livingEntity) < 9.0) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    float g2 = f2 + (float)i2 * (float)Math.PI * 0.4f;
                    this.a(EntityEvoker.this.dc() + (double)MathHelper.b(g2) * 1.5, EntityEvoker.this.di() + (double)MathHelper.a(g2) * 1.5, d2, e2, g2, 0);
                }
                for (int j2 = 0; j2 < 8; ++j2) {
                    float h2 = f2 + (float)j2 * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.a(EntityEvoker.this.dc() + (double)MathHelper.b(h2) * 2.5, EntityEvoker.this.di() + (double)MathHelper.a(h2) * 2.5, d2, e2, h2, 3);
                }
            } else {
                for (int k2 = 0; k2 < 16; ++k2) {
                    double l2 = 1.25 * (double)(k2 + 1);
                    int m2 = 1 * k2;
                    this.a(EntityEvoker.this.dc() + (double)MathHelper.b(f2) * l2, EntityEvoker.this.di() + (double)MathHelper.a(f2) * l2, d2, e2, f2, m2);
                }
            }
        }

        private void a(double x2, double z2, double maxY, double y2, float yaw, int warmup) {
            BlockPosition blockPos = new BlockPosition(x2, y2, z2);
            boolean bl = false;
            double d2 = 0.0;
            do {
                IBlockData blockState2;
                VoxelShape voxelShape;
                BlockPosition blockPos2;
                IBlockData blockState;
                if (!(blockState = EntityEvoker.this.t.a_(blockPos2 = blockPos.c())).d(EntityEvoker.this.t, blockPos2, EnumDirection.b)) continue;
                if (!EntityEvoker.this.t.w(blockPos) && !(voxelShape = (blockState2 = EntityEvoker.this.t.a_(blockPos)).k(EntityEvoker.this.t, blockPos)).b()) {
                    d2 = voxelShape.c(EnumDirection.EnumAxis.b);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.c()).v() >= MathHelper.b(maxY) - 1);
            if (bl) {
                EntityEvoker.this.t.b(new EntityEvokerFangs(EntityEvoker.this.t, x2, (double)blockPos.v() + d2, z2, yaw, warmup, EntityEvoker.this));
            }
        }

        @Override
        @Override
        protected SoundEffect l() {
            return SoundEffects.fO;
        }

        @Override
        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.c;
        }
    }

    public class d
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private final PathfinderTargetCondition e;

        public d() {
            super(EntityEvoker.this);
            this.e = PathfinderTargetCondition.b().a(16.0).a((EntityLiving livingEntity) -> ((EntitySheep)livingEntity).t() == EnumColor.l);
        }

        @Override
        @Override
        public boolean a() {
            if (EntityEvoker.this.G() != null) {
                return false;
            }
            if (EntityEvoker.this.fI()) {
                return false;
            }
            if (EntityEvoker.this.S < this.c) {
                return false;
            }
            if (!EntityEvoker.this.t.X().b(GameRules.c)) {
                return false;
            }
            List<EntitySheep> list = EntityEvoker.this.t.a(EntitySheep.class, this.e, EntityEvoker.this, EntityEvoker.this.cw().c(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.a(list.get(EntityEvoker.this.R.nextInt(list.size())));
            return true;
        }

        @Override
        @Override
        public boolean b() {
            return EntityEvoker.this.fR() != null && this.b > 0;
        }

        @Override
        @Override
        public void d() {
            super.d();
            EntityEvoker.this.a((EntitySheep)null);
        }

        @Override
        @Override
        protected void k() {
            EntitySheep sheep = EntityEvoker.this.fR();
            if (sheep != null && sheep.bl()) {
                sheep.b(EnumColor.o);
            }
        }

        @Override
        @Override
        protected int n() {
            return 40;
        }

        @Override
        @Override
        protected int g() {
            return 60;
        }

        @Override
        @Override
        protected int i() {
            return 140;
        }

        @Override
        @Override
        protected SoundEffect l() {
            return SoundEffects.fQ;
        }

        @Override
        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.d;
        }
    }
}

