/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.CreeperIgniteEvent;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.Creeper;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster
implements PowerableMob {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.i);
    private int e;
    public int bW;
    public int bX = 30;
    public int bY = 3;
    private int bZ;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void u() {
        this.bR.a(1, new PathfinderGoalFloat(this));
        this.bR.a(2, new PathfinderGoalSwell(this));
        this.bR.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bR.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bR.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bR.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bR.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bR.a(6, new PathfinderGoalRandomLookaround(this));
        this.bS.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bS.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder n() {
        return EntityMonster.fD().a(GenericAttributes.d, 0.25);
    }

    @Override
    public int cj() {
        return this.G() == null ? 3 : 3 + (int)(this.dZ() - 1.0f);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        this.bW = (int)((float)this.bW + fallDistance * 1.5f);
        if (this.bW > this.bX - 5) {
            this.bW = this.bX - 5;
        }
        return flag;
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(b, -1);
        this.Z.a(c, false);
        this.Z.a(d, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.Z.a(c).booleanValue()) {
            nbt.a("powered", true);
        }
        nbt.a("Fuse", (short)this.bX);
        nbt.a("ExplosionRadius", (byte)this.bY);
        nbt.a("ignited", this.t());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.Z.b(c, nbt.q("powered"));
        if (nbt.b("Fuse", 99)) {
            this.bX = nbt.g("Fuse");
        }
        if (nbt.b("ExplosionRadius", 99)) {
            this.bY = nbt.f("ExplosionRadius");
        }
        if (nbt.q("ignited")) {
            this.fy();
        }
    }

    @Override
    public void k() {
        if (this.bl()) {
            int i2;
            this.e = this.bW;
            if (this.t()) {
                this.a(1);
            }
            if ((i2 = this.q()) > 0 && this.bW == 0) {
                this.a(SoundEffects.dE, 1.0f, 0.5f);
                this.a(GameEvent.H);
            }
            this.bW += i2;
            if (this.bW < 0) {
                this.bW = 0;
            }
            if (this.bW >= this.bX) {
                this.bW = this.bX;
                this.fB();
            }
        }
        super.k();
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (!(target instanceof Goat)) {
            super.h(target);
        }
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.dD;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.dC;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        EntityCreeper entitycreeper;
        super.a(source, lootingMultiplier, allowDrops);
        Entity entity = source.l();
        if (entity != this && entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).fz()) {
            entitycreeper.fA();
            this.a((IMaterial)Items.rv);
        }
    }

    @Override
    public boolean z(Entity target) {
        return true;
    }

    @Override
    public boolean a() {
        return this.Z.a(c);
    }

    public float z(float timeDelta) {
        return MathHelper.i(timeDelta, this.e, this.bW) / (float)(this.bX - 2);
    }

    public int q() {
        return this.Z.a(b);
    }

    public void a(int fuseSpeed) {
        this.Z.b(b, fuseSpeed);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        super.a(world, lightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, lightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.setPowered(true);
    }

    public void setPowered(boolean powered) {
        this.Z.b(c, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.me)) {
            this.t.a(player, this.dc(), this.de(), this.di(), SoundEffects.gk, this.cO(), 1.0f, this.R.nextFloat() * 0.4f + 0.8f);
            if (!this.t.y) {
                this.fy();
                itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
            }
            return EnumInteractionResult.a(this.t.y);
        }
        return super.b(player, hand);
    }

    public void fB() {
        if (!this.t.y) {
            Explosion.Effect explosion_effect = this.t.X().b(GameRules.c) ? Explosion.Effect.c : Explosion.Effect.a;
            float f2 = this.a() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)this.bY * f2, false);
            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.bf = true;
                this.t.a(this, this.dc(), this.de(), this.di(), event.getRadius(), event.getFire(), explosion_effect);
                this.ah();
                this.fE();
            } else {
                this.bW = 0;
                this.Z.b(d, false);
            }
        }
    }

    private void fE() {
        Collection<MobEffect> collection = this.dW();
        if (!collection.isEmpty() && !this.t.paperConfig.disableCreeperLingeringEffect) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.t, this.dc(), this.de(), this.di());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.b(-0.5f);
            entityareaeffectcloud.d(10);
            entityareaeffectcloud.b(entityareaeffectcloud.n() / 2);
            entityareaeffectcloud.c(-entityareaeffectcloud.h() / (float)entityareaeffectcloud.n());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.t.addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean t() {
        return this.Z.a(d);
    }

    public void fy() {
        this.setIgnited(true);
    }

    public void setIgnited(boolean ignited) {
        CreeperIgniteEvent event;
        if (this.t() != ignited && (event = new CreeperIgniteEvent((Creeper)this.getBukkitEntity(), ignited)).callEvent()) {
            this.Z.b(d, event.isIgnited());
        }
    }

    public boolean fz() {
        return this.a() && this.bZ < 1;
    }

    public void fA() {
        ++this.bZ;
    }
}

