/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.g);
    private static final int d = 6000;
    private static final int e = Short.MAX_VALUE;
    private static final int f = Short.MIN_VALUE;
    public int ap;
    public int aq;
    public int ar = 5;
    @Nullable
    private UUID as;
    @Nullable
    private UUID at;
    public final float b;
    private int lastTick = MinecraftServer.currentTick - 1;
    public boolean canMobPickup = true;

    public EntityItem(EntityTypes<? extends EntityItem> type, World world) {
        super(type, world);
        this.b = this.R.nextFloat() * (float)Math.PI * 2.0f;
        this.o(this.R.nextFloat() * 360.0f);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack) {
        this(world, x2, y2, z2, stack, world.w.nextDouble() * 0.2 - 0.1, 0.2, world.w.nextDouble() * 0.2 - 0.1);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.Q, world);
        this.e(x2, y2, z2);
        this.n(velocityX, velocityY, velocityZ);
        this.a(stack);
    }

    private EntityItem(EntityItem entity) {
        super(entity.ad(), entity.t);
        this.a(entity.h().m());
        this.s(entity);
        this.ap = entity.ap;
        this.b = entity.b;
    }

    @Override
    public boolean aO() {
        return TagsItem.as.a(this.h().c());
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.ai().a(c, ItemStack.b);
    }

    @Override
    public void k() {
        if (this.h().b()) {
            this.ah();
        } else {
            double d0;
            int i2;
            super.k();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.aq != Short.MAX_VALUE) {
                this.aq -= elapsedTicks;
            }
            this.aq = Math.max(0, this.aq);
            if (this.ap != Short.MIN_VALUE) {
                this.ap += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.u = this.dc();
            this.v = this.de();
            this.w = this.di();
            Vec3D vec3d = this.da();
            float f2 = this.cy() - 0.11111111f;
            if (this.aQ() && this.b(TagsFluid.b) > (double)f2) {
                this.x();
            } else if (this.bc() && this.b(TagsFluid.c) > (double)f2) {
                this.y();
            } else if (!this.aM()) {
                this.g(this.da().b(0.0, -0.04, 0.0));
            }
            if (this.t.y) {
                this.Q = false;
            } else {
                boolean bl = this.Q = !this.t.a((Entity)this, this.cw().h(1.0E-7));
                if (this.Q) {
                    this.l(this.dc(), (this.cw().b + this.cw().e) / 2.0, this.di());
                }
            }
            if (!this.z || this.da().i() > (double)1.0E-5f || this.S % 4 == 0) {
                this.a(EnumMoveType.a, this.da());
                float f1 = 0.98f;
                if (this.z) {
                    f1 = this.t.a_(new BlockPosition(this.dc(), this.de() - 1.0, this.di())).b().i() * 0.98f;
                }
                this.g(this.da().d(f1, 0.98, f1));
                if (this.z) {
                    Vec3D vec3d1 = this.da();
                    if (vec3d1.c < 0.0) {
                        this.g(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.b(this.u) != MathHelper.b(this.dc()) || MathHelper.b(this.v) != MathHelper.b(this.de()) || MathHelper.b(this.w) != MathHelper.b(this.di());
            int n2 = i2 = flag ? 2 : 40;
            if (this.S % i2 == 0 && !this.t.y && this.A()) {
                this.z();
            }
            this.ag |= this.aW();
            if (!this.t.y && (d0 = this.da().d(vec3d).g()) > 0.01) {
                this.ag = true;
            }
            if (!this.t.y && this.ap >= this.getDespawnRate()) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.ap = 0;
                    return;
                }
                this.ah();
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.aq != Short.MAX_VALUE) {
            this.aq -= elapsedTicks;
        }
        this.aq = Math.max(0, this.aq);
        if (this.ap != Short.MIN_VALUE) {
            this.ap += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.t.y && this.ap >= this.getDespawnRate()) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.ap = 0;
                return;
            }
            this.ah();
        }
    }

    private void x() {
        Vec3D vec3d = this.da();
        this.n(vec3d.b * (double)0.99f, vec3d.c + (double)(vec3d.c < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.d * (double)0.99f);
    }

    private void y() {
        Vec3D vec3d = this.da();
        this.n(vec3d.b * (double)0.95f, vec3d.c + (double)(vec3d.c < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.d * (double)0.95f);
    }

    private void z() {
        if (this.A()) {
            ItemStack stack = this.h();
            if (stack.I() >= stack.d()) {
                return;
            }
            double radius = this.t.spigotConfig.itemMerge;
            List<EntityItem> list = this.t.a(EntityItem.class, this.cw().c(radius, radius, radius), (? super T entityitem) -> entityitem != this && entityitem.A());
            for (EntityItem entityitem2 : list) {
                RayTrace rayTrace;
                MovingObjectPositionBlock rayTraceResult;
                if (!entityitem2.A() || this.t.paperConfig.fixItemsMergingThroughWalls && (rayTraceResult = this.t.a(rayTrace = new RayTrace(this.cV(), entityitem2.cV(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this))).c() == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(entityitem2);
                if (!this.do()) continue;
                break;
            }
        }
    }

    private boolean A() {
        ItemStack itemstack = this.h();
        return this.bl() && this.aq != Short.MAX_VALUE && this.ap != Short.MIN_VALUE && this.ap < this.getDespawnRate() && itemstack.I() < itemstack.d();
    }

    private void a(EntityItem other) {
        ItemStack itemstack = this.h();
        ItemStack itemstack1 = other.h();
        if (Objects.equals(this.i(), other.i()) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, other, itemstack1);
        }
    }

    public static boolean a(ItemStack stack1, ItemStack stack2) {
        return !stack2.a(stack1.c()) ? false : (stack2.I() + stack1.I() > stack2.d() ? false : (stack2.r() ^ stack1.r() ? false : !stack2.r() || stack2.s().equals(stack1.s())));
    }

    public static ItemStack a(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j2 = Math.min(Math.min(stack1.d(), maxCount) - stack1.I(), stack2.I());
        ItemStack itemstack2 = stack1.m();
        itemstack2.f(j2);
        stack2.g(j2);
        return itemstack2;
    }

    private static void a(EntityItem targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = EntityItem.a(stack1, stack2, 64);
        if (!itemstack2.b()) {
            targetEntity.a(itemstack2);
        }
    }

    private static void a(EntityItem targetEntity, ItemStack targetStack, EntityItem sourceEntity, ItemStack sourceStack) {
        if (CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity).isCancelled()) {
            return;
        }
        EntityItem.a(targetEntity, targetStack, sourceStack);
        targetEntity.aq = Math.max(targetEntity.aq, sourceEntity.aq);
        targetEntity.ap = Math.min(targetEntity.ap, sourceEntity.ap);
        if (sourceStack.b()) {
            sourceEntity.ah();
        }
    }

    @Override
    public boolean aP() {
        return this.h().c().w() || super.aP();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.h().b() && this.h().a(Items.rx) && source.d()) {
            return false;
        }
        if (!this.h().c().a(source)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.bf();
        this.ar = (int)((float)this.ar - amount);
        this.a(GameEvent.r, source.l());
        if (this.ar <= 0) {
            this.h().a(this);
            this.ah();
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        nbt.a("Health", (short)this.ar);
        nbt.a("Age", (short)this.ap);
        nbt.a("PickupDelay", (short)this.aq);
        if (this.j() != null) {
            nbt.a("Thrower", this.j());
        }
        if (this.i() != null) {
            nbt.a("Owner", this.i());
        }
        if (!this.h().b()) {
            nbt.a("Item", this.h().b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.ar = nbt.g("Health");
        this.ap = nbt.g("Age");
        if (nbt.e("PickupDelay")) {
            this.aq = nbt.g("PickupDelay");
        }
        if (nbt.b("Owner")) {
            this.at = nbt.a("Owner");
        }
        if (nbt.b("Thrower")) {
            this.as = nbt.a("Thrower");
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Item");
        this.a(ItemStack.a(nbttagcompound1));
        if (this.h().b()) {
            this.ah();
        }
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.t.y) {
            ItemStack itemstack = this.h();
            Item item = itemstack.c();
            int i2 = itemstack.I();
            int canHold = player.fq().canHold(itemstack);
            int remaining = i2 - canHold;
            boolean flyAtPlayer = false;
            if (this.aq <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.t.getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
            }
            if (this.aq <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.t.getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.e(i2);
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.t.getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                ItemStack current = this.h();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.e(canHold + remaining);
                }
                this.aq = 0;
            } else if (this.aq == 0) {
                this.aq = -1;
            }
            if (this.aq == 0 && (this.at == null || this.at.equals(player.cm())) && player.fq().e(itemstack)) {
                if (flyAtPlayer) {
                    player.a((Entity)this, i2);
                }
                if (itemstack.b()) {
                    this.ah();
                    itemstack.e(i2);
                }
                player.a(StatisticList.e.b(item), i2);
                player.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent X() {
        IChatBaseComponent ichatbasecomponent = this.Z();
        return ichatbasecomponent != null ? ichatbasecomponent : new ChatMessage(this.h().n());
    }

    @Override
    public boolean cf() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        Entity entity = super.b(destination);
        if (!this.t.y && entity instanceof EntityItem) {
            ((EntityItem)entity).z();
        }
        return entity;
    }

    public ItemStack h() {
        return this.ai().a(c);
    }

    public void a(ItemStack stack) {
        Preconditions.checkArgument((!stack.b() ? 1 : 0) != 0, (Object)"Cannot drop air");
        this.ai().b(c, stack);
        this.ai().markDirty(c);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (c.equals(data)) {
            this.h().a((Entity)this);
        }
    }

    @Nullable
    public UUID i() {
        return this.at;
    }

    public void b(@Nullable UUID uuid) {
        this.at = uuid;
    }

    @Nullable
    public UUID j() {
        return this.as;
    }

    public void c(@Nullable UUID uuid) {
        this.as = uuid;
    }

    public int l() {
        return this.ap;
    }

    public void n() {
        this.aq = 10;
    }

    public void o() {
        this.aq = 0;
    }

    public void q() {
        this.aq = Short.MAX_VALUE;
    }

    public void a(int pickupDelay) {
        this.aq = pickupDelay;
    }

    public boolean r() {
        return this.aq > 0;
    }

    public void s() {
        this.ap = Short.MIN_VALUE;
    }

    public void t() {
        this.ap = -6000;
    }

    public void u() {
        this.q();
        this.ap = this.getDespawnRate() - 1;
    }

    public int getDespawnRate() {
        Material material = this.h().getBukkitStack().getType();
        return this.t.paperConfig.altItemDespawnRateMap.getOrDefault(material, this.t.spigotConfig.itemDespawnRate);
    }

    public float a(float tickDelta) {
        return ((float)this.l() + tickDelta) / 20.0f + this.b;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    public EntityItem w() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.i;
    }
}

