/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWither
extends EntityMonster
implements PowerableMob,
IRangedEntity {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> e = ImmutableList.of(b, c, d);
    private static final DataWatcherObject<Integer> bW = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int bX = 220;
    private final float[] bY = new float[2];
    private final float[] bZ = new float[2];
    private final float[] ca = new float[2];
    private final float[] cb = new float[2];
    private final int[] cc = new int[2];
    private final int[] cd = new int[2];
    private int ce;
    public final BossBattleServer cf = (BossBattleServer)new BossBattleServer(this.C_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final Predicate<EntityLiving> cg = entityliving -> entityliving.eq() != EnumMonsterType.b && entityliving.eX();
    private static final PathfinderTargetCondition ch = PathfinderTargetCondition.a().a(20.0).a(cg);
    private boolean canPortal = false;

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    public EntityWither(EntityTypes<? extends EntityWither> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.bO = new ControllerMoveFlying(this, 10, false);
        this.c(this.el());
        this.bM = 50;
    }

    @Override
    protected NavigationAbstract a(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.a(false);
        navigationflying.d(true);
        navigationflying.b(true);
        return navigationflying;
    }

    @Override
    protected void u() {
        this.bR.a(0, new a());
        this.bR.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.bR.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.bR.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bR.a(7, new PathfinderGoalRandomLookaround(this));
        this.bS.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bS.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, cg));
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(b, 0);
        this.Z.a(c, 0);
        this.Z.a(d, 0);
        this.Z.a(bW, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Invul", this.t());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.s(nbt.h("Invul"));
        if (this.Y()) {
            this.cf.a(this.C_());
        }
    }

    @Override
    public void a(@Nullable IChatBaseComponent name) {
        super.a(name);
        this.cf.a(this.C_());
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.uT;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.uW;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.uV;
    }

    @Override
    public void w_() {
        int j2;
        int i2;
        Entity entity;
        Vec3D vec3d = this.da().d(1.0, 0.6, 1.0);
        if (!this.t.y && this.t(0) > 0 && (entity = this.t.a(this.t(0))) != null) {
            double d0 = vec3d.c;
            if (this.de() < entity.de() || !this.a() && this.de() < entity.de() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3D(vec3d.b, d0, vec3d.d);
            Vec3D vec3d1 = new Vec3D(entity.dc() - this.dc(), 0.0, entity.di() - this.di());
            if (vec3d1.i() > 9.0) {
                Vec3D vec3d2 = vec3d1.d();
                vec3d = vec3d.b(vec3d2.b * 0.3 - vec3d.b * 0.6, 0.0, vec3d2.d * 0.3 - vec3d.d * 0.6);
            }
        }
        this.g(vec3d);
        if (vec3d.i() > 0.05) {
            this.o((float)MathHelper.d(vec3d.d, vec3d.b) * 57.295776f - 90.0f);
        }
        super.w_();
        for (i2 = 0; i2 < 2; ++i2) {
            this.cb[i2] = this.bZ[i2];
            this.ca[i2] = this.bY[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int j3 = this.t(i2 + 1);
            Entity entity1 = null;
            if (j3 > 0) {
                entity1 = this.t.a(j3);
            }
            if (entity1 != null) {
                double d1 = this.u(i2 + 1);
                double d2 = this.v(i2 + 1);
                double d3 = this.w(i2 + 1);
                double d4 = entity1.dc() - d1;
                double d5 = entity1.dg() - d2;
                double d6 = entity1.di() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f2 = (float)(MathHelper.d(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d5, d7) * 57.2957763671875));
                this.bY[i2] = this.a(this.bY[i2], f1, 40.0f);
                this.bZ[i2] = this.a(this.bZ[i2], f2, 10.0f);
                continue;
            }
            this.bZ[i2] = this.a(this.bZ[i2], this.aY, 10.0f);
        }
        boolean flag = this.a();
        for (j2 = 0; j2 < 3; ++j2) {
            double d8 = this.u(j2);
            double d9 = this.v(j2);
            double d10 = this.w(j2);
            this.t.a(Particles.U, d8 + this.R.nextGaussian() * (double)0.3f, d9 + this.R.nextGaussian() * (double)0.3f, d10 + this.R.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
            if (!flag || this.t.w.nextInt(4) != 0) continue;
            this.t.a(Particles.v, d8 + this.R.nextGaussian() * (double)0.3f, d9 + this.R.nextGaussian() * (double)0.3f, d10 + this.R.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
        }
        if (this.t() > 0) {
            for (j2 = 0; j2 < 3; ++j2) {
                this.t.a(Particles.v, this.dc() + this.R.nextGaussian(), this.de() + (double)(this.R.nextFloat() * 3.3f), this.di() + this.R.nextGaussian(), (double)0.7f, (double)0.7f, 0.9f);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void R() {
        if (this.t() > 0) {
            int i2 = this.t() - 1;
            this.cf.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                Explosion.Effect explosion_effect = this.t.X().b(GameRules.c) ? Explosion.Effect.c : Explosion.Effect.a;
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.t.a(this, this.dc(), this.dg(), this.di(), event.getRadius(), event.getFire(), explosion_effect);
                }
                if (!this.aL()) {
                    for (EntityPlayer entityPlayer : this.t.z()) {
                        int viewDistance = entityPlayer.getViewDistance();
                        double deltaX = this.dc() - entityPlayer.dc();
                        double deltaZ = this.di() - entityPlayer.di();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        if (this.t.spigotConfig.witherSpawnSoundRadius > 0 && distanceSquared > (double)(this.t.spigotConfig.witherSpawnSoundRadius * this.t.spigotConfig.witherSpawnSoundRadius)) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = entityPlayer.dc() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = entityPlayer.di() + deltaZ / deltaLength * (double)viewDistance;
                            entityPlayer.b.a(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.de(), (int)relativeZ), 0, true));
                            continue;
                        }
                        entityPlayer.b.a(new PacketPlayOutWorldEvent(1023, this.cW(), 0, true));
                    }
                }
            }
            this.s(i2);
            if (this.S % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int i3;
            super.R();
            for (i3 = 1; i3 < 3; ++i3) {
                EntityLiving entityliving1;
                int j2;
                if (this.S < this.cc[i3 - 1]) continue;
                this.cc[i3 - 1] = this.S + 10 + this.R.nextInt(10);
                if (this.t.af() == EnumDifficulty.c || this.t.af() == EnumDifficulty.d) {
                    int k2 = i3 - 1;
                    int l2 = this.cd[i3 - 1];
                    this.cd[k2] = this.cd[i3 - 1] + 1;
                    if (l2 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.a(this.R, this.dc() - 10.0, this.dc() + 10.0);
                        double d1 = MathHelper.a(this.R, this.de() - 5.0, this.de() + 5.0);
                        double d2 = MathHelper.a(this.R, this.di() - 10.0, this.di() + 10.0);
                        this.a(i3 + 1, d0, d1, d2, true);
                        this.cd[i3 - 1] = 0;
                    }
                }
                if ((j2 = this.t(i3)) > 0) {
                    EntityLiving entityliving = (EntityLiving)this.t.a(j2);
                    if (entityliving != null && this.c(entityliving) && this.f((Entity)entityliving) <= 900.0 && this.B(entityliving)) {
                        this.a(i3 + 1, entityliving);
                        this.cc[i3 - 1] = this.S + 40 + this.R.nextInt(20);
                        this.cd[i3 - 1] = 0;
                        continue;
                    }
                    this.a(i3, 0);
                    continue;
                }
                List<EntityLiving> list = this.t.a(EntityLiving.class, ch, this, this.cw().c(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.R.nextInt(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(i3, entityliving1.ae());
            }
            if (this.G() != null) {
                this.a(0, this.G().ae());
            } else {
                this.a(0, 0);
            }
            if (this.ce > 0) {
                --this.ce;
                if (this.ce == 0 && this.t.X().b(GameRules.c)) {
                    void var5_16;
                    i3 = MathHelper.b(this.de());
                    int j2 = MathHelper.b(this.dc());
                    int i1 = MathHelper.b(this.di());
                    boolean flag = false;
                    int n2 = -1;
                    while (var5_16 <= true) {
                        for (int k1 = -1; k1 <= 1; ++k1) {
                            for (int l1 = 0; l1 <= 3; ++l1) {
                                int i2 = j2 + var5_16;
                                int j22 = i3 + l1;
                                int k2 = i1 + k1;
                                BlockPosition blockposition = new BlockPosition(i2, j22, k2);
                                IBlockData iblockdata = this.t.a_(blockposition);
                                if (!EntityWither.c(iblockdata) || CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.a.n()).isCancelled()) continue;
                                flag = this.t.a(blockposition, true, (Entity)this) || flag;
                            }
                        }
                        ++var5_16;
                    }
                    if (flag) {
                        this.t.a((EntityHuman)null, 1022, this.cW(), 0);
                    }
                }
            }
            if (this.S % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.cf.a(this.dZ() / this.el());
        }
    }

    public static boolean c(IBlockData block) {
        return !block.g() && !block.a(TagsBlock.ar);
    }

    public void n() {
        this.s(220);
        this.cf.a(0.0f);
        this.c(this.el() / 3.0f);
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
    }

    @Override
    public void c(EntityPlayer player) {
        super.c(player);
        this.cf.a(player);
    }

    @Override
    public void d(EntityPlayer player) {
        super.d(player);
        this.cf.b(player);
    }

    private double u(int headIndex) {
        if (headIndex <= 0) {
            return this.dc();
        }
        float f2 = (this.aY + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.b(f2);
        return this.dc() + (double)f1 * 1.3;
    }

    private double v(int headIndex) {
        return headIndex <= 0 ? this.de() + 3.0 : this.de() + 2.2;
    }

    private double w(int headIndex) {
        if (headIndex <= 0) {
            return this.di();
        }
        float f2 = (this.aY + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.a(f2);
        return this.di() + (double)f1 * 1.3;
    }

    private float a(float prevAngle, float desiredAngle, float maxDifference) {
        float f3 = MathHelper.g(desiredAngle - prevAngle);
        if (f3 > maxDifference) {
            f3 = maxDifference;
        }
        if (f3 < -maxDifference) {
            f3 = -maxDifference;
        }
        return prevAngle + f3;
    }

    private void a(int headIndex, EntityLiving target) {
        this.a(headIndex, target.dc(), target.de() + (double)target.cy() * 0.5, target.di(), headIndex == 0 && this.R.nextFloat() < 0.001f);
    }

    private void a(int headIndex, double targetX, double targetY, double targetZ, boolean charged) {
        if (!this.aL()) {
            this.t.a((EntityHuman)null, 1024, this.cW(), 0);
        }
        double d3 = this.u(headIndex);
        double d4 = this.v(headIndex);
        double d5 = this.w(headIndex);
        double d6 = targetX - d3;
        double d7 = targetY - d4;
        double d8 = targetZ - d5;
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.t, this, d6, d7, d8);
        entitywitherskull.b((Entity)this);
        if (charged) {
            entitywitherskull.a(true);
        }
        entitywitherskull.o(d3, d4, d5);
        this.t.b(entitywitherskull);
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.a(0, target);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source != DamageSource.h && !(source.l() instanceof EntityWither)) {
            Entity entity;
            if (this.t() > 0 && source != DamageSource.m) {
                return false;
            }
            if (this.a() && (entity = source.k()) instanceof EntityArrow) {
                return false;
            }
            entity = source.l();
            if (entity != null && !(entity instanceof EntityHuman) && entity instanceof EntityLiving && ((EntityLiving)entity).eq() == this.eq()) {
                return false;
            }
            if (this.ce <= 0) {
                this.ce = 20;
            }
            int i2 = 0;
            while (i2 < this.cd.length) {
                int n2 = i2++;
                this.cd[n2] = this.cd[n2] + 3;
            }
            return super.a(source, amount);
        }
        return false;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        EntityItem entityitem = this.a((IMaterial)Items.rx);
        if (entityitem != null) {
            entityitem.t();
        }
    }

    @Override
    public void dj() {
        if (this.t.af() == EnumDifficulty.a && this.P()) {
            this.ah();
        } else {
            this.bg = 0;
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fD().a(GenericAttributes.a, 300.0).a(GenericAttributes.d, 0.6f).a(GenericAttributes.e, 0.6f).a(GenericAttributes.b, 40.0).a(GenericAttributes.i, 4.0);
    }

    public float a(int headIndex) {
        return this.bZ[headIndex];
    }

    public float b(int headIndex) {
        return this.bY[headIndex];
    }

    public int t() {
        return this.Z.a(bW);
    }

    public void s(int ticks) {
        this.Z.b(bW, ticks);
    }

    public int t(int headIndex) {
        return this.Z.a(e.get(headIndex));
    }

    public void a(int headIndex, int id) {
        this.Z.b(e.get(headIndex), id);
    }

    @Override
    public boolean a() {
        return this.dZ() <= this.el() / 2.0f;
    }

    @Override
    public EnumMonsterType eq() {
        return EnumMonsterType.b;
    }

    @Override
    protected boolean l(Entity entity) {
        return false;
    }

    @Override
    public boolean ci() {
        return super.ci() && this.canPortal;
    }

    @Override
    public boolean c(MobEffect effect) {
        return effect.a() == MobEffects.t && this.t.paperConfig.witherImmuneToWitherEffect ? false : super.c(effect);
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityWither.this.t() > 0;
        }
    }
}

