/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger cb = LogManager.getLogger();
    public static final DataWatcherObject<Integer> b = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition cc = PathfinderTargetCondition.a().a(64.0);
    private static final int cd = 200;
    private static final int ce = 400;
    private static final float cf = 0.25f;
    private static final String cg = "DragonDeathTime";
    private static final String ch = "DragonPhase";
    public final double[][] c = new double[64][3];
    public int d = -1;
    public final EntityComplexPart[] ci;
    public final EntityComplexPart e = new EntityComplexPart(this, "head", 1.0f, 1.0f);
    private final EntityComplexPart cj = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
    private final EntityComplexPart ck = new EntityComplexPart(this, "body", 5.0f, 3.0f);
    private final EntityComplexPart cl = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart cm = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart cn = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart co = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
    private final EntityComplexPart cp = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
    public float bV;
    public float bW;
    public boolean bX;
    public int bY;
    public float bZ;
    @Nullable
    public EntityEnderCrystal ca;
    @Nullable
    private final EnderDragonBattle cq;
    private final DragonControllerManager cr;
    private int cs = 100;
    private int ct;
    private final PathPoint[] cu = new PathPoint[24];
    private final int[] cv = new int[24];
    private final Path cw = new Path();
    private Explosion explosionSource = new Explosion(null, this, null, null, Double.NaN, Double.NaN, Double.NaN, Float.NaN, true, Explosion.Effect.c);

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.v, world);
        this.ci = new EntityComplexPart[]{this.e, this.cj, this.ck, this.cl, this.cm, this.cn, this.co, this.cp};
        this.c(this.el());
        this.Q = true;
        this.af = true;
        this.cq = world instanceof WorldServer ? ((WorldServer)world).F() : null;
        this.cr = new DragonControllerManager(this);
    }

    public static AttributeProvider.Builder n() {
        return EntityInsentient.w().a(GenericAttributes.a, 200.0);
    }

    @Override
    public boolean aK() {
        float f2 = MathHelper.b(this.bW * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.bV * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void aJ() {
        if (this.t.y && !this.aL()) {
            this.t.a(this.dc(), this.de(), this.di(), SoundEffects.fo, this.cO(), 5.0f, 0.8f + this.R.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void a_() {
        super.a_();
        this.ai().a(b, DragonControllerPhase.k.b());
    }

    public double[] a(int segmentNumber, float tickDelta) {
        if (this.ea()) {
            tickDelta = 0.0f;
        }
        tickDelta = 1.0f - tickDelta;
        int j2 = this.d - segmentNumber & 0x3F;
        int k2 = this.d - segmentNumber - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.c[j2][0];
        double d1 = MathHelper.f(this.c[k2][0] - d0);
        adouble[0] = d0 + d1 * (double)tickDelta;
        d0 = this.c[j2][1];
        d1 = this.c[k2][1] - d0;
        adouble[1] = d0 + d1 * (double)tickDelta;
        adouble[2] = MathHelper.d((double)tickDelta, this.c[j2][2], this.c[k2][2]);
        return adouble;
    }

    @Override
    public void w_() {
        this.az();
        if (this.t.y) {
            this.c(this.dZ());
            if (!this.aL() && !this.cr.a().a() && --this.cs < 0) {
                this.t.a(this.dc(), this.de(), this.di(), SoundEffects.fp, this.cO(), 2.5f, 0.8f + this.R.nextFloat() * 0.3f, false);
                this.cs = 200 + this.R.nextInt(200);
            }
        }
        this.bV = this.bW;
        if (this.ea()) {
            float f1 = (this.R.nextFloat() - 0.5f) * 8.0f;
            float f2 = (this.R.nextFloat() - 0.5f) * 4.0f;
            float f22 = (this.R.nextFloat() - 0.5f) * 8.0f;
            this.t.a(Particles.x, this.dc() + (double)f1, this.de() + 2.0 + (double)f2, this.di() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.fz();
            Vec3D vec3d = this.da();
            float f3 = 0.2f / ((float)vec3d.h() * 10.0f + 1.0f);
            this.bW = this.cr.a().a() ? (this.bW += 0.1f) : (this.bX ? (this.bW += f3 * 0.5f) : (this.bW += (f3 *= (float)Math.pow(2.0, vec3d.c))));
            this.o(MathHelper.g(this.dm()));
            if (this.fr()) {
                this.bW = 0.5f;
            } else {
                int k2;
                float f5;
                float f4;
                float f32;
                if (this.d < 0) {
                    for (int i2 = 0; i2 < this.c.length; ++i2) {
                        this.c[i2][0] = this.dm();
                        this.c[i2][1] = this.de();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dm();
                this.c[this.d][1] = this.de();
                if (this.t.y) {
                    if (this.bs > 0) {
                        double d3 = this.dc() + (this.bt - this.dc()) / (double)this.bs;
                        double d0 = this.de() + (this.bu - this.de()) / (double)this.bs;
                        d1 = this.di() + (this.bv - this.di()) / (double)this.bs;
                        d2 = MathHelper.f(this.bw - (double)this.dm());
                        this.o(this.dm() + (float)d2 / (float)this.bs);
                        this.p(this.dn() + (float)(this.bx - (double)this.dn()) / (float)this.bs);
                        --this.bs;
                        this.e(d3, d0, d1);
                        this.a(this.dm(), this.dn());
                    }
                    this.cr.a().b();
                } else {
                    Vec3D vec3d1;
                    IDragonController idragoncontroller = this.cr.a();
                    idragoncontroller.c();
                    if (this.cr.a() != idragoncontroller) {
                        idragoncontroller = this.cr.a();
                        idragoncontroller.c();
                    }
                    if ((vec3d1 = idragoncontroller.g()) != null && idragoncontroller.i() != DragonControllerPhase.k) {
                        double d0 = vec3d1.b - this.dc();
                        d1 = vec3d1.c - this.de();
                        d2 = vec3d1.d - this.di();
                        double d4 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.f();
                        double d5 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d5 > 0.0) {
                            d1 = MathHelper.a(d1 / d5, (double)(-f6), (double)f6);
                        }
                        this.g(this.da().b(0.0, d1 * 0.01, 0.0));
                        this.o(MathHelper.g(this.dm()));
                        Vec3D vec3d2 = vec3d1.a(this.dc(), this.de(), this.di()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dm() * ((float)Math.PI / 180)), this.da().c, -MathHelper.b(this.dm() * ((float)Math.PI / 180))).d();
                        f32 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            double d6 = MathHelper.a(MathHelper.f(180.0 - MathHelper.d(d0, d2) * 57.2957763671875 - (double)this.dm()), -50.0, 50.0);
                            this.bZ *= 0.8f;
                            this.bZ = (float)((double)this.bZ + d6 * (double)idragoncontroller.h());
                            this.o(this.dm() + this.bZ * 0.1f);
                        }
                        f4 = (float)(2.0 / (d4 + 1.0));
                        f5 = 0.06f;
                        this.a(0.06f * (f32 * f4 + (1.0f - f4)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.bX) {
                            this.a(EnumMoveType.a, this.da().a((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.da());
                        }
                        Vec3D vec3d4 = this.da().d();
                        double d7 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.g(this.da().d(d7, 0.91f, d7));
                    }
                }
                this.aY = this.dm();
                Vec3D[] avec3d = new Vec3D[this.ci.length];
                for (int j2 = 0; j2 < this.ci.length; ++j2) {
                    avec3d[j2] = new Vec3D(this.ci[j2].dc(), this.ci[j2].de(), this.ci[j2].di());
                }
                float f7 = (float)(this.a(5, 1.0f)[1] - this.a(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f8 = MathHelper.b(f7);
                float f9 = MathHelper.a(f7);
                float f10 = this.dm() * ((float)Math.PI / 180);
                float f11 = MathHelper.a(f10);
                float f12 = MathHelper.b(f10);
                this.a(this.ck, (double)(f11 * 0.5f), 0.0, (double)(-f12 * 0.5f));
                this.a(this.co, (double)(f12 * 4.5f), 2.0, (double)(f11 * 4.5f));
                this.a(this.cp, (double)(f12 * -4.5f), 2.0, (double)(f11 * -4.5f));
                if (!this.t.y && this.aL == 0) {
                    this.a(this.t.a((Entity)this, this.co.cw().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.a(this.t.a((Entity)this, this.cp.cw().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.b(this.t.a((Entity)this, this.e.cw().g(1.0), IEntitySelector.e));
                    this.b(this.t.a((Entity)this, this.cj.cw().g(1.0), IEntitySelector.e));
                }
                float f13 = MathHelper.a(this.dm() * ((float)Math.PI / 180) - this.bZ * 0.01f);
                float f14 = MathHelper.b(this.dm() * ((float)Math.PI / 180) - this.bZ * 0.01f);
                float f15 = this.fy();
                this.a(this.e, (double)(f13 * 6.5f * f8), (double)(f15 + f9 * 6.5f), (double)(-f14 * 6.5f * f8));
                this.a(this.cj, (double)(f13 * 5.5f * f8), (double)(f15 + f9 * 5.5f), (double)(-f14 * 5.5f * f8));
                double[] adouble = this.a(5, 1.0f);
                for (k2 = 0; k2 < 3; ++k2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (k2 == 0) {
                        entitycomplexpart = this.cl;
                    }
                    if (k2 == 1) {
                        entitycomplexpart = this.cm;
                    }
                    if (k2 == 2) {
                        entitycomplexpart = this.cn;
                    }
                    double[] adouble1 = this.a(12 + k2 * 2, 1.0f);
                    float f16 = this.dm() * ((float)Math.PI / 180) + this.i(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    f32 = MathHelper.a(f16);
                    f4 = MathHelper.b(f16);
                    f5 = 1.5f;
                    float f17 = (float)(k2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f11 * 1.5f + f32 * f17) * f8), adouble1[1] - adouble[1] - (double)((f17 + 1.5f) * f9) + 1.5, (double)((f12 * 1.5f + f4 * f17) * f8));
                }
                if (!this.t.y) {
                    this.bX = this.b(this.e.cw()) | this.b(this.cj.cw()) | this.b(this.ck.cw());
                    if (this.cq != null) {
                        this.cq.b(this);
                    }
                }
                for (k2 = 0; k2 < this.ci.length; ++k2) {
                    this.ci[k2].u = avec3d[k2].b;
                    this.ci[k2].v = avec3d[k2].c;
                    this.ci[k2].w = avec3d[k2].d;
                    this.ci[k2].M = avec3d[k2].b;
                    this.ci[k2].N = avec3d[k2].c;
                    this.ci[k2].O = avec3d[k2].d;
                }
            }
        }
    }

    private void a(EntityComplexPart enderDragonPart, double dx, double dy, double dz) {
        enderDragonPart.e(this.dc() + dx, this.de() + dy, this.di() + dz);
    }

    private float fy() {
        if (this.cr.a().a()) {
            return -1.0f;
        }
        double[] adouble = this.a(5, 1.0f);
        double[] adouble1 = this.a(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void fz() {
        if (this.ca != null) {
            if (this.ca.do()) {
                this.ca = null;
            } else if (this.S % 10 == 0 && this.dZ() < this.el()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.c((float)((double)this.dZ() + event.getAmount()));
                }
            }
        }
        if (this.R.nextInt(10) == 0) {
            List<EntityEnderCrystal> list = this.t.a(EntityEnderCrystal.class, this.cw().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.f(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.ca = entityendercrystal;
        }
    }

    private void a(List<Entity> entities) {
        double d0 = (this.ck.cw().a + this.ck.cw().d) / 2.0;
        double d1 = (this.ck.cw().c + this.ck.cw().f) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            double d2 = entity.dc() - d0;
            double d3 = entity.di() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.i(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.cr.a().a() || ((EntityLiving)entity).dM() >= entity.S - 2) continue;
            entity.a(DamageSource.c(this), 5.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private void b(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            entity.a(DamageSource.c(this), 10.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private float i(double yawDegrees) {
        return (float)MathHelper.f(yawDegrees);
    }

    private boolean b(AxisAlignedBB box) {
        int i2 = MathHelper.b(box.a);
        int j2 = MathHelper.b(box.b);
        int k2 = MathHelper.b(box.c);
        int l2 = MathHelper.b(box.d);
        int i1 = MathHelper.b(box.e);
        int j1 = MathHelper.b(box.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<CraftBlock> destroyedBlocks = new ArrayList<CraftBlock>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = this.t.a_(blockposition);
                    if (iblockdata.g() || iblockdata.c() == net.minecraft.world.level.material.Material.n) continue;
                    if (this.t.X().b(GameRules.c) && !iblockdata.a(TagsBlock.aq)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(this.t, blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        CraftEntity bukkitEntity = this.getBukkitEntity();
        EntityExplodeEvent event = new EntityExplodeEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), destroyedBlocks, 0.0f);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.t.a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                org.bukkit.block.Block tntBlock;
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().m() ? this.t.c_(blockposition) : null;
                    LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.t).a(this.t.w).a(LootContextParameters.f, Vec3D.a(blockposition)).a(LootContextParameters.i, ItemStack.b).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.t, blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.t, blockposition, ItemStack.b);
                }
                if (!new TNTPrimeEvent(tntBlock = this.t.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.d().getBukkitEntity()).callEvent()) continue;
                nmsBlock.a(this.t, blockposition, this.explosionSource);
                this.t.a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.R.nextInt(l2 - i2 + 1), j2 + this.R.nextInt(i1 - j2 + 1), k2 + this.R.nextInt(j1 - k2 + 1));
            this.t.c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(EntityComplexPart part, DamageSource source, float amount) {
        if (this.cr.a().i() == DragonControllerPhase.j) {
            return false;
        }
        amount = this.cr.a().a(source, amount);
        if (part != this.e) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (source.l() instanceof EntityHuman || source.d()) {
            float f1 = this.dZ();
            this.g(source, amount);
            if (this.ea() && !this.cr.a().a()) {
                this.c(1.0f);
                this.cr.a(DragonControllerPhase.j);
            }
            if (this.cr.a().a()) {
                this.ct = (int)((float)this.ct + (f1 - this.dZ()));
                if ((float)this.ct > 0.25f * this.el()) {
                    this.ct = 0;
                    this.cr.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).E()) {
            this.a(this.ck, source, amount);
        }
        return false;
    }

    protected boolean g(DamageSource source, float amount) {
        return super.a(source, amount);
    }

    @Override
    public void ag() {
        this.a(Entity.RemovalReason.a);
        if (this.cq != null) {
            this.cq.b(this);
            this.cq.a(this);
        }
    }

    @Override
    protected void dG() {
        if (this.cq != null) {
            this.cq.b(this);
        }
        ++this.bY;
        if (this.bY >= 180 && this.bY <= 200) {
            float f2 = (this.R.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.R.nextFloat() - 0.5f) * 4.0f;
            float f22 = (this.R.nextFloat() - 0.5f) * 8.0f;
            this.t.a(Particles.w, this.dc() + (double)f2, this.de() + 2.0 + (double)f1, this.di() + (double)f22, 0.0, 0.0, 0.0);
        }
        boolean flag = this.t.X().b(GameRules.f);
        int short0 = 500;
        if (this.cq != null && !this.cq.d()) {
            short0 = 12000;
        }
        if (this.t instanceof WorldServer) {
            if (this.bY > 150 && this.bY % 5 == 0 && flag) {
                EntityExperienceOrb.award((WorldServer)this.t, this.cV(), MathHelper.d((float)short0 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.bd, this);
            }
            if (this.bY == 1 && !this.aL()) {
                for (EntityPlayer player : ((WorldServer)this.t).z()) {
                    int viewDistance = player.getViewDistance();
                    double deltaX = this.dc() - player.dc();
                    double deltaZ = this.di() - player.di();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (this.t.spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(this.t.spigotConfig.dragonDeathSoundRadius * this.t.spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dc() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.di() + deltaZ / deltaLength * (double)viewDistance;
                        player.b.a(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.de(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.b.a(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dc(), (int)this.de(), (int)this.di()), 0, true));
                }
            }
        }
        this.a(EnumMoveType.a, new Vec3D(0.0, 0.1f, 0.0));
        this.o(this.dm() + 20.0f);
        this.aY = this.dm();
        if (this.bY == 200 && this.t instanceof WorldServer) {
            if (flag) {
                EntityExperienceOrb.award((WorldServer)this.t, this.cV(), MathHelper.d((float)short0 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.bd, this);
            }
            if (this.cq != null) {
                this.cq.a(this);
            }
            this.a(Entity.RemovalReason.a);
        }
    }

    public int q() {
        if (this.cu[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    i1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(this.t.m_() + 10, this.t.a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cu[i2] = new PathPoint(k2, j1, l2);
            }
            this.cv[0] = 6146;
            this.cv[1] = 8197;
            this.cv[2] = 8202;
            this.cv[3] = 16404;
            this.cv[4] = 32808;
            this.cv[5] = 32848;
            this.cv[6] = 65696;
            this.cv[7] = 131392;
            this.cv[8] = 131712;
            this.cv[9] = 263424;
            this.cv[10] = 526848;
            this.cv[11] = 525313;
            this.cv[12] = 1581057;
            this.cv[13] = 3166214;
            this.cv[14] = 2138120;
            this.cv[15] = 6373424;
            this.cv[16] = 4358208;
            this.cv[17] = 12910976;
            this.cv[18] = 9044480;
            this.cv[19] = 9706496;
            this.cv[20] = 15216640;
            this.cv[21] = 0xD0E000;
            this.cv[22] = 11763712;
            this.cv[23] = 0x7E0000;
        }
        return this.q(this.dc(), this.de(), this.di());
    }

    public int q(double x2, double y2, double z2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.b(x2), MathHelper.b(y2), MathHelper.b(z2));
        int b0 = 0;
        if (this.cq == null || this.cq.c() == 0) {
            b0 = 12;
        }
        for (int j2 = b0; j2 < 24; ++j2) {
            float f1;
            if (this.cu[j2] == null || !((f1 = this.cu[j2].b(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = j2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int from, int to, @Nullable PathPoint pathNode) {
        PathPoint pathpoint1;
        for (int k2 = 0; k2 < 24; ++k2) {
            pathpoint1 = this.cu[k2];
            pathpoint1.i = false;
            pathpoint1.f = 0.0f;
            pathpoint1.g = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.cu[from];
        pathpoint1 = this.cu[to];
        pathpoint2.g = 0.0f;
        pathpoint2.f = pathpoint2.f = pathpoint2.a(pathpoint1);
        this.cw.a();
        this.cw.a(pathpoint2);
        PathPoint pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.cq == null || this.cq.c() == 0) {
            b0 = 12;
        }
        while (!this.cw.e()) {
            int i1;
            PathPoint pathpoint4 = this.cw.c();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathNode != null) {
                    pathNode.h = pathpoint1;
                    pathpoint1 = pathNode;
                }
                return this.a(pathpoint2, pathpoint1);
            }
            if (pathpoint4.a(pathpoint1) < pathpoint3.a(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.i = true;
            int l2 = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.cu[i1] != pathpoint4) {
                    continue;
                }
                l2 = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.cv[l2] & 1 << i1) <= 0) continue;
                PathPoint pathpoint5 = this.cu[i1];
                if (pathpoint5.i) continue;
                float f2 = pathpoint4.g + pathpoint4.a(pathpoint5);
                if (pathpoint5.c() && !(f2 < pathpoint5.g)) continue;
                pathpoint5.h = pathpoint4;
                pathpoint5.g = f2;
                pathpoint5.f = pathpoint5.a(pathpoint1);
                if (pathpoint5.c()) {
                    this.cw.a(pathpoint5, pathpoint5.g + pathpoint5.f);
                    continue;
                }
                pathpoint5.f = pathpoint5.g + pathpoint5.f;
                this.cw.a(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        cb.debug("Failed to find path from {} to {}", (Object)from, (Object)to);
        if (pathNode != null) {
            pathNode.h = pathpoint3;
            pathpoint3 = pathNode;
        }
        return this.a(pathpoint2, pathpoint3);
    }

    private PathEntity a(PathPoint unused, PathPoint node) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = node;
        list.add(0, node);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(node.a, node.b, node.c), true);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(ch, this.cr.a().i().b());
        nbt.a(cg, this.bY);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e(ch)) {
            this.cr.a(DragonControllerPhase.a(nbt.h(ch)));
        }
        if (nbt.e(cg)) {
            this.bY = nbt.h(cg);
        }
    }

    @Override
    public void dj() {
    }

    public EntityComplexPart[] t() {
        return this.ci;
    }

    @Override
    public boolean bh() {
        return false;
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.fl;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.fq;
    }

    @Override
    public float eu() {
        return 5.0f;
    }

    public float a(int segmentOffset, double[] segment1, double[] segment2) {
        double d0;
        IDragonController idragoncontroller = this.cr.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            d0 = idragoncontroller.a() ? (double)segmentOffset : (segmentOffset == 6 ? 0.0 : segment2[1] - segment1[1]);
        } else {
            BlockPosition blockposition = this.t.a(HeightMap.Type.f, WorldGenEndTrophy.e);
            double d1 = Math.max(Math.sqrt(blockposition.a((IPosition)this.cV(), true)) / 4.0, 1.0);
            d0 = (double)segmentOffset / d1;
        }
        return (float)d0;
    }

    public Vec3D y(float tickDelta) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cr.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f2 = this.dn();
                float f1 = 1.5f;
                this.p(-45.0f);
                vec3d = this.e(tickDelta);
                this.p(f2);
            } else {
                vec3d = this.e(tickDelta);
            }
        } else {
            BlockPosition blockposition = this.t.a(HeightMap.Type.f, WorldGenEndTrophy.e);
            float f1 = Math.max((float)Math.sqrt(blockposition.a((IPosition)this.cV(), true)) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.dn();
            float f5 = 1.5f;
            this.p(-f3 * 1.5f * 5.0f);
            vec3d = this.e(tickDelta);
            this.p(f4);
        }
        return vec3d;
    }

    public void a(EntityEnderCrystal crystal, BlockPosition pos, DamageSource source) {
        EntityHuman entityhuman = source.l() instanceof EntityHuman ? (EntityHuman)source.l() : this.t.a(cc, (double)pos.u(), (double)pos.v(), (double)pos.w());
        if (crystal == this.ca) {
            this.a(this.e, DamageSource.d(entityhuman), 10.0f);
        }
        this.cr.a().a(crystal, pos, source, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (b.equals(data) && this.t.y) {
            this.cr.a(DragonControllerPhase.a(this.ai().a(b)));
        }
        super.a(data);
    }

    public DragonControllerManager fw() {
        return this.cr;
    }

    @Nullable
    public EnderDragonBattle fx() {
        return this.cq;
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    @Override
    protected boolean l(Entity entity) {
        return false;
    }

    @Override
    public boolean ci() {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntityLiving packet) {
        super.a(packet);
        EntityComplexPart[] aentitycomplexpart = this.t();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packet.b());
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return target.dS();
    }
}

