/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.i);
    public int b;
    public boolean generatedByDragonFight = false;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> type, World world) {
        super(type, world);
        this.r = true;
        this.b = this.R.nextInt(100000);
    }

    public EntityEnderCrystal(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.u, world);
        this.e(x2, y2, z2);
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.ai().a(c, Optional.empty());
        this.ai().a(d, true);
    }

    @Override
    public void k() {
        ++this.b;
        if (this.t instanceof WorldServer) {
            BlockPosition blockposition = this.cW();
            if (((WorldServer)this.t).F() != null && this.t.a_(blockposition).g() && !CraftEventFactory.callBlockIgniteEvent(this.t, blockposition, this).isCancelled()) {
                this.t.b(blockposition, BlockFireAbstract.a(this.t, blockposition));
            }
            if (this.t.paperConfig.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.cg() && (!Objects.equals(((WorldServer)this.t).uuid, this.getOriginWorld()) || ((WorldServer)this.t).F() == null || ((WorldServer)this.t).F().x == null || ((WorldServer)this.t).F().x.ordinal() > EnumDragonRespawn.d.ordinal())) {
                this.m(false);
                this.a((BlockPosition)null);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.h() != null) {
            nbt.a("BeamTarget", GameProfileSerializer.a(this.h()));
        }
        nbt.a("ShowBottom", this.i());
        if (this.generatedByDragonFight) {
            nbt.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("BeamTarget", 10)) {
            this.a(GameProfileSerializer.b(nbt.p("BeamTarget")));
        }
        if (nbt.b("ShowBottom", 1)) {
            this.a(nbt.q("ShowBottom"));
        }
        if (nbt.b("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = nbt.q("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean bh() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source.l() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.do() && !this.t.y) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                return false;
            }
            this.a(Entity.RemovalReason.a);
            if (!source.d()) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 6.0f, false);
                this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.dq();
                    return false;
                }
                this.t.a(this, this.dc(), this.de(), this.di(), event.getRadius(), event.getFire(), Explosion.Effect.c);
            }
            this.a(source);
        }
        return true;
    }

    @Override
    public void ag() {
        this.a(DamageSource.n);
        super.ag();
    }

    private void a(DamageSource source) {
        EnderDragonBattle enderdragonbattle;
        if (this.t instanceof WorldServer && (enderdragonbattle = ((WorldServer)this.t).F()) != null) {
            enderdragonbattle.a(this, source);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.ai().b(c, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition h() {
        return this.ai().a(c).orElse(null);
    }

    public void a(boolean showBottom) {
        this.ai().b(d, showBottom);
    }

    @Override
    public boolean i() {
        return this.ai().a(d);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.h() != null;
    }

    @Override
    public ItemStack dk() {
        return new ItemStack(Items.sk);
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this);
    }
}

