/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.TurtleGoHomeEvent;
import com.destroystokyo.paper.event.entity.TurtleLayEggEvent;
import com.destroystokyo.paper.event.entity.TurtleStartDiggingEvent;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Turtle;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<BlockPosition> bZ = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.l);
    private static final DataWatcherObject<Boolean> ca = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<BlockPosition> cc = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.l);
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(EntityTurtle.class, DataWatcherRegistry.i);
    public static final RecipeItemStack bW = RecipeItemStack.a(Blocks.ba.k());
    int cf;
    public static final Predicate<EntityLiving> bX = entityliving -> entityliving.y_() && !entityliving.aQ();

    public EntityTurtle(EntityTypes<? extends EntityTurtle> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.i, 0.0f);
        this.a(PathType.u, -1.0f);
        this.a(PathType.t, -1.0f);
        this.a(PathType.s, -1.0f);
        this.bO = new e(this);
        this.P = 1.0f;
    }

    public void g(BlockPosition pos) {
        this.Z.b(bZ, pos.h());
    }

    public BlockPosition fz() {
        return this.Z.a(bZ);
    }

    void h(BlockPosition pos) {
        this.Z.b(cc, pos);
    }

    BlockPosition fA() {
        return this.Z.a(cc);
    }

    public boolean q() {
        return this.Z.a(ca);
    }

    public void v(boolean hasEgg) {
        this.Z.b(ca, hasEgg);
    }

    public boolean t() {
        return this.Z.a(cb);
    }

    void w(boolean diggingSand) {
        this.cf = diggingSand ? 1 : 0;
        this.Z.b(cb, diggingSand);
    }

    public boolean fG() {
        return this.Z.a(cd);
    }

    public void x(boolean landBound) {
        this.Z.b(cd, landBound);
    }

    public boolean fH() {
        return this.Z.a(ce);
    }

    public void y(boolean travelling) {
        this.Z.b(ce, travelling);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(bZ, BlockPosition.b);
        this.Z.a(ca, false);
        this.Z.a(cc, BlockPosition.b);
        this.Z.a(cd, false);
        this.Z.a(ce, false);
        this.Z.a(cb, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("HomePosX", this.fz().u());
        nbt.a("HomePosY", this.fz().v());
        nbt.a("HomePosZ", this.fz().w());
        nbt.a("HasEgg", this.q());
        nbt.a("TravelPosX", this.fA().u());
        nbt.a("TravelPosY", this.fA().v());
        nbt.a("TravelPosZ", this.fA().w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2 = nbt.h("HomePosX");
        int j2 = nbt.h("HomePosY");
        int k2 = nbt.h("HomePosZ");
        this.g(new BlockPosition(i2, j2, k2));
        super.a(nbt);
        this.v(nbt.q("HasEgg"));
        int l2 = nbt.h("TravelPosX");
        int i1 = nbt.h("TravelPosY");
        int j1 = nbt.h("TravelPosZ");
        this.h(new BlockPosition(l2, i1, j1));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.g(this.cW());
        this.h(BlockPosition.b);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static boolean c(EntityTypes<EntityTurtle> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return pos.v() < world.m_() + 4 && BlockTurtleEgg.a(world, pos) && EntityTurtle.a(world, pos);
    }

    @Override
    protected void u() {
        this.bR.a(0, new f(this, 1.2));
        this.bR.a(1, new a(this, 1.0));
        this.bR.a(1, new d(this, 1.0));
        this.bR.a(2, new PathfinderGoalTempt(this, 1.1, bW, false));
        this.bR.a(3, new c(this, 1.0));
        this.bR.a(4, new b(this, 1.0));
        this.bR.a(7, new i(this, 1.0));
        this.bR.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bR.a(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder fy() {
        return EntityInsentient.w().a(GenericAttributes.a, 30.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    public boolean cp() {
        return false;
    }

    @Override
    public boolean dw() {
        return true;
    }

    @Override
    public EnumMonsterType eq() {
        return EnumMonsterType.e;
    }

    @Override
    public int J() {
        return 200;
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        return !this.aQ() && this.z && !this.y_() ? SoundEffects.ts : super.r();
    }

    @Override
    protected void d(float volume) {
        super.d(volume * 1.5f);
    }

    @Override
    protected SoundEffect aF() {
        return SoundEffects.tD;
    }

    @Override
    @Nullable
    protected SoundEffect c(DamageSource source) {
        return this.y_() ? SoundEffects.tz : SoundEffects.ty;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return this.y_() ? SoundEffects.tu : SoundEffects.tt;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffect soundeffect = this.y_() ? SoundEffects.tC : SoundEffects.tB;
        this.a(soundeffect, 0.15f, 1.0f);
    }

    @Override
    public boolean fB() {
        return super.fB() && !this.q();
    }

    @Override
    protected float aE() {
        return this.J + 0.15f;
    }

    @Override
    public float dE() {
        return this.y_() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new g(this, world);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aT.a(world);
    }

    @Override
    public boolean n(ItemStack stack) {
        return stack.a(Blocks.ba.k());
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return !this.fG() && world.b_(pos).a(TagsFluid.b) ? 10.0f : (BlockTurtleEgg.a(world, pos) ? 10.0f : world.y(pos) - 0.5f);
    }

    @Override
    public void w_() {
        BlockPosition blockposition;
        super.w_();
        if (this.bl() && this.t() && this.cf >= 1 && this.cf % 5 == 0 && BlockTurtleEgg.a(this.t, blockposition = this.cW())) {
            this.t.c(2001, blockposition, Block.i(this.t.a_(blockposition.c())));
        }
    }

    @Override
    protected void n() {
        super.n();
        if (!this.y_() && this.t.X().b(GameRules.f)) {
            this.forceDrops = true;
            this.a(Items.md, 1);
            this.forceDrops = false;
        }
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.eH() && this.aQ()) {
            this.a(0.1f, movementInput);
            this.a(EnumMoveType.a, this.da());
            this.g(this.da().a(0.9));
            if (!(this.G() != null || this.fG() && this.fz().a((IPosition)this.cV(), 20.0))) {
                this.g(this.da().b(0.0, -0.005, 0.0));
            }
        } else {
            super.h(movementInput);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return false;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        CraftEventFactory.entityDamage = lightning;
        this.a(DamageSource.b, Float.MAX_VALUE);
        CraftEventFactory.entityDamage = null;
    }

    private static class e
    extends ControllerMove {
        private final EntityTurtle l;

        e(EntityTurtle turtle) {
            super(turtle);
            this.l = turtle;
        }

        private void g() {
            if (this.l.aQ()) {
                this.l.g(this.l.da().b(0.0, 0.005, 0.0));
                if (!this.l.fz().a((IPosition)this.l.cV(), 16.0)) {
                    this.l.r(Math.max(this.l.eC() / 2.0f, 0.08f));
                }
                if (this.l.y_()) {
                    this.l.r(Math.max(this.l.eC() / 3.0f, 0.06f));
                }
            } else if (this.l.z) {
                this.l.r(Math.max(this.l.eC() / 2.0f, 0.06f));
            }
        }

        @Override
        public void a() {
            this.g();
            if (this.k == ControllerMove.Operation.b && !this.l.D().l()) {
                double d0 = this.e - this.l.dc();
                double d1 = this.f - this.l.de();
                double d2 = this.g - this.l.di();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f2 = (float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f;
                this.l.o(this.a(this.l.dm(), f2, 90.0f));
                this.l.aY = this.l.dm();
                float f1 = (float)(this.h * this.l.b(GenericAttributes.d));
                this.l.r(MathHelper.i(0.125f, this.l.eC(), f1));
                this.l.g(this.l.da().b(0.0, (double)this.l.eC() * d1 * 0.1, 0.0));
            } else {
                this.l.r(0.0f);
            }
        }
    }

    private static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle turtle, double speed) {
            super(turtle, speed);
        }

        @Override
        public boolean a() {
            if (this.b.dL() == null && !this.b.bE()) {
                return false;
            }
            BlockPosition blockposition = this.a(this.b.t, this.b, 7);
            if (blockposition != null) {
                this.d = blockposition.u();
                this.e = blockposition.v();
                this.f = blockposition.w();
                return true;
            }
            return this.g();
        }
    }

    private static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle d;

        a(EntityTurtle turtle, double speed) {
            super(turtle, speed);
            this.d = turtle;
        }

        @Override
        public boolean a() {
            return super.a() && !this.d.q();
        }

        @Override
        protected void g() {
            EntityPlayer entityplayer = this.a.fD();
            if (entityplayer == null && this.c.fD() != null) {
                entityplayer = this.c.fD();
            }
            if (entityplayer != null) {
                entityplayer.a(StatisticList.P);
                CriterionTriggers.o.a(entityplayer, this.a, this.c, null);
            }
            this.d.v(true);
            this.a.fF();
            this.c.fF();
            Random random = this.a.dK();
            if (this.b.X().b(GameRules.f)) {
                this.b.b(new EntityExperienceOrb(this.b, this.a.dc(), this.a.de(), this.a.di(), random.nextInt(7) + 1, ExperienceOrb.SpawnReason.BREED, entityplayer));
            }
        }
    }

    private static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle g;

        d(EntityTurtle turtle, double speed) {
            super(turtle, speed, 16);
            this.g = turtle;
        }

        @Override
        public boolean a() {
            return this.g.q() && this.g.fz().a((IPosition)this.g.cV(), 9.0) ? super.a() : false;
        }

        @Override
        public boolean b() {
            return super.b() && this.g.q() && this.g.fz().a((IPosition)this.g.cV(), 9.0);
        }

        @Override
        public void e() {
            super.e();
            BlockPosition blockposition = this.g.cW();
            if (!this.g.aQ() && this.m()) {
                if (this.g.cf < 1) {
                    this.g.w(new TurtleStartDiggingEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.t, this.getTargetPosition())).callEvent());
                } else if (this.g.cf > this.a(200)) {
                    World world = this.g.t;
                    int eggCount = this.g.R.nextInt(4) + 1;
                    TurtleLayEggEvent layEggEvent = new TurtleLayEggEvent((Turtle)this.g.getBukkitEntity(), MCUtil.toLocation(this.g.t, this.e.b()), eggCount);
                    if (layEggEvent.callEvent() && !CraftEventFactory.callEntityChangeBlockEvent(this.g, this.e.b(), (IBlockData)Blocks.kt.n().a(BlockTurtleEgg.e, layEggEvent.getEggCount())).isCancelled()) {
                        world.a((EntityHuman)null, blockposition, SoundEffects.tA, SoundCategory.e, 0.3f, 0.9f + world.w.nextFloat() * 0.2f);
                        world.a(this.e.b(), (IBlockData)Blocks.kt.n().a(BlockTurtleEgg.e, layEggEvent.getEggCount()), 3);
                    }
                    this.g.v(false);
                    this.g.w(false);
                    this.g.s(600);
                }
                if (this.g.t()) {
                    ++this.g.cf;
                }
            }
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return !world.w(pos.b()) ? false : BlockTurtleEgg.b(world, pos);
        }
    }

    private static class c
    extends PathfinderGoalGotoTarget {
        private static final int g = 1200;
        private final EntityTurtle h;

        c(EntityTurtle turtle, double speed) {
            super(turtle, turtle.y_() ? 2.0 : speed, 24);
            this.h = turtle;
            this.f = -1;
        }

        @Override
        public boolean b() {
            return !this.h.aQ() && this.d <= 1200 && this.a(this.h.t, this.e);
        }

        @Override
        public boolean a() {
            return this.h.y_() && !this.h.aQ() ? super.a() : (!this.h.fG() && !this.h.aQ() && !this.h.q() ? super.a() : false);
        }

        @Override
        public boolean l() {
            return this.d % 160 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.A);
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;
        private int d;
        private static final int e = 600;

        b(EntityTurtle turtle, double speed) {
            this.a = turtle;
            this.b = speed;
        }

        @Override
        public boolean a() {
            return this.a.y_() ? false : (this.a.q() || this.a.dK().nextInt(net.minecraft.world.entity.animal.EntityTurtle$b.b(700)) == 0 && !this.a.fz().a((IPosition)this.a.cV(), 64.0)) && new TurtleGoHomeEvent((Turtle)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void c() {
            this.a.x(true);
            this.c = false;
            this.d = 0;
        }

        @Override
        public void d() {
            this.a.x(false);
        }

        @Override
        public boolean b() {
            return !this.a.fz().a((IPosition)this.a.cV(), 7.0) && !this.c && this.d <= this.a(600);
        }

        @Override
        public void e() {
            BlockPosition blockposition = this.a.fz();
            boolean flag = blockposition.a((IPosition)this.a.cV(), 16.0);
            if (flag) {
                ++this.d;
            }
            if (this.a.D().l()) {
                Vec3D vec3d = Vec3D.c(blockposition);
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 != null && !flag && !this.a.t.a_(new BlockPosition(vec3d1)).a(Blocks.A)) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 5, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.c = true;
                    return;
                }
                this.a.D().a(vec3d1.b, vec3d1.c, vec3d1.d, this.b);
            }
        }
    }

    private static class i
    extends PathfinderGoal {
        private final EntityTurtle a;
        private final double b;
        private boolean c;

        i(EntityTurtle turtle, double speed) {
            this.a = turtle;
            this.b = speed;
        }

        @Override
        public boolean a() {
            return !this.a.fG() && !this.a.q() && this.a.aQ();
        }

        @Override
        public void c() {
            boolean flag = true;
            boolean flag1 = true;
            Random random = this.a.R;
            int i2 = random.nextInt(1025) - 512;
            int j2 = random.nextInt(9) - 4;
            int k2 = random.nextInt(1025) - 512;
            if ((double)j2 + this.a.de() > (double)(this.a.t.m_() - 1)) {
                j2 = 0;
            }
            BlockPosition blockposition = new BlockPosition((double)i2 + this.a.dc(), (double)j2 + this.a.de(), (double)k2 + this.a.di());
            this.a.h(blockposition);
            this.a.y(true);
            this.c = false;
        }

        @Override
        public void e() {
            if (this.a.D().l()) {
                Vec3D vec3d = Vec3D.c(this.a.fA());
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 3, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 != null) {
                    int i2 = MathHelper.b(vec3d1.b);
                    int j2 = MathHelper.b(vec3d1.d);
                    boolean flag = true;
                    if (!this.a.t.b(i2 - 34, j2 - 34, i2 + 34, j2 + 34)) {
                        vec3d1 = null;
                    }
                }
                if (vec3d1 == null) {
                    this.c = true;
                    return;
                }
                this.a.D().a(vec3d1.b, vec3d1.c, vec3d1.d, this.b);
            }
        }

        @Override
        public boolean b() {
            return !this.a.D().l() && !this.c && !this.a.fG() && !this.a.fE() && !this.a.q();
        }

        @Override
        public void d() {
            this.a.y(false);
            super.d();
        }
    }

    private static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle i;

        h(EntityTurtle turtle, double speed, int chance) {
            super(turtle, speed, chance);
            this.i = turtle;
        }

        @Override
        public boolean a() {
            return !this.b.aQ() && !this.i.fG() && !this.i.q() ? super.a() : false;
        }
    }

    private static class g
    extends NavigationGuardian {
        g(EntityTurtle owner, World world) {
            super(owner, world);
        }

        @Override
        protected boolean a() {
            return true;
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new AmphibiousNodeEvaluator(true);
            return new Pathfinder(this.o, range);
        }

        @Override
        public boolean a(BlockPosition pos) {
            EntityTurtle entityturtle;
            if (this.a instanceof EntityTurtle && (entityturtle = (EntityTurtle)this.a).fH()) {
                return this.b.a_(pos).a(Blocks.A);
            }
            return !this.b.a_(pos.c()).g();
        }
    }
}

