/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte c = 16;
    private static final float d = 1.7f;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
    }

    @Override
    protected void u() {
        this.bR.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.bR.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.bR.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bR.a(4, new PathfinderGoalRandomLookaround(this));
        this.bS.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, entityliving -> entityliving instanceof IMonster));
    }

    public static AttributeProvider.Builder n() {
        return EntityInsentient.w().a(GenericAttributes.a, 4.0).a(GenericAttributes.d, 0.2f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(b, (byte)16);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Pumpkin", this.q());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("Pumpkin")) {
            this.v(nbt.q("Pumpkin"));
        }
    }

    @Override
    public boolean eD() {
        return true;
    }

    @Override
    public void w_() {
        super.w_();
        if (!this.t.y) {
            int k2;
            int j2;
            int i2 = MathHelper.b(this.dc());
            BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.b(this.de()), k2 = MathHelper.b(this.di()));
            BiomeBase biomebase = this.t.v(blockposition);
            if (biomebase.d(blockposition)) {
                this.a(CraftEventFactory.MELTING, 1.0f);
            }
            if (!this.t.X().b(GameRules.c)) {
                return;
            }
            IBlockData iblockdata = Blocks.cK.n();
            for (int l2 = 0; l2 < 4; ++l2) {
                i2 = MathHelper.b(this.dc() + (double)((float)(l2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockposition1 = new BlockPosition(i2, j2 = MathHelper.b(this.de()), k2 = MathHelper.b(this.di() + (double)((float)(l2 / 2 % 2 * 2 - 1) * 0.25f)));
                if (!this.t.a_(blockposition1).g() || !iblockdata.a((IWorldReader)this.t, blockposition1)) continue;
                CraftEventFactory.handleBlockFormEvent(this.t, blockposition1, iblockdata, this);
            }
        }
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        EntitySnowball entitysnowball = new EntitySnowball(this.t, this);
        double d0 = target.dg() - (double)1.1f;
        double d1 = target.dc() - this.dc();
        double d2 = d0 - entitysnowball.de();
        double d3 = target.di() - this.di();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        entitysnowball.c(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.a(SoundEffects.sn, 1.0f, 0.4f / (this.dK().nextFloat() * 0.4f + 0.8f));
        this.t.b(entitysnowball);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 1.7f;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.pq) && this.a()) {
            if (!CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand)) {
                return EnumInteractionResult.d;
            }
            this.a(SoundCategory.h);
            this.a(GameEvent.M, (Entity)player);
            if (!this.t.y) {
                itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
            }
            return EnumInteractionResult.a(this.t.y);
        }
        return EnumInteractionResult.d;
    }

    @Override
    public void a(SoundCategory shearedSoundCategory) {
        this.t.a((EntityHuman)null, this, SoundEffects.so, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.t.k_()) {
            this.v(false);
            this.forceDrops = true;
            this.a(new ItemStack(Items.eg), 1.7f);
            this.forceDrops = false;
        }
    }

    @Override
    public boolean a() {
        return this.bl() && this.q();
    }

    public boolean q() {
        return (this.Z.a(b) & 0x10) != 0;
    }

    public void v(boolean hasPumpkin) {
        byte b0 = this.Z.a(b);
        if (hasPumpkin) {
            this.Z.b(b, (byte)(b0 | 0x10));
        } else {
            this.Z.b(b, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        return SoundEffects.sk;
    }

    @Override
    @Nullable
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.sm;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.sl;
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.75f * this.cy(), this.cT() * 0.4f);
    }
}

