/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;

public class EntityRabbit
extends EntityAnimal {
    public static final double bW = 0.6;
    public static final double bX = 0.8;
    public static final double bZ = 1.0;
    public static final double ca = 2.2;
    public static final double cb = 1.4;
    private static final DataWatcherObject<Integer> cl = DataWatcher.a(EntityRabbit.class, DataWatcherRegistry.b);
    public static final int cc = 0;
    public static final int cd = 1;
    public static final int ce = 2;
    public static final int cf = 3;
    public static final int cg = 4;
    public static final int ch = 5;
    public static final int ci = 99;
    private static final MinecraftKey cm = new MinecraftKey("killer_bunny");
    public static final int cj = 8;
    public static final int ck = 8;
    private static final int cn = 40;
    private int co;
    private int cp;
    private boolean cq;
    private int cr;
    int cs;

    public EntityRabbit(EntityTypes<? extends EntityRabbit> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bP = new ControllerJumpRabbit(this);
        this.bO = new ControllerMoveRabbit(this);
        this.initializePathFinderGoals();
    }

    public void initializePathFinderGoals() {
        this.i(0.0);
    }

    @Override
    public void u() {
        this.bR.a(1, new PathfinderGoalFloat(this));
        this.bR.a(1, new PathfinderGoalRabbitPanic(this, 2.2));
        this.bR.a(2, new PathfinderGoalBreed(this, 0.8));
        this.bR.a(3, new PathfinderGoalTempt(this, 1.0, RecipeItemStack.a(Items.rl, Items.rq, Blocks.bv), false));
        this.bR.a(4, new PathfinderGoalRabbitAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 2.2, 2.2));
        this.bR.a(4, new PathfinderGoalRabbitAvoidTarget<EntityWolf>(this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.bR.a(4, new PathfinderGoalRabbitAvoidTarget<EntityMonster>(this, EntityMonster.class, 4.0f, 2.2, 2.2));
        this.bR.a(5, new PathfinderGoalEatCarrots(this));
        this.bR.a(6, new PathfinderGoalRandomStrollLand(this, 0.6));
        this.bR.a(11, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
    }

    @Override
    protected float ex() {
        if (!(this.A || this.bO.b() && !(this.bO.e() <= this.de() + 0.5))) {
            PathEntity pathentity = this.bQ.j();
            if (pathentity != null && !pathentity.c()) {
                Vec3D vec3d = pathentity.a(this);
                if (vec3d.c > this.de() + 0.5) {
                    return 0.5f;
                }
            }
            return this.bO.c() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    @Override
    protected void ez() {
        double d1;
        super.ez();
        double d0 = this.bO.c();
        if (d0 > 0.0 && (d1 = this.da().i()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
        if (!this.t.y) {
            this.t.a((Entity)this, (byte)1);
        }
    }

    public float z(float delta) {
        return this.cp == 0 ? 0.0f : ((float)this.co + delta) / (float)this.cp;
    }

    public void i(double speed) {
        this.D().a(speed);
        this.bO.a(this.bO.d(), this.bO.e(), this.bO.f(), speed);
    }

    @Override
    public void q(boolean jumping) {
        super.q(jumping);
        if (jumping) {
            this.a(this.fy(), this.eu(), ((this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void q() {
        this.q(true);
        this.cp = 10;
        this.co = 0;
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(cl, 0);
    }

    @Override
    public void R() {
        if (this.cr > 0) {
            --this.cr;
        }
        if (this.cs > 0) {
            this.cs -= this.R.nextInt(3);
            if (this.cs < 0) {
                this.cs = 0;
            }
        }
        if (this.z) {
            ControllerJumpRabbit entityrabbit_controllerjumprabbit;
            EntityLiving entityliving;
            if (!this.cq) {
                this.q(false);
                this.fI();
            }
            if (this.fz() == 99 && this.cr == 0 && (entityliving = this.G()) != null && this.f((Entity)entityliving) < 16.0) {
                this.b(entityliving.dc(), entityliving.di());
                this.bO.a(entityliving.dc(), entityliving.de(), entityliving.di(), this.bO.c());
                this.q();
                this.cq = true;
            }
            if (!(entityrabbit_controllerjumprabbit = (ControllerJumpRabbit)this.bP).c()) {
                if (this.bO.b() && this.cr == 0) {
                    PathEntity pathentity = this.bQ.j();
                    Vec3D vec3d = new Vec3D(this.bO.d(), this.bO.e(), this.bO.f());
                    if (pathentity != null && !pathentity.c()) {
                        vec3d = pathentity.a(this);
                    }
                    this.b(vec3d.b, vec3d.d);
                    this.q();
                }
            } else if (!entityrabbit_controllerjumprabbit.d()) {
                this.fA();
            }
        }
        this.cq = this.z;
    }

    @Override
    public boolean ba() {
        return false;
    }

    private void b(double x2, double z2) {
        this.o((float)(MathHelper.d(z2 - this.di(), x2 - this.dc()) * 57.2957763671875) - 90.0f);
    }

    private void fA() {
        ((ControllerJumpRabbit)this.bP).a(true);
    }

    private void fG() {
        ((ControllerJumpRabbit)this.bP).a(false);
    }

    private void fH() {
        this.cr = this.bO.c() < 2.2 ? 10 : 1;
    }

    private void fI() {
        this.fH();
        this.fG();
    }

    @Override
    public void w_() {
        super.w_();
        if (this.co != this.cp) {
            ++this.co;
        } else if (this.cp != 0) {
            this.co = 0;
            this.cp = 0;
            this.q(false);
        }
    }

    public static AttributeProvider.Builder t() {
        return EntityInsentient.w().a(GenericAttributes.a, 3.0).a(GenericAttributes.d, 0.3f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("RabbitType", this.fz());
        nbt.a("MoreCarrotTicks", this.cs);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.t(nbt.h("RabbitType"));
        this.cs = nbt.h("MoreCarrotTicks");
    }

    protected SoundEffect fy() {
        return SoundEffects.pv;
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.pr;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.pu;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.pt;
    }

    @Override
    public boolean z(Entity target) {
        if (this.fz() == 99) {
            this.a(SoundEffects.ps, 1.0f, (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f);
            return target.a(DamageSource.c(this), 8.0f);
        }
        return target.a(DamageSource.c(this), 3.0f);
    }

    @Override
    public SoundCategory cO() {
        return this.fz() == 99 ? SoundCategory.f : SoundCategory.g;
    }

    private static boolean m(ItemStack stack) {
        return stack.a(Items.rl) || stack.a(Items.rq) || stack.a(Blocks.bv.k());
    }

    public EntityRabbit b(WorldServer world, EntityAgeable entity) {
        EntityRabbit entityrabbit = EntityTypes.au.a(world);
        int i2 = this.a((GeneratorAccess)world);
        if (this.R.nextInt(20) != 0) {
            i2 = entity instanceof EntityRabbit && this.R.nextBoolean() ? ((EntityRabbit)entity).fz() : this.fz();
        }
        entityrabbit.t(i2);
        return entityrabbit;
    }

    @Override
    public boolean n(ItemStack stack) {
        return EntityRabbit.m(stack);
    }

    public int fz() {
        return this.Z.a(cl);
    }

    public void t(int rabbitType) {
        if (rabbitType == 99) {
            this.a(GenericAttributes.i).a(8.0);
            this.bR.a(4, new PathfinderGoalKillerRabbitMeleeAttack(this));
            this.bS.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
            this.bS.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
            this.bS.a(2, new PathfinderGoalNearestAttackableTarget<EntityWolf>((EntityInsentient)this, EntityWolf.class, true));
            if (!this.Y()) {
                this.a(new ChatMessage(SystemUtils.a("entity", cm)));
            }
        }
        this.Z.b(cl, rabbitType);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        int i2 = this.a(world);
        if (entityData instanceof GroupDataRabbit) {
            i2 = ((GroupDataRabbit)entityData).a;
        } else {
            entityData = new GroupDataRabbit(i2);
        }
        this.t(i2);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private int a(GeneratorAccess world) {
        BiomeBase biomebase = world.v(this.cW());
        int i2 = this.R.nextInt(100);
        return biomebase.c() == BiomeBase.Precipitation.c ? (i2 < 80 ? 1 : 3) : (biomebase.r() == BiomeBase.Geography.m ? 4 : (i2 < 50 ? 0 : (i2 < 90 ? 5 : 2)));
    }

    public static boolean c(EntityTypes<EntityRabbit> entity, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.by) && EntityRabbit.a(world, pos);
    }

    boolean fJ() {
        return this.cs == 0;
    }

    @Override
    public void a(byte status) {
        if (status == 1) {
            this.bb();
            this.cp = 10;
            this.co = 0;
        } else {
            super.a(status);
        }
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.6f * this.cy(), this.cT() * 0.4f);
    }

    public static class ControllerJumpRabbit
    extends ControllerJump {
        private final EntityRabbit b;
        private boolean c;

        public ControllerJumpRabbit(EntityRabbit rabbit) {
            super(rabbit);
            this.b = rabbit;
        }

        public boolean c() {
            return this.a;
        }

        public boolean d() {
            return this.c;
        }

        public void a(boolean canJump) {
            this.c = canJump;
        }

        @Override
        public void b() {
            if (this.a) {
                this.b.q();
                this.a = false;
            }
        }
    }

    private static class ControllerMoveRabbit
    extends ControllerMove {
        private final EntityRabbit l;
        private double m;

        public ControllerMoveRabbit(EntityRabbit owner) {
            super(owner);
            this.l = owner;
        }

        @Override
        public void a() {
            if (this.l.z && !this.l.bo && !((ControllerJumpRabbit)this.l.bP).c()) {
                this.l.i(0.0);
            } else if (this.b()) {
                this.l.i(this.m);
            }
            super.a();
        }

        @Override
        public void a(double x2, double y2, double z2, double speed) {
            if (this.l.aQ()) {
                speed = 1.5;
            }
            super.a(x2, y2, z2, speed);
            if (speed > 0.0) {
                this.m = speed;
            }
        }
    }

    private static class PathfinderGoalRabbitPanic
    extends PathfinderGoalPanic {
        private final EntityRabbit h;

        public PathfinderGoalRabbitPanic(EntityRabbit rabbit, double speed) {
            super(rabbit, speed);
            this.h = rabbit;
        }

        @Override
        public void e() {
            super.e();
            this.h.i(this.c);
        }
    }

    private static class PathfinderGoalRabbitAvoidTarget<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityRabbit i;

        public PathfinderGoalRabbitAvoidTarget(EntityRabbit rabbit, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super(rabbit, fleeFromType, distance, slowSpeed, fastSpeed);
            this.i = rabbit;
        }

        @Override
        public boolean a() {
            return this.i.fz() != 99 && super.a();
        }
    }

    private static class PathfinderGoalEatCarrots
    extends PathfinderGoalGotoTarget {
        private final EntityRabbit g;
        private boolean h;
        private boolean i;

        public PathfinderGoalEatCarrots(EntityRabbit rabbit) {
            super(rabbit, 0.7f, 16);
            this.g = rabbit;
        }

        @Override
        public boolean a() {
            if (this.c <= 0) {
                if (!this.g.t.X().b(GameRules.c)) {
                    return false;
                }
                this.i = false;
                this.h = this.g.fJ();
                this.h = true;
            }
            return super.a();
        }

        @Override
        public boolean b() {
            return this.i && super.b();
        }

        @Override
        public void e() {
            super.e();
            this.g.z().a((double)this.e.u() + 0.5, this.e.v() + 1, (double)this.e.w() + 0.5, 10.0f, this.g.T());
            if (this.m()) {
                World world = this.g.t;
                BlockPosition blockposition = this.e.b();
                IBlockData iblockdata = world.a_(blockposition);
                Block block = iblockdata.b();
                if (this.i && block instanceof BlockCarrots) {
                    int i2 = iblockdata.c(BlockCrops.d);
                    if (i2 == 0) {
                        if (CraftEventFactory.callEntityChangeBlockEvent(this.g, blockposition, Blocks.a.n()).isCancelled()) {
                            return;
                        }
                        world.a(blockposition, Blocks.a.n(), 2);
                        world.a(blockposition, true, (Entity)this.g);
                    } else {
                        if (CraftEventFactory.callEntityChangeBlockEvent(this.g, blockposition, (IBlockData)iblockdata.a(BlockCrops.d, i2 - 1)).isCancelled()) {
                            return;
                        }
                        world.a(blockposition, (IBlockData)iblockdata.a(BlockCrops.d, i2 - 1), 2);
                        world.c(2001, blockposition, Block.i(iblockdata));
                    }
                    this.g.cs = 40;
                }
                this.i = false;
                this.c = 10;
            }
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            IBlockData iblockdata = world.a_(pos);
            if (iblockdata.a(Blocks.ce) && this.h && !this.i && (iblockdata = world.a_(pos.b())).b() instanceof BlockCarrots && ((BlockCarrots)iblockdata.b()).h(iblockdata)) {
                this.i = true;
                return true;
            }
            return false;
        }
    }

    private static class PathfinderGoalKillerRabbitMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalKillerRabbitMeleeAttack(EntityRabbit rabbit) {
            super(rabbit, 1.4, true);
        }

        @Override
        protected double a(EntityLiving entity) {
            return 4.0f + entity.cT();
        }
    }

    public static class GroupDataRabbit
    extends EntityAgeable.a {
        public final int a;

        public GroupDataRabbit(int type) {
            super(1.0f);
            this.a = type;
        }
    }
}

