/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class EntityPig
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityPig.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final RecipeItemStack bZ = RecipeItemStack.a(Items.rl, Items.rm, Items.sn);
    public final SaddleStorage ca;

    public EntityPig(EntityTypes<? extends EntityPig> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.ca = new SaddleStorage(this.Z, bX, bW);
    }

    @Override
    protected void u() {
        this.bR.a(0, new PathfinderGoalFloat(this));
        this.bR.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bR.a(3, new PathfinderGoalBreed(this, 1.0));
        this.bR.a(4, new PathfinderGoalTempt(this, 1.2, RecipeItemStack.a(Items.lR), false));
        this.bR.a(4, new PathfinderGoalTempt(this, 1.2, bZ, false));
        this.bR.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.bR.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bR.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bR.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.w().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    @Nullable
    public Entity cE() {
        return this.cG();
    }

    @Override
    public boolean ff() {
        Entity entity = this.cE();
        if (!(entity instanceof EntityHuman)) {
            return false;
        }
        EntityHuman entityhuman = (EntityHuman)entity;
        return entityhuman.er().a(Items.lR) || entityhuman.es().a(Items.lR);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bX.equals(data) && this.t.y) {
            this.ca.a();
        }
        super.a(data);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(bW, false);
        this.Z.a(bX, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.ca.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.ca.b(nbt);
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.nV;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.nX;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.nW;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.nZ, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.n(player.b(hand));
        if (!flag && this.d() && !this.bG() && !player.ff()) {
            if (!this.t.y) {
                player.k(this);
            }
            return EnumInteractionResult.a(this.t.y);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.lL) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.d;
        }
        return enuminteractionresult;
    }

    @Override
    public boolean c() {
        return this.bl() && !this.y_();
    }

    @Override
    protected void ec() {
        super.ec();
        if (this.d()) {
            this.a((IMaterial)Items.lL);
        }
    }

    @Override
    public boolean d() {
        return this.ca.b();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.ca.a(true);
        if (sound != null) {
            this.t.a((EntityHuman)null, this, SoundEffects.nY, sound, 0.5f, 1.0f);
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cu();
        if (enumdirection.n() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.cW();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EntityPose entitypose : passenger.eY()) {
            AxisAlignedBB axisalignedbb = passenger.f(entitypose);
            int[][] aint1 = aint;
            int i2 = aint.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec3d;
                int[] aint2 = aint1[j2];
                blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v(), blockposition.w() + aint2[1]);
                double d0 = this.t.h(blockposition_mutableblockposition);
                if (!DismountUtil.a(d0) || !DismountUtil.a(this.t, passenger, axisalignedbb.c(vec3d = Vec3D.a(blockposition_mutableblockposition, d0)))) continue;
                passenger.b(entitypose);
                return vec3d;
            }
        }
        return super.b(passenger);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.af() != EnumDifficulty.a) {
            EntityPigZombie entitypigzombie = EntityTypes.bh.a(world);
            entitypigzombie.a(EnumItemSlot.a, new ItemStack(Items.mH));
            entitypigzombie.b(this.dc(), this.de(), this.di(), this.dm(), this.dn());
            entitypigzombie.s(this.fr());
            entitypigzombie.a(this.y_());
            if (this.Y()) {
                entitypigzombie.a(this.Z());
                entitypigzombie.n(this.cr());
            }
            entitypigzombie.fg();
            if (CraftEventFactory.callPigZapEvent(this, lightning, entitypigzombie).isCancelled()) {
                return;
            }
            world.addFreshEntity(entitypigzombie, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.ah();
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    public void h(Vec3D movementInput) {
        this.a(this, this.ca, movementInput);
    }

    @Override
    public float b() {
        return (float)this.b(GenericAttributes.d) * 0.225f;
    }

    @Override
    public void a(Vec3D movementInput) {
        super.h(movementInput);
    }

    @Override
    public boolean a() {
        return this.ca.a(this.dK());
    }

    public EntityPig b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.an.a(world);
    }

    @Override
    public boolean n(ItemStack stack) {
        return bZ.a(stack);
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.6f * this.cy(), this.cT() * 0.4f);
    }
}

