/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float bW = 120.32113f;
    public static final int bX = MathHelper.f(1.4959966f);
    private static final DataWatcherObject<Byte> cg = DataWatcher.a(EntityBee.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(EntityBee.class, DataWatcherRegistry.b);
    private static final int ci = 2;
    private static final int cj = 4;
    private static final int ck = 8;
    private static final int cl = 1200;
    private static final int cm = 2400;
    private static final int cn = 3600;
    private static final int co = 4;
    private static final int cp = 10;
    private static final int cq = 10;
    private static final int cr = 18;
    private static final int cs = 32;
    private static final int ct = 2;
    private static final int cu = 16;
    private static final int cv = 20;
    public static final String bZ = "CropsGrownSincePollination";
    public static final String ca = "CannotEnterHiveTicks";
    public static final String cb = "TicksSincePollination";
    public static final String cc = "HasStung";
    public static final String cd = "HasNectar";
    public static final String ce = "FlowerPos";
    public static final String cf = "HivePos";
    private static final UniformInt cw = TimeRange.a(20, 39);
    @Nullable
    private UUID cx;
    private float cy;
    private float cz;
    private int cA;
    int cB;
    public int cC;
    private int cD;
    private static final int cE = 200;
    int cF;
    private static final int cG = 200;
    int cH;
    @Nullable
    BlockPosition cI;
    @Nullable
    public BlockPosition cJ;
    k cK;
    e cL;
    private f cM;
    private int cN;

    public EntityBee(EntityTypes<? extends EntityBee> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.cH = MathHelper.a(this.R, 20, 60);
        class BeeFlyingMoveControl
        extends ControllerMoveFlying {
            public BeeFlyingMoveControl(EntityInsentient entity, int maxPitchChange, boolean noGravity) {
                super(entity, maxPitchChange, noGravity);
            }

            @Override
            public void a() {
                if (this.d.de() <= (double)EntityBee.this.t.u_()) {
                    this.d.e(false);
                }
                super.a();
            }
        }
        this.bO = new BeeFlyingMoveControl(this, 20, true);
        this.bN = new j(this);
        this.a(PathType.m, -1.0f);
        this.a(PathType.i, -1.0f);
        this.a(PathType.j, 16.0f);
        this.a(PathType.y, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Z.a(cg, (byte)0);
        this.Z.a(ch, 0);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).g() ? 10.0f : 0.0f;
    }

    @Override
    protected void u() {
        this.bR.a(0, new b(this, 1.4f, true));
        this.bR.a(1, new d());
        this.bR.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bR.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(TagsItem.M), false));
        this.cK = new k();
        this.bR.a(4, this.cK);
        this.bR.a(5, new PathfinderGoalFollowParent(this, 1.25));
        this.bR.a(5, new i());
        this.cL = new e();
        this.bR.a(5, this.cL);
        this.cM = new f();
        this.bR.a(6, this.cM);
        this.bR.a(7, new g());
        this.bR.a(8, new l());
        this.bR.a(9, new PathfinderGoalFloat(this));
        this.bS.a(1, new h(this).a(new Class[0]));
        this.bS.a(2, new c(this));
        this.bS.a(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.fG()) {
            nbt.a(cf, GameProfileSerializer.a(this.fH()));
        }
        if (this.t()) {
            nbt.a(ce, GameProfileSerializer.a(this.q()));
        }
        nbt.a(cd, this.fJ());
        nbt.a(cc, this.fK());
        nbt.a(cb, this.cB);
        nbt.a(ca, this.cC);
        nbt.a(bZ, this.cD);
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.cJ = null;
        if (nbt.e(cf)) {
            this.cJ = GameProfileSerializer.b(nbt.p(cf));
        }
        this.cI = null;
        if (nbt.e(ce)) {
            this.cI = GameProfileSerializer.b(nbt.p(ce));
        }
        super.a(nbt);
        this.v(nbt.q(cd));
        this.w(nbt.q(cc));
        this.cB = nbt.h(cb);
        this.cC = nbt.h(ca);
        this.cD = nbt.h(bZ);
        this.a(this.t, nbt);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag = target.a(DamageSource.b(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
            if (target instanceof EntityLiving) {
                ((EntityLiving)target).q(((EntityLiving)target).en() + 1);
                int b0 = 0;
                if (this.t.af() == EnumDifficulty.c) {
                    b0 = 10;
                } else if (this.t.af() == EnumDifficulty.d) {
                    b0 = 18;
                }
                if (b0 > 0) {
                    ((EntityLiving)target).addEffect(new MobEffect(MobEffects.s, b0 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.w(true);
            this.G_();
            this.a(SoundEffects.bg, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void k() {
        super.k();
        if (this.fJ() && this.fS() < 10 && this.R.nextFloat() < 0.05f) {
            for (int i2 = 0; i2 < this.R.nextInt(2) + 1; ++i2) {
                this.a(this.t, this.dc() - (double)0.3f, this.dc() + (double)0.3f, this.di() - (double)0.3f, this.di() + (double)0.3f, this.e(0.5), Particles.an);
            }
        }
        this.fQ();
    }

    private void a(World world, double lastX, double x2, double lastZ, double z2, double y2, ParticleParam effect) {
        world.a(effect, MathHelper.d(world.w.nextDouble(), lastX, x2), y2, MathHelper.d(world.w.nextDouble(), lastZ, z2), 0.0, 0.0, 0.0);
    }

    void h(BlockPosition pos) {
        Vec3D vec3d1;
        Vec3D vec3d = Vec3D.c(pos);
        int b0 = 0;
        BlockPosition blockposition1 = this.cW();
        int i2 = (int)vec3d.c - blockposition1.v();
        if (i2 > 2) {
            b0 = 4;
        } else if (i2 < -2) {
            b0 = -4;
        }
        int j2 = 6;
        int k2 = 8;
        int l2 = blockposition1.k(pos);
        if (l2 < 15) {
            j2 = l2 / 2;
            k2 = l2 / 2;
        }
        if ((vec3d1 = AirRandomPos.a(this, j2, k2, b0, vec3d, 0.3141592741012573)) != null) {
            this.bQ.a(0.5f);
            this.bQ.a(vec3d1.b, vec3d1.c, vec3d1.d, 1.0);
        }
    }

    @Nullable
    public BlockPosition q() {
        return this.cI;
    }

    public boolean t() {
        return this.cI != null;
    }

    public void g(BlockPosition pos) {
        this.cI = pos;
    }

    @VisibleForDebug
    public int fy() {
        return Math.max(this.cL.d, this.cM.d);
    }

    @VisibleForDebug
    public List<BlockPosition> fz() {
        return this.cL.f;
    }

    private boolean fO() {
        return this.cB > 3600;
    }

    boolean fP() {
        if (this.cC <= 0 && !this.cK.l() && !this.fK() && this.G() == null) {
            boolean flag = this.fO() || this.t.Z() || this.t.Q() || this.fJ();
            return flag && !this.fR();
        }
        return false;
    }

    public void t(int ticks) {
        this.cC = ticks;
    }

    public float z(float tickDelta) {
        return MathHelper.i(tickDelta, this.cz, this.cy);
    }

    private void fQ() {
        this.cz = this.cy;
        this.cy = this.fW() ? Math.min(1.0f, this.cy + 0.2f) : Math.max(0.0f, this.cy - 0.24f);
    }

    @Override
    protected void R() {
        boolean flag = this.fK();
        this.cN = this.aT() ? ++this.cN : 0;
        if (this.cN > 20) {
            this.a(DamageSource.h, 1.0f);
        }
        if (flag) {
            ++this.cA;
            if (this.cA % 5 == 0 && this.R.nextInt(MathHelper.a(1200 - this.cA, 1, 1200)) == 0) {
                this.a(DamageSource.n, this.dZ());
            }
        }
        if (!this.fJ()) {
            ++this.cB;
        }
        if (!this.t.y) {
            this.a((WorldServer)this.t, false);
        }
    }

    public void fA() {
        this.cB = 0;
    }

    private boolean fR() {
        if (this.cJ == null) {
            return false;
        }
        if (!this.t.isLoadedAndInBounds(this.cJ)) {
            return false;
        }
        TileEntity tileentity = this.t.c_(this.cJ);
        return tileentity instanceof TileEntityBeehive && ((TileEntityBeehive)tileentity).c();
    }

    @Override
    public int a() {
        return this.Z.a(ch);
    }

    @Override
    public void a(int ticks) {
        this.Z.b(ch, ticks);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cx;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.cx = uuid;
    }

    @Override
    public void c() {
        this.a(cw.a(this.R));
    }

    private boolean i(BlockPosition pos) {
        if (!this.t.isLoadedAndInBounds(pos)) {
            return false;
        }
        TileEntity tileentity = this.t.c_(pos);
        return tileentity instanceof TileEntityBeehive ? !((TileEntityBeehive)tileentity).f() : false;
    }

    @VisibleForDebug
    public boolean fG() {
        return this.cJ != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition fH() {
        return this.cJ;
    }

    @VisibleForDebug
    public PathfinderGoalSelector fI() {
        return this.bR;
    }

    @Override
    protected void Q() {
        super.Q();
        PacketDebug.a(this);
    }

    int fS() {
        return this.cD;
    }

    private void fT() {
        this.cD = 0;
    }

    void fU() {
        ++this.cD;
    }

    @Override
    public void w_() {
        super.w_();
        if (!this.t.y) {
            if (this.cC > 0) {
                --this.cC;
            }
            if (this.cF > 0) {
                --this.cF;
            }
            if (this.cH > 0) {
                --this.cH;
            }
            boolean flag = this.H_() && !this.fK() && this.G() != null && this.G().f((Entity)this) < 4.0;
            this.x(flag);
            if (this.S % 20 == 0 && !this.fV()) {
                this.cJ = null;
            }
        }
    }

    boolean fV() {
        if (!this.fG()) {
            return false;
        }
        if (this.t.getChunkIfLoadedImmediately(this.cJ.u() >> 4, this.cJ.w() >> 4) == null) {
            return true;
        }
        TileEntity tileentity = this.t.c_(this.cJ);
        return tileentity != null && tileentity.u() == TileEntityTypes.G;
    }

    public boolean fJ() {
        return this.u(8);
    }

    public void v(boolean hasNectar) {
        if (hasNectar) {
            this.fA();
        }
        this.d(8, hasNectar);
    }

    public boolean fK() {
        return this.u(4);
    }

    public void w(boolean hasStung) {
        this.d(4, hasStung);
    }

    private boolean fW() {
        return this.u(2);
    }

    private void x(boolean nearTarget) {
        this.d(2, nearTarget);
    }

    boolean j(BlockPosition pos) {
        return !this.b(pos, 32);
    }

    private void d(int bit, boolean value) {
        if (value) {
            this.Z.b(cg, (byte)(this.Z.a(cg) | bit));
        } else {
            this.Z.b(cg, (byte)(this.Z.a(cg) & ~bit));
        }
    }

    private boolean u(int location) {
        return (this.Z.a(cg) & location) != 0;
    }

    public static AttributeProvider.Builder fL() {
        return EntityInsentient.w().a(GenericAttributes.a, 10.0).a(GenericAttributes.e, 0.6f).a(GenericAttributes.d, 0.3f).a(GenericAttributes.f, 2.0).a(GenericAttributes.b, 48.0);
    }

    @Override
    protected NavigationAbstract a(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world){

            @Override
            public boolean a(BlockPosition pos) {
                return !this.b.a_(pos.c()).g();
            }

            @Override
            public void c() {
                if (!EntityBee.this.cK.l()) {
                    super.c();
                }
            }
        };
        navigationflying.a(false);
        navigationflying.d(false);
        navigationflying.b(true);
        return navigationflying;
    }

    @Override
    public boolean n(ItemStack stack) {
        return stack.a(TagsItem.M);
    }

    boolean k(BlockPosition pos) {
        return this.t.n(pos) && this.t.a_(pos).a(TagsBlock.O);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    protected SoundEffect r() {
        return null;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.bd;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.bc;
    }

    @Override
    public float eu() {
        return 0.4f;
    }

    public EntityBee b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.g.a(world);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? dimensions.b * 0.5f : dimensions.b * 0.5f;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData landedState, BlockPosition landedPosition) {
    }

    @Override
    public boolean aK() {
        return this.fM() && this.S % bX == 0;
    }

    @Override
    public boolean fM() {
        return !this.z;
    }

    public void fN() {
        this.v(false);
        this.fT();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        boolean result = super.a(source, amount);
        if (result && !this.t.y) {
            this.cK.m();
        }
        return result;
    }

    @Override
    public EnumMonsterType eq() {
        return EnumMonsterType.c;
    }

    @Override
    protected void c(Tag<FluidType> fluid) {
        this.g(this.da().b(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.5f * this.cy(), this.cT() * 0.2f);
    }

    boolean b(BlockPosition pos, int distance) {
        return pos.a((BaseBlockPosition)this.cW(), (double)distance);
    }

    private class j
    extends ControllerLook {
        j(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
            if (!EntityBee.this.H_()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityBee.this.cK.l();
        }
    }

    private class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        @Override
        public boolean a() {
            return super.a() && EntityBee.this.H_() && !EntityBee.this.fK();
        }

        @Override
        public boolean b() {
            return super.b() && EntityBee.this.H_() && !EntityBee.this.fK();
        }
    }

    private class d
    extends a {
        d() {
        }

        @Override
        public boolean g() {
            if (EntityBee.this.fG() && EntityBee.this.fP() && EntityBee.this.cJ.a((IPosition)EntityBee.this.cV(), 2.0)) {
                if (!EntityBee.this.t.isLoadedAndInBounds(EntityBee.this.cJ)) {
                    return false;
                }
                TileEntity tileentity = EntityBee.this.t.c_(EntityBee.this.cJ);
                if (tileentity instanceof TileEntityBeehive) {
                    TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                    if (!tileentitybeehive.f()) {
                        return true;
                    }
                    EntityBee.this.cJ = null;
                }
            }
            return false;
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void c() {
            if (!EntityBee.this.t.isLoadedAndInBounds(EntityBee.this.cJ)) {
                return;
            }
            TileEntity tileentity = EntityBee.this.t.c_(EntityBee.this.cJ);
            if (tileentity instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                tileentitybeehive.a(EntityBee.this, EntityBee.this.fJ());
            }
        }
    }

    private class k
    extends a {
        private static final int c = 400;
        private static final int d = 20;
        private static final int e = 60;
        private final Predicate<IBlockData> f;
        private static final double g = 0.1;
        private static final int h = 25;
        private static final float i = 0.35f;
        private static final float j = 0.6f;
        private static final float k = 0.33333334f;
        private int l;
        private int m;
        private boolean n;
        @Nullable
        private Vec3D o;
        private int p;
        private static final int q = 600;

        k() {
            this.f = iblockdata -> iblockdata.a(TagsBlock.O) ? (iblockdata.a(Blocks.hi) ? iblockdata.c(BlockTallPlant.a) == BlockPropertyDoubleBlockHalf.a : true) : false;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean g() {
            if (EntityBee.this.cH > 0) {
                return false;
            }
            if (EntityBee.this.fJ()) {
                return false;
            }
            if (EntityBee.this.t.Z()) {
                return false;
            }
            Optional<BlockPosition> optional = this.p();
            if (optional.isPresent()) {
                EntityBee.this.cI = optional.get();
                EntityBee.this.bQ.a((double)EntityBee.this.cI.u() + 0.5, (double)EntityBee.this.cI.v() + 0.5, (double)EntityBee.this.cI.w() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.cH = MathHelper.a(EntityBee.this.R, 20, 60);
            return false;
        }

        @Override
        public boolean i() {
            if (!this.n) {
                return false;
            }
            if (!EntityBee.this.t()) {
                return false;
            }
            if (EntityBee.this.t.Z()) {
                return false;
            }
            if (this.k()) {
                return EntityBee.this.R.nextFloat() < 0.2f;
            }
            if (EntityBee.this.S % 20 == 0 && !EntityBee.this.k(EntityBee.this.cI)) {
                EntityBee.this.cI = null;
                return false;
            }
            return true;
        }

        private boolean k() {
            return this.l > 400;
        }

        boolean l() {
            return this.n;
        }

        void m() {
            this.n = false;
        }

        @Override
        public void c() {
            this.l = 0;
            this.p = 0;
            this.m = 0;
            this.n = true;
            EntityBee.this.fA();
        }

        @Override
        public void d() {
            if (this.k()) {
                EntityBee.this.v(true);
            }
            this.n = false;
            EntityBee.this.bQ.n();
            EntityBee.this.cH = 200;
        }

        @Override
        public boolean h() {
            return true;
        }

        @Override
        public void e() {
            ++this.p;
            if (this.p > 600) {
                EntityBee.this.cI = null;
            } else {
                Vec3D vec3d = Vec3D.c(EntityBee.this.cI).b(0.0, 0.6f, 0.0);
                if (vec3d.f(EntityBee.this.cV()) > 1.0) {
                    this.o = vec3d;
                    this.n();
                } else {
                    if (this.o == null) {
                        this.o = vec3d;
                    }
                    boolean flag = EntityBee.this.cV().f(this.o) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.p > 600) {
                        EntityBee.this.cI = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = EntityBee.this.R.nextInt(25) == 0;
                            if (flag2) {
                                this.o = new Vec3D(vec3d.a() + (double)this.o(), vec3d.b(), vec3d.c() + (double)this.o());
                                EntityBee.this.bQ.n();
                            } else {
                                flag1 = false;
                            }
                            EntityBee.this.z().a(vec3d.a(), vec3d.b(), vec3d.c());
                        }
                        if (flag1) {
                            this.n();
                        }
                        ++this.l;
                        if (EntityBee.this.R.nextFloat() < 0.05f && this.l > this.m + 60) {
                            this.m = this.l;
                            EntityBee.this.a(SoundEffects.bh, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void n() {
            EntityBee.this.A().a(this.o.a(), this.o.b(), this.o.c(), 0.35f);
        }

        private float o() {
            return (EntityBee.this.R.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> p() {
            return this.a(this.f, 5.0);
        }

        private Optional<BlockPosition> a(Predicate<IBlockData> predicate, double searchDistance) {
            BlockPosition blockposition = EntityBee.this.cW();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int i2 = 0;
            while ((double)i2 <= searchDistance) {
                int j2 = 0;
                while ((double)j2 < searchDistance) {
                    int k2 = 0;
                    while (k2 <= j2) {
                        int l2;
                        int n2 = l2 = k2 < j2 && k2 > -j2 ? j2 : 0;
                        while (l2 <= j2) {
                            blockposition_mutableblockposition.a(blockposition, k2, i2 - 1, l2);
                            if (blockposition.a((BaseBlockPosition)blockposition_mutableblockposition, searchDistance) && predicate.test(EntityBee.this.t.a_(blockposition_mutableblockposition))) {
                                return Optional.of(blockposition_mutableblockposition);
                            }
                            l2 = l2 > 0 ? -l2 : 1 - l2;
                        }
                        k2 = k2 > 0 ? -k2 : 1 - k2;
                    }
                    ++j2;
                }
                i2 = i2 > 0 ? -i2 : 1 - i2;
            }
            return Optional.empty();
        }
    }

    private class i
    extends a {
        i() {
        }

        @Override
        public boolean g() {
            return EntityBee.this.cF == 0 && !EntityBee.this.fG() && EntityBee.this.fP();
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void c() {
            EntityBee.this.cF = 200;
            List<BlockPosition> list = this.k();
            if (!list.isEmpty()) {
                BlockPosition blockposition;
                Iterator<BlockPosition> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    EntityBee.this.cL.k();
                    EntityBee.this.cJ = list.get(0);
                    return;
                } while (EntityBee.this.cL.b(blockposition = iterator.next()));
                EntityBee.this.cJ = blockposition;
            }
        }

        private List<BlockPosition> k() {
            BlockPosition blockposition = EntityBee.this.cW();
            VillagePlace villageplace = ((WorldServer)EntityBee.this.t).A();
            Stream<VillagePlaceRecord> stream = villageplace.c(villageplacetype -> villageplacetype == VillagePlaceType.t || villageplacetype == VillagePlaceType.u, blockposition, 20, VillagePlace.Occupancy.c);
            return stream.map(VillagePlaceRecord::f).filter(EntityBee.this::i).sorted(Comparator.comparingDouble(blockposition1 -> blockposition1.j(blockposition))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int b = 600;
        int d;
        private static final int e = 3;
        final List<BlockPosition> f;
        @Nullable
        private PathEntity g;
        private static final int h = 60;
        private int i;

        e() {
            this.d = EntityBee.this.t.w.nextInt(10);
            this.f = Lists.newArrayList();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean g() {
            return EntityBee.this.cJ != null && !EntityBee.this.fn() && EntityBee.this.fP() && !this.d(EntityBee.this.cJ) && EntityBee.this.t.a_(EntityBee.this.cJ).a(TagsBlock.at);
        }

        @Override
        public boolean i() {
            return this.g();
        }

        @Override
        public void c() {
            this.d = 0;
            this.i = 0;
            super.c();
        }

        @Override
        public void d() {
            this.d = 0;
            this.i = 0;
            EntityBee.this.bQ.n();
            EntityBee.this.bQ.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.cJ != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    this.l();
                } else if (!EntityBee.this.bQ.m()) {
                    if (!EntityBee.this.b(EntityBee.this.cJ, 16)) {
                        if (EntityBee.this.j(EntityBee.this.cJ)) {
                            this.m();
                        } else {
                            EntityBee.this.h(EntityBee.this.cJ);
                        }
                    } else {
                        boolean flag = this.a(EntityBee.this.cJ);
                        if (!flag) {
                            this.l();
                        } else if (this.g != null && EntityBee.this.bQ.j().a(this.g)) {
                            ++this.i;
                            if (this.i > 60) {
                                this.m();
                                this.i = 0;
                            }
                        } else {
                            this.g = EntityBee.this.bQ.j();
                        }
                    }
                }
            }
        }

        private boolean a(BlockPosition pos) {
            EntityBee.this.bQ.a(10.0f);
            EntityBee.this.bQ.a((double)pos.u(), (double)pos.v(), (double)pos.w(), 1.0);
            return EntityBee.this.bQ.j() != null && EntityBee.this.bQ.j().j();
        }

        boolean b(BlockPosition pos) {
            return this.f.contains(pos);
        }

        private void c(BlockPosition pos) {
            this.f.add(pos);
            while (this.f.size() > 3) {
                this.f.remove(0);
            }
        }

        void k() {
            this.f.clear();
        }

        private void l() {
            if (EntityBee.this.cJ != null) {
                this.c(EntityBee.this.cJ);
            }
            this.m();
        }

        private void m() {
            EntityBee.this.cJ = null;
            EntityBee.this.cF = 200;
        }

        private boolean d(BlockPosition pos) {
            if (EntityBee.this.b(pos, 2)) {
                return true;
            }
            PathEntity pathentity = EntityBee.this.bQ.j();
            return pathentity != null && pathentity.m().equals(pos) && pathentity.j() && pathentity.c();
        }
    }

    public class f
    extends a {
        private static final int c = 600;
        int d;

        f() {
            this.d = EntityBee.this.t.w.nextInt(10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean g() {
            return EntityBee.this.cI != null && !EntityBee.this.fn() && this.k() && EntityBee.this.k(EntityBee.this.cI) && !EntityBee.this.b(EntityBee.this.cI, 2);
        }

        @Override
        public boolean i() {
            return this.g();
        }

        @Override
        public void c() {
            this.d = 0;
            super.c();
        }

        @Override
        public void d() {
            this.d = 0;
            EntityBee.this.bQ.n();
            EntityBee.this.bQ.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.cI != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    EntityBee.this.cI = null;
                } else if (!EntityBee.this.bQ.m()) {
                    if (EntityBee.this.j(EntityBee.this.cI)) {
                        EntityBee.this.cI = null;
                    } else {
                        EntityBee.this.h(EntityBee.this.cI);
                    }
                }
            }
        }

        private boolean k() {
            return EntityBee.this.cB > 2400;
        }
    }

    private class g
    extends a {
        static final int b = 30;

        g() {
        }

        @Override
        public boolean g() {
            return EntityBee.this.fS() >= 10 ? false : (EntityBee.this.R.nextFloat() < 0.3f ? false : EntityBee.this.fJ() && EntityBee.this.fV());
        }

        @Override
        public boolean i() {
            return this.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.R.nextInt(this.a(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    BlockPosition blockposition = EntityBee.this.cW().c(i2);
                    IBlockData iblockdata = EntityBee.this.t.a_(blockposition);
                    Block block = iblockdata.b();
                    boolean flag = false;
                    BlockStateInteger blockstateinteger = null;
                    if (!iblockdata.a(TagsBlock.av)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops blockcrops = (BlockCrops)block;
                        if (!blockcrops.h(iblockdata)) {
                            flag = true;
                            blockstateinteger = blockcrops.c();
                        }
                    } else if (block instanceof BlockStem) {
                        int j2 = iblockdata.c(BlockStem.b);
                        if (j2 < 7) {
                            flag = true;
                            blockstateinteger = BlockStem.b;
                        }
                    } else if (iblockdata.a(Blocks.mu)) {
                        int j3 = iblockdata.c(BlockSweetBerryBush.b);
                        if (j3 < 3) {
                            flag = true;
                            blockstateinteger = BlockSweetBerryBush.b;
                        }
                    } else if (iblockdata.a(Blocks.pB) || iblockdata.a(Blocks.pC)) {
                        ((IBlockFragilePlantElement)((Object)iblockdata.b())).a((WorldServer)EntityBee.this.t, EntityBee.this.R, blockposition, iblockdata);
                    }
                    if (!flag || CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockposition, (IBlockData)iblockdata.a(blockstateinteger, iblockdata.c(blockstateinteger) + 1)).isCancelled()) continue;
                    EntityBee.this.t.c(2005, blockposition, 0);
                    EntityBee.this.t.b(blockposition, (IBlockData)iblockdata.a(blockstateinteger, iblockdata.c(blockstateinteger) + 1));
                    EntityBee.this.fU();
                }
            }
        }
    }

    private class l
    extends PathfinderGoal {
        private static final int b = 22;

        l() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityBee.this.bQ.l() && EntityBee.this.R.nextInt(10) == 0;
        }

        @Override
        public boolean b() {
            return EntityBee.this.bQ.m();
        }

        @Override
        public void c() {
            Vec3D vec3d = this.g();
            if (vec3d != null) {
                EntityBee.this.bQ.a(EntityBee.this.bQ.a(new BlockPosition(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D g() {
            Vec3D vec3d;
            if (EntityBee.this.fV() && !EntityBee.this.b(EntityBee.this.cJ, 22)) {
                Vec3D vec3d1 = Vec3D.a(EntityBee.this.cJ);
                vec3d = vec3d1.d(EntityBee.this.cV()).d();
            } else {
                vec3d = EntityBee.this.e(0.0f);
            }
            boolean flag = true;
            Vec3D vec3d2 = HoverRandomPos.a(EntityBee.this, 8, 7, vec3d.b, vec3d.d, 1.5707964f, 3, 1);
            return vec3d2 != null ? vec3d2 : AirAndWaterRandomPos.a(EntityBee.this, 8, 4, -2, vec3d.b, vec3d.d, 1.5707963705062866);
        }
    }

    private class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee entitybee) {
            super(entitybee, new Class[0]);
        }

        @Override
        public boolean b() {
            return EntityBee.this.H_() && super.b();
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityBee && this.e.B(target)) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee bee) {
            super(bee, EntityHuman.class, 10, true, false, bee::a_);
        }

        @Override
        public boolean a() {
            return this.i() && super.a();
        }

        @Override
        public boolean b() {
            boolean flag = this.i();
            if (flag && this.e.G() != null) {
                return super.b();
            }
            this.g = null;
            return false;
        }

        private boolean i() {
            EntityBee entitybee = (EntityBee)this.e;
            return entitybee.H_() && !entitybee.fK();
        }
    }

    private abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean g();

        public abstract boolean i();

        @Override
        public boolean a() {
            return this.g() && !EntityBee.this.H_();
        }

        @Override
        public boolean b() {
            return this.i() && !EntityBee.this.H_();
        }
    }
}

