/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    static final int bY = 6000;
    public int bW;
    @Nullable
    public UUID bX;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.m, 16.0f);
        this.a(PathType.n, -1.0f);
    }

    @Override
    protected void R() {
        if (this.j() != 0) {
            this.bW = 0;
        }
        super.R();
    }

    @Override
    public void w_() {
        super.w_();
        if (this.j() != 0) {
            this.bW = 0;
        }
        if (this.bW > 0) {
            --this.bW;
            if (this.bW % 10 == 0) {
                double d0 = this.R.nextGaussian() * 0.02;
                double d1 = this.R.nextGaussian() * 0.02;
                double d2 = this.R.nextGaussian() * 0.02;
                this.t.a(Particles.H, this.d(1.0), this.df() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos.c()).a(Blocks.i) ? 10.0f : world.y(pos) - 0.5f;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("InLove", this.bW);
        if (this.bX != null) {
            nbt.a("LoveCause", this.bX);
        }
    }

    @Override
    public double bp() {
        return 0.14;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.bW = nbt.h("InLove");
        this.bX = nbt.b("LoveCause") ? nbt.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.bs) && EntityAnimal.a(world, pos);
    }

    protected static boolean a(IBlockLightAccess world, BlockPosition pos) {
        return world.b(pos, 0) > 8;
    }

    @Override
    public int J() {
        return 120;
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    protected int d(EntityHuman player) {
        return 1 + this.t.w.nextInt(3);
    }

    public boolean n(ItemStack stack) {
        return stack.a(Items.ni);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.n(itemstack)) {
            int i2 = this.j();
            if (!this.t.y && i2 == 0 && this.fB()) {
                this.a(player, hand, itemstack);
                this.g(player);
                this.a(GameEvent.C, this.cY());
                return EnumInteractionResult.a;
            }
            if (this.y_()) {
                this.a(player, hand, itemstack);
                this.a((int)((float)(-i2 / 20) * 0.1f), true);
                this.a(GameEvent.C, this.cY());
                return EnumInteractionResult.a(this.t.y);
            }
            if (this.t.y) {
                return EnumInteractionResult.b;
            }
        }
        return super.b(player, hand);
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (!player.fr().d) {
            stack.g(1);
        }
    }

    public boolean fB() {
        return this.bW <= 0;
    }

    public void g(@Nullable EntityHuman player) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.bW = entityEnterLoveModeEvent.getTicksInLove();
        if (player != null) {
            this.bX = player.cm();
        }
        this.breedItem = player.fq().f();
        this.t.a((Entity)this, (byte)18);
    }

    public void s(int loveTicks) {
        this.bW = loveTicks;
    }

    public int fC() {
        return this.bW;
    }

    @Nullable
    public EntityPlayer fD() {
        if (this.bX == null) {
            return null;
        }
        EntityHuman entityhuman = this.t.b(this.bX);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean fE() {
        return this.bW > 0;
    }

    public void fF() {
        this.bW = 0;
    }

    public boolean a(EntityAnimal other) {
        return other == this ? false : (other.getClass() != this.getClass() ? false : this.fE() && other.fE());
    }

    public void a(WorldServer world, EntityAnimal other) {
        EntityAgeable entityageable = this.a(world, (EntityAgeable)other);
        if (entityageable != null) {
            EntityPlayer entityplayer;
            if (entityageable instanceof EntityTameableAnimal && ((EntityTameableAnimal)entityageable).q()) {
                entityageable.setPersistenceRequired(true);
            }
            if ((entityplayer = this.fD()) == null && other.fD() != null) {
                entityplayer = other.fD();
            }
            entityageable.a(true);
            entityageable.b(this.dc(), this.de(), this.di(), 0.0f, 0.0f);
            int experience = this.dK().nextInt(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, other, entityplayer, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            if (entityplayer != null) {
                entityplayer.a(StatisticList.P);
                CriterionTriggers.o.a(entityplayer, this, other, entityageable);
            }
            this.b_(6000);
            other.b_(6000);
            this.fF();
            other.fF();
            world.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
            world.a((Entity)this, (byte)18);
            if (world.X().b(GameRules.f) && experience > 0) {
                world.b(new EntityExperienceOrb(world, this.dc(), this.de(), this.di(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityageable));
            }
        }
    }

    @Override
    public void a(byte status) {
        if (status == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.R.nextGaussian() * 0.02;
                double d1 = this.R.nextGaussian() * 0.02;
                double d2 = this.R.nextGaussian() * 0.02;
                this.t.a(Particles.H, this.d(1.0), this.df() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.a(status);
        }
    }
}

