/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.destroystokyo.paper.entity.villager.ReputationConstructor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.MinecraftSerializableUUID;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.ReputationType;

public class Reputation {
    public static final int a = 2;
    private final Map<UUID, a> b = Maps.newHashMap();

    public Map<UUID, a> getReputations() {
        return this.b;
    }

    @VisibleForDebug
    public Map<UUID, Object2IntMap<ReputationType>> a() {
        HashMap map = Maps.newHashMap();
        this.b.keySet().forEach(uuid -> {
            a entityGossips = this.b.get(uuid);
            map.put(uuid, entityGossips.a);
        });
        return map;
    }

    public void b() {
        Iterator<a> iterator = this.b.values().iterator();
        while (iterator.hasNext()) {
            a entityGossips = iterator.next();
            entityGossips.a();
            if (!entityGossips.b()) continue;
            iterator.remove();
        }
    }

    private Stream<b> c() {
        return this.b.entrySet().stream().flatMap(entry -> ((a)entry.getValue()).a((UUID)entry.getKey()));
    }

    private List<b> decompress() {
        ObjectArrayList list = new ObjectArrayList();
        for (Map.Entry<UUID, a> entry : this.getReputations().entrySet()) {
            for (b cur : entry.getValue().decompress(entry.getKey())) {
                if (cur.a() == 0) continue;
                list.add(cur);
            }
        }
        return list;
    }

    private Collection<b> a(Random random, int count) {
        List<b> list = this.decompress();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] is = new int[list.size()];
        int i2 = 0;
        for (int j2 = 0; j2 < list.size(); ++j2) {
            b gossipEntry = list.get(j2);
            is[j2] = (i2 += Math.abs(gossipEntry.a())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int k2 = 0; k2 < count; ++k2) {
            int l2 = random.nextInt(i2);
            int m2 = Arrays.binarySearch(is, l2);
            set.add(list.get(m2 < 0 ? -m2 - 1 : m2));
        }
        return set;
    }

    private a a(UUID target) {
        return this.b.computeIfAbsent(target, uuid -> new a());
    }

    public void a(Reputation from, Random random, int count) {
        Collection<b> collection = from.a(random, count);
        collection.forEach(gossip -> {
            int i2 = gossip.f - gossip.e.m;
            if (i2 >= 2) {
                this.a((UUID)gossip.d).a.mergeInt((Object)gossip.e, i2, Reputation::a);
            }
        });
    }

    public int a(UUID target, Predicate<ReputationType> gossipTypeFilter) {
        a entityGossips = this.b.get(target);
        return entityGossips != null ? entityGossips.a(gossipTypeFilter) : 0;
    }

    public long a(ReputationType type, DoublePredicate predicate) {
        return this.b.values().stream().filter(entityGossips -> predicate.test(entityGossips.a.getOrDefault((Object)type, 0) * type.j)).count();
    }

    public void a(UUID target, ReputationType type, int value) {
        a entityGossips = this.a(target);
        entityGossips.a.mergeInt((Object)type, value, (left, right) -> this.a(type, left, right));
        entityGossips.a(type);
        if (entityGossips.b()) {
            this.b.remove(target);
        }
    }

    public void b(UUID target, ReputationType type, int value) {
        this.a(target, type, -value);
    }

    public void a(UUID target, ReputationType type) {
        a entityGossips = this.b.get(target);
        if (entityGossips != null) {
            entityGossips.b(type);
            if (entityGossips.b()) {
                this.b.remove(target);
            }
        }
    }

    public void a(ReputationType type) {
        Iterator<a> iterator = this.b.values().iterator();
        while (iterator.hasNext()) {
            a entityGossips = iterator.next();
            entityGossips.b(type);
            if (!entityGossips.b()) continue;
            iterator.remove();
        }
    }

    public <T> Dynamic<T> a(DynamicOps<T> dynamicops) {
        return new Dynamic<Object>(dynamicops, dynamicops.createList(this.decompress().stream().map(reputation_b -> reputation_b.a(dynamicops)).map(Dynamic::getValue)));
    }

    public void a(Dynamic<?> dynamic) {
        dynamic.asStream().map(b::a).flatMap(dataResult -> SystemUtils.a(dataResult.result())).forEach(gossipEntry -> this.a((UUID)gossipEntry.d).a.put((Object)gossipEntry.e, gossipEntry.f));
    }

    private static int a(int left, int right) {
        return Math.max(left, right);
    }

    private int a(ReputationType type, int left, int right) {
        int i2 = left + right;
        return i2 > type.k ? Math.max(type.k, left) : i2;
    }

    public static class a {
        final Object2IntMap<ReputationType> a = new Object2IntOpenHashMap();
        private static final com.destroystokyo.paper.entity.villager.ReputationType[] REPUTATION_TYPES = com.destroystokyo.paper.entity.villager.ReputationType.values();

        public int a(Predicate<ReputationType> gossipTypeFilter) {
            int weight = 0;
            for (Object2IntMap.Entry entry : this.a.object2IntEntrySet()) {
                if (!gossipTypeFilter.test((ReputationType)((Object)entry.getKey()))) continue;
                weight += entry.getIntValue() * ((ReputationType)((Object)entry.getKey())).j;
            }
            return weight;
        }

        public List<b> decompress(UUID uuid) {
            ObjectArrayList list = new ObjectArrayList();
            for (Object2IntMap.Entry entry : this.a.object2IntEntrySet()) {
                list.add(new b(uuid, (ReputationType)((Object)entry.getKey()), entry.getIntValue()));
            }
            return list;
        }

        public Stream<b> a(UUID target) {
            return this.a.object2IntEntrySet().stream().map(entry -> new b(target, (ReputationType)((Object)((Object)entry.getKey())), entry.getIntValue()));
        }

        public void a() {
            ObjectIterator objectIterator = this.a.object2IntEntrySet().iterator();
            while (objectIterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
                int i2 = entry.getIntValue() - ((ReputationType)((Object)entry.getKey())).l;
                if (i2 < 2) {
                    objectIterator.remove();
                    continue;
                }
                entry.setValue(i2);
            }
        }

        public boolean b() {
            return this.a.isEmpty();
        }

        public void a(ReputationType gossipType) {
            int i2 = this.a.getInt((Object)gossipType);
            if (i2 > gossipType.k) {
                this.a.put((Object)gossipType, gossipType.k);
            }
            if (i2 < 2) {
                this.b(gossipType);
            }
        }

        public void b(ReputationType gossipType) {
            this.a.removeInt((Object)gossipType);
        }

        public com.destroystokyo.paper.entity.villager.Reputation getPaperReputation() {
            int[] reputation = new int[REPUTATION_TYPES.length];
            reputation[com.destroystokyo.paper.entity.villager.ReputationType.MAJOR_NEGATIVE.ordinal()] = this.a.getOrDefault((Object)ReputationType.a, 0);
            reputation[com.destroystokyo.paper.entity.villager.ReputationType.MAJOR_POSITIVE.ordinal()] = this.a.getOrDefault((Object)ReputationType.d, 0);
            reputation[com.destroystokyo.paper.entity.villager.ReputationType.MINOR_NEGATIVE.ordinal()] = this.a.getOrDefault((Object)ReputationType.b, 0);
            reputation[com.destroystokyo.paper.entity.villager.ReputationType.MINOR_POSITIVE.ordinal()] = this.a.getOrDefault((Object)ReputationType.c, 0);
            reputation[com.destroystokyo.paper.entity.villager.ReputationType.TRADING.ordinal()] = this.a.getOrDefault((Object)ReputationType.e, 0);
            return ReputationConstructor.construct(reputation);
        }

        public void assignFromPaperReputation(com.destroystokyo.paper.entity.villager.Reputation rep) {
            int val = rep.getReputation(com.destroystokyo.paper.entity.villager.ReputationType.MAJOR_NEGATIVE);
            if (val != 0) {
                this.a.put((Object)ReputationType.a, val);
            }
            if ((val = rep.getReputation(com.destroystokyo.paper.entity.villager.ReputationType.MAJOR_POSITIVE)) != 0) {
                this.a.put((Object)ReputationType.d, val);
            }
            if ((val = rep.getReputation(com.destroystokyo.paper.entity.villager.ReputationType.MINOR_NEGATIVE)) != 0) {
                this.a.put((Object)ReputationType.b, val);
            }
            if ((val = rep.getReputation(com.destroystokyo.paper.entity.villager.ReputationType.MINOR_POSITIVE)) != 0) {
                this.a.put((Object)ReputationType.c, val);
            }
            if ((val = rep.getReputation(com.destroystokyo.paper.entity.villager.ReputationType.TRADING)) != 0) {
                this.a.put((Object)ReputationType.e, val);
            }
        }
    }

    static class b {
        public static final String a = "Target";
        public static final String b = "Type";
        public static final String c = "Value";
        public final UUID d;
        public final ReputationType e;
        public final int f;

        public b(UUID target, ReputationType type, int value) {
            this.d = target;
            this.e = type;
            this.f = value;
        }

        public int a() {
            return this.f * this.e.j;
        }

        public String toString() {
            return "GossipEntry{target=" + this.d + ", type=" + this.e + ", value=" + this.f + "}";
        }

        public <T> Dynamic<T> a(DynamicOps<T> dynamicOps) {
            return new Dynamic<Object>(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString(a), MinecraftSerializableUUID.a.encodeStart(dynamicOps, (Object)this.d).result().orElseThrow(RuntimeException::new), (Object)dynamicOps.createString(b), (Object)dynamicOps.createString(this.e.i), (Object)dynamicOps.createString(c), (Object)dynamicOps.createInt(this.f))));
        }

        public static DataResult<b> a(Dynamic<?> dynamic) {
            return DataResult.unbox((App)DataResult.instance().group((App)dynamic.get(a).read(MinecraftSerializableUUID.a), (App)dynamic.get(b).asString().map(ReputationType::a), (App)dynamic.get(c).asNumber().map(Number::intValue)).apply((Applicative)DataResult.instance(), b::new));
        }
    }
}

