/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;

public class BehaviorWalkAway<T>
extends Behavior<EntityCreature> {
    private final MemoryModuleType<T> a;
    private final float c;
    private final int d;
    private final Function<T, Vec3D> e;

    public BehaviorWalkAway(MemoryModuleType<T> memoryType, float speed, int range, boolean requiresWalkTarget, Function<T, Vec3D> posRetriever) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.m, (Object)((Object)(requiresWalkTarget ? MemoryStatus.c : MemoryStatus.b)), memoryType, (Object)((Object)MemoryStatus.a)));
        this.a = memoryType;
        this.c = speed;
        this.d = range;
        this.e = posRetriever;
    }

    public static BehaviorWalkAway<BlockPosition> a(MemoryModuleType<BlockPosition> memoryType, float speed, int range, boolean requiresWalkTarget) {
        return new BehaviorWalkAway<BlockPosition>(memoryType, speed, range, requiresWalkTarget, Vec3D::c);
    }

    public static BehaviorWalkAway<? extends Entity> b(MemoryModuleType<? extends Entity> memoryType, float speed, int range, boolean requiresWalkTarget) {
        return new BehaviorWalkAway<Entity>(memoryType, speed, range, requiresWalkTarget, Entity::cV);
    }

    @Override
    @Override
    protected boolean a(WorldServer world, EntityCreature entity) {
        if (this.b(entity)) {
            return false;
        }
        return entity.cV().a((IPosition)this.a(entity), (double)this.d);
    }

    private Vec3D a(EntityCreature entity) {
        return this.e.apply(entity.dt().c(this.a).get());
    }

    private boolean b(EntityCreature entity) {
        Vec3D vec32;
        if (!entity.dt().a(MemoryModuleType.m)) {
            return false;
        }
        MemoryTarget walkTarget = entity.dt().c(MemoryModuleType.m).get();
        if (walkTarget.b() != this.c) {
            return false;
        }
        Vec3D vec3 = walkTarget.a().a().d(entity.cV());
        return vec3.b(vec32 = this.a(entity).d(entity.cV())) < 0.0;
    }

    @Override
    @Override
    protected void a(WorldServer world, EntityCreature entity, long time) {
        BehaviorWalkAway.a(entity, this.a(entity), this.c);
    }

    private static void a(EntityCreature entity, Vec3D pos, float speed) {
        for (int i2 = 0; i2 < 10; ++i2) {
            Vec3D vec3 = LandRandomPos.b(entity, 16, 7, pos);
            if (vec3 == null) continue;
            entity.dt().a(MemoryModuleType.m, new MemoryTarget(vec3, speed, 0));
            return;
        }
    }
}

