/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class BehaviorInteract<E extends EntityLiving, T extends EntityLiving>
extends Behavior<E> {
    private final int a;
    private final float c;
    private final EntityTypes<? extends T> d;
    private final int e;
    private final Predicate<T> f;
    private final Predicate<E> g;
    private final MemoryModuleType<T> h;

    public BehaviorInteract(EntityTypes<? extends T> entityType, int maxDistance, Predicate<E> shouldRunPredicate, Predicate<T> predicate, MemoryModuleType<T> targetModule, float speed, int completionRange) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.c), MemoryModuleType.m, (Object)((Object)MemoryStatus.b), MemoryModuleType.h, (Object)((Object)MemoryStatus.a)));
        this.d = entityType;
        this.c = speed;
        this.e = maxDistance * maxDistance;
        this.a = completionRange;
        this.f = predicate;
        this.g = shouldRunPredicate;
        this.h = targetModule;
    }

    public static <T extends EntityLiving> BehaviorInteract<EntityLiving, T> a(EntityTypes<? extends T> entityType, int maxDistance, MemoryModuleType<T> targetModule, float speed, int completionRange) {
        return new BehaviorInteract<EntityLiving, EntityLiving>(entityType, maxDistance, entity -> true, entity -> true, targetModule, speed, completionRange);
    }

    public static <T extends EntityLiving> BehaviorInteract<EntityLiving, T> a(EntityTypes<? extends T> entityType, int maxDistance, Predicate<T> condition, MemoryModuleType<T> moduleType, float speed, int completionRange) {
        return new BehaviorInteract<EntityLiving, T>(entityType, maxDistance, entity -> true, condition, moduleType, speed, completionRange);
    }

    @Override
    @Override
    protected boolean a(WorldServer world, E entity) {
        return this.g.test(entity) && this.a(entity);
    }

    private boolean a(E entity) {
        NearestVisibleLivingEntities nearestVisibleLivingEntities = ((EntityLiving)entity).dt().c(MemoryModuleType.h).get();
        return nearestVisibleLivingEntities.d(this::b);
    }

    private boolean b(EntityLiving entity) {
        return this.d.equals(entity.ad()) && this.f.test(entity);
    }

    @Override
    @Override
    protected void a(WorldServer world, E entity, long time) {
        BehaviorController<?> brain = ((EntityLiving)entity).dt();
        Optional<NearestVisibleLivingEntities> optional = brain.c(MemoryModuleType.h);
        if (optional.isEmpty()) {
            return;
        }
        NearestVisibleLivingEntities nearestVisibleLivingEntities = optional.get();
        nearestVisibleLivingEntities.a(target -> this.a(entity, (EntityLiving)target)).ifPresent(target -> {
            brain.a(this.h, target);
            brain.a(MemoryModuleType.n, new BehaviorPositionEntity((Entity)target, true));
            brain.a(MemoryModuleType.m, new MemoryTarget(new BehaviorPositionEntity((Entity)target, false), this.c, this.a));
        });
    }

    private boolean a(E self, EntityLiving target) {
        return this.d.equals(target.ad()) && target.f((Entity)self) <= (double)this.e && this.f.test(target);
    }
}

