/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeProvider {
    public final Map<AttributeBase, AttributeModifiable> a;

    public AttributeProvider(Map<AttributeBase, AttributeModifiable> instances) {
        this.a = ImmutableMap.copyOf(instances);
    }

    private AttributeModifiable d(AttributeBase attribute) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        if (attributeInstance == null) {
            throw new IllegalArgumentException("Can't find attribute " + IRegistry.am.b(attribute));
        }
        return attributeInstance;
    }

    public double a(AttributeBase attribute) {
        return this.d(attribute).f();
    }

    public double b(AttributeBase attribute) {
        return this.d(attribute).b();
    }

    public double a(AttributeBase attribute, UUID uuid) {
        AttributeModifier attributeModifier = this.d(attribute).a(uuid);
        if (attributeModifier == null) {
            throw new IllegalArgumentException("Can't find modifier " + uuid + " on attribute " + IRegistry.am.b(attribute));
        }
        return attributeModifier.d();
    }

    @Nullable
    public AttributeModifiable a(Consumer<AttributeModifiable> updateCallback, AttributeBase attribute) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        if (attributeInstance == null) {
            return null;
        }
        AttributeModifiable attributeInstance2 = new AttributeModifiable(attribute, updateCallback);
        attributeInstance2.a(attributeInstance);
        return attributeInstance2;
    }

    public static Builder a() {
        return new Builder();
    }

    public boolean c(AttributeBase type) {
        return this.a.containsKey(type);
    }

    public boolean b(AttributeBase type, UUID uuid) {
        AttributeModifiable attributeInstance = this.a.get(type);
        return attributeInstance != null && attributeInstance.a(uuid) != null;
    }

    public static class Builder {
        private final Map<AttributeBase, AttributeModifiable> a = Maps.newHashMap();
        private boolean b;

        private AttributeModifiable b(AttributeBase attribute2) {
            AttributeModifiable attributeInstance = new AttributeModifiable(attribute2, attribute -> {
                if (this.b) {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance: " + IRegistry.am.b(attribute2));
                }
            });
            this.a.put(attribute2, attributeInstance);
            return attributeInstance;
        }

        public Builder a(AttributeBase attribute) {
            this.b(attribute);
            return this;
        }

        public Builder a(AttributeBase attribute, double baseValue) {
            AttributeModifiable attributeInstance = this.b(attribute);
            attributeInstance.a(baseValue);
            return this;
        }

        public AttributeProvider a() {
            this.b = true;
            return new AttributeProvider(this.a);
        }
    }
}

