/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityAreaEffectCloud
extends Entity {
    private static final Logger b = LogManager.getLogger();
    private static final int c = 5;
    private static final DataWatcherObject<Float> d = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.c);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<ParticleParam> ap = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.j);
    private static final float aq = 32.0f;
    private PotionRegistry ar = Potions.a;
    public List<MobEffect> as = Lists.newArrayList();
    private final Map<Entity, Integer> at = Maps.newHashMap();
    private int au = 600;
    public int av = 20;
    public int aw = 20;
    private boolean ax;
    public int ay;
    public float az;
    public float aA;
    @Nullable
    private EntityLiving aB;
    @Nullable
    private UUID aC;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> type, World world) {
        super(type, world);
        this.Q = true;
        this.a(3.0f);
    }

    public EntityAreaEffectCloud(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.b, world);
        this.e(x2, y2, z2);
    }

    @Override
    protected void a_() {
        this.ai().a(e, 0);
        this.ai().a(d, Float.valueOf(0.5f));
        this.ai().a(f, false);
        this.ai().a(ap, Particles.v);
    }

    public void a(float radius) {
        if (!this.t.y) {
            this.ai().b(d, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void z_() {
        double d0 = this.dc();
        double d1 = this.de();
        double d2 = this.di();
        super.z_();
        this.e(d0, d1, d2);
    }

    public float h() {
        return this.ai().a(d).floatValue();
    }

    public void a(PotionRegistry potion) {
        this.ar = potion;
        if (!this.ax) {
            this.w();
        }
    }

    private void w() {
        if (this.ar == Potions.a && this.as.isEmpty()) {
            this.ai().b(e, 0);
        } else {
            this.ai().b(e, PotionUtil.a(PotionUtil.a(this.ar, this.as)));
        }
    }

    public void a(MobEffect effect) {
        this.as.add(effect);
        if (!this.ax) {
            this.w();
        }
    }

    public void refreshEffects() {
        if (!this.ax) {
            this.ai().b(e, PotionUtil.a(PotionUtil.a(this.ar, this.as)));
        }
    }

    public String getPotionType() {
        return IRegistry.ab.b(this.ar).toString();
    }

    public void setPotionType(String string) {
        this.a(IRegistry.ab.a(new MinecraftKey(string)));
    }

    public int i() {
        return this.ai().a(e);
    }

    public void a(int rgb) {
        this.ax = true;
        this.ai().b(e, rgb);
    }

    public ParticleParam j() {
        return this.ai().a(ap);
    }

    public void a(ParticleParam particle) {
        this.ai().b(ap, particle);
    }

    protected void a(boolean waiting) {
        this.ai().b(f, waiting);
    }

    public boolean l() {
        return this.ai().a(f);
    }

    public int n() {
        return this.au;
    }

    public void b(int duration) {
        this.au = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.S >= this.av + this.au) {
            this.ah();
            return;
        }
    }

    @Override
    public void k() {
        block22: {
            ArrayList list;
            float f2;
            block23: {
                boolean flag1;
                boolean flag;
                block21: {
                    float f1;
                    int i2;
                    super.k();
                    flag = this.l();
                    f2 = this.h();
                    if (!this.t.y) break block21;
                    if (flag && this.R.nextBoolean()) {
                        return;
                    }
                    ParticleParam particleparam = this.j();
                    if (flag) {
                        i2 = 2;
                        f1 = 0.2f;
                    } else {
                        i2 = MathHelper.f((float)Math.PI * f2 * f2);
                        f1 = f2;
                    }
                    for (int j2 = 0; j2 < i2; ++j2) {
                        double d5;
                        double d4;
                        double d3;
                        float f22 = this.R.nextFloat() * ((float)Math.PI * 2);
                        float f3 = MathHelper.c(this.R.nextFloat()) * f1;
                        double d0 = this.dc() + (double)(MathHelper.b(f22) * f3);
                        double d1 = this.de();
                        double d2 = this.di() + (double)(MathHelper.a(f22) * f3);
                        if (particleparam.b() == Particles.v) {
                            int k2 = flag && this.R.nextBoolean() ? 0xFFFFFF : this.i();
                            d3 = (float)(k2 >> 16 & 0xFF) / 255.0f;
                            d4 = (float)(k2 >> 8 & 0xFF) / 255.0f;
                            d5 = (float)(k2 & 0xFF) / 255.0f;
                        } else if (flag) {
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        } else {
                            d3 = (0.5 - this.R.nextDouble()) * 0.15;
                            d4 = 0.01f;
                            d5 = (0.5 - this.R.nextDouble()) * 0.15;
                        }
                        this.t.b(particleparam, d0, d1, d2, d3, d4, d5);
                    }
                    break block22;
                }
                if (this.S >= this.av + this.au) {
                    this.ah();
                    return;
                }
                boolean bl = flag1 = this.S < this.av;
                if (flag != flag1) {
                    this.a(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.aA != 0.0f) {
                    if ((f2 += this.aA) < 0.5f) {
                        this.ah();
                        return;
                    }
                    this.a(f2);
                }
                if (this.S % 5 != 0) break block22;
                this.at.entrySet().removeIf(entry -> this.S >= (Integer)entry.getValue());
                list = Lists.newArrayList();
                for (MobEffect mobeffect : this.ar.a()) {
                    list.add(new MobEffect(mobeffect.a(), mobeffect.b() / 4, mobeffect.c(), mobeffect.d(), mobeffect.e()));
                }
                list.addAll(this.as);
                if (!list.isEmpty()) break block23;
                this.at.clear();
                break block22;
            }
            List<EntityLiving> list1 = this.t.a(EntityLiving.class, this.cw());
            if (list1.isEmpty()) break block22;
            Iterator<EntityLiving> iterator1 = list1.iterator();
            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
            while (iterator1.hasNext()) {
                double d7;
                double d6;
                double d8;
                EntityLiving entityliving = iterator1.next();
                if (this.at.containsKey(entityliving) || !entityliving.eW() || !((d8 = (d6 = entityliving.dc() - this.dc()) * d6 + (d7 = entityliving.di() - this.di()) * d7) <= (double)(f2 * f2))) continue;
                entities.add((LivingEntity)entityliving.getBukkitEntity());
            }
            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
            if (!event.isCancelled()) {
                for (LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof CraftLivingEntity)) continue;
                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                    this.at.put(entityliving, this.S + this.aw);
                    for (MobEffect mobeffect1 : list) {
                        if (mobeffect1.a().a()) {
                            mobeffect1.a().a(this, this.t(), entityliving, mobeffect1.c(), 0.5);
                            continue;
                        }
                        entityliving.addEffect(new MobEffect(mobeffect1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                    }
                    if (this.az != 0.0f) {
                        if ((f2 += this.az) < 0.5f) {
                            this.ah();
                            return;
                        }
                        this.a(f2);
                    }
                    if (this.ay == 0) continue;
                    this.au += this.ay;
                    if (this.au > 0) continue;
                    this.ah();
                    return;
                }
            }
        }
    }

    public float o() {
        return this.az;
    }

    public void b(float radius) {
        this.az = radius;
    }

    public float q() {
        return this.aA;
    }

    public void c(float growth) {
        this.aA = growth;
    }

    public int r() {
        return this.ay;
    }

    public void c(int durationOnUse) {
        this.ay = durationOnUse;
    }

    public int s() {
        return this.av;
    }

    public void d(int ticks) {
        this.av = ticks;
    }

    public void a(@Nullable EntityLiving owner) {
        this.aB = owner;
        this.aC = owner == null ? null : owner.cm();
    }

    @Nullable
    public EntityLiving t() {
        Entity entity;
        if (this.aB == null && this.aC != null && this.t instanceof WorldServer && (entity = ((WorldServer)this.t).a(this.aC)) instanceof EntityLiving) {
            this.aB = (EntityLiving)entity;
        }
        return this.aB;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.S = nbt.h("Age");
        this.au = nbt.h("Duration");
        this.av = nbt.h("WaitTime");
        this.aw = nbt.h("ReapplicationDelay");
        this.ay = nbt.h("DurationOnUse");
        this.az = nbt.j("RadiusOnUse");
        this.aA = nbt.j("RadiusPerTick");
        this.a(nbt.j("Radius"));
        if (nbt.b("Owner")) {
            this.aC = nbt.a("Owner");
        }
        if (nbt.b("Particle", 8)) {
            try {
                this.a(ArgumentParticle.b(new StringReader(nbt.l("Particle"))));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                b.warn("Couldn't load custom particle {}", (Object)nbt.l("Particle"), (Object)commandsyntaxexception);
            }
        }
        if (nbt.b("Color", 99)) {
            this.a(nbt.h("Color"));
        }
        if (nbt.b("Potion", 8)) {
            this.a(PotionUtil.c(nbt));
        }
        if (nbt.b("Effects", 9)) {
            NBTTagList nbttaglist = nbt.c("Effects", 10);
            this.as.clear();
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                MobEffect mobeffect = MobEffect.b(nbttaglist.a(i2));
                if (mobeffect == null) continue;
                this.a(mobeffect);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Age", this.S);
        nbt.a("Duration", this.au);
        nbt.a("WaitTime", this.av);
        nbt.a("ReapplicationDelay", this.aw);
        nbt.a("DurationOnUse", this.ay);
        nbt.a("RadiusOnUse", this.az);
        nbt.a("RadiusPerTick", this.aA);
        nbt.a("Radius", this.h());
        nbt.a("Particle", this.j().a());
        if (this.aC != null) {
            nbt.a("Owner", this.aC);
        }
        if (this.ax) {
            nbt.a("Color", this.i());
        }
        if (this.ar != Potions.a) {
            nbt.a("Potion", IRegistry.ab.b(this.ar).toString());
        }
        if (!this.as.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (MobEffect mobeffect : this.as) {
                nbttaglist.add(mobeffect.a(new NBTTagCompound()));
            }
            nbt.a("Effects", nbttaglist);
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (d.equals(data)) {
            this.z_();
        }
        super.a(data);
    }

    public PotionRegistry u() {
        return this.ar;
    }

    @Override
    public EnumPistonReaction c_() {
        return EnumPistonReaction.d;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.h() * 2.0f, 0.5f);
    }
}

